package org.mule.weave.extension.api.component;

import org.mule.dx.platform.api.component.ComponentFactory;
import org.mule.dx.platform.api.component.ComponentLifecycle;
import org.mule.dx.platform.api.project.Project;

public abstract class NatureBasedComponentFactory<T extends ComponentLifecycle> implements ComponentFactory<T> {
    private final String nature;

    public NatureBasedComponentFactory(String nature) {
        this.nature = nature;
    }

    public String getNature() {
        return nature;
    }

    @Override
    public boolean applies(Project project) {
        return project.hasNature(nature);
    }
}
