package org.mule.weave.extension.api.component.structure;

import java.util.Objects;

public class WeaveModuleStructure {
    private final String name;
    private final WeaveRootStructure[] roots;
    private final WeaveTargetFolder[] targets;
    private final WeaveDescriptorFile[] descriptors;

    public WeaveModuleStructure(String name, WeaveRootStructure[] roots, WeaveTargetFolder[] target, WeaveDescriptorFile[] descriptors) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(roots);
        Objects.requireNonNull(target);
        Objects.requireNonNull(descriptors);

        this.name = name;
        this.roots = roots;
        this.targets = target;
        this.descriptors = descriptors;
    }

    public String name() {
        return name;
    }

    public WeaveRootStructure[] roots() {
        return roots;
    }

    public WeaveTargetFolder[] targets() {
        return targets;
    }

    public WeaveDescriptorFile[] descriptors() {
        return descriptors;
    }
}
