package org.mule.weave.extension.api.extension.annotations;

import static java.util.Objects.requireNonNull;

import org.mule.weave.v2.api.tooling.annotation.DWAnnotationProcessor;
import org.mule.weave.v2.api.tooling.location.ResourceIdentifier;

public class DefaultWeaveAnnotationProcessorBinding implements WeaveAnnotationProcessorBinding {
    private final ResourceIdentifier resourceIdentifier;
    private final DWAnnotationProcessor annotationProcessor;

    public DefaultWeaveAnnotationProcessorBinding(ResourceIdentifier resourceIdentifier, DWAnnotationProcessor annotationProcessor) {
        this.resourceIdentifier = resourceIdentifier;
        this.annotationProcessor = annotationProcessor;
    }

    public ResourceIdentifier getResourceIdentifier() {
        return this.resourceIdentifier;
    }

    public DWAnnotationProcessor getAnnotationProcessor() {
        return this.annotationProcessor;
    }

    static class Builder implements WeaveAnnotationProcessorBinding.Builder {
        private ResourceIdentifier resourceIdentifier;
        private DWAnnotationProcessor annotationProcessor;

        protected Builder() {}

        @Override
        public WeaveAnnotationProcessorBinding.Builder withResourceIdentifier(ResourceIdentifier resourceIdentifier) {
            requireNonNull(resourceIdentifier);
            this.resourceIdentifier = resourceIdentifier;
            return this;
        }

        @Override
        public WeaveAnnotationProcessorBinding.Builder withAnnotationProcessor(DWAnnotationProcessor annotationProcessor) {
            requireNonNull(annotationProcessor);
            this.annotationProcessor = annotationProcessor;
            return this;
        }

        @Override
        public WeaveAnnotationProcessorBinding build() {
            requireNonNull(resourceIdentifier, "ResourceIdentifier is required and not set.");
            requireNonNull(annotationProcessor, "DWAnnotationProcessor is required and not set.");

            return new DefaultWeaveAnnotationProcessorBinding(resourceIdentifier, annotationProcessor);
        }

    }

}
