package org.mule.weave.extension.api.events;

import static org.mule.weave.extension.api.events.EventTypes.PROJECT_STARTED;

import org.mule.dx.platform.api.event.AbstractEvent;
import org.mule.weave.extension.api.project.ProjectMetadata;

public class ProjectStartedEvent extends AbstractEvent<ProjectStartedEventHandler> {
    private final ProjectMetadata projectMetadata;

    public ProjectStartedEvent(ProjectMetadata projectMetadata) {
        super(PROJECT_STARTED);
        this.projectMetadata = projectMetadata;
    }

    @Override
    public void dispatch(ProjectStartedEventHandler handler) {
        handler.onProjectStarted(projectMetadata);
    }
}
