package org.mule.weave.extension.api.extension.indexer;

import org.mule.weave.extension.api.extension.WeaveProjectExtension;
import org.mule.weave.v2.api.tooling.ast.DWAstNode;

import java.util.List;

/**
 * The indexer extension that will be responsible for extracting the entries to be stored in the Indexer Region
 * @param <K> The indexer extension key.
 * @param <V> The indexer extension value.
 */
public interface IndexerExtension<K, V> extends WeaveProjectExtension {

    List<IndexEntry<K, V>> index(String uri, DWAstNode astNode);

    IndexerID<K,V> id();

}
