package org.mule.weave.extension.api.component.dependency;

import org.mule.dx.platform.api.maven.MavenDependencyModel;
import org.mule.weave.extension.api.component.WeaveComponent;

/**
 * This component manages the dependencies for a project and the information
 */
public interface WeaveDependencyComponent extends WeaveComponent {
    /**
     * Returns the DW version this project depends on
     *
     * @return The DW version this project is using
     */
    String dwVersion();

    /**
     * Reloads all the dependencies
     */
    void reload();

    /**
     * Returns a flat representation of all the project dependencies
     *
     * @return The list of all project dependencies
     */
    DependencyArtifact[] dependencies();

    /**
     * Returns the root dependency model for this project which includes the tree of dependencies resolved.
     * This model contains the project's root artifact and all its transitive dependencies.
     *
     * @return the root dependency model with its dependencies.
     */
    MavenDependencyModel rootDependencyModel();

}
