package org.mule.weave.extension.api.llm.tools;

import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * Represents the parameters of a tool
 */
public interface LLMToolParams {

    /**
     * Returns a param of type String
     *
     * @param name The name of the param
     * @return The param if it exists
     */
    Optional<String> getStringParam(String name);

    /**
     * Returns a param of type Boolean
     *
     * @param name The name of the param
     * @return The param if it exists
     */
    Optional<Boolean> getBooleanParam(String name);

    /**
     * Returns a param of type Map (representing a JSON object)
     *
     * @param name The name of the param
     * @return The param if it exists
     */
    Optional<Map<String, Object>> getObjectParam(String name);

    /**
     * Returns a param of type List (representing a JSON array)
     *
     * @param name The name of the param
     * @return The param if it exists
     */
    Optional<List<Object>> getListParam(String name);


    /**
     * Returns a param of type String.
     * This is a convenience method that directly returns the String value.
     *
     * @param name The name of the param.
     * @return The String value of the param.
     * @throws RuntimeException if the parameter with the given name is not found or is not a String.
     */
    default String stringParam(String name) {
        return getStringParam(name).orElseThrow(() -> new RuntimeException("Property: `" + name + "` with type String was not found."));
    }

    /**
     * Returns a param of type Boolean.
     * This is a convenience method that directly returns the Boolean value.
     *
     * @param name The name of the param.
     * @return The Boolean value of the param.
     * @throws RuntimeException if the parameter with the given name is not found or is not a Boolean.
     */
    default Boolean booleanParam(String name) {
        return getBooleanParam(name).orElseThrow(() -> new RuntimeException("Property: `" + name + "` with type Boolean was not found."));
    }
}
