package org.mule.weave.lsp.commands

import org.eclipse.lsp4j.ExecuteCommandParams
import org.mule.weave.extension.api.extension.command.WeaveCommand
import org.mule.weave.extension.api.project.ProjectMetadata
import org.mule.weave.lsp.project.ProjectKind
import org.mule.weave.lsp.project.commands.ProjectProvider
import org.mule.weave.lsp.services.UIService

class CreateProjectCommand(project: ProjectMetadata, projectKind: ProjectKind) extends WeaveCommand {

  override def commandId(): String = Commands.DW_CREATE_PROJECT

  override def name(): String = "Creates a DataWeave Project"

  override def description(params: ExecuteCommandParams): String = "Create a new DW Project"

  override def execute(params: ExecuteCommandParams): AnyRef = {
    val weaveProtocolClient = projectKind.toolingService(classOf[UIService])
    val projectProvider = new ProjectProvider(weaveProtocolClient, project)
    projectProvider.newProject();
    null
  }
}
