package org.mule.weave.lsp.commands

import org.eclipse.lsp4j.ApplyWorkspaceEditParams
import org.eclipse.lsp4j.Command
import org.eclipse.lsp4j.ExecuteCommandParams
import org.eclipse.lsp4j.TextEdit
import org.eclipse.lsp4j.WorkspaceEdit
import org.mule.weave.extension.api.extension.command.WeaveCommand
import org.mule.weave.lsp.project.ProjectKind
import org.mule.weave.lsp.services.DataWeaveToolingService
import org.mule.weave.lsp.services.WorkspaceEditService

import java.util

class ExtractConstantCommand(weaveService: DataWeaveToolingService, projectKind: ProjectKind) extends WeaveCommand {
  override def commandId(): String = Commands.DW_EXTRACT_CONSTANT

  override def execute(params: ExecuteCommandParams): AnyRef = {
    val startOffset = Commands.argAsInt(params.getArguments, 0)
    val endOffset = Commands.argAsInt(params.getArguments, 1)
    val uri = Commands.argAsString(params.getArguments, 2)
    val toolingService = weaveService.openDocument(uri)
    val maybeRefactor = toolingService.extractConstant(startOffset, endOffset)
    maybeRefactor match {
      case Some(refactor) => {
        val document = new LSPWeaveTextDocument(toolingService)
        refactor.run(document, refactor.parameters().map((p) => (p.name, p.defaultValue)).toMap)
        val edit = new WorkspaceEdit()
        val changes = new util.HashMap[String, util.List[TextEdit]]()
        changes.put(uri, document.edits())
        edit.setChanges(changes)
        val response = projectKind.toolingService(classOf[WorkspaceEditService]).applyEdit(new ApplyWorkspaceEditParams(edit, "Extract constant")).get()
        response.isApplied
      }
      case None =>
    }
    null
  }


  override def name(): String = "Extract constant."

  override def description(params: ExecuteCommandParams): String = "Extracting constant."
}

object ExtractConstantCommand {
  def createCommand(startOffset: Int, endOffset: Int, uri: String): Command = {
    new Command("Extract constant", Commands.DW_EXTRACT_CONSTANT,
      util.Arrays.asList[AnyRef](
        startOffset: java.lang.Integer,
        endOffset: java.lang.Integer,
        uri
      ))
  }
}
