package org.mule.weave.lsp.commands

import org.eclipse.lsp4j.ApplyWorkspaceEditParams
import org.eclipse.lsp4j.Command
import org.eclipse.lsp4j.ExecuteCommandParams
import org.eclipse.lsp4j.TextEdit
import org.eclipse.lsp4j.WorkspaceEdit
import org.mule.weave.extension.api.extension.command.WeaveCommand
import org.mule.weave.lsp.extension.protocol.WeaveInputBoxParams
import org.mule.weave.lsp.extension.protocol.WeaveInputBoxResult
import org.mule.weave.lsp.project.ProjectKind
import org.mule.weave.lsp.services.DataWeaveToolingService
import org.mule.weave.lsp.services.UIService
import org.mule.weave.lsp.services.WorkspaceEditService
import org.mule.weave.v2.editor.CodeRefactor
import org.mule.weave.v2.editor.WeaveDocumentToolingService

import java.util

class ExtractFunctionCommand(weaveService: DataWeaveToolingService, projectKind: ProjectKind) extends WeaveCommand {
  override def commandId(): String = Commands.DW_EXTRACT_FUNCTION

  override def execute(params: ExecuteCommandParams): AnyRef = {
    val uIService = projectKind.toolingService(classOf[UIService]);
    val workspaceEditService = projectKind.toolingService(classOf[WorkspaceEditService])
    val startOffset = Commands.argAsInt(params.getArguments, 0)
    val endOffset = Commands.argAsInt(params.getArguments, 1)
    val uri: String = Commands.argAsString(params.getArguments, 2)
    val toolingService: WeaveDocumentToolingService = weaveService.openDocument(uri)
    val maybeRefactor: Option[CodeRefactor] = toolingService.extractFunction(startOffset, endOffset)
    maybeRefactor match {
      case Some(refactor) => {
        val document = new LSPWeaveTextDocument(toolingService)
        val value = uIService.weaveInputBox(WeaveInputBoxParams("Function Name", refactor.parameters().head.defaultValue))
        val inputBoxResult: WeaveInputBoxResult = value.get()
        if (!inputBoxResult.cancelled) {
          refactor.run(document, refactor.parameters().map((p) => (p.name, inputBoxResult.value)).toMap)
          val edit = new WorkspaceEdit()
          val changes = new util.HashMap[String, util.List[TextEdit]]()
          changes.put(uri, document.edits())
          edit.setChanges(changes)
          val response = workspaceEditService.applyEdit(new ApplyWorkspaceEditParams(edit, "Extract Variable")).get()
          response.isApplied
        }
      }
      case None =>
    }
    null
  }


  override def name(): String = "Extract Function."

  override def description(params: ExecuteCommandParams): String = "Extracting function."
}

object ExtractFunctionCommand {
  def createCommand(startOffset: Int, endOffset: Int, uri: String): Command = {
    new Command("Extract Function", Commands.DW_EXTRACT_FUNCTION,
      util.Arrays.asList[AnyRef](
        startOffset: java.lang.Integer,
        endOffset: java.lang.Integer,
        uri
      ))
  }
}
