package org.mule.weave.lsp.commands

import org.mule.weave.extension.api.extension.command.WeaveCommand
import org.mule.weave.lsp.bat.BatProjectHelper
import org.mule.weave.lsp.bat.BatUserMessages
import org.mule.weave.lsp.project.ProjectKind
import org.mule.weave.lsp.services.UIService
import org.mule.weave.lsp.utils.Messages
import org.mule.weave.lsp.utils.WeaveASTQueryUtils
import org.mule.weave.v2.editor.VirtualFile

/**
  * Trait that represent any weave command
  */
trait InternalWeaveCommand extends WeaveCommand {

  /**
    * Returns whether this command should run on the given context.
    *
    * @return
    */
  def enabled(vf: VirtualFile): Boolean = true

}

abstract class BatCommand(projectKind: ProjectKind) extends InternalWeaveCommand {

  override def enabled(vf: VirtualFile): Boolean = {
    projectKind.name().equals(WeaveASTQueryUtils.BAT)
  }


  protected def installCLIIfNeeded(batProjectManager: BatProjectHelper, uIService: UIService): Boolean = {
    if (!batProjectManager.isBatInstalled) {
      val value = uIService.showMessageRequest(BatUserMessages.installBatCLI())
      value.get() match {
        case msg if msg == Messages.no =>
          false
        case msg if msg == Messages.yes =>
          batProjectManager.downloadAndInstall()
        case _ => {
          false
        }
      }
    } else {
      true
    }
  }

}
