package org.mule.weave.lsp.commands

import org.eclipse.lsp4j.ExecuteCommandParams
import org.mule.weave.extension.api.extension.command.WeaveCommand
import org.mule.weave.extension.api.project.ProjectMetadata
import org.mule.weave.lsp.extension.protocol.LaunchConfiguration
import org.mule.weave.lsp.extension.protocol.LaunchConfiguration._
import org.mule.weave.lsp.extension.protocol.LaunchConfigurationProperty
import org.mule.weave.lsp.project.ProjectKind
import org.mule.weave.lsp.services.ConfigurationService
import org.mule.weave.lsp.utils.Icons
import org.mule.weave.v2.editor.VirtualFileSystem

import java.util

class LaunchWeaveTestCommand( vfs: VirtualFileSystem, project: ProjectMetadata, projectKind: ProjectKind) extends WeaveCommand {

  val icon: Icons = Icons.vscode

  override def commandId(): String = Commands.DW_LAUNCH_TEST

  override def execute(params: ExecuteCommandParams): AnyRef = {
    val configurationService = projectKind.toolingService(classOf[ConfigurationService]);
    val urls: String = Commands.argAsString(params.getArguments(), 0)
    val names = urls.split(",")
      .flatMap((url) => Option(vfs.file(url)))
      .map((vf) => vf.getNameIdentifier.toString())
      .mkString(",")
    val noDebug: Boolean = Commands.argAsBoolean(params.getArguments(), 1)
    val launchConfiguration = createDefaultConfiguration(names, LaunchConfiguration.WTF_CONFIG_TYPE_NAME, noDebug)
    configurationService.runConfiguration(launchConfiguration)
    null
  }

  private def createDefaultConfiguration(mappingName: String, configType: String, noDebug: Boolean): LaunchConfiguration = {
    val mapping: LaunchConfigurationProperty = LaunchConfigurationProperty(MAIN_FILE_NAME, mappingName)
    val testRunnerEnvVarFile: LaunchConfigurationProperty = LaunchConfigurationProperty(TEST_RUNNER_ENV_VAR_FILE, project.settings().testRunnerEnvVarFileName.value())
    LaunchConfiguration(configType, "Debugging " + mappingName, LAUNCH_REQUEST_TYPE, noDebug, util.Arrays.asList(mapping, testRunnerEnvVarFile))
  }

  override def name(): String = "Launch DataWeave Test."

  override def description(params: ExecuteCommandParams): String = "Launching DataWeave Test."
}
