package org.mule.weave.lsp.commands

import org.eclipse.lsp4j.ApplyWorkspaceEditParams
import org.eclipse.lsp4j.ExecuteCommandParams
import org.eclipse.lsp4j.TextEdit
import org.eclipse.lsp4j.WorkspaceEdit
import org.mule.weave.extension.api.extension.command.WeaveCommand
import org.mule.weave.lsp.commands.Commands.argAsInt
import org.mule.weave.lsp.commands.Commands.argAsString
import org.mule.weave.lsp.project.ProjectKind
import org.mule.weave.lsp.services.DataWeaveToolingService
import org.mule.weave.lsp.services.WorkspaceEditService
import org.mule.weave.v2.editor.QuickFix
import org.mule.weave.v2.editor.WeaveDocumentToolingService

import java.util

class QuickFixCommand(toolingService: DataWeaveToolingService, projectKind: ProjectKind) extends WeaveCommand {

  override def commandId(): String = Commands.DW_QUICK_FIX

  override def execute(params: ExecuteCommandParams): AnyRef = {
    val arguments = params.getArguments
    assert(arguments.size() == 6)
    val uri: String = argAsString(arguments, 0)
    val startOffset: Int = argAsInt(arguments, 1)
    val endOffset: Int = argAsInt(arguments, 2)
    val kind: String = argAsString(arguments, 3)
    val severity: String = argAsString(arguments, 4)
    val qfName: String = argAsString(arguments, 5)
    val workspaceEditService = projectKind.toolingService(classOf[WorkspaceEditService])

    val maybeContext = toolingService.contextMetadataFor(uri)
    val quickFixes: Array[QuickFix] = toolingService.quickFixesFor(uri, startOffset, endOffset, kind, severity, maybeContext)
    val documentToolingService: WeaveDocumentToolingService = toolingService.openDocument(uri, maybeContext)
    quickFixes.find((qf) => qf.name == qfName).foreach((qf) => {
      val document = new LSPWeaveTextDocument(documentToolingService)
      qf.quickFix.run(document)
      val edit = new WorkspaceEdit()
      val changes = new util.HashMap[String, util.List[TextEdit]]()
      changes.put(uri, document.edits())
      edit.setChanges(changes)
      workspaceEditService.applyEdit(new ApplyWorkspaceEditParams(edit, qf.description))
    })
    null
  }

  override def name(): String = "Executes Quick Fix."

  override def description(params: ExecuteCommandParams): String = s"Executing Quick Fix: `${argAsString(params.getArguments, 5)}`."

}
