package org.mule.weave.lsp.commands

import org.eclipse.lsp4j.ExecuteCommandParams
import org.mule.weave.extension.api.extension.command.WeaveCommand
import org.mule.weave.lsp.project.ProjectKind

class ReloadDependenciesCommand(project: ProjectKind) extends WeaveCommand {
  override def commandId(): String = Commands.DW_RELOAD_DEPENDENCIES

  override def execute(params: ExecuteCommandParams): AnyRef = {
    project.dependencyManager().reload()
    null
  }

  override def name(): String = "Reloads dependencies."

  override def description(params: ExecuteCommandParams): String = "Reloading dependencies."
}
