package org.mule.weave.lsp.commands

import org.eclipse.lsp4j.ExecuteCommandParams
import org.mule.weave.extension.api.extension.command.WeaveCommand
import org.mule.weave.lsp.agent.WeaveAgentService

class RestartAgentCommand(agentService: WeaveAgentService) extends WeaveCommand {
  override def commandId(): String = Commands.DW_RESTART_AGENT

  override def execute(params: ExecuteCommandParams): AnyRef = {
    agentService.restart()
    null
  }

  override def name(): String = "Force Agent To Restart."

  override def description(params: ExecuteCommandParams): String = "Restarting DataWeave Agent."
}
