package org.mule.weave.lsp.commands

import org.eclipse.lsp4j.ExecuteCommandParams
import org.mule.weave.lsp.bat.BatProjectHelper
import org.mule.weave.lsp.bat.BatUserMessages
import org.mule.weave.lsp.project.ProjectKind
import org.mule.weave.lsp.services.ClientLoggerFactory
import org.mule.weave.lsp.services.DataWeaveToolingService
import org.mule.weave.lsp.services.UIService
import org.mule.weave.lsp.utils.WeaveASTQueryUtils
import org.mule.weave.v2.editor.VirtualFile

import scala.collection.JavaConverters._
import scala.collection.mutable

class RunBatTestCommand(loggerFactory: ClientLoggerFactory, projectKind: ProjectKind, toolingService: DataWeaveToolingService) extends BatCommand(projectKind) {

  override def commandId(): String = Commands.BAT_RUN_BAT_TEST

  override def execute(params: ExecuteCommandParams): AnyRef = {
    val uIService = projectKind.toolingService(classOf[UIService])
    val arguments: mutable.Seq[AnyRef] = params.getArguments.asScala
    val batProjectManager = new BatProjectHelper(loggerFactory.createLogger())
    if (installCLIIfNeeded(batProjectManager, uIService)) {
      batProjectManager.run(arguments.head.toString, arguments.tail.headOption.map(_.toString))
    } else {
      uIService.showMessage(BatUserMessages.batCLINotFound())
      ""
    }
  }

  override def name(): String = "Run a single Bat Test."

  override def description(params: ExecuteCommandParams): String = "Running a Bat Test."

  override def enabled(vf: VirtualFile): Boolean = {
    super.enabled(vf) && WeaveASTQueryUtils.fileKind(toolingService.openDocument(vf.url()).ast().map(_.astNode)).exists(kind => WeaveASTQueryUtils.BAT.equals(kind))
  }
}
