package org.mule.weave.lsp.commands

import org.eclipse.lsp4j.ExecuteCommandParams
import org.eclipse.lsp4j.MessageParams
import org.eclipse.lsp4j.MessageType
import org.mule.weave.dsp.DataWeaveDebuggerAdapterProtocolLauncher.launch
import org.mule.weave.extension.api.extension.command.WeaveCommand
import org.mule.weave.lsp.jobs.JobManagerService
import org.mule.weave.lsp.jobs.Status
import org.mule.weave.lsp.project.DefaultProjectMetadata
import org.mule.weave.lsp.project.ProjectKind
import org.mule.weave.lsp.project.components.ProcessLauncher
import org.mule.weave.lsp.services.ClientLoggerFactory
import org.mule.weave.lsp.services.DataWeaveTestService
import org.mule.weave.lsp.services.UIService
import org.mule.weave.lsp.utils.NetUtils
import org.mule.weave.lsp.vfs.ProjectFileSystemService
import org.mule.weave.v2.editor.VirtualFileSystem

import java.util.concurrent.CountDownLatch

//LSP .....
// LaunchDebugger
// [VSCODE] <-> [LSPADI] <-> [PDW]

class RunWeaveCommand(virtualFileSystem: VirtualFileSystem,
                      projectVirtualFileSystem: ProjectFileSystemService,
                      project: DefaultProjectMetadata,
                      projectKind: ProjectKind,
                      loggerFactory: ClientLoggerFactory,
                      jobManagerService: JobManagerService,
                      dataWeaveTestService: DataWeaveTestService) extends WeaveCommand {

  override def commandId(): String = Commands.DW_RUN_MAPPING

  override def execute(params: ExecuteCommandParams): AnyRef = {
    val uIService = projectKind.toolingService(classOf[UIService]);
    val configType = Commands.argAsString(params.getArguments, 0)
    runMapping(configType, uIService)
  }

  def runMapping(config: String, uIService: UIService): Integer = {


    if (!project.isStarted) {
      uIService.showMessage(new MessageParams(MessageType.Warning, "Can not run a DW script until Project was initialized."))
      -1
    } else {
      val port: Int = NetUtils.freePort()
      val latch = new CountDownLatch(1)
      jobManagerService.schedule((status: Status) => {
        val launcher: ProcessLauncher = ProcessLauncher.createLauncherByType(config, projectKind, loggerFactory, uIService, projectVirtualFileSystem)
        launch(virtualFileSystem, loggerFactory, uIService, launcher, projectKind, jobManagerService, dataWeaveTestService, () => latch.countDown(), port)
      }, "Starting Debugger Server", "Starting Debugger Server")
      latch.await()
      port
    }
  }


  override def name(): String = "Run DataWeave."

  override def description(params: ExecuteCommandParams): String = "Running DataWeave Command."

}
