package org.mule.weave.lsp.extension.protocol

import java.util.concurrent.CompletableFuture
import java.util.logging.Logger

case object NoopDataWeaveProtocolClientDelegate extends DataWeaveProtocolClient {
  private val logger: Logger = Logger.getLogger(getClass.getName)

  private def logWarning(method: String) = {
    logger.warning(s"DataWeaveProtocolClient has not been initialized yet, still ${method} has been called. This is probable a bug.")
  }

  /**
   * Opens an input box to ask the user for input.
   *
   * @return the user provided input. The future can be cancelled, meaning
   *         the input box should be dismissed in the editor.
   */
  override def weaveInputBox(params: WeaveInputBoxParams): CompletableFuture[WeaveInputBoxResult] = {
    logWarning("weaveInputBox(params: WeaveInputBoxParams)")
    new CompletableFuture[WeaveInputBoxResult]()
  }

  /**
   * Opens an menu to ask the user to pick one of the suggested options.
   *
   * @return the user provided pick. The future can be cancelled, meaning
   *         the input box should be dismissed in the editor.
   */
  override def weaveQuickPick(params: WeaveQuickPickParams): CompletableFuture[WeaveQuickPickResult] = {
    logWarning("weaveQuickPick(params: WeaveQuickPickParams)")
    new CompletableFuture[WeaveQuickPickResult]()
  }

  override def weaveFileBrowser(params: WeaveOpenDialogParams): CompletableFuture[String] = {
    logWarning("weaveFileBrowser(params: WeaveOpenDialogParams)")
    new CompletableFuture[String]()
  }

  override def setEditorDecorations(params: EditorDecorationsParams): Unit = {
    logWarning("setEditorDecorations(params: EditorDecorationsParams)")
  }

  override def clearEditorDecorations(): Unit = {
    logWarning("clearEditorDecorations()")
  }

  /**
   * Opens a folder in a new window
   *
   * @param params
   */
  override def openWindow(params: OpenWindowsParams): Unit = {
    logWarning("openWindow(params: OpenWindowsParams)")
  }

  /**
   * This notification is sent from the server to the client to execute the specified configuration on client side.
   *
   */
  override def runConfiguration(config: LaunchConfiguration): Unit = {
    logWarning("runConfiguration(config: LaunchConfiguration)")
  }

  /**
   * This notification is sent from the server to the client to open an editor with the specified document uri
   *
   * @param params The document to be opened
   */
  override def openTextDocument(params: OpenTextDocumentParams): Unit = {
    logWarning("openTextDocument(params: OpenTextDocumentParams)")
  }

  /**
   * This notification is sent from the server to the client to set context variable on visual studio code
   * used for enabling/disabling commands
   * at the editor with the specified document uri
   *
   * @param params The document to be opened
   */
  override def setContext(params: SetContextParams): Unit = {
    logWarning("setContext(params: SetContextParams)")
  }

  /**
   * This notification is sent from the server to the client to show the live data of a script
   *
   * @param result The result of executing a script
   */
  override def showPreviewResult(result: PreviewResult): Unit = {
    logWarning("showPreviewResult(result: PreviewResult)")
  }

  /**
   * This notification is sent from the server to the client to publish all the resolved dependencies of this workspace
   *
   * @param resolvedDependency The list of all the resolved dependencies
   */
  override def publishDependencies(resolvedDependency: DependenciesParams): Unit = {
    logWarning("publishDependencies(resolvedDependency: DependenciesParams)")
  }

  /**
   * This notification is sent from the server to the client to publish current transformation scenarios.
   *
   * @param scenariosParam Scenarios Parameter
   */
  override def showScenarios(scenariosParam: ShowScenariosParams): Unit = {
    logWarning("showScenarios(scenariosParam: ShowScenariosParams)")
  }

  /**
   * This notification is sent from the server to the client to inform the user that a background job has started.
   *
   * @param job The job information that has started
   */
  override def notifyJobStarted(job: JobStartedParams): Unit = {
    logWarning("notifyJobStarted(job: JobStartedParams)")
  }

  /**
   * This notification is sent from the server to the client to inform the user that a background job has finish.
   *
   * @param job The job information that has ended
   */
  override def notifyJobEnded(job: JobEndedParams): Unit = {
    logWarning("notifyJobEnded(job: JobEndedParams)")
  }

  /**
   * This notification is sent from the server to the client to push all the possible tests to run on the project.
   *
   * @param job The job information that has ended
   */
  override def publishTestItems(job: PublishTestItemsParams): Unit = {
    logWarning("publishTestItems(job: PublishTestItemsParams)")
  }

  /**
   * This notification is sent from the server to the client to push tests results.
   *
   * @param job The job information that has ended
   */
  override def publishTestResults(testResults: PublishTestResultsParams): Unit = {
    logWarning("publishTestResults(testResults: PublishTestResultsParams)")
  }

}
