package org.mule.weave.lsp.project

import org.eclipse.lsp4j.services.LanguageClient
import org.mule.weave.extension.api.project.ProjectMetadata
import org.mule.weave.lsp.extension.protocol.DataWeaveProtocolClient
import org.mule.weave.lsp.services.ClientLoggerFactory

/**
 * Detects the Project Kind
 */
trait ProjectKindFactory {

  /**
   * Returns the project kind that was detected
   *
   * @param context The project to be used, and all the context needed to create the kind
   * @return The ProjectKind
   */
  def createKind(context: ProjectKindContext): ProjectKind

}

case class ProjectKindContext(projectMetadata: ProjectMetadata,
                              loggerFactory: ClientLoggerFactory,
                              client: DataWeaveProtocolClient,
                              languageClient: LanguageClient
                             )
