package org.mule.weave.lsp.services

import org.eclipse.lsp4j.services.LanguageClient

class ClientLoggerFactory(_client: LanguageClient) {

  def createLogger() : ClientLogger = {
    new ClientLogger(_client)
  }

  def createLogger(clazz: Class[_]): ClientLogger = {
    new ClientLogger(_client, clazz.getSimpleName)
  }

  def createLogger(clazz: Class[_], id: String): ClientLogger = {
    new ClientLogger(_client, id + "@" + clazz.getSimpleName)
  }
}
