package org.mule.weave.lsp.services

import org.eclipse.lsp4j.ConfigurationParams
import org.eclipse.lsp4j.WorkspaceFolder
import org.eclipse.lsp4j.services.LanguageClient
import org.mule.weave.lsp.extension.protocol.DataWeaveProtocolClient
import org.mule.weave.lsp.extension.protocol.LaunchConfiguration

import java.util
import java.util.concurrent.CompletableFuture

/**
 * Handles everything that is releated to configuration
 */
class ConfigurationService(var languageClient: LanguageClient, dataWeaveProtocolClient: DataWeaveProtocolClient) extends ToolingService {

  def workspaceFolders(): CompletableFuture[util.List[WorkspaceFolder]] = {
    languageClient.workspaceFolders()
  }

  def configuration(configurationParams: ConfigurationParams): CompletableFuture[util.List[AnyRef]] = {
    languageClient.configuration(configurationParams)
  }

  def runConfiguration(config: LaunchConfiguration): Unit = {
    dataWeaveProtocolClient.runConfiguration(config)
  }

  //TODO: W-17148935 bug in DX to delegate mediator's call to wrapped languageClient
  def setLanguageClient(client: LanguageClient) =
    languageClient = client
}
