package org.mule.weave.lsp.services

import org.eclipse.lsp4j.PublishDiagnosticsParams

import scala.collection.mutable.ArrayBuffer

class DiagnosticsPublisherService extends ToolingService {

  private val publishers: ArrayBuffer[DiagnosticsPublisher] = new ArrayBuffer[DiagnosticsPublisher]();
  private var defaultPublisher: Option[DiagnosticsPublisher] = None

  def setDefaultPublisher(defaultPublisher: DiagnosticsPublisher): Unit = {
    this.defaultPublisher = Some(defaultPublisher)
  }

  def addPublisher(diagnosticsPublisher: DiagnosticsPublisher): Unit = {
    this.publishers.+=(diagnosticsPublisher)
  }

  def publishDiagnostics(diagnostics: PublishDiagnosticsParams): Unit = {
    publishers.find(_.handles(diagnostics)).orElse(defaultPublisher).foreach(_.publishDiagnostics(diagnostics))
  }
}
