/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.lsp;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lsp4j.CodeLensOptions;
import org.eclipse.lsp4j.CompletionOptions;
import org.eclipse.lsp4j.ExecuteCommandOptions;
import org.eclipse.lsp4j.InitializeParams;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.InitializedParams;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.ServerInfo;
import org.eclipse.lsp4j.SignatureHelpOptions;
import org.eclipse.lsp4j.TextDocumentSyncKind;
import org.eclipse.lsp4j.jsonrpc.services.JsonDelegate;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.lsp4j.services.WorkspaceService;
import org.mule.dx.platform.api.protocol.ClientAware;
import org.mule.weave.lsp.IDEExecutors$;
import org.mule.weave.lsp.LanguageServerConfiguration;
import org.mule.weave.lsp.actions.CodeActionsManagerService;
import org.mule.weave.lsp.commands.CommandManagerService;
import org.mule.weave.lsp.extension.client.LanguageClientDelegate;
import org.mule.weave.lsp.extension.protocol.DataWeaveProtocolService;
import org.mule.weave.lsp.extension.services.WeaveTextDocumentService;
import org.mule.weave.lsp.indexer.LSPWeaveIndexService;
import org.mule.weave.lsp.jobs.JobManagerService;
import org.mule.weave.lsp.project.DefaultProjectMetadata;
import org.mule.weave.lsp.project.DefaultProjectMetadata$;
import org.mule.weave.lsp.project.ProjectKind;
import org.mule.weave.lsp.project.ProjectKindContext;
import org.mule.weave.lsp.project.ProjectKindFactory;
import org.mule.weave.lsp.services.ClientLogger;
import org.mule.weave.lsp.services.ClientLoggerFactory;
import org.mule.weave.lsp.services.ConfigurationService;
import org.mule.weave.lsp.services.DataWeaveDocumentService;
import org.mule.weave.lsp.services.DataWeaveToolingService;
import org.mule.weave.lsp.services.DataWeaveWorkspaceService;
import org.mule.weave.lsp.services.DiagnosticsPublisher;
import org.mule.weave.lsp.services.DiagnosticsPublisherService;
import org.mule.weave.lsp.services.UIService;
import org.mule.weave.lsp.services.WeaveScenarioManagerService;
import org.mule.weave.lsp.services.WorkspaceEditApplier;
import org.mule.weave.lsp.services.WorkspaceEditService;
import org.mule.weave.lsp.services.delegate.TextDocumentServiceDelegate;
import org.mule.weave.lsp.services.delegate.WorkspaceServiceDelegate;
import org.mule.weave.lsp.vfs.ProjectFileSystemService;
import org.mule.weave.v2.editor.VirtualFileSystem;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dh\u0001\u0002\u0011\"\u0001)B\u0001\u0002\u0014\u0001\u0003\u0002\u0003\u0006I!\u0014\u0005\t'\u0002\u0011\t\u0011)A\u0005)\"A\u0001\f\u0001B\u0001B\u0003%\u0011\fC\u0003a\u0001\u0011\u0005\u0011\rC\u0004g\u0001\t\u0007I\u0011B4\t\rA\u0004\u0001\u0015!\u0003i\u0011\u001d\t\bA1A\u0005\nIDaA\u001f\u0001!\u0002\u0013\u0019\bbB>\u0001\u0005\u0004%I\u0001 \u0005\b\u0003\u0003\u0001\u0001\u0015!\u0003~\u0011%\t\u0019\u0001\u0001b\u0001\n\u0013\t)\u0001\u0003\u0005\u0002\u0014\u0001\u0001\u000b\u0011BA\u0004\u0011-\t)\u0002\u0001a\u0001\u0002\u0004%I!a\u0006\t\u0017\u0005}\u0001\u00011AA\u0002\u0013%\u0011\u0011\u0005\u0005\f\u0003g\u0001\u0001\u0019!A!B\u0013\tI\u0002C\u0006\u00026\u0001\u0001\r\u00111A\u0005\n\u0005]\u0002bCA!\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u0007B1\"a\u0012\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002:!Y\u0011\u0011\n\u0001A\u0002\u0003\u0007I\u0011CA&\u0011-\t\u0019\u0006\u0001a\u0001\u0002\u0004%\t\"!\u0016\t\u0017\u0005e\u0003\u00011A\u0001B\u0003&\u0011Q\n\u0005\u0007!\u0002!\t!a\u0017\t\u000f\u0005u\u0003\u0001\"\u0011\u0002`!9\u0011q\u0010\u0001\u0005B\u0005\u0005\u0005bBAF\u0001\u0011\u0005\u0013Q\u0012\u0005\b\u0003/\u0003A\u0011IAM\u0011\u001d\tY\n\u0001C!\u0003;Cq!!/\u0001\t\u0003\nY\fC\u0004\u0002D\u0002!\t%!2\t\u000f\u0005%\u0007\u0001\"\u0001\u0002L\"9\u0011Q\u001c\u0001\u0005\u0002\u0005}'aE,fCZ,G*\u00198hk\u0006<WmU3sm\u0016\u0014(B\u0001\u0012$\u0003\ra7\u000f\u001d\u0006\u0003I\u0015\nQa^3bm\u0016T!AJ\u0014\u0002\t5,H.\u001a\u0006\u0002Q\u0005\u0019qN]4\u0004\u0001M!\u0001aK\u001a>!\ta\u0013'D\u0001.\u0015\tqs&\u0001\u0003mC:<'\"\u0001\u0019\u0002\t)\fg/Y\u0005\u0003e5\u0012aa\u00142kK\u000e$\bC\u0001\u001b<\u001b\u0005)$B\u0001\u001c8\u0003!\u0019XM\u001d<jG\u0016\u001c(B\u0001\u001d:\u0003\u0015a7\u000f\u001d\u001bk\u0015\tQt%A\u0004fG2L\u0007o]3\n\u0005q*$A\u0004'b]\u001e,\u0018mZ3TKJ4XM\u001d\t\u0004}\u001dKU\"A \u000b\u0005\u0001\u000b\u0015\u0001\u00039s_R|7m\u001c7\u000b\u0005\t\u001b\u0015aA1qS*\u0011A)R\u0001\ta2\fGOZ8s[*\u0011a)J\u0001\u0003IbL!\u0001S \u0003\u0017\rc\u0017.\u001a8u\u0003^\f'/\u001a\t\u0003i)K!aS\u001b\u0003\u001d1\u000bgnZ;bO\u0016\u001cE.[3oi\u0006\u0011\u0002O]8kK\u000e$8*\u001b8e\r\u0006\u001cGo\u001c:z!\tq\u0015+D\u0001P\u0015\t\u0001\u0016%A\u0004qe>TWm\u0019;\n\u0005I{%A\u0005)s_*,7\r^&j]\u00124\u0015m\u0019;pef\fQbY8oM&<WO]1uS>t\u0007CA+W\u001b\u0005\t\u0013BA,\"\u0005ma\u0015M\\4vC\u001e,7+\u001a:wKJ\u001cuN\u001c4jOV\u0014\u0018\r^5p]\u000691/\u001a:wS\u000e,\u0007C\u0001._\u001b\u0005Y&B\u0001!]\u0015\ti\u0016%A\u0005fqR,gn]5p]&\u0011ql\u0017\u0002\u0019\t\u0006$\u0018mV3bm\u0016\u0004&o\u001c;pG>d7+\u001a:wS\u000e,\u0017A\u0002\u001fj]&$h\b\u0006\u0003cG\u0012,\u0007CA+\u0001\u0011\u0015aE\u00011\u0001N\u0011\u0015\u0019F\u00011\u0001U\u0011\u0015AF\u00011\u0001Z\u0003\u0019awnZ4feV\t\u0001\u000e\u0005\u0002j]6\t!N\u0003\u0002lY\u00069An\\4hS:<'BA70\u0003\u0011)H/\u001b7\n\u0005=T'A\u0002'pO\u001e,'/A\u0004m_\u001e<WM\u001d\u0011\u0002!]|'o[:qC\u000e,7+\u001a:wS\u000e,W#A:\u0011\u0005QDX\"A;\u000b\u0005Y<\u0018\u0001\u00033fY\u0016<\u0017\r^3\u000b\u0005Y\n\u0013BA=v\u0005a9vN]6ta\u0006\u001cWmU3sm&\u001cW\rR3mK\u001e\fG/Z\u0001\u0012o>\u00148n\u001d9bG\u0016\u001cVM\u001d<jG\u0016\u0004\u0013a\u0005;fqR$unY;nK:$8+\u001a:wS\u000e,W#A?\u0011\u0005Qt\u0018BA@v\u0005m!V\r\u001f;E_\u000e,X.\u001a8u'\u0016\u0014h/[2f\t\u0016dWmZ1uK\u0006!B/\u001a=u\t>\u001cW/\\3oiN+'O^5dK\u0002\na\u0002\\1oOV\fw-Z\"mS\u0016tG/\u0006\u0002\u0002\bA!\u0011\u0011BA\b\u001b\t\tYAC\u0002\u0002\u000eq\u000baa\u00197jK:$\u0018\u0002BA\t\u0003\u0017\u0011a\u0003T1oOV\fw-Z\"mS\u0016tG\u000fR3mK\u001e\fG/Z\u0001\u0010Y\u0006tw-^1hK\u000ec\u0017.\u001a8uA\u0005y\u0001O]8kK\u000e$X*\u001a;bI\u0006$\u0018-\u0006\u0002\u0002\u001aA\u0019a*a\u0007\n\u0007\u0005uqJ\u0001\fEK\u001a\fW\u000f\u001c;Qe>TWm\u0019;NKR\fG-\u0019;b\u0003M\u0001(o\u001c6fGRlU\r^1eCR\fw\fJ3r)\u0011\t\u0019#a\f\u0011\t\u0005\u0015\u00121F\u0007\u0003\u0003OQ!!!\u000b\u0002\u000bM\u001c\u0017\r\\1\n\t\u00055\u0012q\u0005\u0002\u0005+:LG\u000fC\u0005\u000229\t\t\u00111\u0001\u0002\u001a\u0005\u0019\u0001\u0010J\u0019\u0002!A\u0014xN[3di6+G/\u00193bi\u0006\u0004\u0013\u0001D2mS\u0016tG\u000fT8hO\u0016\u0014XCAA\u001d!\u0011\tY$!\u0010\u000e\u0003]L1!a\u0010x\u00051\u0019E.[3oi2{wmZ3s\u0003A\u0019G.[3oi2{wmZ3s?\u0012*\u0017\u000f\u0006\u0003\u0002$\u0005\u0015\u0003\"CA\u0019#\u0005\u0005\t\u0019AA\u001d\u00035\u0019G.[3oi2{wmZ3sA\u0005Y\u0001O]8kK\u000e$8*\u001b8e+\t\ti\u0005E\u0002O\u0003\u001fJ1!!\u0015P\u0005-\u0001&o\u001c6fGR\\\u0015N\u001c3\u0002\u001fA\u0014xN[3di.Kg\u000eZ0%KF$B!a\t\u0002X!I\u0011\u0011\u0007\u000b\u0002\u0002\u0003\u0007\u0011QJ\u0001\raJ|'.Z2u\u0017&tG\r\t\u000b\u0003\u00033\t!\"\u001b8ji&\fG.\u001b>f)\u0011\t\t'!\u001e\u0011\r\u0005\r\u0014\u0011NA7\u001b\t\t)GC\u0002\u0002h1\f!bY8oGV\u0014(/\u001a8u\u0013\u0011\tY'!\u001a\u0003#\r{W\u000e\u001d7fi\u0006\u0014G.\u001a$viV\u0014X\r\u0005\u0003\u0002p\u0005ET\"A\u001c\n\u0007\u0005MtG\u0001\tJ]&$\u0018.\u00197ju\u0016\u0014Vm];mi\"9\u0011qO\fA\u0002\u0005e\u0014A\u00029be\u0006l7\u000f\u0005\u0003\u0002p\u0005m\u0014bAA?o\t\u0001\u0012J\\5uS\u0006d\u0017N_3QCJ\fWn]\u0001\fS:LG/[1mSj,G\r\u0006\u0003\u0002$\u0005\r\u0005bBA<1\u0001\u0007\u0011Q\u0011\t\u0005\u0003_\n9)C\u0002\u0002\n^\u0012\u0011#\u00138ji&\fG.\u001b>fIB\u000b'/Y7t\u0003!\u0019\b.\u001e;e_^tGCAAH!\u0019\t\u0019'!\u001b\u0002\u0012B!\u0011QEAJ\u0013\u0011\t)*a\n\u0003\r\u0005s\u0017PU3g\u0003\u0011)\u00070\u001b;\u0015\u0005\u0005\r\u0012AF4fiR+\u0007\u0010\u001e#pGVlWM\u001c;TKJ4\u0018nY3\u0015\u0005\u0005}\u0005\u0003BAQ\u0003Kk!!a)\u000b\u0005Yb\u0016\u0002BAT\u0003G\u0013\u0001dV3bm\u0016$V\r\u001f;E_\u000e,X.\u001a8u'\u0016\u0014h/[2fQ\rY\u00121\u0016\t\u0005\u0003[\u000b),\u0004\u0002\u00020*\u0019a'!-\u000b\u0007\u0005Mv'A\u0004kg>t'\u000f]2\n\t\u0005]\u0016q\u0016\u0002\r\u0015N|g\u000eR3mK\u001e\fG/Z\u0001\u0014O\u0016$xk\u001c:lgB\f7-Z*feZL7-\u001a\u000b\u0003\u0003{\u00032\u0001NA`\u0013\r\t\t-\u000e\u0002\u0011/>\u00148n\u001d9bG\u0016\u001cVM\u001d<jG\u0016\fqaY8o]\u0016\u001cG\u000f\u0006\u0003\u0002$\u0005\u001d\u0007BBA\u0007;\u0001\u0007\u0011*\u0001\u0002ggR\u0011\u0011Q\u001a\t\u0005\u0003\u001f\fI.\u0004\u0002\u0002R*!\u00111[Ak\u0003\u0019)G-\u001b;pe*\u0019\u0011q[\u0012\u0002\u0005Y\u0014\u0014\u0002BAn\u0003#\u0014\u0011CV5siV\fGNR5mKNK8\u000f^3n\u0003!)\u00070Z2vi>\u0014HCAAq!\u0011\t\u0019'a9\n\t\u0005\u0015\u0018Q\r\u0002\u0010\u000bb,7-\u001e;peN+'O^5dK\u0002")
public class WeaveLanguageServer
implements LanguageServer,
ClientAware<LanguageClient> {
    private final ProjectKindFactory projectKindFactory;
    private final LanguageServerConfiguration configuration;
    private final DataWeaveProtocolService service;
    private final Logger logger;
    private final WorkspaceServiceDelegate workspaceService;
    private final TextDocumentServiceDelegate textDocumentService;
    private final LanguageClientDelegate languageClient;
    private DefaultProjectMetadata projectMetadata;
    private ClientLogger clientLogger;
    private ProjectKind projectKind;

    private Logger logger() {
        return this.logger;
    }

    private WorkspaceServiceDelegate workspaceService() {
        return this.workspaceService;
    }

    private TextDocumentServiceDelegate textDocumentService() {
        return this.textDocumentService;
    }

    private LanguageClientDelegate languageClient() {
        return this.languageClient;
    }

    private DefaultProjectMetadata projectMetadata() {
        return this.projectMetadata;
    }

    private void projectMetadata_$eq(DefaultProjectMetadata x$1) {
        this.projectMetadata = x$1;
    }

    private ClientLogger clientLogger() {
        return this.clientLogger;
    }

    private void clientLogger_$eq(ClientLogger x$1) {
        this.clientLogger = x$1;
    }

    public ProjectKind projectKind() {
        return this.projectKind;
    }

    public void projectKind_$eq(ProjectKind x$1) {
        this.projectKind = x$1;
    }

    public DefaultProjectMetadata project() {
        return this.projectMetadata();
    }

    public CompletableFuture<InitializeResult> initialize(InitializeParams params) {
        this.logger().log(Level.INFO, new StringBuilder(25).append("Initialize (connected?: ").append(this.languageClient().delegate() != null).append(")").toString());
        return CompletableFuture.supplyAsync(() -> {
            this.logger().log(Level.INFO, new StringBuilder(30).append("Initializing... (connected?: ").append(this.languageClient().delegate() != null).append(")").toString());
            Runtime.getRuntime().addShutdownHook(new Thread(() -> this.shutdown().get()));
            ClientLoggerFactory clientLoggerFactory = new ClientLoggerFactory(this.languageClient());
            this.clientLogger_$eq(clientLoggerFactory.createLogger(WeaveLanguageServer.class, $this.configuration.lspID()));
            this.projectMetadata_$eq(DefaultProjectMetadata$.MODULE$.create(params));
            this.projectKind_$eq($this.projectKindFactory.createKind(new ProjectKindContext(this.projectMetadata(), clientLoggerFactory, $this.service.getClient(), this.languageClient())));
            if ($this.configuration.fileScheme().isEmpty()) {
                this.projectKind().toolingService(ConfigurationService.class).setLanguageClient(this.languageClient());
                this.projectKind().toolingService(UIService.class).setLanguageClient(this.languageClient());
            }
            DiagnosticsPublisherService publisherService = this.projectKind().toolingService(DiagnosticsPublisherService.class);
            WorkspaceEditService workspaceEditsService = this.projectKind().toolingService(WorkspaceEditService.class);
            if ($this.configuration.fileScheme().isDefined()) {
                publisherService.addPublisher(new DiagnosticsPublisher(this.languageClient(), $this.configuration.fileScheme()));
                workspaceEditsService.addApplier(new WorkspaceEditApplier(this.languageClient(), $this.configuration.fileScheme()));
            } else {
                publisherService.setDefaultPublisher(new DiagnosticsPublisher(this.languageClient(), (Option<String>)Option$.MODULE$.empty()));
                workspaceEditsService.setDefaultApplier(new WorkspaceEditApplier(this.languageClient(), (Option<String>)Option$.MODULE$.empty()));
            }
            this.projectMetadata().setEventBus(this.projectKind().eventBus());
            DataWeaveDocumentService documentServiceImpl = new DataWeaveDocumentService(this.projectKind().toolingService(DataWeaveToolingService.class), this.executor(), this.projectKind().toolingService(ProjectFileSystemService.class), this.projectKind().toolingService(WeaveScenarioManagerService.class), this.projectKind().vfs(), this.projectKind().toolingService(CodeActionsManagerService.class), $this.configuration.codeLens());
            this.textDocumentService().delegate_$eq(documentServiceImpl);
            DataWeaveWorkspaceService workspaceServiceImpl = new DataWeaveWorkspaceService(this.projectMetadata(), this.projectKind().vfs(), clientLoggerFactory, $this.service.getClient(), this.projectKind().toolingService(JobManagerService.class), this.projectKind().toolingService(LSPWeaveIndexService.class), this.projectKind().toolingService(CommandManagerService.class));
            this.workspaceService().delegate_$eq(workspaceServiceImpl);
            documentServiceImpl.initialize(this.projectKind(), this.projectKind().eventBus());
            workspaceServiceImpl.initialize(this.projectKind(), this.projectKind().eventBus());
            this.projectKind().initialize();
            CommandManagerService commandManagerService = this.projectKind().toolingService(CommandManagerService.class);
            ServerCapabilities capabilities = new ServerCapabilities();
            capabilities.setTextDocumentSync(TextDocumentSyncKind.Full);
            capabilities.setCompletionProvider(new CompletionOptions(Predef$.MODULE$.boolean2Boolean(true), Arrays.asList((Object[])new String[]{"."})));
            capabilities.setHoverProvider(Predef$.MODULE$.boolean2Boolean(true));
            capabilities.setDocumentSymbolProvider(Predef$.MODULE$.boolean2Boolean(true));
            capabilities.setDefinitionProvider(Predef$.MODULE$.boolean2Boolean(true));
            capabilities.setDocumentFormattingProvider(Predef$.MODULE$.boolean2Boolean(true));
            capabilities.setFoldingRangeProvider(Predef$.MODULE$.boolean2Boolean(true));
            capabilities.setCodeActionProvider(Predef$.MODULE$.boolean2Boolean($this.configuration.codeActions()));
            capabilities.setWorkspaceSymbolProvider(Predef$.MODULE$.boolean2Boolean(true));
            capabilities.setCodeLensProvider(new CodeLensOptions(Predef$.MODULE$.boolean2Boolean($this.configuration.codeLens())));
            capabilities.setRenameProvider(Predef$.MODULE$.boolean2Boolean(true));
            capabilities.setDocumentRangeFormattingProvider(Predef$.MODULE$.boolean2Boolean(true));
            capabilities.setReferencesProvider(Predef$.MODULE$.boolean2Boolean(true));
            capabilities.setSignatureHelpProvider(new SignatureHelpOptions(Arrays.asList((Object[])new String[]{"("}), Arrays.asList((Object[])new String[]{","})));
            if ($this.configuration.commands()) {
                capabilities.setExecuteCommandProvider(new ExecuteCommandOptions((List)JavaConverters$.MODULE$.seqAsJavaListConverter(commandManagerService.commandIds()).asJava()));
            }
            ServerInfo serverInfo = new ServerInfo("DataWeave", this.projectKind().getWeaveVersion());
            this.clientLogger().logInfo(new StringBuilder(46).append("Initialize: Finished. Server: ").append(serverInfo).append(", Capabilities: ").append(capabilities).toString());
            return new InitializeResult(capabilities, serverInfo);
        });
    }

    public void initialized(InitializedParams params) {
        this.projectKind().toolingService(JobManagerService.class).schedule(x$1 -> {
            try {
                this.clientLogger().logInfo(new StringBuilder(24).append("Project Kind: ").append(this.projectKind().name()).append(" Starting.").toString());
                this.projectKind().initialized();
                this.projectMetadata().markStarted();
                this.clientLogger().logInfo("ProjectStartedEvent fired");
            }
            catch (Exception e) {
                this.clientLogger().logInfo("Unable to Start project.", e);
            }
        }, "Starting DataWeave Project", new StringBuilder(27).append("Starting Project of Kind: ").append(this.projectKind().name()).append(".").toString());
    }

    public CompletableFuture<Object> shutdown() {
        return CompletableFuture.supplyAsync(() -> {
            this.clientLogger().logInfo("Stopping the services");
            this.projectKind().shutdown();
            return null;
        });
    }

    public void exit() {
        System.exit(0);
    }

    @JsonDelegate
    public WeaveTextDocumentService getTextDocumentService() {
        this.logger().log(Level.INFO, "getTextDocumentService");
        return this.textDocumentService();
    }

    public WorkspaceService getWorkspaceService() {
        this.logger().log(Level.INFO, "getWorkspaceService");
        return this.workspaceService();
    }

    public void connect(LanguageClient client) {
        this.logger().log(Level.INFO, "connect");
        this.languageClient().delegate_$eq(client);
    }

    public VirtualFileSystem fs() {
        return this.projectKind().vfs();
    }

    public ExecutorService executor() {
        return IDEExecutors$.MODULE$.defaultExecutor();
    }

    public WeaveLanguageServer(ProjectKindFactory projectKindFactory, LanguageServerConfiguration configuration, DataWeaveProtocolService service) {
        this.projectKindFactory = projectKindFactory;
        this.configuration = configuration;
        this.service = service;
        this.logger = Logger.getLogger(this.getClass().getName());
        this.workspaceService = new WorkspaceServiceDelegate();
        this.textDocumentService = new TextDocumentServiceDelegate();
        this.languageClient = new LanguageClientDelegate();
    }
}

