/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.lsp.agent;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.mule.weave.extension.api.component.dependency.DependencyArtifact;
import org.mule.weave.extension.api.project.ProjectMetadata;
import org.mule.weave.lsp.agent.AgentClasspathResolver;
import org.mule.weave.lsp.agent.FutureValue;
import org.mule.weave.lsp.agent.FutureValue$;
import org.mule.weave.lsp.agent.WeaveTypeBind;
import org.mule.weave.lsp.extension.protocol.PreviewResult;
import org.mule.weave.lsp.extension.protocol.PreviewResult$;
import org.mule.weave.lsp.project.ProjectKind;
import org.mule.weave.lsp.project.components.ClassPathConfig;
import org.mule.weave.lsp.project.components.ClassPathConfig$;
import org.mule.weave.lsp.project.components.JavaWeaveLauncher$;
import org.mule.weave.lsp.project.components.ProjectStructureHelper$;
import org.mule.weave.lsp.project.components.Scenario;
import org.mule.weave.lsp.project.events.DependencyArtifactResolvedEvent$;
import org.mule.weave.lsp.project.events.OnDependencyArtifactResolved;
import org.mule.weave.lsp.project.events.OnProjectStarted;
import org.mule.weave.lsp.project.events.ProjectStartedEvent$;
import org.mule.weave.lsp.services.ClientLogger;
import org.mule.weave.lsp.services.ClientLoggerFactory;
import org.mule.weave.lsp.services.DataWeaveToolingService;
import org.mule.weave.lsp.services.ToolingService;
import org.mule.weave.lsp.services.WeaveScenarioManagerService;
import org.mule.weave.lsp.services.events.AgentStartedEvent;
import org.mule.weave.lsp.services.events.AgentStoppedEvent;
import org.mule.weave.lsp.utils.IOUtils$;
import org.mule.weave.lsp.utils.InternalEventBus;
import org.mule.weave.lsp.utils.NetUtils$;
import org.mule.weave.lsp.utils.ProcessStreamLineConsumer;
import org.mule.weave.v2.agent.api.event.DataFormatsDefinitionsEvent;
import org.mule.weave.v2.agent.api.event.ImplicitInputTypesEvent;
import org.mule.weave.v2.agent.api.event.InferWeaveTypeEvent;
import org.mule.weave.v2.agent.api.event.ModuleResolvedEvent;
import org.mule.weave.v2.agent.api.event.PreviewExecutedEvent;
import org.mule.weave.v2.agent.api.event.PreviewExecutedFailedEvent;
import org.mule.weave.v2.agent.api.event.PreviewExecutedSuccessfulEvent;
import org.mule.weave.v2.agent.api.event.UnexpectedServerErrorEvent;
import org.mule.weave.v2.agent.api.event.WeaveDataFormatDescriptor;
import org.mule.weave.v2.agent.api.event.WeaveDataFormatProperty;
import org.mule.weave.v2.agent.client.ClientProtocol;
import org.mule.weave.v2.agent.client.ConnectionRetriesListener;
import org.mule.weave.v2.agent.client.DataFormatDefinitionListener;
import org.mule.weave.v2.agent.client.ImplicitWeaveTypesListener;
import org.mule.weave.v2.agent.client.ModuleLoadedListener;
import org.mule.weave.v2.agent.client.PreviewExecutedListener;
import org.mule.weave.v2.agent.client.WeaveAgentClient;
import org.mule.weave.v2.agent.client.WeaveTypeInferListener;
import org.mule.weave.v2.agent.client.tcp.TcpClientProtocol;
import org.mule.weave.v2.completion.DataFormatDescriptor;
import org.mule.weave.v2.completion.DataFormatDescriptor$;
import org.mule.weave.v2.completion.DataFormatProperty;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.sdk.WeaveResource;
import org.mule.weave.v2.sdk.WeaveResource$;
import org.mule.weave.v2.ts.WeaveType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\tUh\u0001\u0002\u001a4\u0001yB\u0001b\u0013\u0001\u0003\u0002\u0003\u0006I\u0001\u0014\u0005\t\u001f\u0002\u0011\t\u0011)A\u0005!\"A!\f\u0001B\u0001B\u0003%1\f\u0003\u0005_\u0001\t\u0005\t\u0015!\u0003`\u0011!A\u0007A!A!\u0002\u0013I\u0007\u0002\u00037\u0001\u0005\u0003\u0005\u000b\u0011B7\t\u000bE\u0004A\u0011\u0001:\t\u000fi\u0004!\u0019!C\u0005w\"1q\u0010\u0001Q\u0001\nqD\u0011\"!\u0001\u0001\u0005\u0004%\t!a\u0001\t\u0011\u0005E\u0001\u0001)A\u0005\u0003\u000bA\u0011\"a\u0005\u0001\u0005\u0004%\t!a\u0001\t\u0011\u0005U\u0001\u0001)A\u0005\u0003\u000bA\u0011\"a\u0006\u0001\u0005\u0004%\t!a\u0001\t\u0011\u0005e\u0001\u0001)A\u0005\u0003\u000bA1\"a\u0007\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u001e!Y\u0011Q\u0005\u0001A\u0002\u0003\u0007I\u0011BA\u0014\u0011-\t\u0019\u0004\u0001a\u0001\u0002\u0003\u0006K!a\b\t\u0017\u0005U\u0002\u00011AA\u0002\u0013%\u0011q\u0007\u0005\f\u0003\u0017\u0002\u0001\u0019!a\u0001\n\u0013\ti\u0005C\u0006\u0002R\u0001\u0001\r\u0011!Q!\n\u0005e\u0002bCA*\u0001\u0001\u0007\t\u0019!C\u0005\u0003+B1\"!\u0019\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002d!Y\u0011q\r\u0001A\u0002\u0003\u0005\u000b\u0015BA,\u0011%\tI\u0007\u0001b\u0001\n\u0013\tY\u0007\u0003\u0005\u0002z\u0001\u0001\u000b\u0011BA7\u0011-\tY\b\u0001a\u0001\u0002\u0004%I!! \t\u0017\u0005-\u0005\u00011AA\u0002\u0013%\u0011Q\u0012\u0005\f\u0003#\u0003\u0001\u0019!A!B\u0013\ty\bC\u0004\u0002\u0014\u0002!\t%!&\t\u000f\u0005m\u0005\u0001\"\u0001\u0002\u001e\"9\u0011q\u0014\u0001\u0005\u0002\u0005u\u0005bBAQ\u0001\u0011%\u00111\u0015\u0005\b\u0003W\u0003A\u0011BAW\u0011\u001d\t)\f\u0001C!\u0003;Cq!a.\u0001\t\u0003\tI\fC\u0004\u0002d\u0002!\t!!:\t\u000f\tM\u0001\u0001\"\u0001\u0003\u0016!9!q\u0003\u0001\u0005\n\u00055\u0006b\u0002B\r\u0001\u0011\u0005!1\u0004\u0005\b\u0005_\u0001A\u0011\u0001B\u0019\u0011\u001d\u0011\u0019\u0005\u0001C\u0001\u0005\u000bBqAa\u0011\u0001\t\u0003\u0011)\bC\u0004\u0003$\u0002!IA!*\t\u0013\t5\u0006!%A\u0005\n\t=\u0006b\u0002Bc\u0001\u0011\u0005!q\u0019\u0005\b\u00053\u0004A\u0011\u0002Bn\u0011\u001d\u0011\t\u0010\u0001C!\u0003;CqAa=\u0001\t\u0013\tiJA\tXK\u00064X-Q4f]R\u001cVM\u001d<jG\u0016T!\u0001N\u001b\u0002\u000b\u0005<WM\u001c;\u000b\u0005Y:\u0014a\u00017ta*\u0011\u0001(O\u0001\u0006o\u0016\fg/\u001a\u0006\u0003um\nA!\\;mK*\tA(A\u0002pe\u001e\u001c\u0001aE\u0002\u0001\u007f\u0015\u0003\"\u0001Q\"\u000e\u0003\u0005S\u0011AQ\u0001\u0006g\u000e\fG.Y\u0005\u0003\t\u0006\u0013a!\u00118z%\u00164\u0007C\u0001$J\u001b\u00059%B\u0001%6\u0003!\u0019XM\u001d<jG\u0016\u001c\u0018B\u0001&H\u00059!vn\u001c7j]\u001e\u001cVM\u001d<jG\u0016\f\u0011C^1mS\u0012\fG/[8o'\u0016\u0014h/[2f!\t1U*\u0003\u0002O\u000f\n9B)\u0019;b/\u0016\fg/\u001a+p_2LgnZ*feZL7-Z\u0001\tKb,7-\u001e;peB\u0011\u0011\u000bW\u0007\u0002%*\u00111\u000bV\u0001\u000bG>t7-\u001e:sK:$(BA+W\u0003\u0011)H/\u001b7\u000b\u0003]\u000bAA[1wC&\u0011\u0011L\u0015\u0002\t\u000bb,7-\u001e;pe\u0006iAn\\4hKJ4\u0015m\u0019;pef\u0004\"A\u0012/\n\u0005u;%aE\"mS\u0016tG\u000fT8hO\u0016\u0014h)Y2u_JL\u0018a\u00029s_*,7\r\u001e\t\u0003A\u001al\u0011!\u0019\u0006\u0003=\nT!a\u00193\u0002\u0007\u0005\u0004\u0018N\u0003\u0002fo\u0005IQ\r\u001f;f]NLwN\\\u0005\u0003O\u0006\u0014q\u0002\u0015:pU\u0016\u001cG/T3uC\u0012\fG/Y\u0001\u0017g\u000e,g.\u0019:j_6\u000bg.Y4feN+'O^5dKB\u0011aI[\u0005\u0003W\u001e\u00131dV3bm\u0016\u001c6-\u001a8be&|W*\u00198bO\u0016\u00148+\u001a:wS\u000e,\u0017!E2mCN\u001c\b/\u0019;i%\u0016\u001cx\u000e\u001c<feB\u0011an\\\u0007\u0002g%\u0011\u0001o\r\u0002\u0017\u0003\u001e,g\u000e^\"mCN\u001c\b/\u0019;i%\u0016\u001cx\u000e\u001c<fe\u00061A(\u001b8jiz\"ra\u001d;vm^D\u0018\u0010\u0005\u0002o\u0001!)1j\u0002a\u0001\u0019\")qj\u0002a\u0001!\")!l\u0002a\u00017\")al\u0002a\u0001?\")\u0001n\u0002a\u0001S\")An\u0002a\u0001[\u0006a1\r\\5f]RdunZ4feV\tA\u0010\u0005\u0002G{&\u0011ap\u0012\u0002\r\u00072LWM\u001c;M_\u001e<WM]\u0001\u000eG2LWM\u001c;M_\u001e<WM\u001d\u0011\u0002A\u0005;UI\u0014+`'\u0016\u0013f+\u0012*`\u0019\u0006+fj\u0011%F%~k\u0015)\u0013(`\u00072\u000b5kU\u000b\u0003\u0003\u000b\u0001B!a\u0002\u0002\u000e5\u0011\u0011\u0011\u0002\u0006\u0004\u0003\u00171\u0016\u0001\u00027b]\u001eLA!a\u0004\u0002\n\t11\u000b\u001e:j]\u001e\f\u0011%Q$F\u001dR{6+\u0012*W\u000bJ{F*Q+O\u0007\"+%kX'B\u0013:{6\tT!T'\u0002\n!\u0002T%H\u0011R{vIU#Z\u0003-a\u0015j\u0012%U?\u001e\u0013V)\u0017\u0011\u0002\u0007I+E)\u0001\u0003S\u000b\u0012\u0003\u0013\u0001D1hK:$\bK]8dKN\u001cXCAA\u0010!\u0011\t9!!\t\n\t\u0005\r\u0012\u0011\u0002\u0002\b!J|7-Z:t\u0003A\tw-\u001a8u!J|7-Z:t?\u0012*\u0017\u000f\u0006\u0003\u0002*\u0005=\u0002c\u0001!\u0002,%\u0019\u0011QF!\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003c\t\u0012\u0011!a\u0001\u0003?\t1\u0001\u001f\u00132\u00035\tw-\u001a8u!J|7-Z:tA\u0005\u0001r/Z1wK\u0006;WM\u001c;DY&,g\u000e^\u000b\u0003\u0003s\u0001B!a\u000f\u0002H5\u0011\u0011Q\b\u0006\u0005\u0003\u007f\t\t%\u0001\u0004dY&,g\u000e\u001e\u0006\u0004i\u0005\r#bAA#o\u0005\u0011aOM\u0005\u0005\u0003\u0013\niD\u0001\tXK\u00064X-Q4f]R\u001cE.[3oi\u0006!r/Z1wK\u0006;WM\u001c;DY&,g\u000e^0%KF$B!!\u000b\u0002P!I\u0011\u0011\u0007\u000b\u0002\u0002\u0003\u0007\u0011\u0011H\u0001\u0012o\u0016\fg/Z!hK:$8\t\\5f]R\u0004\u0013a\u00039s_*,7\r^&j]\u0012,\"!a\u0016\u0011\t\u0005e\u0013QL\u0007\u0003\u00037R!AX\u001b\n\t\u0005}\u00131\f\u0002\f!J|'.Z2u\u0017&tG-A\bqe>TWm\u0019;LS:$w\fJ3r)\u0011\tI#!\u001a\t\u0013\u0005Er#!AA\u0002\u0005]\u0013\u0001\u00049s_*,7\r^&j]\u0012\u0004\u0013AD:uCJ$\u0018iZ3oi2{7m[\u000b\u0003\u0003[\u0002B!a\u001c\u0002v5\u0011\u0011\u0011\u000f\u0006\u0004\u0003g\u0012\u0016!\u00027pG.\u001c\u0018\u0002BA<\u0003c\u0012A\u0001T8dW\u0006y1\u000f^1si\u0006;WM\u001c;M_\u000e\\\u0007%\u0001\u0005fm\u0016tGOQ;t+\t\ty\b\u0005\u0003\u0002\u0002\u0006\u001dUBAAB\u0015\r\t))N\u0001\u0006kRLGn]\u0005\u0005\u0003\u0013\u000b\u0019I\u0001\tJ]R,'O\\1m\u000bZ,g\u000e\u001e\"vg\u0006aQM^3oi\n+8o\u0018\u0013fcR!\u0011\u0011FAH\u0011%\t\t\u0004HA\u0001\u0002\u0004\ty(A\u0005fm\u0016tGOQ;tA\u0005Q\u0011N\\5uS\u0006d\u0017N_3\u0015\r\u0005%\u0012qSAM\u0011\u001d\t\u0019F\ba\u0001\u0003/Bq!a\u001f\u001f\u0001\u0004\ty(A\u0004sKN$\u0018M\u001d;\u0015\u0005\u0005%\u0012AC:uCJ$\u0018iZ3oi\u0006i\u0011mZ3oi\u0016C\u0018\u000e^\"pI\u0016,\"!!*\u0011\u0007\u0001\u000b9+C\u0002\u0002*\u0006\u00131!\u00138u\u00039I7\u000f\u0015:pG\u0016\u001c8/\u00117jm\u0016,\"!a,\u0011\u0007\u0001\u000b\t,C\u0002\u00024\u0006\u0013qAQ8pY\u0016\fg.A\u0006j]&$\u0018.\u00197ju\u0016$\u0017!H5oM\u0016\u0014\u0018J\u001c9vi6+G/\u00193bi\u00064uN]*dK:\f'/[8\u0015\t\u0005m\u00161\u001b\t\u0006#\u0006u\u0016\u0011Y\u0005\u0004\u0003\u007f\u0013&!E\"p[BdW\r^1cY\u00164U\u000f^;sKB)\u0001)a1\u0002H&\u0019\u0011QY!\u0003\r=\u0003H/[8o!\u0015\u0001\u0015\u0011ZAg\u0013\r\tY-\u0011\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004]\u0006=\u0017bAAig\tiq+Z1wKRK\b/\u001a\"j]\u0012Dq!!6%\u0001\u0004\t9.\u0001\u0005tG\u0016t\u0017M]5p!\u0011\tI.a8\u000e\u0005\u0005m'\u0002BAo\u00037\n!bY8na>tWM\u001c;t\u0013\u0011\t\t/a7\u0003\u0011M\u001bWM\\1sS>\fQB]3t_24X-T8ek2,GCBAt\u0003o\u0014y\u0001E\u0003R\u0003{\u000bI\u000fE\u0003A\u0003\u0007\fY\u000f\u0005\u0003\u0002n\u0006MXBAAx\u0015\u0011\t\t0a\u0011\u0002\u0007M$7.\u0003\u0003\u0002v\u0006=(!D,fCZ,'+Z:pkJ\u001cW\rC\u0004\u0002z\u0016\u0002\r!a?\u0002\u0015%$WM\u001c;jM&,'\u000f\u0005\u0003\u0002~\n-a\u0002BA\u0000\u0005\u000f\u00012A!\u0001B\u001b\t\u0011\u0019AC\u0002\u0003\u0006u\na\u0001\u0010:p_Rt\u0014b\u0001B\u0005\u0003\u00061\u0001K]3eK\u001aLA!a\u0004\u0003\u000e)\u0019!\u0011B!\t\u000f\tEQ\u00051\u0001\u0002|\u00061An\\1eKJ\fab\u00195fG.\u001cuN\u001c8fGR,G\r\u0006\u0002\u00020\u0006q\u0011n\u001d#jg\u000e|gN\\3di\u0016$\u0017AH5oM\u0016\u0014x*\u001e;qkRlU\r^1eCR\fgi\u001c:TG\u0016t\u0017M]5p)\u0011\u0011iB!\f\u0011\u000bE\u000biLa\b\u0011\u000b\u0001\u000b\u0019M!\t\u0011\t\t\r\"\u0011F\u0007\u0003\u0005KQAAa\n\u0002D\u0005\u0011Ao]\u0005\u0005\u0005W\u0011)CA\u0005XK\u00064X\rV=qK\"9\u0011Q\u001b\u0015A\u0002\u0005]\u0017a\u00033bi\u00064uN]7biN$\"Aa\r\u0011\u000b\u0001\u000bIM!\u000e\u0011\t\t]\"qH\u0007\u0003\u0005sQAAa\u000f\u0003>\u0005)QM^3oi*\u00191-!\u0011\n\t\t\u0005#\u0011\b\u0002\u001a/\u0016\fg/\u001a#bi\u00064uN]7bi\u0012+7o\u0019:jaR|'/A\u0002sk:$\u0002Ba\u0012\u0003V\t5$\u0011\u000f\t\u0005\u0005\u0013\u0012\t&\u0004\u0002\u0003L)!!Q\nB(\u0003!\u0001(o\u001c;pG>d'BA36\u0013\u0011\u0011\u0019Fa\u0013\u0003\u001bA\u0013XM^5foJ+7/\u001e7u\u0011\u001d\u00119F\u000ba\u0001\u00053\naB\\1nK&#WM\u001c;jM&,'\u000f\u0005\u0003\u0003\\\t%TB\u0001B/\u0015\u0011\u0011yF!\u0019\u0002\u0013Y\f'/[1cY\u0016\u001c(\u0002\u0002B2\u0005K\n1!Y:u\u0015\u0011\u00119'a\u0011\u0002\rA\f'o]3s\u0013\u0011\u0011YG!\u0018\u0003\u001d9\u000bW.Z%eK:$\u0018NZ5fe\"9!q\u000e\u0016A\u0002\u0005m\u0018aB2p]R,g\u000e\u001e\u0005\b\u0005gR\u0003\u0019AA~\u0003\r)(\u000f\u001c\u000b\u0013\u0005\u000f\u00129H!\u001f\u0003|\tu$1\u0011BG\u0005'\u0013y\nC\u0004\u0003X-\u0002\rA!\u0017\t\u000f\t=4\u00061\u0001\u0002|\"9!1O\u0016A\u0002\u0005m\bb\u0002B@W\u0001\u0007!\u0011Q\u0001\u0010aJ,g/[3x'\u000e,g.\u0019:j_B)\u0001)a1\u0002X\"9!QQ\u0016A\u0002\t\u001d\u0015!\u0005:v]RLW.\u001a)s_B,'\u000f^5fgBA\u0011Q BE\u0003w\fY0\u0003\u0003\u0003\f\n5!aA'ba\"9!qR\u0016A\u0002\tE\u0015AD8viB,H/T5nKRK\b/\u001a\t\u0006\u0001\u0006\r\u00171 \u0005\b\u0005+[\u0003\u0019\u0001BL\u00031i\u0017-\u001f2f)&lWm\\;u!\u0015\u0001\u00151\u0019BM!\r\u0001%1T\u0005\u0004\u0005;\u000b%\u0001\u0002'p]\u001eDqA!),\u0001\u0004\ty+\u0001\nxSRDG+Z:ug\u000ec\u0017m]:qCRD\u0017aF2bY\u000e,H.\u0019;f\u0019>\u001c\u0017\r\\\"mCN\u001c\b/\u0019;i)\u0011\u00119K!+\u0011\u000b\u0001\u000bI-a?\t\u0013\t-F\u0006%AA\u0002\u0005=\u0016!C<ji\"$Vm\u001d;t\u0003\u0005\u001a\u0017\r\\2vY\u0006$X\rT8dC2\u001cE.Y:ta\u0006$\b\u000e\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011\tL\u000b\u0003\u00020\nM6F\u0001B[!\u0011\u00119L!1\u000e\u0005\te&\u0002\u0002B^\u0005{\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t}\u0016)\u0001\u0006b]:|G/\u0019;j_:LAAa1\u0003:\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002%\u0011,g-\u001b8fI\u0012\u000bG/\u0019$pe6\fGo\u001d\u000b\u0003\u0005\u0013\u0004R!UA_\u0005\u0017\u0004R\u0001QAe\u0005\u001b\u0004BAa4\u0003V6\u0011!\u0011\u001b\u0006\u0005\u0005'\f\u0019%\u0001\u0006d_6\u0004H.\u001a;j_:LAAa6\u0003R\n!B)\u0019;b\r>\u0014X.\u0019;EKN\u001c'/\u001b9u_J\f\u0001\u0003^8ECR\fgi\u001c:nCR\u0004&o\u001c9\u0015\t\tu'Q\u001d\t\u0006\u0001\u0006%'q\u001c\t\u0005\u0005\u001f\u0014\t/\u0003\u0003\u0003d\nE'A\u0005#bi\u00064uN]7biB\u0013x\u000e]3sifDqAa:0\u0001\u0004\u0011I/\u0001\u000exK\u00064X\rR1uC\u001a{'/\\1u!J|\u0007/\u001a:usN+\u0017\u000fE\u0003A\u0003\u0013\u0014Y\u000f\u0005\u0003\u00038\t5\u0018\u0002\u0002Bx\u0005s\u0011qcV3bm\u0016$\u0015\r^1G_Jl\u0017\r\u001e)s_B,'\u000f^=\u0002\tM$x\u000e]\u0001\ngR|\u0007/Q4f]R\u0004")
public class WeaveAgentService
implements ToolingService {
    public final DataWeaveToolingService org$mule$weave$lsp$agent$WeaveAgentService$$validationService;
    private final Executor executor;
    private final ProjectMetadata project;
    private final WeaveScenarioManagerService scenarioManagerService;
    private final AgentClasspathResolver classpathResolver;
    private final ClientLogger org$mule$weave$lsp$agent$WeaveAgentService$$clientLogger;
    private final String AGENT_SERVER_LAUNCHER_MAIN_CLASS;
    private final String LIGHT_GREY;
    private final String RED;
    private Process agentProcess;
    private WeaveAgentClient weaveAgentClient;
    private ProjectKind projectKind;
    private final Lock startAgentLock;
    private InternalEventBus eventBus;

    public ClientLogger org$mule$weave$lsp$agent$WeaveAgentService$$clientLogger() {
        return this.org$mule$weave$lsp$agent$WeaveAgentService$$clientLogger;
    }

    public String AGENT_SERVER_LAUNCHER_MAIN_CLASS() {
        return this.AGENT_SERVER_LAUNCHER_MAIN_CLASS;
    }

    public String LIGHT_GREY() {
        return this.LIGHT_GREY;
    }

    public String RED() {
        return this.RED;
    }

    private Process agentProcess() {
        return this.agentProcess;
    }

    private void agentProcess_$eq(Process x$1) {
        this.agentProcess = x$1;
    }

    private WeaveAgentClient weaveAgentClient() {
        return this.weaveAgentClient;
    }

    private void weaveAgentClient_$eq(WeaveAgentClient x$1) {
        this.weaveAgentClient = x$1;
    }

    private ProjectKind projectKind() {
        return this.projectKind;
    }

    private void projectKind_$eq(ProjectKind x$1) {
        this.projectKind = x$1;
    }

    private Lock startAgentLock() {
        return this.startAgentLock;
    }

    private InternalEventBus eventBus() {
        return this.eventBus;
    }

    private void eventBus_$eq(InternalEventBus x$1) {
        this.eventBus = x$1;
    }

    @Override
    public void initialize(ProjectKind projectKind, InternalEventBus eventBus) {
        this.eventBus_$eq(eventBus);
        this.projectKind_$eq(projectKind);
        eventBus.register(DependencyArtifactResolvedEvent$.MODULE$.ARTIFACT_RESOLVED(), new OnDependencyArtifactResolved(this){
            private final /* synthetic */ WeaveAgentService $outer;

            public void onArtifactsResolved(DependencyArtifact[] artifacts) {
                this.$outer.restart();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        eventBus.register(ProjectStartedEvent$.MODULE$.PROJECT_STARTED(), new OnProjectStarted(this){
            private final /* synthetic */ WeaveAgentService $outer;

            public void onProjectStarted(ProjectMetadata projectMetadata) {
                this.$outer.startAgent();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void restart() {
        this.stopAgent();
        this.startAgent();
    }

    public void startAgent() {
        if (this.startAgentLock().tryLock()) {
            this.org$mule$weave$lsp$agent$WeaveAgentService$$clientLogger().logDebug("Locked startAgent");
            try {
                if (!this.org$mule$weave$lsp$agent$WeaveAgentService$$isProcessAlive()) {
                    int port = NetUtils$.MODULE$.freePort();
                    Seq<String> jars = this.classpathResolver.resolveClasspathJars();
                    if (jars.isEmpty()) {
                        this.org$mule$weave$lsp$agent$WeaveAgentService$$clientLogger().logError("Could not resolve agent jars");
                    }
                    boolean x$1 = false;
                    Seq<String> x$2 = jars;
                    boolean x$3 = ClassPathConfig$.MODULE$.apply$default$2();
                    ClassPathConfig classpathCfg = new ClassPathConfig(x$1, x$3, x$2);
                    ArrayList<String> commandArgs = JavaWeaveLauncher$.MODULE$.buildJavaProcessBaseArgs(this.projectKind(), classpathCfg, this.AGENT_SERVER_LAUNCHER_MAIN_CLASS(), JavaWeaveLauncher$.MODULE$.buildJavaProcessBaseArgs$default$4());
                    ProcessBuilder builder = new ProcessBuilder(new String[0]);
                    ArrayList<String> args = new ArrayList<String>();
                    args.addAll(commandArgs);
                    args.add("-p");
                    args.add(Integer.toString(port));
                    builder.command(args);
                    this.agentProcess_$eq(builder.start());
                    this.org$mule$weave$lsp$agent$WeaveAgentService$$clientLogger().logDebug(new StringBuilder(16).append("Starting Agent: ").append(((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(args).asScala()).mkString(" ")).toString());
                    ProcessStreamLineConsumer processStreamLineConsumer = new ProcessStreamLineConsumer(this){
                        private final /* synthetic */ WeaveAgentService $outer;

                        public void onStdErrorLineRead(String line) {
                            this.$outer.org$mule$weave$lsp$agent$WeaveAgentService$$clientLogger().logError(String.valueOf(line));
                        }

                        public void onStdOutLineRead(String line) {
                            this.$outer.org$mule$weave$lsp$agent$WeaveAgentService$$clientLogger().logDebug(String.valueOf(line));
                        }

                        public void onIOException(IOException ioException) {
                            this.$outer.org$mule$weave$lsp$agent$WeaveAgentService$$clientLogger().logError("Error on Agent", ioException);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    };
                    IOUtils$.MODULE$.forwardProcessStream(this.agentProcess(), this.executor, processStreamLineConsumer);
                    TcpClientProtocol clientProtocol = new TcpClientProtocol("localhost", port);
                    this.weaveAgentClient_$eq(new WeaveAgentClient((ClientProtocol)clientProtocol));
                    this.weaveAgentClient().connect(50, 500L, new ConnectionRetriesListener(this, port){
                        private final /* synthetic */ WeaveAgentService $outer;
                        private final int port$1;

                        public void startConnecting() {
                            this.$outer.org$mule$weave$lsp$agent$WeaveAgentService$$clientLogger().logDebug(new StringBuilder(37).append("DataWeave Agent start connecting at: ").append(this.port$1).toString());
                        }

                        public void connectedSuccessfully() {
                            this.$outer.org$mule$weave$lsp$agent$WeaveAgentService$$clientLogger().logDebug(new StringBuilder(30).append("DataWeave Agent connected at: ").append(this.port$1).toString());
                        }

                        public void failToConnect(String reason) {
                            this.$outer.org$mule$weave$lsp$agent$WeaveAgentService$$clientLogger().logError(new StringBuilder(26).append("Fail to connect to agent: ").append(reason).toString());
                        }

                        public boolean onRetry(int count, int total) {
                            if (!this.$outer.org$mule$weave$lsp$agent$WeaveAgentService$$isProcessAlive()) {
                                this.$outer.org$mule$weave$lsp$agent$WeaveAgentService$$clientLogger().logError(new StringBuilder(67).append("Will not retry as process is no longer alive and exit code was: `").append(this.$outer.org$mule$weave$lsp$agent$WeaveAgentService$$agentExitCode()).append("`.").toString());
                                return false;
                            }
                            this.$outer.org$mule$weave$lsp$agent$WeaveAgentService$$clientLogger().logError(new StringBuilder(23).append("Retrying to connect: ").append(count).append("/").append(total).append(".").toString());
                            return true;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.port$1 = port$1;
                        }
                    });
                    if (!this.weaveAgentClient().isConnected()) {
                        this.org$mule$weave$lsp$agent$WeaveAgentService$$clientLogger().logError("Unable to connect to Weave Agent");
                    } else {
                        this.org$mule$weave$lsp$agent$WeaveAgentService$$clientLogger().logDebug(new StringBuilder(32).append("Weave Agent Started at port: `").append(port).append("`.").toString());
                        this.eventBus().fire(new AgentStartedEvent());
                    }
                }
            }
            finally {
                this.startAgentLock().unlock();
            }
            return;
        }
    }

    public int org$mule$weave$lsp$agent$WeaveAgentService$$agentExitCode() {
        if (this.agentProcess() == null) {
            return -1;
        }
        return this.agentProcess().exitValue();
    }

    public boolean org$mule$weave$lsp$agent$WeaveAgentService$$isProcessAlive() {
        return this.agentProcess() != null && this.agentProcess().isAlive();
    }

    @Override
    public void initialized() {
    }

    public CompletableFuture<Option<WeaveTypeBind[]>> inferInputMetadataForScenario(Scenario scenario) {
        return CompletableFuture.supplyAsync(() -> {
            if (this.checkConnected()) {
                FutureValue result = new FutureValue(FutureValue$.MODULE$.$lessinit$greater$default$1());
                this.weaveAgentClient().inferInputsWeaveType(scenario.inputsDirectory().getAbsolutePath(), new ImplicitWeaveTypesListener(this, result){
                    private final /* synthetic */ WeaveAgentService $outer;
                    private final FutureValue result$1;

                    public void onImplicitWeaveTypesCalculated(ImplicitInputTypesEvent event) {
                        WeaveTypeBind[] binds = (WeaveTypeBind[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])event.types())).flatMap((Function1 & Serializable & scala.Serializable)m -> Option$.MODULE$.option2Iterable($this.$outer.org$mule$weave$lsp$agent$WeaveAgentService$$validationService.loadType(m.wtypeString()).map((Function1 & Serializable & scala.Serializable)wt -> new WeaveTypeBind(m.name(), (WeaveType)wt))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(WeaveTypeBind.class)));
                        this.result$1.set(new Some((Object)binds));
                    }

                    public void onUnexpectedError(UnexpectedServerErrorEvent unexpectedServerErrorEvent) {
                        this.$outer.org$mule$weave$lsp$agent$WeaveAgentService$$clientLogger().logError(new StringBuilder(54).append("Unexpected error at 'inferInputsWeaveType' caused by: ").append(unexpectedServerErrorEvent.stacktrace()).toString());
                        this.result$1.set(None$.MODULE$);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.result$1 = result$1;
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onImplicitWeaveTypesCalculated$1(org.mule.weave.lsp.agent.WeaveAgentService$$anon$5 org.mule.weave.v2.agent.api.event.WeaveTypeEntry ), $anonfun$onImplicitWeaveTypesCalculated$2(org.mule.weave.v2.agent.api.event.WeaveTypeEntry org.mule.weave.v2.ts.WeaveType )}, serializedLambda);
                    }
                });
                return result.get().flatten(Predef$.MODULE$.$conforms());
            }
            return None$.MODULE$;
        }, this.executor);
    }

    public CompletableFuture<Option<WeaveResource>> resolveModule(String identifier, String loader) {
        return CompletableFuture.supplyAsync(() -> {
            if (this.checkConnected()) {
                FutureValue result = new FutureValue(FutureValue$.MODULE$.$lessinit$greater$default$1());
                this.weaveAgentClient().resolveModule(identifier, loader, this.calculateLocalClasspath(this.calculateLocalClasspath$default$1()), new ModuleLoadedListener(this, result){
                    private final /* synthetic */ WeaveAgentService $outer;
                    private final FutureValue result$2;

                    public void onModuleLoaded(ModuleResolvedEvent resultEvent) {
                        None$ maybeUrl;
                        Object object = maybeUrl = resultEvent.url() == null ? None$.MODULE$ : resultEvent.url();
                        if (resultEvent.content().isDefined()) {
                            String content = (String)resultEvent.content().getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
                            String url = (String)maybeUrl.getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
                            this.result$2.set(new Some((Object)WeaveResource$.MODULE$.apply(url, content)));
                            return;
                        }
                        this.result$2.set(None$.MODULE$);
                    }

                    public void onUnexpectedError(UnexpectedServerErrorEvent unexpectedServerErrorEvent) {
                        this.$outer.org$mule$weave$lsp$agent$WeaveAgentService$$clientLogger().logError(new StringBuilder(47).append("Unexpected error at 'resolveModule' caused by: ").append(unexpectedServerErrorEvent.stacktrace()).toString());
                        this.result$2.set(None$.MODULE$);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.result$2 = result$2;
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onModuleLoaded$1(), $anonfun$onModuleLoaded$2()}, serializedLambda);
                    }
                });
                return result.get().flatten(Predef$.MODULE$.$conforms());
            }
            return None$.MODULE$;
        }, this.executor);
    }

    public boolean checkConnected() {
        if (this.isDisconnected()) {
            this.org$mule$weave$lsp$agent$WeaveAgentService$$clientLogger().logDebug("Restarting Agent as is not initialized.");
            this.restart();
        }
        return this.weaveAgentClient() != null && this.weaveAgentClient().isConnected();
    }

    private boolean isDisconnected() {
        return this.weaveAgentClient() == null || !this.weaveAgentClient().isConnected() || !this.org$mule$weave$lsp$agent$WeaveAgentService$$isProcessAlive();
    }

    public CompletableFuture<Option<WeaveType>> inferOutputMetadataForScenario(Scenario scenario) {
        return CompletableFuture.supplyAsync(() -> {
            if (this.checkConnected()) {
                FutureValue result = new FutureValue(FutureValue$.MODULE$.$lessinit$greater$default$1());
                Option<File> maybeExpected = scenario.expected();
                if (maybeExpected.isDefined()) {
                    this.weaveAgentClient().inferWeaveType(((File)maybeExpected.get()).getAbsolutePath(), new WeaveTypeInferListener(this, result){
                        private final /* synthetic */ WeaveAgentService $outer;
                        private final FutureValue result$3;

                        public void onWeaveTypeInfer(InferWeaveTypeEvent event) {
                            this.result$3.set(this.$outer.org$mule$weave$lsp$agent$WeaveAgentService$$validationService.loadType(event.typeString()));
                        }

                        public void onUnexpectedError(UnexpectedServerErrorEvent unexpectedServerErrorEvent) {
                            this.$outer.org$mule$weave$lsp$agent$WeaveAgentService$$clientLogger().logError(new StringBuilder(64).append("Unexpected error at 'inferOutputMetadataForScenario' caused by: ").append(unexpectedServerErrorEvent.stacktrace()).toString());
                            this.result$3.set(None$.MODULE$);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.result$3 = result$3;
                        }
                    });
                    return result.get().flatten(Predef$.MODULE$.$conforms());
                }
                return None$.MODULE$;
            }
            return None$.MODULE$;
        }, this.executor);
    }

    public WeaveDataFormatDescriptor[] dataFormats() {
        if (this.checkConnected()) {
            FutureValue runResult = new FutureValue(FutureValue$.MODULE$.$lessinit$greater$default$1());
            this.weaveAgentClient().definedDataFormats(new DataFormatDefinitionListener(this, runResult){
                private final /* synthetic */ WeaveAgentService $outer;
                private final FutureValue runResult$1;

                public void onDataFormatDefinitionCalculated(DataFormatsDefinitionsEvent dfde) {
                    this.runResult$1.set(dfde.formats());
                }

                public void onUnexpectedError(UnexpectedServerErrorEvent unexpectedServerErrorEvent) {
                    this.$outer.org$mule$weave$lsp$agent$WeaveAgentService$$clientLogger().logError(new StringBuilder(52).append("Unexpected error at 'definedDataFormats' caused by: ").append(unexpectedServerErrorEvent.stacktrace()).toString());
                    this.runResult$1.set(Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(WeaveDataFormatDescriptor.class)));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.runResult$1 = runResult$1;
                }
            });
            return (WeaveDataFormatDescriptor[])runResult.get().getOrElse((Function0 & Serializable & scala.Serializable)() -> (WeaveDataFormatDescriptor[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(WeaveDataFormatDescriptor.class)));
        }
        return (WeaveDataFormatDescriptor[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(WeaveDataFormatDescriptor.class));
    }

    public PreviewResult run(NameIdentifier nameIdentifier, String content, String url) {
        Option<Scenario> maybeScenario = this.scenarioManagerService.activeScenario(nameIdentifier);
        return this.run(nameIdentifier, content, url, maybeScenario, (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)), (Option<String>)None$.MODULE$, (Option<Object>)None$.MODULE$, false);
    }

    public PreviewResult run(NameIdentifier nameIdentifier, String content, String url, Option<Scenario> previewScenario, Map<String, String> runtimeProperties, Option<String> outputMimeType, Option<Object> maybeTimeout, boolean withTestsClasspath) {
        if (this.checkConnected()) {
            long timeout = BoxesRunTime.unboxToLong((Object)maybeTimeout.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString($this.project.settings().previewTimeout().value())).toLong()));
            FutureValue runResult = new FutureValue(timeout * 2L);
            String[] classpath = this.calculateLocalClasspath(withTestsClasspath);
            String inputsPath = (String)previewScenario.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.inputsDirectory().getAbsolutePath()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
            long startTime = System.currentTimeMillis();
            PreviewExecutedListener weaveAgentClientListener = new PreviewExecutedListener(this, runResult, url, startTime){
                private final /* synthetic */ WeaveAgentService $outer;
                private final FutureValue runResult$2;
                private final String url$1;
                private final long startTime$1;

                public void onPreviewExecuted(PreviewExecutedEvent result) {
                    long endTime = System.currentTimeMillis();
                    PreviewExecutedEvent previewExecutedEvent = result;
                    if (previewExecutedEvent instanceof PreviewExecutedFailedEvent) {
                        PreviewExecutedFailedEvent previewExecutedFailedEvent = (PreviewExecutedFailedEvent)previewExecutedEvent;
                        String message = previewExecutedFailedEvent.message();
                        Seq messages = previewExecutedFailedEvent.messages();
                        String[] logsArray = (String[])((TraversableOnce)messages.map((Function1 & Serializable & scala.Serializable)m -> new StringBuilder(3).append(m.timestamp()).append(" : ").append(m.message()).toString(), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
                        String x$1 = message;
                        boolean x$2 = false;
                        List<Object> x$3 = Arrays.asList((Object[])logsArray);
                        String x$4 = this.url$1;
                        long x$5 = endTime - this.startTime$1;
                        String x$6 = PreviewResult$.MODULE$.apply$default$4();
                        String x$7 = PreviewResult$.MODULE$.apply$default$5();
                        String x$8 = PreviewResult$.MODULE$.apply$default$7();
                        String x$9 = PreviewResult$.MODULE$.apply$default$8();
                        this.runResult$2.set(new PreviewResult(x$4, x$2, x$3, x$6, x$7, x$1, x$8, x$9, x$5));
                        return;
                    }
                    if (previewExecutedEvent instanceof PreviewExecutedSuccessfulEvent) {
                        PreviewExecutedSuccessfulEvent previewExecutedSuccessfulEvent = (PreviewExecutedSuccessfulEvent)previewExecutedEvent;
                        byte[] result2 = previewExecutedSuccessfulEvent.result();
                        String mimeType = previewExecutedSuccessfulEvent.mimeType();
                        String extension = previewExecutedSuccessfulEvent.extension();
                        String encoding = previewExecutedSuccessfulEvent.encoding();
                        Seq messages = previewExecutedSuccessfulEvent.messages();
                        String[] logsArray = (String[])((TraversableOnce)messages.map((Function1 & Serializable & scala.Serializable)m -> new StringBuilder(3).append(m.timestamp()).append(" : ").append(m.message()).toString(), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
                        String x$10 = new String(result2, encoding);
                        String x$11 = mimeType;
                        boolean x$12 = true;
                        List<Object> x$13 = Arrays.asList((Object[])logsArray);
                        String x$14 = this.url$1;
                        long x$15 = endTime - this.startTime$1;
                        String x$16 = extension;
                        String x$17 = PreviewResult$.MODULE$.apply$default$6();
                        String x$18 = PreviewResult$.MODULE$.apply$default$7();
                        this.runResult$2.set(new PreviewResult(x$14, x$12, x$13, x$10, x$11, x$17, x$18, x$16, x$15));
                        return;
                    }
                    throw new MatchError((Object)previewExecutedEvent);
                }

                public void onUnexpectedError(UnexpectedServerErrorEvent unexpectedServerErrorEvent) {
                    long endTime = System.currentTimeMillis();
                    this.$outer.org$mule$weave$lsp$agent$WeaveAgentService$$clientLogger().logError(new StringBuilder(44).append("Unexpected error at 'runPreview' caused by: ").append(unexpectedServerErrorEvent.stacktrace()).toString());
                    String x$1 = "Unexpected error at 'runPreview'";
                    boolean x$2 = false;
                    List<Object> x$3 = Arrays.asList((Object[])new String[]{unexpectedServerErrorEvent.stacktrace()});
                    String x$4 = this.url$1;
                    long x$5 = endTime - this.startTime$1;
                    String x$6 = PreviewResult$.MODULE$.apply$default$4();
                    String x$7 = PreviewResult$.MODULE$.apply$default$5();
                    String x$8 = PreviewResult$.MODULE$.apply$default$7();
                    String x$9 = PreviewResult$.MODULE$.apply$default$8();
                    PreviewResult result = new PreviewResult(x$4, x$2, x$3, x$6, x$7, x$1, x$8, x$9, x$5);
                    this.runResult$2.set(result);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.runResult$2 = runResult$2;
                    this.url$1 = url$1;
                    this.startTime$1 = startTime$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onPreviewExecuted$1(org.mule.weave.v2.agent.api.event.WeaveLogMessage ), $anonfun$onPreviewExecuted$2(org.mule.weave.v2.agent.api.event.WeaveLogMessage )}, serializedLambda);
                }
            };
            this.weaveAgentClient().runPreview(inputsPath, content, nameIdentifier.toString(), url, timeout, classpath, runtimeProperties, outputMimeType, weaveAgentClientListener);
            return (PreviewResult)runResult.get().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                String x$1 = "Unable to Start DataWeave Agent to Run Preview.";
                boolean x$2 = false;
                List<String> x$3 = Collections.emptyList();
                String x$4 = url;
                String x$5 = PreviewResult$.MODULE$.apply$default$4();
                String x$6 = PreviewResult$.MODULE$.apply$default$5();
                String x$7 = PreviewResult$.MODULE$.apply$default$7();
                String x$8 = PreviewResult$.MODULE$.apply$default$8();
                long x$9 = PreviewResult$.MODULE$.apply$default$9();
                return new PreviewResult(x$4, x$2, x$3, x$5, x$6, x$1, x$7, x$8, x$9);
            });
        }
        String x$10 = "Unable to Start DataWeave Agent to Run Preview.";
        boolean x$11 = false;
        List<String> x$12 = Collections.emptyList();
        String x$13 = url;
        String x$14 = PreviewResult$.MODULE$.apply$default$4();
        String x$15 = PreviewResult$.MODULE$.apply$default$5();
        String x$16 = PreviewResult$.MODULE$.apply$default$7();
        String x$17 = PreviewResult$.MODULE$.apply$default$8();
        long x$18 = PreviewResult$.MODULE$.apply$default$9();
        return new PreviewResult(x$13, x$11, x$12, x$14, x$15, x$10, x$16, x$17, x$18);
    }

    private String[] calculateLocalClasspath(boolean withTests) {
        String[] sources = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ProjectStructureHelper$.MODULE$.mainSourceFolders(this.projectKind().structure()))).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getAbsolutePath(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        String[] resources = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ProjectStructureHelper$.MODULE$.mainResourcesFolders(this.projectKind().structure()))).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getAbsolutePath(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        String[] targets = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ProjectStructureHelper$.MODULE$.mainTargetFolders(this.projectKind().structure()))).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getAbsolutePath(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        String[] tests = withTests ? (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ProjectStructureHelper$.MODULE$.testsSourceFolders(this.projectKind().structure()))).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.getAbsolutePath(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))) : (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class));
        return (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sources)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])resources)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])targets)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tests)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
    }

    private boolean calculateLocalClasspath$default$1() {
        return false;
    }

    public CompletableFuture<DataFormatDescriptor[]> definedDataFormats() {
        return CompletableFuture.supplyAsync(() -> {
            if (this.checkConnected()) {
                FutureValue result = new FutureValue(FutureValue$.MODULE$.$lessinit$greater$default$1());
                this.weaveAgentClient().definedDataFormats(new DataFormatDefinitionListener(this, result){
                    private final /* synthetic */ WeaveAgentService $outer;
                    private final FutureValue result$4;

                    public void onDataFormatDefinitionCalculated(DataFormatsDefinitionsEvent event) {
                        WeaveDataFormatDescriptor[] formats = event.formats();
                        DataFormatDescriptor[] descriptor = (DataFormatDescriptor[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])formats)).map((Function1 & Serializable & scala.Serializable)weaveDataFormatDescriptor -> {
                            String mimeType = weaveDataFormatDescriptor.mimeType();
                            return DataFormatDescriptor$.MODULE$.apply(mimeType, weaveDataFormatDescriptor.id(), $this.$outer.org$mule$weave$lsp$agent$WeaveAgentService$$toDataFormatProp(weaveDataFormatDescriptor.writerProperties()), $this.$outer.org$mule$weave$lsp$agent$WeaveAgentService$$toDataFormatProp(weaveDataFormatDescriptor.readerProperties()));
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DataFormatDescriptor.class)));
                        this.result$4.set(descriptor);
                    }

                    public void onUnexpectedError(UnexpectedServerErrorEvent unexpectedServerErrorEvent) {
                        this.$outer.org$mule$weave$lsp$agent$WeaveAgentService$$clientLogger().logError(new StringBuilder(52).append("Unexpected error at 'definedDataFormats' caused by: ").append(unexpectedServerErrorEvent.stacktrace()).toString());
                        this.result$4.set(Array$.MODULE$.empty(ClassTag$.MODULE$.apply(DataFormatDescriptor.class)));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.result$4 = result$4;
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onDataFormatDefinitionCalculated$1(org.mule.weave.lsp.agent.WeaveAgentService$$anon$10 org.mule.weave.v2.agent.api.event.WeaveDataFormatDescriptor )}, serializedLambda);
                    }
                });
                return (DataFormatDescriptor[])result.get().getOrElse((Function0 & Serializable & scala.Serializable)() -> (DataFormatDescriptor[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(DataFormatDescriptor.class)));
            }
            return (DataFormatDescriptor[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(DataFormatDescriptor.class));
        }, this.executor);
    }

    public DataFormatProperty[] org$mule$weave$lsp$agent$WeaveAgentService$$toDataFormatProp(WeaveDataFormatProperty[] weaveDataFormatPropertySeq) {
        return (DataFormatProperty[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])weaveDataFormatPropertySeq)).map((Function1 & Serializable & scala.Serializable)property -> new DataFormatProperty(property.name(), property.description(), property.wtype(), property.values()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DataFormatProperty.class)));
    }

    @Override
    public void stop() {
        this.org$mule$weave$lsp$agent$WeaveAgentService$$clientLogger().logDebug("stop() hit");
        this.stopAgent();
    }

    private void stopAgent() {
        this.org$mule$weave$lsp$agent$WeaveAgentService$$clientLogger().logDebug("stopAgent() hit");
        if (this.weaveAgentClient() != null) {
            this.weaveAgentClient().disconnect();
        }
        if (this.agentProcess() != null) {
            this.agentProcess().destroyForcibly();
            this.agentProcess_$eq(null);
        }
        this.eventBus().fire(new AgentStoppedEvent());
    }

    public WeaveAgentService(DataWeaveToolingService validationService, Executor executor, ClientLoggerFactory loggerFactory, ProjectMetadata project, WeaveScenarioManagerService scenarioManagerService, AgentClasspathResolver classpathResolver) {
        this.org$mule$weave$lsp$agent$WeaveAgentService$$validationService = validationService;
        this.executor = executor;
        this.project = project;
        this.scenarioManagerService = scenarioManagerService;
        this.classpathResolver = classpathResolver;
        ToolingService.$init$(this);
        this.org$mule$weave$lsp$agent$WeaveAgentService$$clientLogger = loggerFactory.createLogger(WeaveAgentService.class);
        this.AGENT_SERVER_LAUNCHER_MAIN_CLASS = "org.mule.weave.v2.agent.server.AgentServerLauncher";
        this.LIGHT_GREY = "rgb(113, 113, 113)";
        this.RED = "rgb(139, 0, 0)";
        this.startAgentLock = new ReentrantLock();
    }
}

