/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.lsp.commands;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.lsp4j.ApplyWorkspaceEditParams;
import org.eclipse.lsp4j.ApplyWorkspaceEditResponse;
import org.eclipse.lsp4j.CreateFile;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentEdit;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.mule.weave.extension.api.component.structure.WeaveModuleStructure;
import org.mule.weave.extension.api.component.structure.WeaveRootStructure;
import org.mule.weave.extension.api.extension.command.WeaveCommand;
import org.mule.weave.lsp.commands.Commands$;
import org.mule.weave.lsp.extension.protocol.OpenTextDocumentParams;
import org.mule.weave.lsp.extension.protocol.OpenTextDocumentParams$;
import org.mule.weave.lsp.extension.protocol.WeaveInputBoxParams;
import org.mule.weave.lsp.extension.protocol.WeaveInputBoxParams$;
import org.mule.weave.lsp.extension.protocol.WeaveInputBoxResult;
import org.mule.weave.lsp.extension.protocol.WeaveQuickPickItem;
import org.mule.weave.lsp.extension.protocol.WeaveQuickPickItem$;
import org.mule.weave.lsp.extension.protocol.WeaveQuickPickParams;
import org.mule.weave.lsp.extension.protocol.WeaveQuickPickParams$;
import org.mule.weave.lsp.extension.protocol.WeaveQuickPickResult;
import org.mule.weave.lsp.project.ProjectKind;
import org.mule.weave.lsp.project.components.ProjectStructureHelper$;
import org.mule.weave.lsp.services.UIService;
import org.mule.weave.lsp.services.WorkspaceEditService;
import org.mule.weave.lsp.utils.URLUtils$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001I4QAC\u0006\u0002\u0002YAQA\u000b\u0001\u0005\u0002-BqA\f\u0001C\u0002\u0013\u0005q\u0006\u0003\u00044\u0001\u0001\u0006I\u0001\r\u0005\u0006i\u00011\t!\u000e\u0005\u0006w\u00011\t\u0001\u0010\u0005\u0006\u0013\u00021\tA\u0013\u0005\u0006+\u00021\tA\u0016\u0005\u00061\u0002!\t!\u0017\u0005\u0006Y\u0002!\t%\u001c\u0002\u001a\u0003\n\u001cHO]1di\u000e\u0013X-\u0019;f\r&dWmQ8n[\u0006tGM\u0003\u0002\r\u001b\u0005A1m\\7nC:$7O\u0003\u0002\u000f\u001f\u0005\u0019An\u001d9\u000b\u0005A\t\u0012!B<fCZ,'B\u0001\n\u0014\u0003\u0011iW\u000f\\3\u000b\u0003Q\t1a\u001c:h\u0007\u0001\u00192\u0001A\f !\tAR$D\u0001\u001a\u0015\tQ2$\u0001\u0003mC:<'\"\u0001\u000f\u0002\t)\fg/Y\u0005\u0003=e\u0011aa\u00142kK\u000e$\bC\u0001\u0011)\u001b\u0005\t#B\u0001\u0012$\u0003\u001d\u0019w.\\7b]\u0012T!\u0001J\u0013\u0002\u0013\u0015DH/\u001a8tS>t'B\u0001\u0014(\u0003\r\t\u0007/\u001b\u0006\u0003I=I!!K\u0011\u0003\u0019]+\u0017M^3D_6l\u0017M\u001c3\u0002\rqJg.\u001b;?)\u0005a\u0003CA\u0017\u0001\u001b\u0005Y\u0011aG%O)\u0016;%+\u0011+J\u001f:{V*\u0011)Q\u0013:;ulQ(O)\u0016sE+F\u00011!\tA\u0012'\u0003\u000233\t11\u000b\u001e:j]\u001e\fA$\u0013(U\u000b\u001e\u0013\u0016\tV%P\u001d~k\u0015\t\u0015)J\u001d\u001e{6i\u0014(U\u000b:#\u0006%A\u0004qe>TWm\u0019;\u0016\u0003Y\u0002\"aN\u001d\u000e\u0003aR!\u0001N\u0007\n\u0005iB$a\u0003)s_*,7\r^&j]\u0012\fQbZ3u\u0013:\u0004X\u000f\u001e'bE\u0016dW#A\u001f\u0011\u0005y:eBA F!\t\u00015)D\u0001B\u0015\t\u0011U#\u0001\u0004=e>|GO\u0010\u0006\u0002\t\u0006)1oY1mC&\u0011aiQ\u0001\u0007!J,G-\u001a4\n\u0005IB%B\u0001$D\u000399W\r\u001e#fM\u0006,H\u000e\u001e(b[\u0016$\"!P&\t\u000b13\u0001\u0019A'\u0002\rA\f'/Y7t!\tq5+D\u0001P\u0015\t\u0001\u0016+A\u0003mgB$$N\u0003\u0002S'\u00059Qm\u00197jaN,\u0017B\u0001+P\u0005Q)\u00050Z2vi\u0016\u001cu.\\7b]\u0012\u0004\u0016M]1ng\u0006Yq-\u001a;UK6\u0004H.\u0019;f)\tit\u000bC\u0003M\u000f\u0001\u0007Q*A\u000bsKR\u0014\u0018.\u001a<f\t\u00164\u0017-\u001e7u\r>dG-\u001a:\u0015\u0005i#\u0007cA.]=6\t1)\u0003\u0002^\u0007\n1q\n\u001d;j_:\u0004\"a\u00182\u000e\u0003\u0001T!!Y\u000e\u0002\u0005%|\u0017BA2a\u0005\u00111\u0015\u000e\\3\t\u000b\u0015D\u0001\u0019\u00014\u0002\u0013UL5+\u001a:wS\u000e,\u0007CA4k\u001b\u0005A'BA5\u000e\u0003!\u0019XM\u001d<jG\u0016\u001c\u0018BA6i\u0005%)\u0016jU3sm&\u001cW-A\u0004fq\u0016\u001cW\u000f^3\u0015\u00059\f\bCA.p\u0013\t\u00018I\u0001\u0004B]f\u0014VM\u001a\u0005\u0006\u0019&\u0001\r!\u0014")
public abstract class AbstractCreateFileCommand
implements WeaveCommand {
    private final String INTEGRATION_MAPPING_CONTENT;

    public String INTEGRATION_MAPPING_CONTENT() {
        return this.INTEGRATION_MAPPING_CONTENT;
    }

    public abstract ProjectKind project();

    public abstract String getInputLabel();

    public abstract String getDefaultName(ExecuteCommandParams var1);

    public abstract String getTemplate(ExecuteCommandParams var1);

    public Option<File> retrieveDefaultFolder(UIService uIService) {
        WeaveModuleStructure[] modulesWithRoots = (WeaveModuleStructure[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.project().structure().modules())).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)AbstractCreateFileCommand.$anonfun$retrieveDefaultFolder$1(x$1)));
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])modulesWithRoots)).isEmpty()) {
            return None$.MODULE$;
        }
        if (modulesWithRoots.length == 1) {
            return new Some((Object)((WeaveRootStructure)ProjectStructureHelper$.MODULE$.mainRoot((WeaveModuleStructure)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])modulesWithRoots)).head()).get()).defaultSourceFolder());
        }
        WeaveQuickPickItem[] inputs = (WeaveQuickPickItem[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])modulesWithRoots)).map((Function1 & Serializable & scala.Serializable)m -> new WeaveQuickPickItem(m.name(), m.name(), WeaveQuickPickItem$.MODULE$.apply$default$3(), WeaveQuickPickItem$.MODULE$.apply$default$4(), WeaveQuickPickItem$.MODULE$.apply$default$5(), WeaveQuickPickItem$.MODULE$.apply$default$6()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(WeaveQuickPickItem.class)));
        WeaveQuickPickResult result = uIService.weaveQuickPick(new WeaveQuickPickParams(Arrays.asList((Object[])inputs), "Select the Module where to create the File", WeaveQuickPickParams$.MODULE$.apply$default$3(), WeaveQuickPickParams$.MODULE$.apply$default$4(), WeaveQuickPickParams$.MODULE$.apply$default$5(), WeaveQuickPickParams$.MODULE$.apply$default$6(), WeaveQuickPickParams$.MODULE$.apply$default$7(), WeaveQuickPickParams$.MODULE$.apply$default$8(), WeaveQuickPickParams$.MODULE$.apply$default$9(), WeaveQuickPickParams$.MODULE$.apply$default$10())).get();
        if (Predef$.MODULE$.Boolean2boolean(result.cancelled()) || result.itemsId().isEmpty()) {
            return None$.MODULE$;
        }
        String moduleName = result.itemsId().get(0);
        Option maybeStructure = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])modulesWithRoots)).find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)AbstractCreateFileCommand.$anonfun$retrieveDefaultFolder$3(moduleName, x$2)));
        return maybeStructure.map((Function1 & Serializable & scala.Serializable)x$3 -> ((WeaveRootStructure)ProjectStructureHelper$.MODULE$.mainRoot((WeaveModuleStructure)x$3).get()).defaultSourceFolder());
    }

    public Object execute(ExecuteCommandParams params) {
        Option<File> directory;
        Option<File> option;
        UIService uIService = this.project().toolingService(UIService.class);
        WorkspaceEditService workspaceEdits = this.project().toolingService(WorkspaceEditService.class);
        if (params.getArguments() != null && !params.getArguments().isEmpty()) {
            String directoryUri = Commands$.MODULE$.argAsString(params.getArguments(), 0);
            option = URLUtils$.MODULE$.toFile(directoryUri);
        } else {
            option = this.retrieveDefaultFolder(uIService);
        }
        Option<File> option2 = directory = option;
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            File folder = (File)some.value();
            WeaveInputBoxResult result = uIService.weaveInputBox(new WeaveInputBoxParams(this.getInputLabel(), this.getDefaultName(params), WeaveInputBoxParams$.MODULE$.apply$default$3(), WeaveInputBoxParams$.MODULE$.apply$default$4(), WeaveInputBoxParams$.MODULE$.apply$default$5(), WeaveInputBoxParams$.MODULE$.apply$default$6(), WeaveInputBoxParams$.MODULE$.apply$default$7(), WeaveInputBoxParams$.MODULE$.apply$default$8(), WeaveInputBoxParams$.MODULE$.apply$default$9(), WeaveInputBoxParams$.MODULE$.apply$default$10())).get();
            if (!Predef$.MODULE$.Boolean2boolean(result.cancelled())) {
                String name = result.value();
                if (StringUtils.isEmpty((CharSequence)FilenameUtils.getExtension((String)name))) {
                    name = new StringBuilder(4).append(name).append(".dwl").toString();
                }
                String mappingFile = URLUtils$.MODULE$.toLSPUrl(new File(folder, name));
                Either createFile = Either.forRight((Object)new CreateFile(mappingFile));
                TextEdit textEdit = new TextEdit(new Range(new Position(0, 0), new Position(0, 0)), this.getTemplate(params));
                TextDocumentEdit textDocumentEdit = new TextDocumentEdit(new VersionedTextDocumentIdentifier(mappingFile, Predef$.MODULE$.int2Integer(0)), Arrays.asList((Object[])new TextEdit[]{textEdit}));
                Either insertText = Either.forLeft((Object)textDocumentEdit);
                ArrayList<Object> edits = new ArrayList<Object>();
                edits.add(createFile);
                edits.add(insertText);
                edits.addAll(Arrays.asList((Object[])this.project().newFile(folder, name)));
                ApplyWorkspaceEditResponse response = workspaceEdits.applyEdit(new ApplyWorkspaceEditParams(new WorkspaceEdit(edits))).get();
                if (response.isApplied()) {
                    uIService.openTextDocument(new OpenTextDocumentParams(mappingFile, OpenTextDocumentParams$.MODULE$.apply$default$2()));
                }
            }
        } else if (None$.MODULE$.equals(option2)) {
            uIService.showMessage(new MessageParams(MessageType.Error, "No source folder was detected. Please open a Project before trying to create element."));
        } else {
            throw new MatchError(option2);
        }
        return null;
    }

    public static final /* synthetic */ boolean $anonfun$retrieveDefaultFolder$1(WeaveModuleStructure x$1) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$1.roots())).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$retrieveDefaultFolder$3(String moduleName$1, WeaveModuleStructure x$2) {
        return x$2.name().equals(moduleName$1);
    }

    public AbstractCreateFileCommand() {
        this.INTEGRATION_MAPPING_CONTENT = "|/**\n       |* This mapping won't be shared through your library, but you can use it to try out your module and create integration tests.\n       |*/";
    }
}

