/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.lsp.commands;

import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import org.eclipse.lsp4j.ApplyWorkspaceEditParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.CreateFile;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ResourceOperation;
import org.eclipse.lsp4j.TextDocumentEdit;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.mule.weave.extension.api.extension.command.WeaveCommand;
import org.mule.weave.extension.api.project.ProjectMetadata;
import org.mule.weave.lsp.commands.Commands$;
import org.mule.weave.lsp.commands.CreateUnitTest$;
import org.mule.weave.lsp.extension.protocol.OpenTextDocumentParams;
import org.mule.weave.lsp.extension.protocol.OpenTextDocumentParams$;
import org.mule.weave.lsp.i18n.UserMessages$;
import org.mule.weave.lsp.project.ProjectKind;
import org.mule.weave.lsp.project.components.ProjectStructureHelper$;
import org.mule.weave.lsp.services.DataWeaveToolingService;
import org.mule.weave.lsp.services.UIService;
import org.mule.weave.lsp.services.WorkspaceEditService;
import org.mule.weave.lsp.utils.URLUtils$;
import org.mule.weave.lsp.utils.WeaveDirectoryUtils$;
import org.mule.weave.v2.editor.WeaveDocumentToolingService;
import org.mule.weave.v2.editor.WeaveUnitTestAddition;
import org.mule.weave.v2.parser.ast.AstNode;
import org.mule.weave.v2.parser.location.Position;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.io.BufferedSource;
import scala.io.Source$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t]a\u0001B\f\u0019\u0001\rB\u0001b\u000e\u0001\u0003\u0002\u0003\u0006I\u0001\u000f\u0005\t}\u0001\u0011\t\u0011)A\u0005\u007f!A!\t\u0001B\u0001B\u0003%Q\tC\u0003K\u0001\u0011\u00051\nC\u0003R\u0001\u0011\u0005#\u000bC\u0003a\u0001\u0011\u0005\u0013\rC\u0003q\u0001\u0011%\u0011\u000fC\u0004\u00026\u0001!I!a\u000e\u0006\r\u0005\u001d\u0003\u0001AA%\u0011\u001d\t)\u0007\u0001C\u0005\u0003OBq!!\u001f\u0001\t\u0013\tY\bC\u0004\u0002\u0014\u0002!I!!&\t\u0013\u0005%\u0006!%A\u0005\n\u0005-\u0006bBAa\u0001\u0011%\u00111\u0019\u0005\b\u0003#\u0004A\u0011BAj\u0011\u001d\ti\u000e\u0001C\u0005\u0003?Da!!:\u0001\t\u0003\u0012\u0006bBAt\u0001\u0011\u0005\u0013\u0011^\u0004\b\u0003[D\u0002\u0012AAx\r\u00199\u0002\u0004#\u0001\u0002r\"1!\n\u0006C\u0001\u0003gDq!!>\u0015\t\u0003\t9P\u0001\bDe\u0016\fG/Z+oSR$Vm\u001d;\u000b\u0005eQ\u0012\u0001C2p[6\fg\u000eZ:\u000b\u0005ma\u0012a\u00017ta*\u0011QDH\u0001\u0006o\u0016\fg/\u001a\u0006\u0003?\u0001\nA!\\;mK*\t\u0011%A\u0002pe\u001e\u001c\u0001aE\u0002\u0001I1\u0002\"!\n\u0016\u000e\u0003\u0019R!a\n\u0015\u0002\t1\fgn\u001a\u0006\u0002S\u0005!!.\u0019<b\u0013\tYcE\u0001\u0004PE*,7\r\u001e\t\u0003[Uj\u0011A\f\u0006\u0003_A\nqaY8n[\u0006tGM\u0003\u00022e\u0005IQ\r\u001f;f]NLwN\u001c\u0006\u0003gQ\n1!\u00199j\u0015\t\tD$\u0003\u00027]\taq+Z1wK\u000e{W.\\1oI\u0006\tb/\u00197jI\u0006$\u0018n\u001c8TKJ4\u0018nY3\u0011\u0005ebT\"\u0001\u001e\u000b\u0005mR\u0012\u0001C:feZL7-Z:\n\u0005uR$a\u0006#bi\u0006<V-\u0019<f)>|G.\u001b8h'\u0016\u0014h/[2f\u0003-\u0001(o\u001c6fGR\\\u0015N\u001c3\u0011\u0005\u0001\u001bU\"A!\u000b\u0005\tS\u0012a\u00029s_*,7\r^\u0005\u0003\t\u0006\u00131\u0002\u0015:pU\u0016\u001cGoS5oIB\u0011a\tS\u0007\u0002\u000f*\u0011!IM\u0005\u0003\u0013\u001e\u0013q\u0002\u0015:pU\u0016\u001cG/T3uC\u0012\fG/Y\u0001\u0007y%t\u0017\u000e\u001e \u0015\t1su\n\u0015\t\u0003\u001b\u0002i\u0011\u0001\u0007\u0005\u0006o\u0011\u0001\r\u0001\u000f\u0005\u0006}\u0011\u0001\ra\u0010\u0005\u0006\u0005\u0012\u0001\r!R\u0001\nG>lW.\u00198e\u0013\u0012$\u0012a\u0015\t\u0003)vs!!V.\u0011\u0005YKV\"A,\u000b\u0005a\u0013\u0013A\u0002\u001fs_>$hHC\u0001[\u0003\u0015\u00198-\u00197b\u0013\ta\u0016,\u0001\u0004Qe\u0016$WMZ\u0005\u0003=~\u0013aa\u0015;sS:<'B\u0001/Z\u0003\u001d)\u00070Z2vi\u0016$\"A\u00194\u0011\u0005\r$W\"A-\n\u0005\u0015L&AB!osJ+g\rC\u0003h\r\u0001\u0007\u0001.\u0001\u0004qCJ\fWn\u001d\t\u0003S:l\u0011A\u001b\u0006\u0003W2\fQ\u0001\\:qi)T!!\u001c\u0011\u0002\u000f\u0015\u001cG.\u001b9tK&\u0011qN\u001b\u0002\u0015\u000bb,7-\u001e;f\u0007>lW.\u00198e!\u0006\u0014\u0018-\\:\u0002\u0019\u0011|7I]3bi\u0016$Vm\u001d;\u0015\u0019I,Xp`A\n\u0003;\t\t#a\u000b\u0011\u0005\r\u001c\u0018B\u0001;Z\u0005\u0011)f.\u001b;\t\u000bY<\u0001\u0019A<\u0002\u0011Q,7\u000f\u001e$jY\u0016\u0004\"\u0001_>\u000e\u0003eT!A\u001f\u0015\u0002\u0005%|\u0017B\u0001?z\u0005\u00111\u0015\u000e\\3\t\u000by<\u0001\u0019A*\u0002\u0017Q,7\u000f\u001e$jY\u0016,&\u000b\u0014\u0005\b\u0003\u00039\u0001\u0019AA\u0002\u0003Y!wnY;nK:$Hk\\8mS:<7+\u001a:wS\u000e,\u0007\u0003BA\u0003\u0003\u001fi!!a\u0002\u000b\t\u0005%\u00111B\u0001\u0007K\u0012LGo\u001c:\u000b\u0007\u00055A$\u0001\u0002we%!\u0011\u0011CA\u0004\u0005m9V-\u0019<f\t>\u001cW/\\3oiR{w\u000e\\5oON+'O^5dK\"9\u0011QC\u0004A\u0002\u0005]\u0011aC:uCJ$xJ\u001a4tKR\u00042aYA\r\u0013\r\tY\"\u0017\u0002\u0004\u0013:$\bbBA\u0010\u000f\u0001\u0007\u0011qC\u0001\nK:$wJ\u001a4tKRDq!a\t\b\u0001\u0004\t)#A\nxK\u00064X\rT1oOV\fw-Z\"mS\u0016tG\u000fE\u0002:\u0003OI1!!\u000b;\u0005%)\u0016jU3sm&\u001cW\rC\u0004\u0002.\u001d\u0001\r!a\f\u0002\u001d1\fgnZ;bO\u0016\u001cE.[3oiB\u0019\u0011(!\r\n\u0007\u0005M\"H\u0001\u000bX_J\\7\u000f]1dK\u0016#\u0017\u000e^*feZL7-Z\u0001\u0013C\u0012$G+Z:u)>\u0014E.\u00198l\r&dW\rF\bs\u0003s\tY$!\u0010\u0002@\u0005\u0005\u00131IA#\u0011\u00151\b\u00021\u0001x\u0011\u0015q\b\u00021\u0001T\u0011\u001d\t\t\u0001\u0003a\u0001\u0003\u0007Aq!!\u0006\t\u0001\u0004\t9\u0002C\u0004\u0002 !\u0001\r!a\u0006\t\u000f\u0005\r\u0002\u00021\u0001\u0002&!9\u0011Q\u0006\u0005A\u0002\u0005=\"\u0001B#eSR\u0004\u0002\"a\u0013\u0002V\u0005e\u0013qL\u0007\u0003\u0003\u001bRA!a\u0014\u0002R\u0005AQ.Z:tC\u001e,7OC\u0002\u0002T)\fqA[:p]J\u00048-\u0003\u0003\u0002X\u00055#AB#ji\",'\u000fE\u0002j\u00037J1!!\u0018k\u0005A!V\r\u001f;E_\u000e,X.\u001a8u\u000b\u0012LG\u000fE\u0002j\u0003CJ1!a\u0019k\u0005E\u0011Vm]8ve\u000e,w\n]3sCRLwN\\\u0001\u001aC\u0012$G+Z:u)>,\u00050[:uS:<G+Z:u\u0007>$W\rF\bs\u0003S\nY'!\u001c\u0002p\u0005E\u00141OA<\u0011\u00151(\u00021\u0001x\u0011\u0015q(\u00021\u0001T\u0011\u001d\t\tA\u0003a\u0001\u0003\u0007Aq!!\u0006\u000b\u0001\u0004\t9\u0002C\u0004\u0002 )\u0001\r!a\u0006\t\u000f\u0005U$\u00021\u0001\u0002&\u0005IQ/S*feZL7-\u001a\u0005\b\u0003[Q\u0001\u0019AA\u0018\u0003=9W\r\u001e+fgR\fE\rZ5uS>tGCCA?\u0003\u0013\u000bi)a$\u0002\u0012B)1-a \u0002\u0004&\u0019\u0011\u0011Q-\u0003\r=\u0003H/[8o!\u0011\t)!!\"\n\t\u0005\u001d\u0015q\u0001\u0002\u0016/\u0016\fg/Z+oSR$Vm\u001d;BI\u0012LG/[8o\u0011\u001d\tYi\u0003a\u0001\u0003\u0007\t!\u0003^3tiR{w\u000e\\5oON+'O^5dK\"9\u0011\u0011A\u0006A\u0002\u0005\r\u0001bBA\u000b\u0017\u0001\u0007\u0011q\u0003\u0005\b\u0003?Y\u0001\u0019AA\f\u00039Ign]3siR+\u0007\u0010^#eSR$\"\"a&\u0002\u001c\u0006u\u0015\u0011UAS!\r\tI*C\u0007\u0002\u0001!)a\u0010\u0004a\u0001'\"1\u0011q\u0014\u0007A\u0002M\u000bA\u0001^3ti\"9\u00111\u0015\u0007A\u0002\u0005]\u0011\u0001\u00027j]\u0016D\u0011\"a*\r!\u0003\u0005\r!a\u0006\u0002\r\r|G.^7o\u0003aIgn]3siR+\u0007\u0010^#eSR$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003[SC!a\u0006\u00020.\u0012\u0011\u0011\u0017\t\u0005\u0003g\u000bi,\u0004\u0002\u00026*!\u0011qWA]\u0003%)hn\u00195fG.,GMC\u0002\u0002<f\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\ty,!.\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u0006baBd\u00170\u00123jiN$RA]Ac\u0003\u000fDq!!\f\u000f\u0001\u0004\ty\u0003C\u0004\u0002J:\u0001\r!a3\u0002\u000b\u0015$\u0017\u000e^:\u0011\u000b\r\fi-!\u0013\n\u0007\u0005=\u0017L\u0001\u0006=e\u0016\u0004X-\u0019;fIz\n1\"[:CY\u0006t7NR5mKR!\u0011Q[An!\r\u0019\u0017q[\u0005\u0004\u00033L&a\u0002\"p_2,\u0017M\u001c\u0005\u0006m>\u0001\ra^\u0001\u0010k:\f'\r\\3U_J+h\u000eV3tiR)!/!9\u0002d\")a\u000f\u0005a\u0001o\"9\u0011Q\u000f\tA\u0002\u0005\u0015\u0012\u0001\u00028b[\u0016\f1\u0002Z3tGJL\u0007\u000f^5p]R\u00191+a;\t\u000b\u001d\u0014\u0002\u0019\u00015\u0002\u001d\r\u0013X-\u0019;f+:LG\u000fV3tiB\u0011Q\nF\n\u0003)\t$\"!a<\u0002\u001b\r\u0014X-\u0019;f\u0007>lW.\u00198e)\u0019\tI0a@\u0003\u0004A\u0019\u0011.a?\n\u0007\u0005u(NA\u0004D_6l\u0017M\u001c3\t\r\t\u0005a\u00031\u0001T\u0003\r)(/\u001b\u0005\b\u0005\u000b1\u0002\u0019\u0001B\u0004\u0003\u001d\t7\u000f\u001e(pI\u0016\u0004BA!\u0003\u0003\u00145\u0011!1\u0002\u0006\u0005\u0005\u001b\u0011y!A\u0002bgRTAA!\u0005\u0002\f\u00051\u0001/\u0019:tKJLAA!\u0006\u0003\f\t9\u0011i\u001d;O_\u0012,\u0007")
public class CreateUnitTest
implements WeaveCommand {
    private final DataWeaveToolingService validationService;
    private final ProjectKind projectKind;
    private final ProjectMetadata project;

    public static Command createCommand(String string, AstNode astNode) {
        return CreateUnitTest$.MODULE$.createCommand(string, astNode);
    }

    public String commandId() {
        return Commands$.MODULE$.DW_CREATE_UNIT_TEST();
    }

    public Object execute(ExecuteCommandParams params) {
        UIService uIService = this.projectKind.toolingService(UIService.class);
        WorkspaceEditService workspaceEditsService = this.projectKind.toolingService(WorkspaceEditService.class);
        java.util.List args = params.getArguments();
        String uri = Commands$.MODULE$.argAsString(args, 0);
        int startOffset = Commands$.MODULE$.argAsInt(args, 1);
        int endOffset = Commands$.MODULE$.argAsInt(args, 2);
        WeaveDocumentToolingService documentToolingService = this.validationService.openDocument(uri);
        String testPath = documentToolingService.getTestPathFromDefinition();
        File[] files = ProjectStructureHelper$.MODULE$.testsSourceFolders(this.projectKind.structure());
        File weaveTestFolder = (File)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files)).find((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)CreateUnitTest.$anonfun$execute$1(f))).getOrElse((Function0 & Serializable & scala.Serializable)() -> $this.projectKind.projectFolderFactory().createTestSourceFolder($this.project));
        File testFile = new File(weaveTestFolder, testPath);
        String testFileURL = URLUtils$.MODULE$.toLSPUrl(testFile);
        this.doCreateTest(testFile, testFileURL, documentToolingService, startOffset, endOffset, uIService, workspaceEditsService);
        return null;
    }

    private void doCreateTest(File testFile, String testFileURL, WeaveDocumentToolingService documentToolingService, int startOffset, int endOffset, UIService weaveLanguageClient, WorkspaceEditService languageClient) {
        if (this.isBlankFile(testFile)) {
            this.addTestToBlankFile(testFile, testFileURL, documentToolingService, startOffset, endOffset, weaveLanguageClient, languageClient);
            return;
        }
        this.addTestToExistingTestCode(testFile, testFileURL, documentToolingService, startOffset, endOffset, weaveLanguageClient, languageClient);
    }

    private void addTestToBlankFile(File testFile, String testFileURL, WeaveDocumentToolingService documentToolingService, int startOffset, int endOffset, UIService weaveLanguageClient, WorkspaceEditService languageClient) {
        Option maybeTest = documentToolingService.createUnitTestFromDefinition(startOffset, endOffset);
        maybeTest.foreach((Function1 & Serializable & scala.Serializable)test -> {
            CreateUnitTest.$anonfun$addTestToBlankFile$1(this, testFileURL, testFile, languageClient, weaveLanguageClient, test);
            return BoxedUnit.UNIT;
        });
    }

    private void addTestToExistingTestCode(File testFile, String testFileURL, WeaveDocumentToolingService documentToolingService, int startOffset, int endOffset, UIService uIService, WorkspaceEditService languageClient) {
        BoxedUnit boxedUnit;
        WeaveDocumentToolingService testToolingService = this.validationService.openDocument(testFileURL);
        Option<WeaveUnitTestAddition> maybeAddition = this.getTestAddition(testToolingService, documentToolingService, startOffset, endOffset);
        if (maybeAddition.isEmpty()) {
            this.unableToRunTest(testFile, uIService);
            return;
        }
        WeaveUnitTestAddition testAddition = (WeaveUnitTestAddition)maybeAddition.get();
        String testStr = testAddition.test();
        int line = testAddition.replacementLine() - 1;
        ArrayBuffer edits = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        if (testAddition.needsCommaBefore()) {
            Position commaPosition = testAddition.commaPosition();
            boxedUnit = edits.$plus$eq(this.insertTextEdit(testFileURL, ",", commaPosition.line() - 1, commaPosition.column() - 1));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        edits.$plus$eq(this.insertTextEdit(testFileURL, testStr, line, this.insertTextEdit$default$4()));
        this.applyEdits(languageClient, (Seq<Either<TextDocumentEdit, ResourceOperation>>)edits);
        uIService.openTextDocument(new OpenTextDocumentParams(testFileURL, new Range(new org.eclipse.lsp4j.Position(line, 0), new org.eclipse.lsp4j.Position(line + new StringOps(Predef$.MODULE$.augmentString(testStr)).count((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)CreateUnitTest.$anonfun$addTestToExistingTestCode$1(BoxesRunTime.unboxToChar((Object)x$1)))), 0))));
    }

    private Option<WeaveUnitTestAddition> getTestAddition(WeaveDocumentToolingService testToolingService, WeaveDocumentToolingService documentToolingService, int startOffset, int endOffset) {
        Option maybeAst = testToolingService.ast().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.astNode());
        return maybeAst.flatMap((Function1 & Serializable & scala.Serializable)ast -> documentToolingService.addUnitTestFromDefinition(startOffset, endOffset, ast));
    }

    private Either<TextDocumentEdit, ResourceOperation> insertTextEdit(String testFileURL, String test, int line, int column) {
        org.eclipse.lsp4j.Position position = new org.eclipse.lsp4j.Position(line, column);
        TextEdit textEdit = new TextEdit(new Range(position, position), test);
        TextDocumentEdit textDocumentEdit = new TextDocumentEdit(new VersionedTextDocumentIdentifier(testFileURL, Predef$.MODULE$.int2Integer(0)), Arrays.asList((Object[])new TextEdit[]{textEdit}));
        return Either.forLeft((Object)textDocumentEdit);
    }

    private int insertTextEdit$default$4() {
        return 0;
    }

    private void applyEdits(WorkspaceEditService languageClient, Seq<Either<TextDocumentEdit, ResourceOperation>> edits) {
        java.util.List<Object> editList = Arrays.asList((Object[])edits.toArray(ClassTag$.MODULE$.apply(Either.class)));
        languageClient.applyEdit(new ApplyWorkspaceEditParams(new WorkspaceEdit(editList))).get();
    }

    private boolean isBlankFile(File testFile) {
        boolean bl;
        if (!testFile.exists()) {
            return true;
        }
        try (BufferedSource source = Source$.MODULE$.fromFile(testFile, "UTF-8");){
            bl = source.mkString().trim().isEmpty();
        }
        return bl;
    }

    private void unableToRunTest(File testFile, UIService uIService) {
        uIService.showMessage(new MessageParams(MessageType.Error, UserMessages$.MODULE$.invalidTestFileSyntax(testFile)));
    }

    public String name() {
        return "Creates Unit.";
    }

    public String description(ExecuteCommandParams params) {
        return "Creating Unit Test.";
    }

    public static final /* synthetic */ boolean $anonfun$execute$1(File f) {
        String string = f.getName();
        String string2 = WeaveDirectoryUtils$.MODULE$.DWTest_FOLDER();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$addTestToBlankFile$1(CreateUnitTest $this, String testFileURL$1, File testFile$1, WorkspaceEditService languageClient$1, UIService weaveLanguageClient$1, String test) {
        Either<TextDocumentEdit, ResourceOperation> insertText = $this.insertTextEdit(testFileURL$1, test, 0, $this.insertTextEdit$default$4());
        Either createFile = Either.forRight((Object)new CreateFile(testFileURL$1));
        Seq edits = !testFile$1.exists() ? (Seq)new .colon.colon((Object)createFile, (List)new .colon.colon(insertText, (List)Nil$.MODULE$)) : (Seq)new .colon.colon(insertText, (List)Nil$.MODULE$);
        $this.applyEdits(languageClient$1, (Seq<Either<TextDocumentEdit, ResourceOperation>>)edits);
        weaveLanguageClient$1.openTextDocument(new OpenTextDocumentParams(testFileURL$1, OpenTextDocumentParams$.MODULE$.apply$default$2()));
    }

    public static final /* synthetic */ boolean $anonfun$addTestToExistingTestCode$1(char x$1) {
        return x$1 == '\n';
    }

    public CreateUnitTest(DataWeaveToolingService validationService, ProjectKind projectKind, ProjectMetadata project) {
        this.validationService = validationService;
        this.projectKind = projectKind;
        this.project = project;
    }
}

