/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.lsp.commands;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.lsp4j.ConfigurationItem;
import org.eclipse.lsp4j.ConfigurationParams;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.WorkspaceFolder;
import org.mule.weave.extension.api.extension.command.WeaveCommand;
import org.mule.weave.lsp.commands.Commands$;
import org.mule.weave.lsp.extension.protocol.LaunchConfiguration;
import org.mule.weave.lsp.extension.protocol.LaunchConfiguration$;
import org.mule.weave.lsp.extension.protocol.LaunchConfigurationProperty;
import org.mule.weave.lsp.extension.protocol.WeaveQuickPickItem;
import org.mule.weave.lsp.extension.protocol.WeaveQuickPickItem$;
import org.mule.weave.lsp.extension.protocol.WeaveQuickPickParams;
import org.mule.weave.lsp.extension.protocol.WeaveQuickPickParams$;
import org.mule.weave.lsp.extension.protocol.WeaveQuickPickResult;
import org.mule.weave.lsp.project.ProjectKind;
import org.mule.weave.lsp.services.ConfigurationService;
import org.mule.weave.lsp.services.UIService;
import org.mule.weave.lsp.utils.Icons;
import org.mule.weave.lsp.utils.Icons$vscode$;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001Q4AAC\u0006\u0001-!A!\u0006\u0001B\u0001B\u0003%1\u0006C\u00032\u0001\u0011\u0005!\u0007C\u00047\u0001\t\u0007I\u0011A\u001c\t\ry\u0002\u0001\u0015!\u00039\u0011\u0015y\u0004\u0001\"\u0011A\u0011\u0015q\u0005\u0001\"\u0011P\u0011\u0015q\u0006\u0001\"\u0003`\u0011\u0015\u0001\b\u0001\"\u0011A\u0011\u0015\t\b\u0001\"\u0011s\u0005Ia\u0015-\u001e8dQ^+\u0017M^3D_6l\u0017M\u001c3\u000b\u00051i\u0011\u0001C2p[6\fg\u000eZ:\u000b\u00059y\u0011a\u00017ta*\u0011\u0001#E\u0001\u0006o\u0016\fg/\u001a\u0006\u0003%M\tA!\\;mK*\tA#A\u0002pe\u001e\u001c\u0001aE\u0002\u0001/}\u0001\"\u0001G\u000f\u000e\u0003eQ!AG\u000e\u0002\t1\fgn\u001a\u0006\u00029\u0005!!.\u0019<b\u0013\tq\u0012D\u0001\u0004PE*,7\r\u001e\t\u0003A!j\u0011!\t\u0006\u0003E\r\nqaY8n[\u0006tGM\u0003\u0002%K\u0005IQ\r\u001f;f]NLwN\u001c\u0006\u0003M\u001d\n1!\u00199j\u0015\t!s\"\u0003\u0002*C\taq+Z1wK\u000e{W.\\1oI\u0006Y\u0001O]8kK\u000e$8*\u001b8e!\tas&D\u0001.\u0015\tqS\"A\u0004qe>TWm\u0019;\n\u0005Aj#a\u0003)s_*,7\r^&j]\u0012\fa\u0001P5oSRtDCA\u001a6!\t!\u0004!D\u0001\f\u0011\u0015Q#\u00011\u0001,\u0003\u0011I7m\u001c8\u0016\u0003a\u0002\"!\u000f\u001f\u000e\u0003iR!aO\u0007\u0002\u000bU$\u0018\u000e\\:\n\u0005uR$!B%d_:\u001c\u0018!B5d_:\u0004\u0013!C2p[6\fg\u000eZ%e)\u0005\t\u0005C\u0001\"L\u001d\t\u0019\u0015\n\u0005\u0002E\u000f6\tQI\u0003\u0002G+\u00051AH]8pizR\u0011\u0001S\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0015\u001e\u000ba\u0001\u0015:fI\u00164\u0017B\u0001'N\u0005\u0019\u0019FO]5oO*\u0011!jR\u0001\bKb,7-\u001e;f)\t\u0001F\u000b\u0005\u0002R%6\tq)\u0003\u0002T\u000f\n1\u0011I\\=SK\u001aDQ!\u0016\u0004A\u0002Y\u000ba\u0001]1sC6\u001c\bCA,]\u001b\u0005A&BA-[\u0003\u0015a7\u000f\u001d\u001bk\u0015\tY6#A\u0004fG2L\u0007o]3\n\u0005uC&\u0001F#yK\u000e,H/Z\"p[6\fg\u000e\u001a)be\u0006l7/\u0001\u000ede\u0016\fG/\u001a#fM\u0006,H\u000e^\"p]\u001aLw-\u001e:bi&|g\u000e\u0006\u0003aO&\\\u0007CA1f\u001b\u0005\u0011'BA2e\u0003!\u0001(o\u001c;pG>d'B\u0001\u0013\u000e\u0013\t1'MA\nMCVt7\r[\"p]\u001aLw-\u001e:bi&|g\u000eC\u0003i\u000f\u0001\u0007\u0011)A\u0006nCB\u0004\u0018N\\4OC6,\u0007\"\u00026\b\u0001\u0004\t\u0015AC2p]\u001aLw\rV=qK\")An\u0002a\u0001[\u00069an\u001c#fEV<\u0007CA)o\u0013\tywIA\u0004C_>dW-\u00198\u0002\t9\fW.Z\u0001\fI\u0016\u001c8M]5qi&|g\u000e\u0006\u0002Bg\")Q+\u0003a\u0001-\u0002")
public class LaunchWeaveCommand
implements WeaveCommand {
    private final ProjectKind projectKind;
    private final Icons icon;

    public Icons icon() {
        return this.icon;
    }

    public String commandId() {
        return Commands$.MODULE$.DW_LAUNCH_MAPPING();
    }

    public Object execute(ExecuteCommandParams params) {
        UIService uIService = this.projectKind.toolingService(UIService.class);
        ConfigurationService workspaceService = this.projectKind.toolingService(ConfigurationService.class);
        String mappingName = Commands$.MODULE$.argAsString(params.getArguments(), 0);
        String configType = Commands$.MODULE$.argAsString(params.getArguments(), 1);
        boolean noDebug = Commands$.MODULE$.argAsBoolean(params.getArguments(), 2);
        ConfigurationItem item = new ConfigurationItem();
        List<WorkspaceFolder> workspaceFolders = workspaceService.workspaceFolders().get();
        if (workspaceFolders != null && !workspaceFolders.isEmpty()) {
            item.setScopeUri(workspaceFolders.get(0).getUri());
            item.setSection(LaunchConfiguration$.MODULE$.LAUNCH_REQUEST_TYPE());
            List<Object> configurations = workspaceService.configuration(new ConfigurationParams(Arrays.asList((Object[])new ConfigurationItem[]{item}))).get();
            ArrayList<LaunchConfiguration> results = new ArrayList<LaunchConfiguration>();
            if (!configurations.isEmpty()) {
                for (int e = 0; e < configurations.size(); ++e) {
                    Object config = configurations.get(0);
                    Object object = config;
                    if (!(object instanceof JsonObject)) continue;
                    JsonObject jsonObject = (JsonObject)object;
                    JsonArray array = jsonObject.getAsJsonArray("configurations");
                    if (array == null) continue;
                    Iterator configs = array.iterator();
                    while (configs.hasNext()) {
                        Object object2;
                        JsonObject launchConfig = ((JsonElement)configs.next()).getAsJsonObject();
                        String string = launchConfig.get(LaunchConfiguration$.MODULE$.TYPE_PROP_NAME()).getAsString();
                        String string2 = configType;
                        if (!(string != null ? !string.equals(string2) : string2 != null)) {
                            String string3 = launchConfig.get(LaunchConfiguration$.MODULE$.MAIN_FILE_NAME()).getAsString();
                            String string4 = mappingName;
                            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                                String string5 = launchConfig.get(LaunchConfiguration$.MODULE$.REQUEST_PROP_NAME()).getAsString();
                                String string6 = LaunchConfiguration$.MODULE$.LAUNCH_REQUEST_TYPE();
                                if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
                                    Iterator entries = launchConfig.entrySet().iterator();
                                    String theName = launchConfig.get(LaunchConfiguration$.MODULE$.NAME_PROP_NAME()).getAsString();
                                    String theRequest = launchConfig.get(LaunchConfiguration$.MODULE$.REQUEST_PROP_NAME()).getAsString();
                                    ArrayList<LaunchConfigurationProperty> configurationProperties = new ArrayList<LaunchConfigurationProperty>();
                                    while (entries.hasNext()) {
                                        Map.Entry entry = (Map.Entry)entries.next();
                                        Object object3 = !LaunchConfiguration$.MODULE$.DEFAULT_CONFIG_NAMES().contains(entry.getKey()) ? BoxesRunTime.boxToBoolean((boolean)configurationProperties.add(new LaunchConfigurationProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsJsonPrimitive().getAsString()))) : BoxedUnit.UNIT;
                                    }
                                    object2 = BoxesRunTime.boxToBoolean((boolean)results.add(new LaunchConfiguration(LaunchConfiguration$.MODULE$.DATA_WEAVE_CONFIG_TYPE_NAME(), theName, theRequest, noDebug, configurationProperties)));
                                    continue;
                                }
                            }
                        }
                        object2 = BoxedUnit.UNIT;
                    }
                }
            }
            if (results.isEmpty()) {
                LaunchConfiguration launchConfiguration = this.createDefaultConfiguration(mappingName, configType, noDebug);
                workspaceService.runConfiguration(launchConfiguration);
            } else if (results.size() == 1) {
                workspaceService.runConfiguration((LaunchConfiguration)results.get(0));
            } else {
                ArrayList<WeaveQuickPickItem> items = new ArrayList<WeaveQuickPickItem>();
                Iterator configIterators = results.iterator();
                int i = 0;
                while (configIterators.hasNext()) {
                    LaunchConfiguration configuration = (LaunchConfiguration)configIterators.next();
                    items.add(new WeaveQuickPickItem(Integer.toString(i), new StringBuilder(0).append(this.icon().file()).append(configuration.name()).toString(), WeaveQuickPickItem$.MODULE$.apply$default$3(), WeaveQuickPickItem$.MODULE$.apply$default$4(), WeaveQuickPickItem$.MODULE$.apply$default$5(), WeaveQuickPickItem$.MODULE$.apply$default$6()));
                    ++i;
                }
                WeaveQuickPickResult result = uIService.weaveQuickPick(new WeaveQuickPickParams(items, "Select The Configuration To Run", WeaveQuickPickParams$.MODULE$.apply$default$3(), WeaveQuickPickParams$.MODULE$.apply$default$4(), WeaveQuickPickParams$.MODULE$.apply$default$5(), WeaveQuickPickParams$.MODULE$.apply$default$6(), WeaveQuickPickParams$.MODULE$.apply$default$7(), WeaveQuickPickParams$.MODULE$.apply$default$8(), WeaveQuickPickParams$.MODULE$.apply$default$9(), WeaveQuickPickParams$.MODULE$.apply$default$10())).get();
                if (!Predef$.MODULE$.Boolean2boolean(result.cancelled())) {
                    workspaceService.runConfiguration((LaunchConfiguration)results.get(new StringOps(Predef$.MODULE$.augmentString(result.itemsId().get(0))).toInt()));
                }
            }
        } else {
            LaunchConfiguration launchConfiguration = this.createDefaultConfiguration(mappingName, configType, noDebug);
            workspaceService.runConfiguration(launchConfiguration);
        }
        return null;
    }

    private LaunchConfiguration createDefaultConfiguration(String mappingName, String configType, boolean noDebug) {
        LaunchConfigurationProperty mapping = new LaunchConfigurationProperty(LaunchConfiguration$.MODULE$.MAIN_FILE_NAME(), mappingName);
        return new LaunchConfiguration(configType, new StringBuilder(10).append("Debugging ").append(mappingName).toString(), LaunchConfiguration$.MODULE$.LAUNCH_REQUEST_TYPE(), noDebug, Arrays.asList((Object[])new LaunchConfigurationProperty[]{mapping}));
    }

    public String name() {
        return "Launch DataWeave.";
    }

    public String description(ExecuteCommandParams params) {
        return "Launching DataWeave File.";
    }

    public LaunchWeaveCommand(ProjectKind projectKind) {
        this.projectKind = projectKind;
        this.icon = Icons$vscode$.MODULE$;
    }
}

