/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.lsp.commands;

import java.io.Serializable;
import java.util.concurrent.CountDownLatch;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.mule.weave.dsp.DataWeaveDebuggerAdapterProtocolLauncher$;
import org.mule.weave.extension.api.extension.command.WeaveCommand;
import org.mule.weave.lsp.commands.Commands$;
import org.mule.weave.lsp.jobs.JobManagerService;
import org.mule.weave.lsp.project.DefaultProjectMetadata;
import org.mule.weave.lsp.project.ProjectKind;
import org.mule.weave.lsp.project.components.ProcessLauncher;
import org.mule.weave.lsp.project.components.ProcessLauncher$;
import org.mule.weave.lsp.services.ClientLoggerFactory;
import org.mule.weave.lsp.services.DataWeaveTestService;
import org.mule.weave.lsp.services.UIService;
import org.mule.weave.lsp.utils.NetUtils$;
import org.mule.weave.lsp.vfs.ProjectFileSystemService;
import org.mule.weave.v2.editor.VirtualFileSystem;
import scala.Function0;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005%b\u0001\u0002\b\u0010\u0001iA\u0001B\f\u0001\u0003\u0002\u0003\u0006Ia\f\u0005\to\u0001\u0011\t\u0011)A\u0005q!Aa\b\u0001B\u0001B\u0003%q\b\u0003\u0005E\u0001\t\u0005\t\u0015!\u0003F\u0011!A\u0005A!A!\u0002\u0013I\u0005\u0002C(\u0001\u0005\u0003\u0005\u000b\u0011\u0002)\t\u0011Y\u0003!\u0011!Q\u0001\n]CQA\u0017\u0001\u0005\u0002mCQ!\u001a\u0001\u0005B\u0019DQ\u0001\u001e\u0001\u0005BUDq!!\u0003\u0001\t\u0003\tY\u0001\u0003\u0004\u0002\"\u0001!\tE\u001a\u0005\b\u0003G\u0001A\u0011IA\u0013\u0005=\u0011VO\\,fCZ,7i\\7nC:$'B\u0001\t\u0012\u0003!\u0019w.\\7b]\u0012\u001c(B\u0001\n\u0014\u0003\ra7\u000f\u001d\u0006\u0003)U\tQa^3bm\u0016T!AF\f\u0002\t5,H.\u001a\u0006\u00021\u0005\u0019qN]4\u0004\u0001M\u0019\u0001aG\u0012\u0011\u0005q\tS\"A\u000f\u000b\u0005yy\u0012\u0001\u00027b]\u001eT\u0011\u0001I\u0001\u0005U\u00064\u0018-\u0003\u0002#;\t1qJ\u00196fGR\u0004\"\u0001\n\u0017\u000e\u0003\u0015R!AJ\u0014\u0002\u000f\r|W.\\1oI*\u0011\u0001&K\u0001\nKb$XM\\:j_:T!AK\u0016\u0002\u0007\u0005\u0004\u0018N\u0003\u0002)'%\u0011Q&\n\u0002\r/\u0016\fg/Z\"p[6\fg\u000eZ\u0001\u0012m&\u0014H/^1m\r&dWmU=ti\u0016l\u0007C\u0001\u00196\u001b\u0005\t$B\u0001\u001a4\u0003\u0019)G-\u001b;pe*\u0011AgE\u0001\u0003mJJ!AN\u0019\u0003#YK'\u000f^;bY\u001aKG.Z*zgR,W.\u0001\rqe>TWm\u0019;WSJ$X/\u00197GS2,7+_:uK6\u0004\"!\u000f\u001f\u000e\u0003iR!aO\t\u0002\u0007Y47/\u0003\u0002>u\tA\u0002K]8kK\u000e$h)\u001b7f'f\u001cH/Z7TKJ4\u0018nY3\u0002\u000fA\u0014xN[3diB\u0011\u0001IQ\u0007\u0002\u0003*\u0011a(E\u0005\u0003\u0007\u0006\u0013a\u0003R3gCVdG\u000f\u0015:pU\u0016\u001cG/T3uC\u0012\fG/Y\u0001\faJ|'.Z2u\u0017&tG\r\u0005\u0002A\r&\u0011q)\u0011\u0002\f!J|'.Z2u\u0017&tG-A\u0007m_\u001e<WM\u001d$bGR|'/\u001f\t\u0003\u00156k\u0011a\u0013\u0006\u0003\u0019F\t\u0001b]3sm&\u001cWm]\u0005\u0003\u001d.\u00131c\u00117jK:$Hj\\4hKJ4\u0015m\u0019;pef\f\u0011C[8c\u001b\u0006t\u0017mZ3s'\u0016\u0014h/[2f!\t\tF+D\u0001S\u0015\t\u0019\u0016#\u0001\u0003k_\n\u001c\u0018BA+S\u0005EQuNY'b]\u0006<WM]*feZL7-Z\u0001\u0015I\u0006$\u0018mV3bm\u0016$Vm\u001d;TKJ4\u0018nY3\u0011\u0005)C\u0016BA-L\u0005Q!\u0015\r^1XK\u00064X\rV3tiN+'O^5dK\u00061A(\u001b8jiz\"\u0002\u0002\u00180`A\u0006\u00147\r\u001a\t\u0003;\u0002i\u0011a\u0004\u0005\u0006]!\u0001\ra\f\u0005\u0006o!\u0001\r\u0001\u000f\u0005\u0006}!\u0001\ra\u0010\u0005\u0006\t\"\u0001\r!\u0012\u0005\u0006\u0011\"\u0001\r!\u0013\u0005\u0006\u001f\"\u0001\r\u0001\u0015\u0005\u0006-\"\u0001\raV\u0001\nG>lW.\u00198e\u0013\u0012$\u0012a\u001a\t\u0003QFt!![8\u0011\u0005)lW\"A6\u000b\u00051L\u0012A\u0002\u001fs_>$hHC\u0001o\u0003\u0015\u00198-\u00197b\u0013\t\u0001X.\u0001\u0004Qe\u0016$WMZ\u0005\u0003eN\u0014aa\u0015;sS:<'B\u00019n\u0003\u001d)\u00070Z2vi\u0016$\"A\u001e>\u0011\u0005]DX\"A7\n\u0005el'AB!osJ+g\rC\u0003|\u0015\u0001\u0007A0\u0001\u0004qCJ\fWn\u001d\t\u0004{\u0006\u0015Q\"\u0001@\u000b\u0007}\f\t!A\u0003mgB$$NC\u0002\u0002\u0004]\tq!Z2mSB\u001cX-C\u0002\u0002\by\u0014A#\u0012=fGV$XmQ8n[\u0006tG\rU1sC6\u001c\u0018A\u0003:v]6\u000b\u0007\u000f]5oOR1\u0011QBA\n\u0003/\u00012\u0001HA\b\u0013\r\t\t\"\b\u0002\b\u0013:$XmZ3s\u0011\u0019\t)b\u0003a\u0001O\u000611m\u001c8gS\u001eDq!!\u0007\f\u0001\u0004\tY\"A\u0005v\u0013N+'O^5dKB\u0019!*!\b\n\u0007\u0005}1JA\u0005V\u0013N+'O^5dK\u0006!a.Y7f\u0003-!Wm]2sSB$\u0018n\u001c8\u0015\u0007\u001d\f9\u0003C\u0003|\u001b\u0001\u0007A\u0010")
public class RunWeaveCommand
implements WeaveCommand {
    private final VirtualFileSystem virtualFileSystem;
    private final ProjectFileSystemService projectVirtualFileSystem;
    private final DefaultProjectMetadata project;
    private final ProjectKind projectKind;
    private final ClientLoggerFactory loggerFactory;
    private final JobManagerService jobManagerService;
    private final DataWeaveTestService dataWeaveTestService;

    public String commandId() {
        return Commands$.MODULE$.DW_RUN_MAPPING();
    }

    public Object execute(ExecuteCommandParams params) {
        UIService uIService = this.projectKind.toolingService(UIService.class);
        String configType = Commands$.MODULE$.argAsString(params.getArguments(), 0);
        return this.runMapping(configType, uIService);
    }

    public Integer runMapping(String config, UIService uIService) {
        if (!this.project.isStarted()) {
            uIService.showMessage(new MessageParams(MessageType.Warning, "Can not run a DW script until Project was initialized."));
            return Predef$.MODULE$.int2Integer(-1);
        }
        int port = NetUtils$.MODULE$.freePort();
        CountDownLatch latch = new CountDownLatch(1);
        this.jobManagerService.schedule(status -> {
            ProcessLauncher launcher = ProcessLauncher$.MODULE$.createLauncherByType(config, $this.projectKind, $this.loggerFactory, uIService, $this.projectVirtualFileSystem);
            DataWeaveDebuggerAdapterProtocolLauncher$.MODULE$.launch($this.virtualFileSystem, $this.loggerFactory, uIService, launcher, $this.projectKind, $this.jobManagerService, $this.dataWeaveTestService, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> latch.countDown(), port);
        }, "Starting Debugger Server", "Starting Debugger Server");
        latch.await();
        return Predef$.MODULE$.int2Integer(port);
    }

    public String name() {
        return "Run DataWeave.";
    }

    public String description(ExecuteCommandParams params) {
        return "Running DataWeave Command.";
    }

    public RunWeaveCommand(VirtualFileSystem virtualFileSystem, ProjectFileSystemService projectVirtualFileSystem, DefaultProjectMetadata project, ProjectKind projectKind, ClientLoggerFactory loggerFactory, JobManagerService jobManagerService, DataWeaveTestService dataWeaveTestService) {
        this.virtualFileSystem = virtualFileSystem;
        this.projectVirtualFileSystem = projectVirtualFileSystem;
        this.project = project;
        this.projectKind = projectKind;
        this.loggerFactory = loggerFactory;
        this.jobManagerService = jobManagerService;
        this.dataWeaveTestService = dataWeaveTestService;
    }
}

