/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.lsp.project.commands;

import java.io.FileWriter;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.mule.weave.lsp.project.commands.ProjectCreationInfo;
import org.mule.weave.lsp.project.commands.ProjectCreator;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001)3A!\u0002\u0004\u0001'!)a\u0004\u0001C\u0001?!)\u0011\u0005\u0001C\u0001E!)1\u0006\u0001C\u0005Y!)!\b\u0001C\u0005w\t)B)\u001a4bk2$\bK]8kK\u000e$8I]3bi>\u0014(BA\u0004\t\u0003!\u0019w.\\7b]\u0012\u001c(BA\u0005\u000b\u0003\u001d\u0001(o\u001c6fGRT!a\u0003\u0007\u0002\u00071\u001c\bO\u0003\u0002\u000e\u001d\u0005)q/Z1wK*\u0011q\u0002E\u0001\u0005[VdWMC\u0001\u0012\u0003\ry'oZ\u0002\u0001'\r\u0001AC\u0007\t\u0003+ai\u0011A\u0006\u0006\u0002/\u0005)1oY1mC&\u0011\u0011D\u0006\u0002\u0007\u0003:L(+\u001a4\u0011\u0005maR\"\u0001\u0004\n\u0005u1!A\u0004)s_*,7\r^\"sK\u0006$xN]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0001\u0002\"a\u0007\u0001\u0002\r\r\u0014X-\u0019;f)\t\u0019c\u0005\u0005\u0002\u0016I%\u0011QE\u0006\u0002\u0005+:LG\u000fC\u0003(\u0005\u0001\u0007\u0001&A\u0006qe>TWm\u0019;J]\u001a|\u0007CA\u000e*\u0013\tQcAA\nQe>TWm\u0019;De\u0016\fG/[8o\u0013:4w.A\nhKR\u0014Vm]8ve\u000e,\u0017i]*ue&tw\r\u0006\u0002.qA\u0011a&\u000e\b\u0003_M\u0002\"\u0001\r\f\u000e\u0003ER!A\r\n\u0002\rq\u0012xn\u001c;?\u0013\t!d#\u0001\u0004Qe\u0016$WMZ\u0005\u0003m]\u0012aa\u0015;sS:<'B\u0001\u001b\u0017\u0011\u0015I4\u00011\u0001.\u0003!\u0011Xm]8ve\u000e,\u0017!C<sSR,g)\u001b7f)\r\u0019C\b\u0013\u0005\u0006{\u0011\u0001\rAP\u0001\u0002aB\u0011qHR\u0007\u0002\u0001*\u0011\u0011IQ\u0001\u0005M&dWM\u0003\u0002D\t\u0006\u0019a.[8\u000b\u0003\u0015\u000bAA[1wC&\u0011q\t\u0011\u0002\u0005!\u0006$\b\u000eC\u0003J\t\u0001\u0007Q&A\u0004d_:$XM\u001c;")
public class DefaultProjectCreator
implements ProjectCreator {
    @Override
    public void create(ProjectCreationInfo projectInfo) {
        Path projectPath = projectInfo.pathToCreate().resolve(projectInfo.projectName());
        Files.createDirectories(projectPath, new FileAttribute[0]);
        String replacedPom = this.getResourceAsString("pom-default.xml").replaceAll("@group-id@", projectInfo.groupId()).replaceAll("@artifact-id@", projectInfo.artifactId()).replaceAll("@version@", projectInfo.version()).replaceAll("@project-name@", projectInfo.projectName());
        this.writeFile(projectPath.resolve("pom.xml"), replacedPom);
        Path sourcePath = projectPath.resolve("src");
        Path mainPath = sourcePath.resolve("main");
        Path mainDwPath = mainPath.resolve("dw");
        Path dwModulePath = mainDwPath.resolve("MyModule.dwl");
        Path mainResourcesPath = mainPath.resolve("resources");
        Path testPath = sourcePath.resolve("test");
        Path testDwPath = testPath.resolve("dw");
        Path dwMappingPath = testDwPath.resolve("MyMapping.dwl");
        Path testResourcesPath = testPath.resolve("resources");
        Files.createDirectories(mainDwPath, new FileAttribute[0]);
        Files.createDirectories(mainResourcesPath, new FileAttribute[0]);
        Files.createDirectories(testDwPath, new FileAttribute[0]);
        Files.createDirectories(testResourcesPath, new FileAttribute[0]);
        String exampleDwModule = this.getResourceAsString("dw-template-project-module.dwl");
        String exampleDwMapping = this.getResourceAsString("dw-template-project-mapping.dwl");
        this.writeFile(dwModulePath, exampleDwModule);
        this.writeFile(dwMappingPath, exampleDwMapping);
    }

    private String getResourceAsString(String resource) {
        InputStream source = this.getClass().getClassLoader().getResourceAsStream(resource);
        return new String(source.readAllBytes(), StandardCharsets.UTF_8);
    }

    private void writeFile(Path p, String content) {
        try (FileWriter writer = new FileWriter(p.toFile());){
            writer.write(content);
        }
    }
}

