/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.lsp.services;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.mule.weave.extension.api.extension.validation.DocumentNode;
import org.mule.weave.extension.api.extension.validation.MessageBuilderFactory;
import org.mule.weave.extension.api.extension.validation.MessageValidationCollector;
import org.mule.weave.extension.api.extension.validation.ValidationTypeLevel;
import org.mule.weave.extension.api.extension.validation.WeaveValidator;
import org.mule.weave.extension.api.filesystem.VirtualFile;
import org.mule.weave.extension.api.metadata.ContextMetadata;
import org.mule.weave.extension.api.metadata.InputMetadata;
import org.mule.weave.extension.api.project.ProjectMetadata;
import org.mule.weave.lsp.indexer.events.IndexingFinishedEvent$;
import org.mule.weave.lsp.indexer.events.IndexingType$;
import org.mule.weave.lsp.indexer.events.OnIndexingFinished;
import org.mule.weave.lsp.project.ProjectKind;
import org.mule.weave.lsp.project.Settings$;
import org.mule.weave.lsp.project.components.SampleDataComponent;
import org.mule.weave.lsp.project.events.OnProjectStarted;
import org.mule.weave.lsp.project.events.OnSettingsChanged;
import org.mule.weave.lsp.project.events.ProjectStartedEvent$;
import org.mule.weave.lsp.project.events.SettingsChangedEvent$;
import org.mule.weave.lsp.services.DataWeaveToolingService$;
import org.mule.weave.lsp.services.DiagnosticsPublisherService;
import org.mule.weave.lsp.services.MessageValidationCollectorAdapter;
import org.mule.weave.lsp.services.ToolingService;
import org.mule.weave.lsp.services.WeaveToolingServiceFactory;
import org.mule.weave.lsp.utils.InternalEventBus;
import org.mule.weave.lsp.utils.LSPConverters$;
import org.mule.weave.lsp.utils.URLUtils$;
import org.mule.weave.lsp.utils.VFUtils$;
import org.mule.weave.lsp.utils.WeaveTypeUtils$;
import org.mule.weave.lsp.vfs.VirtualFileAdapter$;
import org.mule.weave.lsp.vfs.events.OnProjectVirtualFileChangedEvent;
import org.mule.weave.lsp.vfs.events.OnProjectVirtualFileCreatedEvent;
import org.mule.weave.lsp.vfs.events.OnProjectVirtualFileDeletedEvent;
import org.mule.weave.lsp.vfs.events.ProjectVirtualFileChangedEvent$;
import org.mule.weave.lsp.vfs.events.ProjectVirtualFileCreatedEvent$;
import org.mule.weave.lsp.vfs.events.ProjectVirtualFileDeletedEvent$;
import org.mule.weave.v2.api.tooling.impl.message.DefaultMessageBuilder;
import org.mule.weave.v2.api.tooling.message.MessageBuilder;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.editor.MappingInput;
import org.mule.weave.v2.editor.QuickFix;
import org.mule.weave.v2.editor.ValidationMessage;
import org.mule.weave.v2.editor.ValidationMessages;
import org.mule.weave.v2.editor.VirtualFileSystem;
import org.mule.weave.v2.editor.WeaveDocumentToolingService;
import org.mule.weave.v2.editor.WeaveToolingService;
import org.mule.weave.v2.parser.MessageCategory;
import org.mule.weave.v2.parser.ScopePhaseCategory$;
import org.mule.weave.v2.parser.TypePhaseCategory$;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.sdk.WeaveResource;
import org.mule.weave.v2.ts.WeaveType;
import org.mule.weave.v2.versioncheck.SVersion$;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\rMa\u0001\u0002\u00180\u0001iB\u0001\"\u0012\u0001\u0003\u0006\u0004%\tA\u0012\u0005\t!\u0002\u0011\t\u0011)A\u0005\u000f\"A\u0011\u000b\u0001BC\u0002\u0013\u0005!\u000b\u0003\u0005\\\u0001\t\u0005\t\u0015!\u0003T\u0011!a\u0006A!A!\u0002\u0013i\u0006\u0002\u00031\u0001\u0005\u0003\u0005\u000b\u0011B1\t\u0011\u0011\u0004!\u0011!Q\u0001\n\u0015DQa\u001c\u0001\u0005\u0002ADqa\u001e\u0001C\u0002\u0013%\u0001\u0010\u0003\u0004\u0000\u0001\u0001\u0006I!\u001f\u0005\f\u0003\u0003\u0001\u0001\u0019!a\u0001\n#\t\u0019\u0001C\u0006\u0002\u0010\u0001\u0001\r\u00111A\u0005\u0012\u0005E\u0001bCA\u000f\u0001\u0001\u0007\t\u0011)Q\u0005\u0003\u000bA!\"a\b\u0001\u0011\u000b\u0007I\u0011BA\u0011\u0011-\tI\u0003\u0001a\u0001\u0002\u0004%I!a\u000b\t\u0017\u0005\u0005\u0003\u00011AA\u0002\u0013%\u00111\t\u0005\f\u0003\u000f\u0002\u0001\u0019!A!B\u0013\ti\u0003C\u0005\u0002J\u0001\u0001\r\u0011\"\u0005\u0002L!I\u00111\u000b\u0001A\u0002\u0013E\u0011Q\u000b\u0005\t\u00033\u0002\u0001\u0015)\u0003\u0002N!9\u00111\r\u0001\u0005B\u0005\u0015\u0004bBA=\u0001\u0011%\u00111\u0010\u0005\b\u0003G\u0003A\u0011BAS\u0011\u001d\tY\u000b\u0001C\u0005\u0003[Cq!!.\u0001\t\u0003\t9\fC\u0004\u0002L\u0002!I!!4\t\u000f\u0005=\u0007\u0001\"\u0001\u0002R\"9\u00111\u001d\u0001\u0005\u0002\u0005\u0015\bbBA\u007f\u0001\u0011\u0005\u0011q \u0005\b\u0003{\u0004A\u0011\u0001B\u0005\u0011\u001d\u0011\t\u0002\u0001C\u0001\u0005'Aq!!@\u0001\t\u0013\u00119\u0002C\u0004\u0003N\u0001!\tAa\u0014\t\u000f\tM\u0003\u0001\"\u0001\u0003V!9!1\f\u0001\u0005\u0002\tu\u0003b\u0002B2\u0001\u0011\u0005!Q\r\u0005\n\u0005o\u0002\u0011\u0013!C\u0001\u0005sBqA!$\u0001\t\u0003\u0011y\tC\u0004\u00032\u0002!\tAa-\t\u0013\t]\u0007!%A\u0005\u0002\te\u0007b\u0002Bo\u0001\u0011%!q\u001c\u0005\b\u0005c\u0004A\u0011\u0001Bz\u0011%\u0011I\u0010AI\u0001\n\u0003\u0011I\u000eC\u0004\u0003|\u0002!IA!@\t\u000f\r=\u0001\u0001\"\u0001\u0004\u0012\t9B)\u0019;b/\u0016\fg/\u001a+p_2LgnZ*feZL7-\u001a\u0006\u0003aE\n\u0001b]3sm&\u001cWm\u001d\u0006\u0003eM\n1\u0001\\:q\u0015\t!T'A\u0003xK\u00064XM\u0003\u00027o\u0005!Q.\u001e7f\u0015\u0005A\u0014aA8sO\u000e\u00011c\u0001\u0001<\u0003B\u0011AhP\u0007\u0002{)\ta(A\u0003tG\u0006d\u0017-\u0003\u0002A{\t1\u0011I\\=SK\u001a\u0004\"AQ\"\u000e\u0003=J!\u0001R\u0018\u0003\u001dQ{w\u000e\\5oON+'O^5dK\u00069\u0001O]8kK\u000e$X#A$\u0011\u0005!sU\"A%\u000b\u0005\u0015S%BA&M\u0003\r\t\u0007/\u001b\u0006\u0003\u001bN\n\u0011\"\u001a=uK:\u001c\u0018n\u001c8\n\u0005=K%a\u0004)s_*,7\r^'fi\u0006$\u0017\r^1\u0002\u0011A\u0014xN[3di\u0002\n1A\u001e4t+\u0005\u0019\u0006C\u0001+Z\u001b\u0005)&B\u0001,X\u0003\u0019)G-\u001b;pe*\u0011\u0001lM\u0001\u0003mJJ!AW+\u0003#YK'\u000f^;bY\u001aKG.Z*zgR,W.\u0001\u0003wMN\u0004\u0013\u0001\u00059vE2L7\u000f[3s'\u0016\u0014h/[2f!\t\u0011e,\u0003\u0002`_\tYB)[1h]>\u001cH/[2t!V\u0014G.[:iKJ\u001cVM\u001d<jG\u0016\fa\u0003Z8dk6,g\u000e^*feZL7-\u001a$bGR|'/\u001f\t\u0003\u0005\nL!aY\u0018\u00035]+\u0017M^3U_>d\u0017N\\4TKJ4\u0018nY3GC\u000e$xN]=\u0002\u0011\u0015DXmY;u_J\u0004\"AZ7\u000e\u0003\u001dT!\u0001[5\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002kW\u0006!Q\u000f^5m\u0015\u0005a\u0017\u0001\u00026bm\u0006L!A\\4\u0003\u0011\u0015CXmY;u_J\fa\u0001P5oSRtDCB9sgR,h\u000f\u0005\u0002C\u0001!)Q\t\u0003a\u0001\u000f\")\u0011\u000b\u0003a\u0001'\")A\f\u0003a\u0001;\")\u0001\r\u0003a\u0001C\")A\r\u0003a\u0001K\u00061An\\4hKJ,\u0012!\u001f\t\u0003uvl\u0011a\u001f\u0006\u0003y&\fq\u0001\\8hO&tw-\u0003\u0002\u007fw\n1Aj\\4hKJ\fq\u0001\\8hO\u0016\u0014\b%A\u0006qe>TWm\u0019;LS:$WCAA\u0003!\u0011\t9!a\u0003\u000e\u0005\u0005%!BA#2\u0013\u0011\ti!!\u0003\u0003\u0017A\u0013xN[3di.Kg\u000eZ\u0001\u0010aJ|'.Z2u\u0017&tGm\u0018\u0013fcR!\u00111CA\r!\ra\u0014QC\u0005\u0004\u0003/i$\u0001B+oSRD\u0011\"a\u0007\r\u0003\u0003\u0005\r!!\u0002\u0002\u0007a$\u0013'\u0001\u0007qe>TWm\u0019;LS:$\u0007%\u0001\t`I>\u001cW/\\3oiN+'O^5dKV\u0011\u00111\u0005\t\u0004)\u0006\u0015\u0012bAA\u0014+\n\u0019r+Z1wKR{w\u000e\\5oON+'O^5dK\u0006\u00012-^:u_64\u0016\r\\5eCR|'o]\u000b\u0003\u0003[\u0001R\u0001PA\u0018\u0003gI1!!\r>\u0005\u0015\t%O]1z!\u0011\t)$!\u0010\u000e\u0005\u0005]\"\u0002BA\u001d\u0003w\t!B^1mS\u0012\fG/[8o\u0015\ti%*\u0003\u0003\u0002@\u0005]\"AD,fCZ,g+\u00197jI\u0006$xN]\u0001\u0015GV\u001cHo\\7WC2LG-\u0019;peN|F%Z9\u0015\t\u0005M\u0011Q\t\u0005\n\u00037\u0001\u0012\u0011!a\u0001\u0003[\t\u0011cY;ti>lg+\u00197jI\u0006$xN]:!\u0003\u001dIg\u000eZ3yK\u0012,\"!!\u0014\u0011\u0007q\ny%C\u0002\u0002Ru\u0012qAQ8pY\u0016\fg.A\u0006j]\u0012,\u00070\u001a3`I\u0015\fH\u0003BA\n\u0003/B\u0011\"a\u0007\u0014\u0003\u0003\u0005\r!!\u0014\u0002\u0011%tG-\u001a=fI\u0002B3\u0001FA/!\ra\u0014qL\u0005\u0004\u0003Cj$\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0002\u0015%t\u0017\u000e^5bY&TX\r\u0006\u0004\u0002\u0014\u0005\u001d\u0014\u0011\u000e\u0005\b\u0003\u0003)\u0002\u0019AA\u0003\u0011\u001d\tY'\u0006a\u0001\u0003[\n\u0001\"\u001a<f]R\u0014Uo\u001d\t\u0005\u0003_\n)(\u0004\u0002\u0002r)\u0019\u00111O\u0019\u0002\u000bU$\u0018\u000e\\:\n\t\u0005]\u0014\u0011\u000f\u0002\u0011\u0013:$XM\u001d8bY\u00163XM\u001c;CkN\fqCZ5oI\u000e{'O]3ta>tG-\u001b8h\t^4\u0015\u000e\\3\u0015\t\u0005u\u0014\u0011\u0012\t\u0006y\u0005}\u00141Q\u0005\u0004\u0003\u0003k$AB(qi&|g\u000eE\u0002U\u0003\u000bK1!a\"V\u0005-1\u0016N\u001d;vC24\u0015\u000e\\3\t\u000f\u0005-e\u00031\u0001\u0002\u000e\u0006\u00191\u000f\u001e:\u0011\t\u0005=\u0015Q\u0014\b\u0005\u0003#\u000bI\nE\u0002\u0002\u0014vj!!!&\u000b\u0007\u0005]\u0015(\u0001\u0004=e>|GOP\u0005\u0004\u00037k\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002 \u0006\u0005&AB*ue&twMC\u0002\u0002\u001cv\n!C^1mS\u0012\fG/Z!mY\u0016#\u0017\u000e^8sgR!\u00111CAT\u0011\u001d\tIk\u0006a\u0001\u0003\u001b\u000baA]3bg>t\u0017\u0001\u0006<bY&$\u0017\r^3EKB,g\u000eZ3oG&,7\u000f\u0006\u0004\u0002\u0014\u0005=\u00161\u0017\u0005\b\u0003cC\u0002\u0019AAB\u0003\t1h\rC\u0004\u0002*b\u0001\r!!$\u0002\u00111|\u0017\r\u001a+za\u0016$B!!/\u0002HB)A(a \u0002<B!\u0011QXAb\u001b\t\tyLC\u0002\u0002B^\u000b!\u0001^:\n\t\u0005\u0015\u0017q\u0018\u0002\n/\u0016\fg/\u001a+za\u0016Dq!!3\u001a\u0001\u0004\ti)\u0001\u0006usB,7\u000b\u001e:j]\u001e\fq\u0002Z8dk6,g\u000e^*feZL7-\u001a\u000b\u0003\u0003G\tq!\u001b8qkR|e\r\u0006\u0004\u0002T\u0006m\u0017q\u001c\t\u0006y\u0005}\u0014Q\u001b\t\u0004)\u0006]\u0017bAAm+\naQ*\u00199qS:<\u0017J\u001c9vi\"9\u0011Q\\\u000eA\u0002\u00055\u0015aA;sS\"9\u0011\u0011]\u000eA\u0002\u00055\u0015!C5oaV$h*Y7f\u0003I\u0019wN\u001c;fqRlU\r^1eCR\fgi\u001c:\u0015\t\u0005\u001d\u00181 \t\u0007\u0003S\fY/a<\u000e\u0003%L1!!<j\u0005!y\u0005\u000f^5p]\u0006d\u0007\u0003BAy\u0003ol!!a=\u000b\u0007\u0005U(*\u0001\u0005nKR\fG-\u0019;b\u0013\u0011\tI0a=\u0003\u001f\r{g\u000e^3yi6+G/\u00193bi\u0006Dq!!8\u001d\u0001\u0004\ti)\u0001\u0007pa\u0016tGi\\2v[\u0016tG\u000f\u0006\u0003\u0003\u0002\t\u001d\u0001c\u0001+\u0003\u0004%\u0019!QA+\u00037]+\u0017M^3E_\u000e,X.\u001a8u)>|G.\u001b8h'\u0016\u0014h/[2f\u0011\u001d\ti.\ba\u0001\u0003\u001b#bA!\u0001\u0003\f\t5\u0001bBAo=\u0001\u0007\u0011Q\u0012\u0005\b\u0005\u001fq\u0002\u0019AAt\u00031i\u0017-\u001f2f\u0007>tG/\u001a=u\u0003iy\u0007/\u001a8E_\u000e,X.\u001a8u/&$\bn\\;u\u0007>tG/\u001a=u)\u0011\u0011\tA!\u0006\t\u000f\u0005uw\u00041\u0001\u0002\u000eRA!\u0011\u0001B\r\u00057\u00119\u0004C\u0004\u0002^\u0002\u0002\r!!$\t\u000f\tu\u0001\u00051\u0001\u0003 \u0005)\u0011N\u001c9viB!\u0011\u0011\u001fB\u0011\u0013\u0011\u0011\u0019#a=\u0003\u001b%s\u0007/\u001e;NKR\fG-\u0019;bQ\u0011\u0011YBa\n\u0011\t\t%\"1G\u0007\u0003\u0005WQAA!\f\u00030\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005\tE\u0012!\u00026bm\u0006D\u0018\u0002\u0002B\u001b\u0005W\u0011\u0001BT;mY\u0006\u0014G.\u001a\u0005\b\u0005s\u0001\u0003\u0019\u0001B\u001e\u00039)\u0007\u0010]3di\u0016$w*\u001e;qkR\u0004BA!\u0010\u0003H5\u0011!q\b\u0006\u0005\u0003\u0003\u0014\tE\u0003\u0003\u0003D\t\u0015\u0013a\u0002;p_2Lgn\u001a\u0006\u0003\u0017^KAA!\u0013\u0003@\t1Ai\u0016+za\u0016DCAa\u000e\u0003(\u0005i1\r\\8tK\u0012{7-^7f]R$B!a\u0005\u0003R!9\u0011Q\\\u0011A\u0002\u00055\u0015!E<ji\"d\u0015M\\4vC\u001e,G*\u001a<fYR!\u00111\u0005B,\u0011\u001d\u0011IF\ta\u0001\u0003\u001b\u000bq\u0002Z<MC:<W/Y4f\u0019\u00164X\r\\\u0001\rm\u0006d\u0017\u000eZ1uK\u001aKG.\u001a\u000b\u0007\u0003'\u0011yF!\u0019\t\u000f\u0005E6\u00051\u0001\u0002\u0004\"9\u0011\u0011V\u0012A\u0002\u00055\u0015!\u0005;sS\u001e<WM\u001d,bY&$\u0017\r^5p]RA\u00111\u0003B4\u0005W\u0012i\u0007C\u0004\u0003j\u0011\u0002\r!!$\u0002\u0017\u0011|7-^7f]R,&/\u001b\u0005\b\u0003S#\u0003\u0019AAG\u0011%\u0011y\u0007\nI\u0001\u0002\u0004\u0011\t(\u0001\np]Z\u000bG.\u001b3bi&|gNR5oSND\u0007#\u0002\u001f\u0003t\u0005M\u0011b\u0001B;{\tIa)\u001e8di&|g\u000eM\u0001\u001ciJLwmZ3s-\u0006d\u0017\u000eZ1uS>tG\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\tm$\u0006\u0002B9\u0005{Z#Aa \u0011\t\t\u0005%\u0011R\u0007\u0003\u0005\u0007SAA!\"\u0003\b\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005[i\u0014\u0002\u0002BF\u0005\u0007\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00035!x\u000eR5bO:|7\u000f^5dgR!!\u0011\u0013BT!\u0019\tIOa%\u0003\u0018&\u0019!QS5\u0003\t1K7\u000f\u001e\t\u0005\u00053\u0013\u0019+\u0004\u0002\u0003\u001c*!!Q\u0014BP\u0003\u0015a7\u000f\u001d\u001bk\u0015\r\u0011\tkN\u0001\bK\u000ed\u0017\u000e]:f\u0013\u0011\u0011)Ka'\u0003\u0015\u0011K\u0017m\u001a8pgRL7\rC\u0004\u0003*\u001a\u0002\rAa+\u0002\u00115,7o]1hKN\u00042\u0001\u0016BW\u0013\r\u0011y+\u0016\u0002\u0013-\u0006d\u0017\u000eZ1uS>tW*Z:tC\u001e,7/A\u0007rk&\u001c7NR5yKN4uN\u001d\u000b\u000f\u0005k\u0013iLa0\u0003J\n5'\u0011\u001bBk!\u0015a\u0014q\u0006B\\!\r!&\u0011X\u0005\u0004\u0005w+&\u0001C)vS\u000e\\g)\u001b=\t\u000f\t%t\u00051\u0001\u0002\u000e\"9!\u0011Y\u0014A\u0002\t\r\u0017aC:uCJ$xJ\u001a4tKR\u00042\u0001\u0010Bc\u0013\r\u00119-\u0010\u0002\u0004\u0013:$\bb\u0002BfO\u0001\u0007!1Y\u0001\nK:$wJ\u001a4tKRDqAa4(\u0001\u0004\ti)\u0001\u0003lS:$\u0007b\u0002BjO\u0001\u0007\u0011QR\u0001\tg\u00164XM]5us\"I!qB\u0014\u0011\u0002\u0003\u0007\u0011q]\u0001\u0018cVL7m\u001b$jq\u0016\u001chi\u001c:%I\u00164\u0017-\u001e7uIY*\"Aa7+\t\u0005\u001d(QP\u0001\u000f[\u0006$8\r[3t\u001b\u0016\u001c8/Y4f))\tiE!9\u0003l\n5(q\u001e\u0005\b\u0005GL\u0003\u0019\u0001Bs\u0003\u0005i\u0007c\u0001+\u0003h&\u0019!\u0011^+\u0003#Y\u000bG.\u001b3bi&|g.T3tg\u0006<W\rC\u0004\u0003P&\u0002\r!!$\t\u000f\t\u0005\u0017\u00061\u0001\u0003D\"9!1Z\u0015A\u0002\t\r\u0017\u0001\u0003<bY&$\u0017\r^3\u0015\r\t-&Q\u001fB|\u0011\u001d\u0011IG\u000ba\u0001\u0003\u001bC\u0011Ba\u0004+!\u0003\u0005\r!a:\u0002%Y\fG.\u001b3bi\u0016$C-\u001a4bk2$HEM\u0001\u0017CB\u0004H._\"vgR|WNV1mS\u0012\fG/[8ogRA!1\u0016B\u0000\u0007\u0003\u0019)\u0001C\u0004\u0003j1\u0002\r!!$\t\u000f\r\rA\u00061\u0001\u0003\u0002\u00051Bm\\2v[\u0016tG\u000fV8pY&twmU3sm&\u001cW\rC\u0004\u0004\b1\u0002\ra!\u0003\u0002\u0013QL\b/\u001a'fm\u0016d\u0007\u0003BA\u001b\u0007\u0017IAa!\u0004\u00028\t\u0019b+\u00197jI\u0006$\u0018n\u001c8UsB,G*\u001a<fY\u0006Iq-\u001a;M_\u001e<WM\u001d\u000b\u0002s\u0002")
public class DataWeaveToolingService
implements ToolingService {
    private WeaveToolingService _documentService;
    private final ProjectMetadata project;
    private final VirtualFileSystem vfs;
    private final DiagnosticsPublisherService publisherService;
    private WeaveToolingServiceFactory documentServiceFactory;
    private final Executor executor;
    private final Logger logger;
    private ProjectKind projectKind;
    private WeaveValidator[] customValidators;
    private volatile boolean indexed;
    private volatile boolean bitmap$0;

    public ProjectMetadata project() {
        return this.project;
    }

    public VirtualFileSystem vfs() {
        return this.vfs;
    }

    private Logger logger() {
        return this.logger;
    }

    public ProjectKind projectKind() {
        return this.projectKind;
    }

    public void projectKind_$eq(ProjectKind x$1) {
        this.projectKind = x$1;
    }

    private WeaveToolingService _documentService$lzycompute() {
        DataWeaveToolingService dataWeaveToolingService = this;
        synchronized (dataWeaveToolingService) {
            if (!this.bitmap$0) {
                this._documentService = this.documentServiceFactory.create();
                this.bitmap$0 = true;
            }
        }
        this.documentServiceFactory = null;
        return this._documentService;
    }

    private WeaveToolingService _documentService() {
        if (!this.bitmap$0) {
            return this._documentService$lzycompute();
        }
        return this._documentService;
    }

    private WeaveValidator[] customValidators() {
        return this.customValidators;
    }

    private void customValidators_$eq(WeaveValidator[] x$1) {
        this.customValidators = x$1;
    }

    public boolean indexed() {
        return this.indexed;
    }

    public void indexed_$eq(boolean x$1) {
        this.indexed = x$1;
    }

    @Override
    public void initialize(ProjectKind projectKind, InternalEventBus eventBus) {
        this.projectKind_$eq(projectKind);
        this.customValidators_$eq(projectKind.customValidators());
        eventBus.register(SettingsChangedEvent$.MODULE$.SETTINGS_CHANGED(), new OnSettingsChanged(this){
            private final /* synthetic */ DataWeaveToolingService $outer;

            public void onSettingsChanged(String[] modifiedSettingsName) {
                if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])modifiedSettingsName)).contains((Object)Settings$.MODULE$.LANGUAGE_LEVEL_PROP_NAME())) {
                    this.$outer.org$mule$weave$lsp$services$DataWeaveToolingService$$validateAllEditors("settingsChanged");
                    return;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        eventBus.register(IndexingFinishedEvent$.MODULE$.INDEXING_FINISHED(), new OnIndexingFinished(this){
            private final /* synthetic */ DataWeaveToolingService $outer;

            public void onIndexingFinished(Enumeration.Value indexingType) {
                if (IndexingType$.MODULE$.Dependencies().equals((Object)indexingType)) {
                    this.$outer.indexed_$eq(true);
                    this.$outer.org$mule$weave$lsp$services$DataWeaveToolingService$$validateAllEditors("indexingFinishes");
                    return;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        eventBus.register(ProjectStartedEvent$.MODULE$.PROJECT_STARTED(), new OnProjectStarted(this){
            private final /* synthetic */ DataWeaveToolingService $outer;

            public void onProjectStarted(ProjectMetadata projectMetadata) {
                this.$outer.org$mule$weave$lsp$services$DataWeaveToolingService$$validateAllEditors("projectStarted");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        eventBus.register(ProjectVirtualFileCreatedEvent$.MODULE$.VIRTUAL_FILE_CREATED(), new OnProjectVirtualFileCreatedEvent(this){
            private final /* synthetic */ DataWeaveToolingService $outer;

            public void onVirtualFileCreated(org.mule.weave.v2.editor.VirtualFile vf) {
                if (VFUtils$.MODULE$.isDWFile(vf.url())) {
                    this.$outer.validateFile(vf, "onCreated");
                    return;
                }
                this.$outer.org$mule$weave$lsp$services$DataWeaveToolingService$$findCorrespondingDwFile(vf.url()).foreach((Function1 & Serializable & scala.Serializable)dwVirtualFile -> {
                    $anon$4.$anonfun$onVirtualFileCreated$1(this, dwVirtualFile);
                    return BoxedUnit.UNIT;
                });
            }

            public static final /* synthetic */ void $anonfun$onVirtualFileCreated$1($anon$4 $this, org.mule.weave.v2.editor.VirtualFile dwVirtualFile) {
                $this.$outer.validateFile(dwVirtualFile, "onScenarioChanged");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onVirtualFileCreated$1$adapted(org.mule.weave.lsp.services.DataWeaveToolingService$$anon$4 org.mule.weave.v2.editor.VirtualFile )}, serializedLambda);
            }
        });
        eventBus.register(ProjectVirtualFileChangedEvent$.MODULE$.VIRTUAL_FILE_CHANGED(), new OnProjectVirtualFileChangedEvent(this){
            private final /* synthetic */ DataWeaveToolingService $outer;

            public void onVirtualFileChanged(org.mule.weave.v2.editor.VirtualFile vf) {
                if (VFUtils$.MODULE$.isDWFile(vf.url())) {
                    this.$outer.validateFile(vf, "onChanged");
                    return;
                }
                this.$outer.org$mule$weave$lsp$services$DataWeaveToolingService$$findCorrespondingDwFile(vf.url()).foreach((Function1 & Serializable & scala.Serializable)dwVirtualFile -> {
                    $anon$5.$anonfun$onVirtualFileChanged$1(this, dwVirtualFile);
                    return BoxedUnit.UNIT;
                });
            }

            public static final /* synthetic */ void $anonfun$onVirtualFileChanged$1($anon$5 $this, org.mule.weave.v2.editor.VirtualFile dwVirtualFile) {
                $this.$outer.validateFile(dwVirtualFile, "onScenarioChanged");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onVirtualFileChanged$1$adapted(org.mule.weave.lsp.services.DataWeaveToolingService$$anon$5 org.mule.weave.v2.editor.VirtualFile )}, serializedLambda);
            }
        });
        eventBus.register(ProjectVirtualFileDeletedEvent$.MODULE$.VIRTUAL_FILE_DELETED(), new OnProjectVirtualFileDeletedEvent(this){
            private final /* synthetic */ DataWeaveToolingService $outer;

            public void onVirtualFileDeleted(org.mule.weave.v2.editor.VirtualFile vf) {
                if (VFUtils$.MODULE$.isDWFile(vf.url())) {
                    this.$outer.org$mule$weave$lsp$services$DataWeaveToolingService$$validateDependencies(vf, "onDeleted");
                    return;
                }
                this.$outer.org$mule$weave$lsp$services$DataWeaveToolingService$$findCorrespondingDwFile(vf.url()).foreach((Function1 & Serializable & scala.Serializable)dwVirtualFile -> {
                    $anon$6.$anonfun$onVirtualFileDeleted$1(this, dwVirtualFile);
                    return BoxedUnit.UNIT;
                });
            }

            public static final /* synthetic */ void $anonfun$onVirtualFileDeleted$1($anon$6 $this, org.mule.weave.v2.editor.VirtualFile dwVirtualFile) {
                $this.$outer.validateFile(dwVirtualFile, "onScenarioChanged");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onVirtualFileDeleted$1$adapted(org.mule.weave.lsp.services.DataWeaveToolingService$$anon$6 org.mule.weave.v2.editor.VirtualFile )}, serializedLambda);
            }
        });
    }

    public Option<org.mule.weave.v2.editor.VirtualFile> org$mule$weave$lsp$services$DataWeaveToolingService$$findCorrespondingDwFile(String str) {
        SampleDataComponent sampleDataManager = this.projectKind().sampleDataManager();
        return this.documentService().openEditors().find((Function1 & Serializable & scala.Serializable)oe -> BoxesRunTime.boxToBoolean((boolean)URLUtils$.MODULE$.isChildOfAny(str, (File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sampleDataManager.listScenarios(oe.file().getNameIdentifier()))).map((Function1 & Serializable & scala.Serializable)scenario -> scenario.file(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class)))))).map((Function1 & Serializable & scala.Serializable)weaveDocToolingService -> weaveDocToolingService.file());
    }

    public void org$mule$weave$lsp$services$DataWeaveToolingService$$validateAllEditors(String reason) {
        Seq services = (Seq)this.documentService().openEditors().map((Function1 & Serializable & scala.Serializable)openEditor -> openEditor.file().url(), Seq$.MODULE$.canBuildFrom());
        this.documentService().invalidateAll();
        services.foreach((Function1 & Serializable & scala.Serializable)url -> {
            this.triggerValidation(url, reason, this.triggerValidation$default$3());
            return BoxedUnit.UNIT;
        });
    }

    public void org$mule$weave$lsp$services$DataWeaveToolingService$$validateDependencies(org.mule.weave.v2.editor.VirtualFile vf, String reason) {
        NameIdentifier fileLogicalName = vf.getNameIdentifier();
        Seq dependants = this.documentService().dependantsOf(fileLogicalName);
        this.logger().log(Level.INFO, new StringBuilder(37).append("[DWProject] Validate dependants of ").append(fileLogicalName).append(": ").append(dependants.mkString("[", ",", "]")).toString());
        dependants.foreach((Function1 & Serializable & scala.Serializable)ni -> {
            DataWeaveToolingService.$anonfun$validateDependencies$1(this, vf, reason, ni);
            return BoxedUnit.UNIT;
        });
    }

    public Option<WeaveType> loadType(String typeString) {
        return this.documentService().loadType(typeString);
    }

    private WeaveToolingService documentService() {
        return this._documentService();
    }

    public Option<MappingInput> inputOf(String uri, String inputName) {
        WeaveDocumentToolingService documentToolingService = this.openDocument(uri);
        return documentToolingService.inputOf(inputName);
    }

    public Optional<ContextMetadata> contextMetadataFor(String uri) {
        org.mule.weave.v2.editor.VirtualFile vf = this.vfs().file(uri);
        if (vf != null) {
            return this.projectKind().metadataProvider().metadata((VirtualFile)VirtualFileAdapter$.MODULE$.apply(vf));
        }
        return Optional.empty();
    }

    public WeaveDocumentToolingService openDocument(String uri) {
        Optional<ContextMetadata> maybeContext = this.contextMetadataFor(uri);
        if (maybeContext.isPresent()) {
            ContextMetadata context = maybeContext.get();
            return this.openDocument(uri, context.getInputMetadata(), context.getOutput());
        }
        return this.openDocumentWithoutContext(uri);
    }

    public WeaveDocumentToolingService openDocument(String uri, Optional<ContextMetadata> maybeContext) {
        if (maybeContext.isPresent()) {
            ContextMetadata context = maybeContext.get();
            return this.openDocument(uri, context.getInputMetadata(), context.getOutput());
        }
        return this.openDocument(uri);
    }

    public WeaveDocumentToolingService openDocumentWithoutContext(String uri) {
        return this._documentService().open(uri, null, null);
    }

    private WeaveDocumentToolingService openDocument(String uri, @Nullable InputMetadata input, @Nullable DWType expectedOutput) {
        None$ none$;
        if (expectedOutput != null) {
            if (!(expectedOutput instanceof WeaveType)) {
                throw new IllegalArgumentException(new StringBuilder(83).append("Unexpected `expectedOutput` instance, please, contact the extension owner. Actual: ").append(expectedOutput.getClass().getName()).toString());
            }
            none$ = new Some((Object)((WeaveType)expectedOutput));
        } else {
            none$ = None$.MODULE$;
        }
        None$ output = none$;
        return this._documentService().open(uri, WeaveTypeUtils$.MODULE$.toImplicitInput(input), (Option)output);
    }

    public void closeDocument(String uri) {
        this.documentService().close(uri);
    }

    public WeaveToolingService withLanguageLevel(String dwLanguageLevel) {
        return this._documentService().updateLanguageLevel(SVersion$.MODULE$.fromString(dwLanguageLevel));
    }

    public void validateFile(org.mule.weave.v2.editor.VirtualFile vf, String reason) {
        this.triggerValidation(vf.url(), reason, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.org$mule$weave$lsp$services$DataWeaveToolingService$$validateDependencies(vf, reason));
    }

    public void triggerValidation(String documentUri, String reason, Function0<BoxedUnit> onValidationFinish) {
        this.logger().log(Level.INFO, new StringBuilder(30).append("TriggerValidation of: ").append(documentUri).append(" reason ").append(reason).toString());
        CompletableFuture.runAsync(() -> {
            this.logger().log(Level.INFO, new StringBuilder(40).append("[").append(Thread.currentThread().getName()).append("][").append(this.getClass().getName()).append("] Init TriggerValidation of: ").append(documentUri).append(" reason ").append(reason).toString());
            this.withLanguageLevel(this.projectKind().dependencyManager().dwVersion());
            ValidationMessages messages = this.validate(documentUri, this.validate$default$2());
            List<Diagnostic> diagnostics = this.toDiagnostics(messages);
            this.logger().log(Level.INFO, new StringBuilder(58).append("[").append(Thread.currentThread().getName()).append("][").append(this.getClass().getName()).append("] TriggerValidation finished: ").append(documentUri).append(" reason ").append(reason).append(". Diagnostics: [").append(diagnostics).append("]").toString());
            $this.publisherService.publishDiagnostics(new PublishDiagnosticsParams(documentUri, diagnostics));
            onValidationFinish.apply$mcV$sp();
        }, this.executor);
    }

    public Function0<BoxedUnit> triggerValidation$default$3() {
        return (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {};
    }

    public List<Diagnostic> toDiagnostics(ValidationMessages messages) {
        ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])messages.errorMessage())).foreach((Function1 & Serializable & scala.Serializable)message -> BoxesRunTime.boxToBoolean((boolean)diagnostics.add(LSPConverters$.MODULE$.toDiagnostic(message, DiagnosticSeverity.Error))));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])messages.warningMessage())).foreach((Function1 & Serializable & scala.Serializable)message -> BoxesRunTime.boxToBoolean((boolean)diagnostics.add(LSPConverters$.MODULE$.toDiagnostic(message, DiagnosticSeverity.Warning))));
        return diagnostics;
    }

    public QuickFix[] quickFixesFor(String documentUri, int startOffset, int endOffset, String kind, String severity, Optional<ContextMetadata> maybeContext) {
        ValidationMessages messages = this.validate(documentUri, maybeContext);
        String string = severity;
        String string2 = DiagnosticSeverity.Error.name();
        Option messageFound = !(string != null ? !string.equals(string2) : string2 != null) ? new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])messages.errorMessage())).find((Function1 & Serializable & scala.Serializable)m -> BoxesRunTime.boxToBoolean((boolean)this.matchesMessage(m, kind, startOffset, endOffset))) : new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])messages.warningMessage())).find((Function1 & Serializable & scala.Serializable)m -> BoxesRunTime.boxToBoolean((boolean)this.matchesMessage(m, kind, startOffset, endOffset)));
        return (QuickFix[])messageFound.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.quickFix()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (QuickFix[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(QuickFix.class)));
    }

    public Optional<ContextMetadata> quickFixesFor$default$6() {
        return Optional.empty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean matchesMessage(ValidationMessage m, String kind, int startOffset, int endOffset) {
        if (m.location().startPosition().index() != startOffset) return false;
        if (m.location().endPosition().index() != endOffset) return false;
        String string = LSPConverters$.MODULE$.toDiagnosticKind(m);
        String string2 = kind;
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    public ValidationMessages validate(String documentUri, Optional<ContextMetadata> maybeContext) {
        WeaveDocumentToolingService documentToolingService;
        WeaveDocumentToolingService weaveDocumentToolingService;
        if (maybeContext.isPresent()) {
            ContextMetadata context = maybeContext.get();
            weaveDocumentToolingService = this.openDocument(documentUri, context.getInputMetadata(), context.getOutput());
        } else {
            Optional<ContextMetadata> maybeContext2 = this.contextMetadataFor(documentUri);
            if (maybeContext2.isPresent()) {
                ContextMetadata context = maybeContext2.get();
                weaveDocumentToolingService = this.openDocument(documentUri, context.getInputMetadata(), null);
            } else {
                weaveDocumentToolingService = documentToolingService = this.openDocumentWithoutContext(documentUri);
            }
        }
        ValidationMessages messages = this.indexed() && Settings$.MODULE$.isTypeLevel(this.project().settings()) ? documentToolingService.typeCheck().concat(this.applyCustomValidations(documentUri, documentToolingService, ValidationTypeLevel.SCOPE)).concat(this.applyCustomValidations(documentUri, documentToolingService, ValidationTypeLevel.TYPE)) : (this.indexed() && Settings$.MODULE$.isScopeLevel(this.project().settings()) ? documentToolingService.scopeCheck().concat(this.applyCustomValidations(documentUri, documentToolingService, ValidationTypeLevel.SCOPE)) : documentToolingService.parseCheck());
        return messages;
    }

    public Optional<ContextMetadata> validate$default$2() {
        return Optional.empty();
    }

    private ValidationMessages applyCustomValidations(String documentUri, WeaveDocumentToolingService documentToolingService, ValidationTypeLevel typeLevel) {
        return (ValidationMessages)documentToolingService.ast().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.dwAstNode()).map((Function1 & Serializable & scala.Serializable)rootDwAstNode -> {
            TypePhaseCategory$ category = TypePhaseCategory$.MODULE$;
            ValidationTypeLevel validationTypeLevel = typeLevel;
            ValidationTypeLevel validationTypeLevel2 = ValidationTypeLevel.SCOPE;
            if (!(validationTypeLevel != null ? !validationTypeLevel.equals(validationTypeLevel2) : validationTypeLevel2 != null)) {
                category = ScopePhaseCategory$.MODULE$;
            }
            MessageValidationCollectorAdapter messageCollector = new MessageValidationCollectorAdapter((MessageCategory)category);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.customValidators())).filter((Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToBoolean((boolean)v.appliesTo(documentUri))))).filter((Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToBoolean((boolean)DataWeaveToolingService.$anonfun$applyCustomValidations$4(typeLevel, v))))).foreach((Function1 & Serializable & scala.Serializable)v -> {
                v.validate(new DocumentNode(documentUri, rootDwAstNode), (MessageValidationCollector)messageCollector, new MessageBuilderFactory(null){

                    public MessageBuilder createMessageBuilder() {
                        return new DefaultMessageBuilder();
                    }
                });
                return BoxedUnit.UNIT;
            });
            return messageCollector.getValidationMessages();
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> new ValidationMessages((ValidationMessage[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(ValidationMessage.class)), (ValidationMessage[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(ValidationMessage.class))));
    }

    public Logger getLogger() {
        return this.logger();
    }

    public static final /* synthetic */ void $anonfun$validateDependencies$1(DataWeaveToolingService $this, org.mule.weave.v2.editor.VirtualFile vf$1, String reason$2, NameIdentifier ni) {
        Option option = vf$1.fs().asResourceResolver().resolve(ni);
        if (option instanceof Some) {
            Some some = (Some)option;
            WeaveResource resource = (WeaveResource)some.value();
            $this.triggerValidation(resource.url(), new StringBuilder(20).append("dependantChanged ->").append(reason$2).append(" ").append(vf$1.url()).toString(), $this.triggerValidation$default$3());
            return;
        }
        if (None$.MODULE$.equals(option)) {
            $this.logger().log(Level.WARNING, new StringBuilder(27).append("No resource found for file ").append(vf$1.url()).toString());
            return;
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ boolean $anonfun$applyCustomValidations$4(ValidationTypeLevel typeLevel$1, WeaveValidator v) {
        ValidationTypeLevel validationTypeLevel = v.validationLevel();
        ValidationTypeLevel validationTypeLevel2 = typeLevel$1;
        return !(validationTypeLevel != null ? !validationTypeLevel.equals(validationTypeLevel2) : validationTypeLevel2 != null);
    }

    public DataWeaveToolingService(ProjectMetadata project, VirtualFileSystem vfs, DiagnosticsPublisherService publisherService, WeaveToolingServiceFactory documentServiceFactory, Executor executor) {
        this.project = project;
        this.vfs = vfs;
        this.publisherService = publisherService;
        this.documentServiceFactory = documentServiceFactory;
        this.executor = executor;
        ToolingService.$init$(this);
        this.logger = Logger.getLogger(this.getClass().getName());
        this.indexed = false;
    }
}

