/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.lsp.services;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lsp4j.DidChangeConfigurationParams;
import org.eclipse.lsp4j.DidChangeWatchedFilesParams;
import org.eclipse.lsp4j.DidChangeWorkspaceFoldersParams;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.SymbolKind;
import org.eclipse.lsp4j.WorkspaceSymbolParams;
import org.eclipse.lsp4j.services.WorkspaceService;
import org.mule.weave.extension.api.extension.command.WeaveCommand;
import org.mule.weave.lsp.commands.CommandManagerService;
import org.mule.weave.lsp.commands.Commands$;
import org.mule.weave.lsp.commands.InternalWeaveCommand;
import org.mule.weave.lsp.extension.protocol.DataWeaveProtocolClient;
import org.mule.weave.lsp.extension.protocol.SetContextParams;
import org.mule.weave.lsp.extension.protocol.SetContextValue;
import org.mule.weave.lsp.indexer.LSPWeaveIndexService;
import org.mule.weave.lsp.jobs.JobManagerService;
import org.mule.weave.lsp.jobs.Status;
import org.mule.weave.lsp.jobs.Task;
import org.mule.weave.lsp.project.DefaultProjectMetadata;
import org.mule.weave.lsp.project.ProjectKind;
import org.mule.weave.lsp.services.ClientLogger;
import org.mule.weave.lsp.services.ClientLoggerFactory;
import org.mule.weave.lsp.services.events.DocumentChangedEvent$;
import org.mule.weave.lsp.services.events.DocumentFocusChangedEvent$;
import org.mule.weave.lsp.services.events.DocumentOpenedEvent$;
import org.mule.weave.lsp.services.events.FileChangedEvent;
import org.mule.weave.lsp.services.events.OnDocumentChanged;
import org.mule.weave.lsp.services.events.OnDocumentFocused;
import org.mule.weave.lsp.services.events.OnDocumentOpened;
import org.mule.weave.lsp.utils.InternalEventBus;
import org.mule.weave.lsp.utils.LSPConverters$;
import org.mule.weave.v2.editor.VirtualFile;
import org.mule.weave.v2.editor.VirtualFileSystem;
import org.mule.weave.v2.editor.indexing.IdentifierType$;
import org.mule.weave.v2.editor.indexing.LocatedResult;
import org.mule.weave.v2.editor.indexing.WeaveIdentifier;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.parser.location.Position;
import org.mule.weave.v2.sdk.WeaveResource;
import org.mule.weave.v2.sdk.WeaveResourceResolver;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u00055g\u0001\u0002\u000e\u001c\u0001\u0019B\u0001\u0002\u000f\u0001\u0003\u0002\u0003\u0006I!\u000f\u0005\t}\u0001\u0011\t\u0011)A\u0005\u007f!Aq\t\u0001B\u0001B\u0003%\u0001\n\u0003\u0005M\u0001\t\u0005\t\u0015!\u0003N\u0011!)\u0006A!A!\u0002\u00131\u0006\u0002\u0003/\u0001\u0005\u0003\u0005\u000b\u0011B/\t\u0011\r\u0004!\u0011!Q\u0001\n\u0011DQA\u001b\u0001\u0005\u0002-Dq\u0001\u001e\u0001C\u0002\u0013%Q\u000f\u0003\u0004z\u0001\u0001\u0006IA\u001e\u0005\bu\u0002\u0011\r\u0011\"\u0003|\u0011\u001d\tI\u0001\u0001Q\u0001\nqD1\"a\u0003\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u000e!Y\u00111\u0004\u0001A\u0002\u0003\u0007I\u0011BA\u000f\u0011-\ty\u0003\u0001a\u0001\u0002\u0003\u0006K!a\u0004\t\u0017\u0005E\u0002\u00011AA\u0002\u0013%\u00111\u0007\u0005\f\u0003w\u0001\u0001\u0019!a\u0001\n\u0013\ti\u0004C\u0006\u0002B\u0001\u0001\r\u0011!Q!\n\u0005U\u0002bBA\"\u0001\u0011\u0005\u0011Q\t\u0005\b\u0003\u0017\u0002A\u0011BA'\u0011\u001d\tI\u0006\u0001C!\u00037Bq!!&\u0001\t\u0003\n9\nC\u0004\u0002\"\u0002!\t%a)\t\u000f\u0005U\u0006\u0001\"\u0011\u00028\"9\u0011\u0011\u0019\u0001\u0005B\u0005\r'!\u0007#bi\u0006<V-\u0019<f/>\u00148n\u001d9bG\u0016\u001cVM\u001d<jG\u0016T!\u0001H\u000f\u0002\u0011M,'O^5dKNT!AH\u0010\u0002\u00071\u001c\bO\u0003\u0002!C\u0005)q/Z1wK*\u0011!eI\u0001\u0005[VdWMC\u0001%\u0003\ry'oZ\u0002\u0001'\r\u0001qe\f\t\u0003Q5j\u0011!\u000b\u0006\u0003U-\nA\u0001\\1oO*\tA&\u0001\u0003kCZ\f\u0017B\u0001\u0018*\u0005\u0019y%M[3diB\u0011\u0001GN\u0007\u0002c)\u0011AD\r\u0006\u0003gQ\nQ\u0001\\:qi)T!!N\u0012\u0002\u000f\u0015\u001cG.\u001b9tK&\u0011q'\r\u0002\u0011/>\u00148n\u001d9bG\u0016\u001cVM\u001d<jG\u0016\fq\u0001\u001d:pU\u0016\u001cG\u000f\u0005\u0002;y5\t1H\u0003\u00029;%\u0011Qh\u000f\u0002\u0017\t\u00164\u0017-\u001e7u!J|'.Z2u\u001b\u0016$\u0018\rZ1uC\u0006\u0019aOZ:\u0011\u0005\u0001+U\"A!\u000b\u0005\t\u001b\u0015AB3eSR|'O\u0003\u0002E?\u0005\u0011aOM\u0005\u0003\r\u0006\u0013\u0011CV5siV\fGNR5mKNK8\u000f^3n\u00035awnZ4fe\u001a\u000b7\r^8ssB\u0011\u0011JS\u0007\u00027%\u00111j\u0007\u0002\u0014\u00072LWM\u001c;M_\u001e<WM\u001d$bGR|'/_\u0001\u0014o\u0016\fg/\u001a)s_R|7m\u001c7DY&,g\u000e\u001e\t\u0003\u001dNk\u0011a\u0014\u0006\u0003!F\u000b\u0001\u0002\u001d:pi>\u001cw\u000e\u001c\u0006\u0003%v\t\u0011\"\u001a=uK:\u001c\u0018n\u001c8\n\u0005Q{%a\u0006#bi\u0006<V-\u0019<f!J|Go\\2pY\u000ec\u0017.\u001a8u\u0003EQwNY'b]\u0006<WM]*feZL7-\u001a\t\u0003/jk\u0011\u0001\u0017\u0006\u00033v\tAA[8cg&\u00111\f\u0017\u0002\u0012\u0015>\u0014W*\u00198bO\u0016\u00148+\u001a:wS\u000e,\u0017\u0001D5oI\u0016D8+\u001a:wS\u000e,\u0007C\u00010b\u001b\u0005y&B\u00011\u001e\u0003\u001dIg\u000eZ3yKJL!AY0\u0003)1\u001b\u0006kV3bm\u0016Le\u000eZ3y'\u0016\u0014h/[2f\u00039\u0019w.\\7b]\u0012l\u0015M\\1hKJ\u0004\"!\u001a5\u000e\u0003\u0019T!aZ\u000f\u0002\u0011\r|W.\\1oINL!!\u001b4\u0003+\r{W.\\1oI6\u000bg.Y4feN+'O^5dK\u00061A(\u001b8jiz\"\u0002\u0002\\7o_B\f(o\u001d\t\u0003\u0013\u0002AQ\u0001\u000f\u0005A\u0002eBQA\u0010\u0005A\u0002}BQa\u0012\u0005A\u0002!CQ\u0001\u0014\u0005A\u00025CQ!\u0016\u0005A\u0002YCQ\u0001\u0018\u0005A\u0002uCQa\u0019\u0005A\u0002\u0011\fAb\u00197jK:$Hj\\4hKJ,\u0012A\u001e\t\u0003\u0013^L!\u0001_\u000e\u0003\u0019\rc\u0017.\u001a8u\u0019><w-\u001a:\u0002\u001b\rd\u0017.\u001a8u\u0019><w-\u001a:!\u0003\u0019awnZ4feV\tA\u0010E\u0002~\u0003\u000bi\u0011A \u0006\u0004\u007f\u0006\u0005\u0011a\u00027pO\u001eLgn\u001a\u0006\u0004\u0003\u0007Y\u0013\u0001B;uS2L1!a\u0002\u007f\u0005\u0019aunZ4fe\u00069An\\4hKJ\u0004\u0013\u0001C3wK:$()^:\u0016\u0005\u0005=\u0001\u0003BA\t\u0003/i!!a\u0005\u000b\u0007\u0005UQ$A\u0003vi&d7/\u0003\u0003\u0002\u001a\u0005M!\u0001E%oi\u0016\u0014h.\u00197Fm\u0016tGOQ;t\u00031)g/\u001a8u\u0005V\u001cx\fJ3r)\u0011\ty\"a\u000b\u0011\t\u0005\u0005\u0012qE\u0007\u0003\u0003GQ!!!\n\u0002\u000bM\u001c\u0017\r\\1\n\t\u0005%\u00121\u0005\u0002\u0005+:LG\u000fC\u0005\u0002.9\t\t\u00111\u0001\u0002\u0010\u0005\u0019\u0001\u0010J\u0019\u0002\u0013\u00154XM\u001c;CkN\u0004\u0013a\u00039s_*,7\r^&j]\u0012,\"!!\u000e\u0011\u0007i\n9$C\u0002\u0002:m\u00121\u0002\u0015:pU\u0016\u001cGoS5oI\u0006y\u0001O]8kK\u000e$8*\u001b8e?\u0012*\u0017\u000f\u0006\u0003\u0002 \u0005}\u0002\"CA\u0017#\u0005\u0005\t\u0019AA\u001b\u00031\u0001(o\u001c6fGR\\\u0015N\u001c3!\u0003)Ig.\u001b;jC2L'0\u001a\u000b\u0007\u0003?\t9%!\u0013\t\u000f\u0005E2\u00031\u0001\u00026!9\u00111B\nA\u0002\u0005=\u0011\u0001\u00068pi&4\u0017pQ8oi\u0016DHo\u00115b]\u001e,G\r\u0006\u0003\u0002 \u0005=\u0003bBA))\u0001\u0007\u00111K\u0001\u0003m\u001a\u00042\u0001QA+\u0013\r\t9&\u0011\u0002\f-&\u0014H/^1m\r&dW-\u0001\u0004ts6\u0014w\u000e\u001c\u000b\u0005\u0003;\nY\t\u0005\u0004\u0002`\u0005\u0015\u0014\u0011N\u0007\u0003\u0003CRA!a\u0019\u0002\u0002\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\t\u0005\u001d\u0014\u0011\r\u0002\u0012\u0007>l\u0007\u000f\\3uC\ndWMR;ukJ,\u0007\u0007BA6\u0003o\u0002b!!\u001c\u0002p\u0005MTBAA\u0001\u0013\u0011\t\t(!\u0001\u0003\t1K7\u000f\u001e\t\u0005\u0003k\n9\b\u0004\u0001\u0005\u0017\u0005eT#!A\u0001\u0002\u000b\u0005\u00111\u0010\u0002\u0004?\u0012\n\u0014\u0003BA?\u0003\u0007\u0003B!!\t\u0002\u0000%!\u0011\u0011QA\u0012\u0005\u001dqu\u000e\u001e5j]\u001e\u0004B!!\"\u0002\b6\t!'C\u0002\u0002\nJ\u0012\u0011cU=nE>d\u0017J\u001c4pe6\fG/[8o\u0011\u001d\ti)\u0006a\u0001\u0003\u001f\u000ba\u0001]1sC6\u001c\b\u0003BAC\u0003#K1!a%3\u0005U9vN]6ta\u0006\u001cWmU=nE>d\u0007+\u0019:b[N\fa\u0003Z5e\u0007\"\fgnZ3D_:4\u0017nZ;sCRLwN\u001c\u000b\u0005\u0003?\tI\nC\u0004\u0002\u000eZ\u0001\r!a'\u0011\t\u0005\u0015\u0015QT\u0005\u0004\u0003?\u0013$\u0001\b#jI\u000eC\u0017M\\4f\u0007>tg-[4ve\u0006$\u0018n\u001c8QCJ\fWn]\u0001\u000fKb,7-\u001e;f\u0007>lW.\u00198e)\u0011\t)+!,\u0011\r\u0005}\u0013QMAT!\u0011\t\t#!+\n\t\u0005-\u00161\u0005\u0002\u0007\u0003:L(+\u001a4\t\u000f\u00055u\u00031\u0001\u00020B!\u0011QQAY\u0013\r\t\u0019L\r\u0002\u0015\u000bb,7-\u001e;f\u0007>lW.\u00198e!\u0006\u0014\u0018-\\:\u00023\u0011LGm\u00115b]\u001e,wk\u001c:lgB\f7-\u001a$pY\u0012,'o\u001d\u000b\u0005\u0003?\tI\fC\u0004\u0002\u000eb\u0001\r!a/\u0011\t\u0005\u0015\u0015QX\u0005\u0004\u0003\u007f\u0013$a\b#jI\u000eC\u0017M\\4f/>\u00148n\u001d9bG\u00164u\u000e\u001c3feN\u0004\u0016M]1ng\u0006)B-\u001b3DQ\u0006tw-Z,bi\u000eDW\r\u001a$jY\u0016\u001cH\u0003BA\u0010\u0003\u000bDq!!$\u001a\u0001\u0004\t9\r\u0005\u0003\u0002\u0006\u0006%\u0017bAAfe\tYB)\u001b3DQ\u0006tw-Z,bi\u000eDW\r\u001a$jY\u0016\u001c\b+\u0019:b[N\u0004")
public class DataWeaveWorkspaceService
implements WorkspaceService {
    private final DefaultProjectMetadata project;
    private final VirtualFileSystem vfs;
    private final DataWeaveProtocolClient weaveProtocolClient;
    private final JobManagerService jobManagerService;
    private final LSPWeaveIndexService indexService;
    private final CommandManagerService commandManager;
    private final ClientLogger clientLogger;
    private final Logger logger;
    private InternalEventBus eventBus;
    private ProjectKind projectKind;

    private ClientLogger clientLogger() {
        return this.clientLogger;
    }

    private Logger logger() {
        return this.logger;
    }

    private InternalEventBus eventBus() {
        return this.eventBus;
    }

    private void eventBus_$eq(InternalEventBus x$1) {
        this.eventBus = x$1;
    }

    private ProjectKind projectKind() {
        return this.projectKind;
    }

    private void projectKind_$eq(ProjectKind x$1) {
        this.projectKind = x$1;
    }

    public void initialize(ProjectKind projectKind, InternalEventBus eventBus) {
        this.eventBus_$eq(eventBus);
        this.projectKind_$eq(projectKind);
        eventBus.register(DocumentChangedEvent$.MODULE$.DOCUMENT_CHANGED(), new OnDocumentChanged(this){
            private final /* synthetic */ DataWeaveWorkspaceService $outer;

            public void onDocumentChanged(VirtualFile vf) {
                this.$outer.org$mule$weave$lsp$services$DataWeaveWorkspaceService$$notifyContextChanged(vf);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        eventBus.register(DocumentOpenedEvent$.MODULE$.DOCUMENT_OPENED(), new OnDocumentOpened(this){
            private final /* synthetic */ DataWeaveWorkspaceService $outer;

            public void onDocumentOpened(VirtualFile vf) {
                this.$outer.org$mule$weave$lsp$services$DataWeaveWorkspaceService$$notifyContextChanged(vf);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        eventBus.register(DocumentFocusChangedEvent$.MODULE$.DOCUMENT_FOCUS_CHANGED(), new OnDocumentFocused(this){
            private final /* synthetic */ DataWeaveWorkspaceService $outer;

            public void onDocumentFocused(VirtualFile vf) {
                this.$outer.org$mule$weave$lsp$services$DataWeaveWorkspaceService$$notifyContextChanged(vf);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void org$mule$weave$lsp$services$DataWeaveWorkspaceService$$notifyContextChanged(VirtualFile vf) {
        SetContextParams params = new SetContextParams((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)this.commandManager.commands().map((Function1 & Serializable & scala.Serializable)command -> {
            boolean bl;
            WeaveCommand weaveCommand = command;
            if (weaveCommand instanceof InternalWeaveCommand) {
                InternalWeaveCommand internalWeaveCommand = (InternalWeaveCommand)weaveCommand;
                bl = internalWeaveCommand.enabled(vf);
            } else {
                bl = true;
            }
            boolean isEnabled = bl;
            return new SetContextValue(new StringBuilder(0).append(command.commandId()).append(Commands$.MODULE$.COMMAND_ENABLED_SUFFIX()).toString(), isEnabled, vf.url());
        }, Seq$.MODULE$.canBuildFrom())).asJava());
        this.weaveProtocolClient.setContext(params);
    }

    public CompletableFuture<List<? extends SymbolInformation>> symbol(WorkspaceSymbolParams params) {
        return CompletableFuture.supplyAsync(() -> {
            WeaveResourceResolver resourceResolver = $this.vfs.asResourceResolver();
            Iterable<LocatedResult<WeaveIdentifier>> iterable = $this.indexService.searchSymbol(params.getQuery());
            ArrayList result = new ArrayList();
            iterable.foreach((Function1 & Serializable & scala.Serializable)lr -> {
                Option moduleResource;
                SymbolInformation information = new SymbolInformation();
                information.setName(((WeaveIdentifier)lr.value()).value());
                int n = ((WeaveIdentifier)lr.value()).idType();
                SymbolKind kind = IdentifierType$.MODULE$.FUNCTION() == n ? SymbolKind.Function : (IdentifierType$.MODULE$.VARIABLE() == n ? SymbolKind.Variable : (IdentifierType$.MODULE$.NAMESPACE() == n ? SymbolKind.Namespace : (IdentifierType$.MODULE$.ANNOTATION() == n ? SymbolKind.Interface : SymbolKind.Field)));
                information.setKind(kind);
                NameIdentifier name = lr.moduleName();
                Option option = moduleResource = resourceResolver.resolve(name);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    WeaveResource weaveResource = (WeaveResource)some.value();
                    Range range = new Range();
                    Position startPosition = weaveResource.positionOf(((WeaveIdentifier)lr.value()).startLocation());
                    Position endPosition = weaveResource.positionOf(((WeaveIdentifier)lr.value()).endLocation());
                    range.setStart(LSPConverters$.MODULE$.toPosition(startPosition));
                    range.setEnd(LSPConverters$.MODULE$.toPosition(endPosition));
                    Location location = new Location(weaveResource.url(), range);
                    information.setLocation(location);
                    return BoxesRunTime.boxToBoolean((boolean)result.add(information));
                }
                return BoxedUnit.UNIT;
            });
            return result;
        });
    }

    public void didChangeConfiguration(DidChangeConfigurationParams params) {
        this.logger().log(Level.INFO, new StringBuilder(24).append("didChangeConfiguration: ").append(params.getSettings()).toString());
        this.project.settings().update(params.getSettings());
    }

    public CompletableFuture<Object> executeCommand(ExecuteCommandParams params) {
        this.logger().log(Level.INFO, new StringBuilder(16).append("executeCommand: ").append(params).toString());
        return CompletableFuture.supplyAsync(() -> $this.commandManager.commandBy(params.getCommand()).map((Function1 & Serializable & scala.Serializable)c -> {
            ObjectRef result = ObjectRef.create(null);
            $this.jobManagerService.execute(new Task(null, result, (WeaveCommand)c, params){
                private final ObjectRef result$2;
                private final WeaveCommand c$1;
                private final ExecuteCommandParams params$2;

                public void run(Status cancelable) {
                    this.result$2.elem = this.c$1.execute(this.params$2);
                }
                {
                    this.result$2 = result$2;
                    this.c$1 = c$1;
                    this.params$2 = params$2;
                }
            }, new StringBuilder(17).append("Running command: ").append(c.name()).toString(), String.valueOf(c.description(params)));
            return result.elem;
        }).orNull(Predef$.MODULE$.$conforms()));
    }

    public void didChangeWorkspaceFolders(DidChangeWorkspaceFoldersParams params) {
        this.logger().log(Level.INFO, new StringBuilder(17).append("Changed Folders: ").append(params.getEvent()).toString());
    }

    public void didChangeWatchedFiles(DidChangeWatchedFilesParams params) {
        params.getChanges().forEach(fe -> {
            if (this.projectKind().isProjectFile(fe.getUri())) {
                this.clientLogger().logDebug(new StringBuilder(26).append("Changed Watched File : ").append(fe.getUri()).append(" - ").append(fe.getType()).toString());
                this.eventBus().fire(new FileChangedEvent(fe.getUri(), fe.getType()));
                return;
            }
            this.clientLogger().logDebug(new StringBuilder(26).append("Ignored Watched File : ").append(fe.getUri()).append(" - ").append(fe.getType()).toString());
        });
    }

    public DataWeaveWorkspaceService(DefaultProjectMetadata project, VirtualFileSystem vfs, ClientLoggerFactory loggerFactory, DataWeaveProtocolClient weaveProtocolClient, JobManagerService jobManagerService, LSPWeaveIndexService indexService, CommandManagerService commandManager) {
        this.project = project;
        this.vfs = vfs;
        this.weaveProtocolClient = weaveProtocolClient;
        this.jobManagerService = jobManagerService;
        this.indexService = indexService;
        this.commandManager = commandManager;
        this.clientLogger = loggerFactory.createLogger(DataWeaveWorkspaceService.class);
        this.logger = Logger.getLogger(this.getClass().getName());
    }
}

