/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.lsp.services;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.eclipse.lsp4j.FileChangeType;
import org.mule.weave.extension.api.project.ProjectMetadata;
import org.mule.weave.lsp.agent.WeaveAgentService;
import org.mule.weave.lsp.extension.protocol.DataWeaveProtocolClient;
import org.mule.weave.lsp.extension.protocol.PreviewResult;
import org.mule.weave.lsp.extension.protocol.PreviewResult$;
import org.mule.weave.lsp.jobs.JobManagerService;
import org.mule.weave.lsp.project.DefaultProjectMetadata;
import org.mule.weave.lsp.project.ProjectKind;
import org.mule.weave.lsp.project.events.OnProjectStarted;
import org.mule.weave.lsp.project.events.ProjectStartedEvent$;
import org.mule.weave.lsp.services.DataWeaveToolingService;
import org.mule.weave.lsp.services.Debouncer;
import org.mule.weave.lsp.services.ToolingService;
import org.mule.weave.lsp.services.events.ActiveScenarioChangedEvent$;
import org.mule.weave.lsp.services.events.DocumentChangedEvent$;
import org.mule.weave.lsp.services.events.DocumentFocusChangedEvent$;
import org.mule.weave.lsp.services.events.FileChangedEvent$;
import org.mule.weave.lsp.services.events.OnActiveScenarioChanged;
import org.mule.weave.lsp.services.events.OnDocumentChanged;
import org.mule.weave.lsp.services.events.OnDocumentFocused;
import org.mule.weave.lsp.services.events.OnFileChanged;
import org.mule.weave.lsp.services.exception.RunPreviewException;
import org.mule.weave.lsp.utils.InternalEventBus;
import org.mule.weave.lsp.utils.URLUtils$;
import org.mule.weave.lsp.utils.WeaveASTQueryUtils$;
import org.mule.weave.v2.editor.VirtualFile;
import org.mule.weave.v2.editor.WeaveDocumentToolingService;
import org.mule.weave.v2.parser.ast.AstNode;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0001\u0005=h\u0001\u0002\u0012$\u00019B\u0001\"\u000f\u0001\u0003\u0002\u0003\u0006IA\u000f\u0005\t\u0001\u0002\u0011\t\u0011)A\u0005\u0003\"A\u0011\n\u0001B\u0001B\u0003%!\n\u0003\u0005P\u0001\t\u0005\t\u0015!\u0003Q\u0011!\u0019\u0006A!A!\u0002\u0013!\u0006\"\u0002.\u0001\t\u0003Y\u0006b\u00022\u0001\u0005\u0004%Ia\u0019\u0005\u0007]\u0002\u0001\u000b\u0011\u00023\t\u0013=\u0004\u0001\u0019!a\u0001\n\u0013\u0001\b\"C<\u0001\u0001\u0004\u0005\r\u0011\"\u0003y\u0011%q\b\u00011A\u0001B\u0003&\u0011\u000f\u0003\u0005\u0000\u0001\u0001\u0007I\u0011BA\u0001\u0011%\tI\u0001\u0001a\u0001\n\u0013\tY\u0001\u0003\u0005\u0002\u0010\u0001\u0001\u000b\u0015BA\u0002\u0011%\tI\u0002\u0001a\u0001\n\u0013\tY\u0002C\u0005\u00024\u0001\u0001\r\u0011\"\u0003\u00026!A\u0011\u0011\b\u0001!B\u0013\ti\u0002C\u0005\u0002<\u0001\u0001\r\u0011\"\u0003\u0002\u001c!I\u0011Q\b\u0001A\u0002\u0013%\u0011q\b\u0005\t\u0003\u0007\u0002\u0001\u0015)\u0003\u0002\u001e!I\u0011Q\t\u0001C\u0002\u0013%\u0011q\t\u0005\t\u0003G\u0002\u0001\u0015!\u0003\u0002J!9\u0011Q\r\u0001\u0005B\u0005\u001d\u0004bBA;\u0001\u0011\u0005\u0011q\u000f\u0005\b\u0003\u0007\u0003A\u0011AAC\u0011\u001d\t\u0019\t\u0001C\u0001\u0003#Cq!a!\u0001\t\u0013\t)\nC\u0004\u0002<\u0002!I!!0\t\u000f\u0005m\u0006\u0001\"\u0003\u0002D\"9\u0011q\u0019\u0001\u0005\u0002\u0005%\u0007\"CAi\u0001E\u0005I\u0011AAj\u0011\u001d\tI\u000f\u0001C\u0001\u0003WDq!!<\u0001\t\u0003\tYO\u0001\bQe\u00164\u0018.Z<TKJ4\u0018nY3\u000b\u0005\u0011*\u0013\u0001C:feZL7-Z:\u000b\u0005\u0019:\u0013a\u00017ta*\u0011\u0001&K\u0001\u0006o\u0016\fg/\u001a\u0006\u0003U-\nA!\\;mK*\tA&A\u0002pe\u001e\u001c\u0001aE\u0002\u0001_U\u0002\"\u0001M\u001a\u000e\u0003ER\u0011AM\u0001\u0006g\u000e\fG.Y\u0005\u0003iE\u0012a!\u00118z%\u00164\u0007C\u0001\u001c8\u001b\u0005\u0019\u0013B\u0001\u001d$\u00059!vn\u001c7j]\u001e\u001cVM\u001d<jG\u0016\fA\"Y4f]R\u001cVM\u001d<jG\u0016\u0004\"a\u000f \u000e\u0003qR!!P\u0013\u0002\u000b\u0005<WM\u001c;\n\u0005}b$!E,fCZ,\u0017iZ3oiN+'O^5dK\u0006\u0019r/Z1wK2\u000bgnZ;bO\u0016\u001cE.[3oiB\u0011!iR\u0007\u0002\u0007*\u0011A)R\u0001\taJ|Go\\2pY*\u0011a)J\u0001\nKb$XM\\:j_:L!\u0001S\"\u0003/\u0011\u000bG/Y,fCZ,\u0007K]8u_\u000e|Gn\u00117jK:$\u0018a\u00029s_*,7\r\u001e\t\u0003\u00176k\u0011\u0001\u0014\u0006\u0003\u0013\u0016J!A\u0014'\u0003-\u0011+g-Y;miB\u0013xN[3di6+G/\u00193bi\u0006\fq\u0002^8pY&twmU3sm&\u001cWm\u001d\t\u0003mEK!AU\u0012\u0003/\u0011\u000bG/Y,fCZ,Gk\\8mS:<7+\u001a:wS\u000e,\u0017A\u00036pE6\u000bg.Y4feB\u0011Q\u000bW\u0007\u0002-*\u0011q+J\u0001\u0005U>\u00147/\u0003\u0002Z-\n\t\"j\u001c2NC:\fw-\u001a:TKJ4\u0018nY3\u0002\rqJg.\u001b;?)\u0019aVLX0aCB\u0011a\u0007\u0001\u0005\u0006s\u0019\u0001\rA\u000f\u0005\u0006\u0001\u001a\u0001\r!\u0011\u0005\u0006\u0013\u001a\u0001\rA\u0013\u0005\u0006\u001f\u001a\u0001\r\u0001\u0015\u0005\u0006'\u001a\u0001\r\u0001V\u0001\u0007Y><w-\u001a:\u0016\u0003\u0011\u0004\"!\u001a7\u000e\u0003\u0019T!a\u001a5\u0002\u000f1|wmZ5oO*\u0011\u0011N[\u0001\u0005kRLGNC\u0001l\u0003\u0011Q\u0017M^1\n\u000554'A\u0002'pO\u001e,'/A\u0004m_\u001e<WM\u001d\u0011\u0002\u0011\u00154XM\u001c;CkN,\u0012!\u001d\t\u0003eVl\u0011a\u001d\u0006\u0003i\u0016\nQ!\u001e;jYNL!A^:\u0003!%sG/\u001a:oC2,e/\u001a8u\u0005V\u001c\u0018\u0001D3wK:$()^:`I\u0015\fHCA=}!\t\u0001$0\u0003\u0002|c\t!QK\\5u\u0011\u001di(\"!AA\u0002E\f1\u0001\u001f\u00132\u0003%)g/\u001a8u\u0005V\u001c\b%A\u0006f]\u0006\u0014G.\u001a,bYV,WCAA\u0002!\r\u0001\u0014QA\u0005\u0004\u0003\u000f\t$a\u0002\"p_2,\u0017M\\\u0001\u0010K:\f'\r\\3WC2,Xm\u0018\u0013fcR\u0019\u00110!\u0004\t\u0011ul\u0011\u0011!a\u0001\u0003\u0007\tA\"\u001a8bE2,g+\u00197vK\u0002B3ADA\n!\r\u0001\u0014QC\u0005\u0004\u0003/\t$\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0002'A,g\u000eZ5oOB\u0013xN[3diN#\u0018M\u001d;\u0016\u0005\u0005u\u0001#\u0002\u0019\u0002 \u0005\r\u0012bAA\u0011c\t1q\n\u001d;j_:\u0004B!!\n\u000205\u0011\u0011q\u0005\u0006\u0005\u0003S\tY#\u0001\u0004fI&$xN\u001d\u0006\u0004\u0003[9\u0013A\u0001<3\u0013\u0011\t\t$a\n\u0003\u0017YK'\u000f^;bY\u001aKG.Z\u0001\u0018a\u0016tG-\u001b8h!J|'.Z2u'R\f'\u000f^0%KF$2!_A\u001c\u0011!i\b#!AA\u0002\u0005u\u0011\u0001\u00069f]\u0012Lgn\u001a)s_*,7\r^*uCJ$\b%\u0001\tdkJ\u0014XM\u001c;WMB\u0013XM^5fo\u0006!2-\u001e:sK:$hK\u001a)sKZLWm^0%KF$2!_A!\u0011!i8#!AA\u0002\u0005u\u0011!E2veJ,g\u000e\u001e,g!J,g/[3xA\u0005\u0001\u0002O]3wS\u0016<H)\u001a2pk:\u001cWM]\u000b\u0003\u0003\u0013\u0002RANA&\u0003\u001fJ1!!\u0014$\u0005%!UMY8v]\u000e,'\u000f\u0005\u0003\u0002R\u0005}SBAA*\u0015\u0011\t)&a\u0016\u0002\u0013Y\f'/[1cY\u0016\u001c(\u0002BA-\u00037\n1!Y:u\u0015\u0011\ti&a\u000b\u0002\rA\f'o]3s\u0013\u0011\t\t'a\u0015\u0003\u001d9\u000bW.Z%eK:$\u0018NZ5fe\u0006\t\u0002O]3wS\u0016<H)\u001a2pk:\u001cWM\u001d\u0011\u0002\u0015%t\u0017\u000e^5bY&TX\rF\u0003z\u0003S\n\u0019\bC\u0004\u0002l]\u0001\r!!\u001c\u0002\u0017A\u0014xN[3di.Kg\u000e\u001a\t\u0004\u0017\u0006=\u0014bAA9\u0019\nY\u0001K]8kK\u000e$8*\u001b8e\u0011\u0015yw\u00031\u0001r\u0003)\u0011XO\u001c)sKZLWm\u001e\u000b\u0005\u0003s\ny\bE\u0002C\u0003wJ1!! D\u00055\u0001&/\u001a<jK^\u0014Vm];mi\"9\u0011\u0011\u0011\rA\u0002\u0005\r\u0012A\u0001<g\u00035\u0019\u0017M\u001c*v]B\u0013XM^5foR!\u00111AAD\u0011\u001d\tI)\u0007a\u0001\u0003\u0017\u000ba\u0003Z8dk6,g\u000e\u001e+p_2LgnZ*feZL7-\u001a\t\u0005\u0003K\ti)\u0003\u0003\u0002\u0010\u0006\u001d\"aG,fCZ,Gi\\2v[\u0016tG\u000fV8pY&twmU3sm&\u001cW\r\u0006\u0003\u0002\u0004\u0005M\u0005bBAA5\u0001\u0007\u00111\u0005\u000b\u0007\u0003\u0007\t9*!'\t\u000f\u0005\u00055\u00041\u0001\u0002$!9\u00111T\u000eA\u0002\u0005u\u0015\u0001\u00054jY\u0016\\\u0015N\u001c3SKN|GN^3s!\u0015\u0001\u0014qTAR\u0013\r\t\t+\r\u0002\n\rVt7\r^5p]B\u0002R\u0001MA\u0010\u0003K\u0003B!a*\u00026:!\u0011\u0011VAY!\r\tY+M\u0007\u0003\u0003[S1!a,.\u0003\u0019a$o\\8u}%\u0019\u00111W\u0019\u0002\rA\u0013X\rZ3g\u0013\u0011\t9,!/\u0003\rM#(/\u001b8h\u0015\r\t\u0019,M\u0001\tM&dWmS5oIR!\u00111UA`\u0011\u001d\t\t\r\ba\u0001\u0003K\u000bqAZ5mKV\u0013H\u000e\u0006\u0003\u0002$\u0006\u0015\u0007bBAE;\u0001\u0007\u00111R\u0001\u0013g\u000eDW\rZ;mKJ+h\u000e\u0015:fm&,w\u000f\u0006\u0004\u0002&\u0006-\u0017Q\u001a\u0005\b\u0003\u0003s\u0002\u0019AA\u0012\u0011%\tyM\bI\u0001\u0002\u0004\t\u0019!\u0001\u0003ts:\u001c\u0017\u0001H:dQ\u0016$W\u000f\\3Sk:\u0004&/\u001a<jK^$C-\u001a4bk2$HEM\u000b\u0003\u0003+TC!a\u0001\u0002X.\u0012\u0011\u0011\u001c\t\u0005\u00037\f)/\u0004\u0002\u0002^*!\u0011q\\Aq\u0003%)hn\u00195fG.,GMC\u0002\u0002dF\n!\"\u00198o_R\fG/[8o\u0013\u0011\t9/!8\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u0004f]\u0006\u0014G.\u001a\u000b\u0002s\u00069A-[:bE2,\u0007")
public class PreviewService
implements ToolingService {
    private final WeaveAgentService agentService;
    private final DataWeaveProtocolClient weaveLanguageClient;
    private final DefaultProjectMetadata project;
    private final DataWeaveToolingService toolingServices;
    private final JobManagerService jobManager;
    private final Logger logger;
    private InternalEventBus eventBus;
    private volatile boolean org$mule$weave$lsp$services$PreviewService$$enableValue;
    private Option<VirtualFile> org$mule$weave$lsp$services$PreviewService$$pendingProjectStart;
    private Option<VirtualFile> org$mule$weave$lsp$services$PreviewService$$currentVfPreview;
    private final Debouncer<NameIdentifier> previewDebouncer;

    private Logger logger() {
        return this.logger;
    }

    private InternalEventBus eventBus() {
        return this.eventBus;
    }

    private void eventBus_$eq(InternalEventBus x$1) {
        this.eventBus = x$1;
    }

    public boolean org$mule$weave$lsp$services$PreviewService$$enableValue() {
        return this.org$mule$weave$lsp$services$PreviewService$$enableValue;
    }

    private void org$mule$weave$lsp$services$PreviewService$$enableValue_$eq(boolean x$1) {
        this.org$mule$weave$lsp$services$PreviewService$$enableValue = x$1;
    }

    public Option<VirtualFile> org$mule$weave$lsp$services$PreviewService$$pendingProjectStart() {
        return this.org$mule$weave$lsp$services$PreviewService$$pendingProjectStart;
    }

    public void org$mule$weave$lsp$services$PreviewService$$pendingProjectStart_$eq(Option<VirtualFile> x$1) {
        this.org$mule$weave$lsp$services$PreviewService$$pendingProjectStart = x$1;
    }

    public Option<VirtualFile> org$mule$weave$lsp$services$PreviewService$$currentVfPreview() {
        return this.org$mule$weave$lsp$services$PreviewService$$currentVfPreview;
    }

    private void org$mule$weave$lsp$services$PreviewService$$currentVfPreview_$eq(Option<VirtualFile> x$1) {
        this.org$mule$weave$lsp$services$PreviewService$$currentVfPreview = x$1;
    }

    private Debouncer<NameIdentifier> previewDebouncer() {
        return this.previewDebouncer;
    }

    @Override
    public void initialize(ProjectKind projectKind, InternalEventBus eventBus) {
        this.eventBus_$eq(eventBus);
        eventBus.register(DocumentChangedEvent$.MODULE$.DOCUMENT_CHANGED(), new OnDocumentChanged(this){
            private final /* synthetic */ PreviewService $outer;

            public void onDocumentChanged(VirtualFile vf) {
                if (this.$outer.org$mule$weave$lsp$services$PreviewService$$enableValue() && this.$outer.canRunPreview(vf)) {
                    this.$outer.scheduleRunPreview(vf, this.$outer.scheduleRunPreview$default$2());
                    return;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        eventBus.register(DocumentFocusChangedEvent$.MODULE$.DOCUMENT_FOCUS_CHANGED(), new OnDocumentFocused(this){
            private final /* synthetic */ PreviewService $outer;

            public void onDocumentFocused(VirtualFile vf) {
                if (this.$outer.org$mule$weave$lsp$services$PreviewService$$enableValue() && this.$outer.canRunPreview(vf)) {
                    this.$outer.scheduleRunPreview(vf, this.$outer.scheduleRunPreview$default$2());
                    return;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        eventBus.register(FileChangedEvent$.MODULE$.FILE_CHANGED_EVENT(), new OnFileChanged(this, projectKind){
            private final /* synthetic */ PreviewService $outer;
            private final ProjectKind projectKind$1;

            public void onFileChanged(String uri, FileChangeType changeType) {
                if (this.$outer.org$mule$weave$lsp$services$PreviewService$$enableValue()) {
                    this.$outer.org$mule$weave$lsp$services$PreviewService$$currentVfPreview().map((Function1 & Serializable & scala.Serializable)currentVFPreview -> $this.projectKind$1.sampleDataManager().searchSampleDataFolderFor(currentVFPreview.getNameIdentifier()).map((Function1 & Serializable & scala.Serializable)scenarioFolder -> {
                        if (URLUtils$.MODULE$.isChildOf(uri, (File)scenarioFolder) || URLUtils$.MODULE$.isChildOf(URLUtils$.MODULE$.toLSPUrl(scenarioFolder.getPath()), uri)) {
                            return $this.$outer.scheduleRunPreview((VirtualFile)currentVFPreview, $this.$outer.scheduleRunPreview$default$2());
                        }
                        return BoxedUnit.UNIT;
                    }));
                    return;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.projectKind$1 = projectKind$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onFileChanged$1(org.mule.weave.lsp.services.PreviewService$$anon$3 java.lang.String org.mule.weave.v2.editor.VirtualFile ), $anonfun$onFileChanged$2(org.mule.weave.lsp.services.PreviewService$$anon$3 java.lang.String org.mule.weave.v2.editor.VirtualFile java.io.File )}, serializedLambda);
            }
        });
        eventBus.register(ProjectStartedEvent$.MODULE$.PROJECT_STARTED(), new OnProjectStarted(this){
            private final /* synthetic */ PreviewService $outer;

            public void onProjectStarted(ProjectMetadata metadata) {
                if (this.$outer.org$mule$weave$lsp$services$PreviewService$$pendingProjectStart().isDefined()) {
                    this.$outer.scheduleRunPreview((VirtualFile)this.$outer.org$mule$weave$lsp$services$PreviewService$$pendingProjectStart().get(), this.$outer.scheduleRunPreview$default$2());
                    this.$outer.org$mule$weave$lsp$services$PreviewService$$pendingProjectStart_$eq((Option<VirtualFile>)None$.MODULE$);
                    return;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        eventBus.register(ActiveScenarioChangedEvent$.MODULE$.ACTIVE_SCENARIO_CHANGED(), new OnActiveScenarioChanged(this){
            private final /* synthetic */ PreviewService $outer;

            public void onActiveScenarioChanged(VirtualFile vf) {
                if (this.$outer.org$mule$weave$lsp$services$PreviewService$$enableValue() && this.$outer.org$mule$weave$lsp$services$PreviewService$$currentVfPreview().isDefined() && ((VirtualFile)this.$outer.org$mule$weave$lsp$services$PreviewService$$currentVfPreview().get()).url().equals(vf.url()) && this.$outer.canRunPreview(vf)) {
                    this.$outer.scheduleRunPreview(vf, this.$outer.scheduleRunPreview$default$2());
                    return;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public PreviewResult runPreview(VirtualFile vf) {
        String fileUrl = vf.url();
        if (!this.project.isStarted()) {
            String x$1 = fileUrl;
            boolean x$2 = false;
            List<String> x$3 = Collections.emptyList();
            String x$4 = "Project is not yet initialized.\nPreview is going to be executed once project initializes.";
            String x$5 = PreviewResult$.MODULE$.apply$default$4();
            String x$6 = PreviewResult$.MODULE$.apply$default$5();
            String x$7 = PreviewResult$.MODULE$.apply$default$7();
            String x$8 = PreviewResult$.MODULE$.apply$default$8();
            long x$9 = PreviewResult$.MODULE$.apply$default$9();
            return new PreviewResult(x$1, x$2, x$3, x$5, x$6, x$4, x$7, x$8, x$9);
        }
        NameIdentifier identifier = vf.getNameIdentifier();
        String content = vf.read();
        this.logger().info(new StringBuilder(27).append("Trigger run preview for `").append(identifier).append("`.").toString());
        return this.agentService.run(identifier, content, fileUrl);
    }

    public boolean canRunPreview(WeaveDocumentToolingService documentToolingService) {
        if (documentToolingService == null) {
            return false;
        }
        return this.canRunPreview(documentToolingService.file(), (Function0<Option<String>>)(Function0 & Serializable & scala.Serializable)() -> this.fileKind(documentToolingService));
    }

    public boolean canRunPreview(VirtualFile vf) {
        return this.canRunPreview(vf, (Function0<Option<String>>)(Function0 & Serializable & scala.Serializable)() -> this.fileKind(vf.url()));
    }

    private boolean canRunPreview(VirtualFile vf, Function0<Option<String>> fileKindResolver) {
        if (vf == null) {
            return false;
        }
        Option<URI> fileUrl = URLUtils$.MODULE$.toURI(vf.url());
        if (fileUrl.exists((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)PreviewService.$anonfun$canRunPreview$3(p)))) {
            return false;
        }
        Option mayBeKind = (Option)fileKindResolver.apply();
        boolean isMapping = mayBeKind.forall((Function1 & Serializable & scala.Serializable)kind -> BoxesRunTime.boxToBoolean((boolean)kind.equals(WeaveASTQueryUtils$.MODULE$.MAPPING())));
        return !vf.readOnly() && isMapping;
    }

    private Option<String> fileKind(String fileUrl) {
        return this.fileKind(this.toolingServices.openDocument(fileUrl));
    }

    private Option<String> fileKind(WeaveDocumentToolingService documentToolingService) {
        Option maybeAstNode = documentToolingService.ast().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.astNode());
        Option<String> mayBeKind = WeaveASTQueryUtils$.MODULE$.fileKind((Option<AstNode>)maybeAstNode);
        return mayBeKind;
    }

    public String scheduleRunPreview(VirtualFile vf, boolean sync) {
        String fileUrl = vf.url();
        if (!this.canRunPreview(vf)) {
            String errorMessage = new StringBuilder(42).append("File `").append(vf.getNameIdentifier().name()).append("` is not an executable mapping file.").toString();
            if (sync) {
                throw new RunPreviewException(errorMessage);
            }
            String x$1 = fileUrl;
            boolean x$2 = false;
            List<String> x$3 = Collections.emptyList();
            String x$4 = new StringBuilder(42).append("File `").append(vf.getNameIdentifier().name()).append("` is not an executable mapping file.").toString();
            String x$5 = PreviewResult$.MODULE$.apply$default$4();
            String x$6 = PreviewResult$.MODULE$.apply$default$5();
            String x$7 = PreviewResult$.MODULE$.apply$default$7();
            String x$8 = PreviewResult$.MODULE$.apply$default$8();
            long x$9 = PreviewResult$.MODULE$.apply$default$9();
            this.weaveLanguageClient.showPreviewResult(new PreviewResult(x$1, x$2, x$3, x$5, x$6, x$4, x$7, x$8, x$9));
        } else if (!this.project.isStarted()) {
            if (sync) {
                throw new RunPreviewException("Project is not yet initialized, preview cannot be executed at this time.");
            }
            this.org$mule$weave$lsp$services$PreviewService$$pendingProjectStart_$eq((Option<VirtualFile>)new Some((Object)vf));
            PreviewResult previewResult = this.runPreview(vf);
            this.weaveLanguageClient.showPreviewResult(previewResult);
        } else {
            PreviewResult previewResult = this.runPreview(vf);
            if (sync) {
                if (previewResult.success()) {
                    return previewResult.content();
                }
                throw new RunPreviewException(previewResult.errorMessage());
            }
            NameIdentifier identifier = vf.getNameIdentifier();
            this.previewDebouncer().debounce(identifier, () -> $this.jobManager.execute(x$2 -> $this.weaveLanguageClient.showPreviewResult(this.runPreview(vf)), "Running preview", new StringBuilder(19).append("Running preview of ").append(identifier).toString()), 300L, TimeUnit.MILLISECONDS);
        }
        this.org$mule$weave$lsp$services$PreviewService$$currentVfPreview_$eq((Option<VirtualFile>)new Some((Object)vf));
        return null;
    }

    public boolean scheduleRunPreview$default$2() {
        return false;
    }

    public void enable() {
        this.org$mule$weave$lsp$services$PreviewService$$enableValue_$eq(true);
    }

    public void disable() {
        this.org$mule$weave$lsp$services$PreviewService$$enableValue_$eq(false);
        this.org$mule$weave$lsp$services$PreviewService$$currentVfPreview_$eq((Option<VirtualFile>)None$.MODULE$);
    }

    public static final /* synthetic */ boolean $anonfun$canRunPreview$3(URI p) {
        String string = p.getScheme();
        String string2 = "preview";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public PreviewService(WeaveAgentService agentService, DataWeaveProtocolClient weaveLanguageClient, DefaultProjectMetadata project, DataWeaveToolingService toolingServices, JobManagerService jobManager) {
        this.agentService = agentService;
        this.weaveLanguageClient = weaveLanguageClient;
        this.project = project;
        this.toolingServices = toolingServices;
        this.jobManager = jobManager;
        ToolingService.$init$(this);
        this.logger = Logger.getLogger(this.getClass().getName());
        this.org$mule$weave$lsp$services$PreviewService$$enableValue = false;
        this.org$mule$weave$lsp$services$PreviewService$$pendingProjectStart = None$.MODULE$;
        this.org$mule$weave$lsp$services$PreviewService$$currentVfPreview = None$.MODULE$;
        this.previewDebouncer = new Debouncer();
    }
}

