/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.lsp.services;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.lsp4j.ApplyWorkspaceEditParams;
import org.eclipse.lsp4j.ApplyWorkspaceEditResponse;
import org.eclipse.lsp4j.CreateFile;
import org.eclipse.lsp4j.DeleteFile;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ResourceOperation;
import org.eclipse.lsp4j.TextDocumentEdit;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.mule.weave.lsp.extension.protocol.DataWeaveProtocolClient;
import org.mule.weave.lsp.extension.protocol.SampleInput;
import org.mule.weave.lsp.extension.protocol.ShowScenariosParams;
import org.mule.weave.lsp.extension.protocol.WeaveScenario;
import org.mule.weave.lsp.project.ProjectKind;
import org.mule.weave.lsp.project.components.SampleDataComponent;
import org.mule.weave.lsp.project.components.Scenario;
import org.mule.weave.lsp.project.components.Scenario$;
import org.mule.weave.lsp.services.DataWeaveToolingService;
import org.mule.weave.lsp.services.ToolingService;
import org.mule.weave.lsp.services.WeaveScenarioManagerService$;
import org.mule.weave.lsp.services.WorkspaceEditService;
import org.mule.weave.lsp.services.events.ActiveScenarioChangedEvent;
import org.mule.weave.lsp.services.events.DocumentClosedEvent$;
import org.mule.weave.lsp.services.events.DocumentFocusChangedEvent$;
import org.mule.weave.lsp.services.events.OnDocumentClosed;
import org.mule.weave.lsp.services.events.OnDocumentFocused;
import org.mule.weave.lsp.utils.InputScaffoldingFactory$;
import org.mule.weave.lsp.utils.InternalEventBus;
import org.mule.weave.lsp.utils.LSPConverters$;
import org.mule.weave.lsp.utils.URLUtils$;
import org.mule.weave.lsp.utils.VFUtils$;
import org.mule.weave.lsp.utils.WeaveDirectoryUtils$;
import org.mule.weave.v2.editor.VirtualFile;
import org.mule.weave.v2.editor.VirtualFileSystem;
import org.mule.weave.v2.editor.WeaveDocumentToolingService;
import org.mule.weave.v2.parser.ast.AstNode;
import org.mule.weave.v2.parser.ast.AstNodeHelper$;
import org.mule.weave.v2.parser.ast.WeaveLocationCapable;
import org.mule.weave.v2.parser.ast.functions.FunctionCallNode;
import org.mule.weave.v2.parser.ast.functions.FunctionCallParametersNode;
import org.mule.weave.v2.parser.ast.structure.ArrayNode;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier$;
import org.mule.weave.v2.parser.ast.variables.VariableReferenceNode;
import org.mule.weave.v2.sdk.NameIdentifierHelper$;
import org.mule.weave.v2.utils.StringHelper$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0001\rUa\u0001B\u00193\u0001uB\u0001\u0002\u0013\u0001\u0003\u0002\u0003\u0006I!\u0013\u0005\t\u0019\u0002\u0011\t\u0011)A\u0005\u001b\"A\u0001\u000b\u0001B\u0001B\u0003%\u0011\u000b\u0003\u0005Z\u0001\t\u0015\r\u0011\"\u0001[\u0011!\u0019\u0007A!A!\u0002\u0013Y\u0006\"\u00023\u0001\t\u0003)\u0007\"C6\u0001\u0001\u0004\u0005\r\u0011\"\u0003m\u0011%\u0019\b\u00011AA\u0002\u0013%A\u000fC\u0005{\u0001\u0001\u0007\t\u0011)Q\u0005[\"I1\u0010\u0001a\u0001\u0002\u0004%\t\u0002 \u0005\f\u0003\u000f\u0001\u0001\u0019!a\u0001\n#\tI\u0001\u0003\u0006\u0002\u000e\u0001\u0001\r\u0011!Q!\nuD\u0011\"a\u0004\u0001\u0005\u0004%I!!\u0005\t\u0011\u0005\r\u0003\u0001)A\u0005\u0003'Aq!!\u0012\u0001\t\u0013\t9\u0005C\u0004\u0002t\u0001!\t%!\u001e\t\u000f\u0005m\u0004\u0001\"\u0001\u0002~!9\u00111\u0011\u0001\u0005\u0002\u0005\u0015\u0005bBAR\u0001\u0011\u0005\u0011Q\u0015\u0005\b\u0003S\u0003A\u0011AAV\u0011\u001d\t9\f\u0001C\u0001\u0003sCq!!1\u0001\t\u0003\t\u0019\rC\u0004\u0002J\u0002!\t!a3\t\u000f\u0005\r\b\u0001\"\u0003\u0002f\"9\u0011q\u001e\u0001\u0005\u0002\u0005E\bbBA\u0000\u0001\u0011\u0005!\u0011\u0001\u0005\b\u0005\u0017\u0001A\u0011\u0001B\u0007\u0011\u001d\u00119\u0002\u0001C\u0001\u00053A\u0011B!\u000b\u0001#\u0003%\tAa\u000b\t\u000f\t\u0005\u0003\u0001\"\u0001\u0003D!9!q\t\u0001\u0005\u0002\t%\u0003b\u0002B)\u0001\u0011E!1\u000b\u0005\b\u0005;\u0002A\u0011\u0002B0\u0011\u001d\u0011Y\t\u0001C\u0005\u0005\u001bCqA!%\u0001\t\u0013\u0011\u0019\nC\u0004\u0003*\u0002!IAa+\t\u000f\t%\u0006\u0001\"\u0003\u0003>\"9!Q\u0019\u0001\u0005\n\t\u001d\u0007b\u0002Bi\u0001\u0011%!1\u001b\u0005\b\u00053\u0004A\u0011\u0001Bn\u0011\u001d\u0011\u0019\u000f\u0001C\u0005\u0005KDqAa;\u0001\t\u0013\u0011i\u000fC\u0004\u0003l\u0002!IA!?\b\u000f\tu(\u0007#\u0001\u0003\u0000\u001a1\u0011G\rE\u0001\u0007\u0003Aa\u0001Z\u0017\u0005\u0002\r\r\u0001\"CB\u0003[\t\u0007I\u0011AB\u0004\u0011!\u0019\u0019\"\fQ\u0001\n\r%!aG,fCZ,7kY3oCJLw.T1oC\u001e,'oU3sm&\u001cWM\u0003\u00024i\u0005A1/\u001a:wS\u000e,7O\u0003\u00026m\u0005\u0019An\u001d9\u000b\u0005]B\u0014!B<fCZ,'BA\u001d;\u0003\u0011iW\u000f\\3\u000b\u0003m\n1a\u001c:h\u0007\u0001\u00192\u0001\u0001 E!\ty$)D\u0001A\u0015\u0005\t\u0015!B:dC2\f\u0017BA\"A\u0005\u0019\te.\u001f*fMB\u0011QIR\u0007\u0002e%\u0011qI\r\u0002\u000f)>|G.\u001b8h'\u0016\u0014h/[2f\u0003]!\u0017\r^1XK\u00064X\rV8pY&twmU3sm&\u001cW\r\u0005\u0002F\u0015&\u00111J\r\u0002\u0018\t\u0006$\u0018mV3bm\u0016$vn\u001c7j]\u001e\u001cVM\u001d<jG\u0016\fQc^8sWN\u0004\u0018mY3FI&$8oU3sm&\u001cW\r\u0005\u0002F\u001d&\u0011qJ\r\u0002\u0015/>\u00148n\u001d9bG\u0016,E-\u001b;TKJ4\u0018nY3\u0002'],\u0017M^3MC:<W/Y4f\u00072LWM\u001c;\u0011\u0005I;V\"A*\u000b\u0005Q+\u0016\u0001\u00039s_R|7m\u001c7\u000b\u0005Y#\u0014!C3yi\u0016t7/[8o\u0013\tA6KA\fECR\fw+Z1wKB\u0013x\u000e^8d_2\u001cE.[3oi\u0006\tb/\u001b:uk\u0006dg)\u001b7f'f\u001cH/Z7\u0016\u0003m\u0003\"\u0001X1\u000e\u0003uS!AX0\u0002\r\u0015$\u0017\u000e^8s\u0015\t\u0001g'\u0001\u0002we%\u0011!-\u0018\u0002\u0012-&\u0014H/^1m\r&dWmU=ti\u0016l\u0017A\u0005<jeR,\u0018\r\u001c$jY\u0016\u001c\u0016p\u001d;f[\u0002\na\u0001P5oSRtD#\u00024hQ&T\u0007CA#\u0001\u0011\u0015Ae\u00011\u0001J\u0011\u0015ae\u00011\u0001N\u0011\u0015\u0001f\u00011\u0001R\u0011\u0015If\u00011\u0001\\\u0003!)g/\u001a8u\u0005V\u001cX#A7\u0011\u00059\fX\"A8\u000b\u0005A$\u0014!B;uS2\u001c\u0018B\u0001:p\u0005AIe\u000e^3s]\u0006dWI^3oi\n+8/\u0001\u0007fm\u0016tGOQ;t?\u0012*\u0017\u000f\u0006\u0002vqB\u0011qH^\u0005\u0003o\u0002\u0013A!\u00168ji\"9\u0011\u0010CA\u0001\u0002\u0004i\u0017a\u0001=%c\u0005IQM^3oi\n+8\u000fI\u0001\faJ|'.Z2u\u0017&tG-F\u0001~!\rq\u00181A\u0007\u0002\u007f*\u0019\u0011\u0011\u0001\u001b\u0002\u000fA\u0014xN[3di&\u0019\u0011QA@\u0003\u0017A\u0013xN[3di.Kg\u000eZ\u0001\u0010aJ|'.Z2u\u0017&tGm\u0018\u0013fcR\u0019Q/a\u0003\t\u000fe\\\u0011\u0011!a\u0001{\u0006a\u0001O]8kK\u000e$8*\u001b8eA\u0005y\u0011m\u0019;jm\u0016\u001c6-\u001a8be&|7/\u0006\u0002\u0002\u0014AA\u0011QCA\u0010\u0003G\t9$\u0004\u0002\u0002\u0018)!\u0011\u0011DA\u000e\u0003\u001diW\u000f^1cY\u0016T1!!\bA\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003C\t9BA\u0004ICNDW*\u00199\u0011\t\u0005\u0015\u00121G\u0007\u0003\u0003OQA!!\u000b\u0002,\u0005Ia/\u0019:jC\ndWm\u001d\u0006\u0005\u0003[\ty#A\u0002bgRT1!!\r`\u0003\u0019\u0001\u0018M]:fe&!\u0011QGA\u0014\u00059q\u0015-\\3JI\u0016tG/\u001b4jKJ\u0004B!!\u000f\u0002@5\u0011\u00111\b\u0006\u0004\u0003{y\u0018AC2p[B|g.\u001a8ug&!\u0011\u0011IA\u001e\u0005!\u00196-\u001a8be&|\u0017\u0001E1di&4XmU2f]\u0006\u0014\u0018n\\:!\u00031i\u0017\r]*dK:\f'/[8t)\u0019\tI%a\u0018\u0002jA1\u00111JA+\u00033j!!!\u0014\u000b\t\u0005=\u0013\u0011K\u0001\u0005kRLGN\u0003\u0002\u0002T\u0005!!.\u0019<b\u0013\u0011\t9&!\u0014\u0003\t1K7\u000f\u001e\t\u0004%\u0006m\u0013bAA/'\niq+Z1wKN\u001bWM\\1sS>Dq!!\u0019\u0010\u0001\u0004\t\u0019'A\nnCf\u0014W-Q2uSZ,7kY3oCJLw\u000eE\u0003@\u0003K\n9$C\u0002\u0002h\u0001\u0013aa\u00149uS>t\u0007bBA6\u001f\u0001\u0007\u0011QN\u0001\rC2d7kY3oCJLwn\u001d\t\u0006\u007f\u0005=\u0014qG\u0005\u0004\u0003c\u0002%!B!se\u0006L\u0018AC5oSRL\u0017\r\\5{KR)Q/a\u001e\u0002z!)1\u0010\u0005a\u0001{\")1\u000e\u0005a\u0001[\u0006iA.[:u'\u000e,g.\u0019:j_N$B!!\u001c\u0002\u0000!9\u0011\u0011Q\tA\u0002\u0005\r\u0012A\u00048b[\u0016LE-\u001a8uS\u001aLWM]\u0001\u0015g\u0016\f'o\u00195TG\u0016t\u0017M]5p\u0005ft\u0015-\\3\u0015\r\u0005\r\u0014qQAE\u0011\u001d\t\tI\u0005a\u0001\u0003GAq!a#\u0013\u0001\u0004\ti)\u0001\u0007tG\u0016t\u0017M]5p\u001d\u0006lW\r\u0005\u0003\u0002\u0010\u0006ue\u0002BAI\u00033\u00032!a%A\u001b\t\t)JC\u0002\u0002\u0018r\na\u0001\u0010:p_Rt\u0014bAAN\u0001\u00061\u0001K]3eK\u001aLA!a(\u0002\"\n11\u000b\u001e:j]\u001eT1!a'A\u00039\t7\r^5wKN\u001bWM\\1sS>$B!a\u0019\u0002(\"9\u0011\u0011Q\nA\u0002\u0005\r\u0012AD2paf\u001c6-\u001a8be&|Gk\u001c\u000b\bk\u00065\u0016\u0011WA[\u0011\u001d\ty\u000b\u0006a\u0001\u0003G\t\u0011#\\1qa&tw-\u00133f]RLg-[3s\u0011\u001d\t\u0019\f\u0006a\u0001\u0003o\t1b\u001c7e'\u000e,g.\u0019:j_\"9\u00111\u0012\u000bA\u0002\u00055\u0015!E:fi\u0006\u001bG/\u001b<f'\u000e,g.\u0019:j_R)Q/a/\u0002>\"9\u0011\u0011Q\u000bA\u0002\u0005\r\u0002bBA`+\u0001\u0007\u0011QR\u0001\u0012]\u0006lWm\u00144UQ\u0016\u001c6-\u001a8be&|\u0017A\u00043fY\u0016$XmU2f]\u0006\u0014\u0018n\u001c\u000b\u0006k\u0006\u0015\u0017q\u0019\u0005\b\u0003\u00033\u0002\u0019AA\u0012\u0011\u001d\tyL\u0006a\u0001\u0003\u001b\u000b\u0011d\u0019:fCR,wJ]+qI\u0006$X-T1qa&tw\rV3tiRA\u0011QZAn\u0003;\fy\u000eE\u0003@\u0003K\ny\r\u0005\u0003\u0002R\u0006]WBAAj\u0015\u0011\t).!\u0015\u0002\u0005%|\u0017\u0002BAm\u0003'\u0014AAR5mK\"9\u0011\u0011Q\fA\u0002\u0005\r\u0002bBAF/\u0001\u0007\u0011Q\u0012\u0005\b\u0003C<\u0002\u0019AAG\u0003!i\u0017.\\3UsB,\u0017A\u00033p'\u00064X\rV3tiRA\u0011QZAt\u0003S\fi\u000fC\u0004\u0002\u0002b\u0001\r!a\t\t\u000f\u0005-\b\u00041\u0001\u00028\u0005A1oY3oCJLw\u000eC\u0004\u0002bb\u0001\r!!$\u0002\u0015M\fg/Z(viB,H\u000f\u0006\u0006\u0002N\u0006M\u0018Q_A|\u0003wDq!!!\u001a\u0001\u0004\t\u0019\u0003C\u0004\u0002@f\u0001\r!!$\t\u000f\u0005e\u0018\u00041\u0001\u0002\u000e\u0006Qq.\u001e;qkRt\u0015-\\3\t\u000f\u0005u\u0018\u00041\u0001\u0002\u000e\u0006Qa.Z<D_:$XM\u001c;\u0002\u0019\u0011,G.\u001a;f\u001fV$\b/\u001e;\u0015\u000fU\u0014\u0019A!\u0002\u0003\b!9\u0011\u0011\u0011\u000eA\u0002\u0005\r\u0002bBA`5\u0001\u0007\u0011Q\u0012\u0005\b\u0005\u0013Q\u0002\u0019AAG\u0003%yW\u000f\u001e9viV\u0013H.A\u0006eK2,G/Z%oaV$HcB;\u0003\u0010\tE!1\u0003\u0005\b\u0003\u0003[\u0002\u0019AA\u0012\u0011\u001d\tyl\u0007a\u0001\u0003\u001bCqA!\u0006\u001c\u0001\u0004\ti)\u0001\u0005j]B,H/\u0016:m\u00039\u0019'/Z1uKN\u001bWM\\1sS>$\"\"!4\u0003\u001c\tu!q\u0004B\u0012\u0011\u001d\t\t\t\ba\u0001\u0003GAq!a0\u001d\u0001\u0004\ti\tC\u0004\u0003\"q\u0001\r!!$\u0002\u001b%t\u0007/\u001e;GS2,g*Y7f\u0011%\u0011)\u0003\bI\u0001\u0002\u0004\u00119#A\tnCf\u0014W-\u00138qkR\u001cuN\u001c;f]R\u0004RaPA3\u0003\u001b\u000b\u0001d\u0019:fCR,7kY3oCJLw\u000e\n3fM\u0006,H\u000e\u001e\u00135+\t\u0011iC\u000b\u0003\u0003(\t=2F\u0001B\u0019!\u0011\u0011\u0019D!\u0010\u000e\u0005\tU\"\u0002\u0002B\u001c\u0005s\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\tm\u0002)\u0001\u0006b]:|G/\u0019;j_:LAAa\u0010\u00036\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002!M\fW\u000e\u001d7f\t\u0006$\u0018MR8mI\u0016\u0014H\u0003BAh\u0005\u000bBq!!!\u001f\u0001\u0004\t\u0019#\u0001\u0006tG\u0016t\u0017M]5p\u001f\u001a$b!a4\u0003L\t=\u0003b\u0002B'?\u0001\u0007\u0011qZ\u0001\u0010g\u0006l\u0007\u000f\\3D_:$\u0018-\u001b8fe\"9\u0011qX\u0010A\u0002\u00055\u0015!\u00043p\u0007J,\u0017\r^3J]B,H\u000f\u0006\u0006\u0002N\nU#q\u000bB-\u00057Bq!!!!\u0001\u0004\t\u0019\u0003C\u0004\u0003\"\u0001\u0002\r!!$\t\u000f\t\u0015\u0002\u00051\u0001\u0003(!9\u00111\u001e\u0011A\u0002\u0005=\u0017!\u00043fY\u0016$XMR5mK\u000ekG\r\u0006\u0003\u0003b\t\u001d\u0005\u0003\u0003B2\u0005k\u0012IH!!\u000e\u0005\t\u0015$\u0002\u0002B4\u0005S\n\u0001\"\\3tg\u0006<Wm\u001d\u0006\u0005\u0005W\u0012i'A\u0004kg>t'\u000f]2\u000b\t\t=$\u0011O\u0001\u0006YN\u0004HG\u001b\u0006\u0004\u0005gR\u0014aB3dY&\u00048/Z\u0005\u0005\u0005o\u0012)G\u0001\u0004FSRDWM\u001d\t\u0005\u0005w\u0012i(\u0004\u0002\u0003n%!!q\u0010B7\u0005A!V\r\u001f;E_\u000e,X.\u001a8u\u000b\u0012LG\u000f\u0005\u0003\u0003|\t\r\u0015\u0002\u0002BC\u0005[\u0012\u0011CU3t_V\u00148-Z(qKJ\fG/[8o\u0011\u001d\u0011I)\ta\u0001\u0003\u001f\fq\u0002Z3ti&t\u0017\r^5p]\u001aKG.Z\u0001\u000eGJ,\u0017\r^3GS2,7)\u001c3\u0015\t\t\u0005$q\u0012\u0005\b\u0005\u0013\u0013\u0003\u0019AAh\u0003-)G-\u001b;GS2,7)\u001c3\u0015\u0015\t\u0005$Q\u0013BL\u0005C\u0013)\u000bC\u0004\u0003\n\u000e\u0002\r!a4\t\u000f\te5\u00051\u0001\u0003\u001c\u0006A1\u000f^1siB{7\u000f\u0005\u0003\u0003|\tu\u0015\u0002\u0002BP\u0005[\u0012\u0001\u0002U8tSRLwN\u001c\u0005\b\u0005G\u001b\u0003\u0019\u0001BN\u0003\u0019)g\u000e\u001a)pg\"9!qU\u0012A\u0002\u00055\u0015a\u00028foR+\u0007\u0010^\u0001\u000bCB\u0004H._#eSR\u001cH\u0003\u0002BW\u0005g\u0003BAa\u001f\u00030&!!\u0011\u0017B7\u0005i\t\u0005\u000f\u001d7z/>\u00148n\u001d9bG\u0016,E-\u001b;SKN\u0004xN\\:f\u0011\u001d\u0011)\f\na\u0001\u0005o\u000bQ!\u001a3jiN\u0004Ra\u0010B]\u0005CJ1Aa/A\u0005)a$/\u001a9fCR,GM\u0010\u000b\u0005\u0005[\u0013y\fC\u0004\u0003B\u0016\u0002\rAa1\u0002\u0013\u0015$\u0017\u000e^:MSN$\bCBA&\u0003+\u0012\t'\u0001\u0007e_N\u000bg/Z(viB,H\u000f\u0006\u0006\u0002N\n%'1\u001aBg\u0005\u001fDq!!!'\u0001\u0004\t\u0019\u0003C\u0004\u0002z\u001a\u0002\r!!$\t\u000f\u0005-h\u00051\u0001\u0002P\"9!q\u0015\u0014A\u0002\u00055\u0015\u0001C8viB,Ho\u00144\u0015\r\u0005='Q\u001bBl\u0011\u001d\tYo\na\u0001\u0003\u001fDq!!?(\u0001\u0004\ti)A\u0004j]B,Ho\u00144\u0015\r\u0005='Q\u001cBp\u0011\u001d\tY\u000f\u000ba\u0001\u0003\u001fDqA!9)\u0001\u0004\ti)A\u0005j]B,HOT1nK\u0006yq-\u001a;WCJL\u0017M\u00197f!\u0006$\b\u000e\u0006\u0003\u0002\u000e\n\u001d\bb\u0002BuS\u0001\u0007\u0011QR\u0001\tM&dWMT1nK\u0006\u0011bn\u001c;jMf\fE\u000e\\*dK:\f'/[8t)\r)(q\u001e\u0005\b\u0005cT\u0003\u0019\u0001Bz\u0003\t1h\rE\u0002]\u0005kL1Aa>^\u0005-1\u0016N\u001d;vC24\u0015\u000e\\3\u0015\u0007U\u0014Y\u0010C\u0004\u0002\u0002.\u0002\r!a\t\u00027]+\u0017M^3TG\u0016t\u0017M]5p\u001b\u0006t\u0017mZ3s'\u0016\u0014h/[2f!\t)Uf\u0005\u0002.}Q\u0011!q`\u0001\u000e\t\u00163\u0015)\u0016'U?&s\u0005+\u0016+\u0016\u0005\r%\u0001\u0003BB\u0006\u0007#i!a!\u0004\u000b\t\r=\u0011\u0011K\u0001\u0005Y\u0006tw-\u0003\u0003\u0002 \u000e5\u0011A\u0004#F\r\u0006+F\nV0J\u001dB+F\u000b\t")
public class WeaveScenarioManagerService
implements ToolingService {
    private final DataWeaveToolingService dataWeaveToolingService;
    private final WorkspaceEditService workspaceEditsService;
    public final DataWeaveProtocolClient org$mule$weave$lsp$services$WeaveScenarioManagerService$$weaveLanguageClient;
    private final VirtualFileSystem virtualFileSystem;
    private InternalEventBus eventBus;
    private ProjectKind projectKind;
    private final HashMap<NameIdentifier, Scenario> activeScenarios;

    public static String DEFAULT_INPUT() {
        return WeaveScenarioManagerService$.MODULE$.DEFAULT_INPUT();
    }

    public VirtualFileSystem virtualFileSystem() {
        return this.virtualFileSystem;
    }

    private InternalEventBus eventBus() {
        return this.eventBus;
    }

    private void eventBus_$eq(InternalEventBus x$1) {
        this.eventBus = x$1;
    }

    public ProjectKind projectKind() {
        return this.projectKind;
    }

    public void projectKind_$eq(ProjectKind x$1) {
        this.projectKind = x$1;
    }

    private HashMap<NameIdentifier, Scenario> activeScenarios() {
        return this.activeScenarios;
    }

    private List<WeaveScenario> mapScenarios(Option<Scenario> maybeActiveScenario, Scenario[] allScenarios) {
        String defaultScenarioName = (String)maybeActiveScenario.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.name()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        WeaveScenario[] scenarios = (WeaveScenario[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])allScenarios)).map((Function1 & Serializable & scala.Serializable)scenario -> {
            SampleInput[] inputsList = scenario.inputs();
            String expectedOrNull = (String)scenario.expected().map((Function1 & Serializable & scala.Serializable)file -> URLUtils$.MODULE$.toLSPUrl((File)file)).orNull(Predef$.MODULE$.$conforms());
            return new WeaveScenario(Predef$.MODULE$.boolean2Boolean(scenario.name().equals(defaultScenarioName)), scenario.name(), URLUtils$.MODULE$.toLSPUrl(scenario.file()), inputsList, expectedOrNull);
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(WeaveScenario.class)));
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])scenarios)).toList()).asJava();
    }

    @Override
    public void initialize(ProjectKind projectKind, InternalEventBus eventBus) {
        this.projectKind_$eq(projectKind);
        this.eventBus_$eq(eventBus);
        eventBus.register(DocumentFocusChangedEvent$.MODULE$.DOCUMENT_FOCUS_CHANGED(), new OnDocumentFocused(this, projectKind){
            private final /* synthetic */ WeaveScenarioManagerService $outer;
            private final ProjectKind projectKind$1;

            public void onDocumentFocused(VirtualFile vf) {
                boolean isPartOfTheTestResources;
                File[] resources = WeaveDirectoryUtils$.MODULE$.wtfResourcesTestFolder(this.projectKind$1.structure());
                boolean bl = isPartOfTheTestResources = !new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])resources)).exists((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)$anon$1.$anonfun$onDocumentFocused$1(vf, f)));
                if (VFUtils$.MODULE$.isSupportedEditableScheme(vf.url()) && isPartOfTheTestResources) {
                    this.$outer.org$mule$weave$lsp$services$WeaveScenarioManagerService$$notifyAllScenarios(vf);
                    return;
                }
                this.$outer.org$mule$weave$lsp$services$WeaveScenarioManagerService$$weaveLanguageClient.showScenarios(null);
            }

            public static final /* synthetic */ boolean $anonfun$onDocumentFocused$1(VirtualFile vf$1, File f) {
                return URLUtils$.MODULE$.isChildOf(vf$1.url(), f);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.projectKind$1 = projectKind$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onDocumentFocused$1$adapted(org.mule.weave.v2.editor.VirtualFile java.io.File )}, serializedLambda);
            }
        });
        eventBus.register(DocumentClosedEvent$.MODULE$.DOCUMENT_CLOSED(), new OnDocumentClosed(this){
            private final /* synthetic */ WeaveScenarioManagerService $outer;

            public void onDocumentClosed(VirtualFile vf) {
                this.$outer.org$mule$weave$lsp$services$WeaveScenarioManagerService$$weaveLanguageClient.showScenarios(null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public Scenario[] listScenarios(NameIdentifier nameIdentifier) {
        return this.projectKind().sampleDataManager().listScenarios(nameIdentifier);
    }

    public Option<Scenario> searchScenarioByName(NameIdentifier nameIdentifier, String scenarioName) {
        return this.projectKind().sampleDataManager().searchScenarioByName(nameIdentifier, scenarioName);
    }

    public Option<Scenario> activeScenario(NameIdentifier nameIdentifier) {
        return this.activeScenarios().get((Object)nameIdentifier).orElse((Function0 & Serializable & scala.Serializable)() -> {
            Scenario[] scenarios = this.listScenarios(nameIdentifier);
            if (scenarios != null && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])scenarios)).nonEmpty()) {
                Option maybeFirstScenario = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])scenarios)).find((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)WeaveScenarioManagerService.$anonfun$activeScenario$2(s))).orElse((Function0 & Serializable & scala.Serializable)() -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])scenarios)).headOption());
                maybeFirstScenario.foreach((Function1 & Serializable & scala.Serializable)scenario -> this.activeScenarios().put((Object)nameIdentifier, scenario));
                return maybeFirstScenario;
            }
            return None$.MODULE$;
        });
    }

    public void copyScenarioTo(NameIdentifier mappingIdentifier, Scenario oldScenario, String scenarioName) {
        SampleInput[] inputs = oldScenario.inputs();
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])inputs)).isEmpty()) {
            this.createScenario(mappingIdentifier, scenarioName, WeaveScenarioManagerService$.MODULE$.DEFAULT_INPUT(), (Option<String>)None$.MODULE$);
            return;
        }
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])inputs)).foreach((Function1 & Serializable & scala.Serializable)input -> URLUtils$.MODULE$.toFile(input.uri()).map((Function1 & Serializable & scala.Serializable)oldInputFile -> {
            String inputName = new StringBuilder(1).append(input.name()).append(".").append(FilenameUtils.getExtension((String)oldInputFile.getName())).toString();
            String content = FileUtils.readFileToString((File)oldInputFile, (Charset)Charset.defaultCharset());
            return this.createScenario(mappingIdentifier, scenarioName, inputName, (Option<String>)new Some((Object)content));
        }));
    }

    public void setActiveScenario(NameIdentifier nameIdentifier, String nameOfTheScenario) {
        Option maybeScenario = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.projectKind().sampleDataManager().listScenarios(nameIdentifier))).find((Function1 & Serializable & scala.Serializable)scenario -> BoxesRunTime.boxToBoolean((boolean)WeaveScenarioManagerService.$anonfun$setActiveScenario$1(nameOfTheScenario, scenario)));
        maybeScenario.foreach((Function1 & Serializable & scala.Serializable)s -> {
            WeaveScenarioManagerService.$anonfun$setActiveScenario$2(this, nameIdentifier, s);
            return BoxedUnit.UNIT;
        });
        Iterator virtualFiles = (Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(this.virtualFileSystem().listFiles()).asScala();
        virtualFiles.find((Function1 & Serializable & scala.Serializable)vf -> BoxesRunTime.boxToBoolean((boolean)WeaveScenarioManagerService.$anonfun$setActiveScenario$3(nameIdentifier, vf))).foreach((Function1 & Serializable & scala.Serializable)vf -> {
            WeaveScenarioManagerService.$anonfun$setActiveScenario$4(this, vf);
            return BoxedUnit.UNIT;
        });
    }

    public void deleteScenario(NameIdentifier nameIdentifier, String nameOfTheScenario) {
        this.projectKind().sampleDataManager().searchScenarioByName(nameIdentifier, nameOfTheScenario).foreach((Function1 & Serializable & scala.Serializable)s -> {
            WeaveScenarioManagerService.$anonfun$deleteScenario$1(s);
            return BoxedUnit.UNIT;
        });
        this.activeScenarios().get((Object)nameIdentifier).foreach((Function1 & Serializable & scala.Serializable)activeScenario -> {
            String string = activeScenario.name();
            String string2 = nameOfTheScenario;
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return this.activeScenarios().remove((Object)nameIdentifier);
            }
            return BoxedUnit.UNIT;
        });
        this.notifyAllScenarios(nameIdentifier);
    }

    public Option<File> createOrUpdateMappingTest(NameIdentifier nameIdentifier, String scenarioName, String mimeType) {
        Option<Scenario> maybeScenario = this.projectKind().sampleDataManager().searchScenarioByName(nameIdentifier, scenarioName);
        Option maybeFile = maybeScenario.flatMap((Function1 & Serializable & scala.Serializable)scenario -> this.doSaveTest(nameIdentifier, (Scenario)scenario, mimeType));
        return maybeFile;
    }

    private Option<File> doSaveTest(NameIdentifier nameIdentifier, Scenario scenario, String mimeType) {
        File testFile = new File(WeaveDirectoryUtils$.MODULE$.wtfUnitDefaultTestSourceFolder(this.projectKind().structure())[0], new StringBuilder(9).append(WeaveDirectoryUtils$.MODULE$.toFolderName((NameIdentifier)nameIdentifier.parent().getOrElse((Function0 & Serializable & scala.Serializable)() -> new NameIdentifier("", NameIdentifier$.MODULE$.apply$default$2())))).append("/").append(nameIdentifier.localName()).append("Test.dwl").toString());
        String scenarioTemplate = StringHelper$.MODULE$.toStringTransformer(new StringBuilder(157).append("\n         |    \"Assert ").append(scenario.name()).append("\" in do {\n         |        evalPath(\"").append(new StringOps(Predef$.MODULE$.augmentString(NameIdentifierHelper$.MODULE$.toWeaveFilePath(nameIdentifier, "/"))).drop(1)).append("\", inputsFrom(\"").append(WeaveDirectoryUtils$.MODULE$.toFolderName(nameIdentifier)).append("/").append(scenario.name()).append("\"),\"").append(mimeType).append("\") must\n         |                  equalTo(outputFrom(\"").append(WeaveDirectoryUtils$.MODULE$.toFolderName(nameIdentifier)).append("/").append(scenario.name()).append("\"))\n         |    }").toString()).stripMarginAndNormalizeEOL();
        String testTemplate = StringHelper$.MODULE$.toStringTransformer(new StringBuilder(155).append("%dw ").append(this.projectKind().getWeaveVersion()).append("\n         |import * from dw::test::Tests\n         |import * from dw::test::Asserts\n         |---\n         |\"Test ").append(nameIdentifier.name()).append("\" describedBy [").append(scenarioTemplate).append("\n         |]\n         |").toString()).stripMarginAndNormalizeEOL();
        if (testFile.exists()) {
            return this.appendScenarioToExistingTest$1(testFile, scenarioTemplate, nameIdentifier);
        }
        return this.createTestWithFirstScenario$1(testFile, testTemplate, nameIdentifier);
    }

    public Option<File> saveOutput(NameIdentifier nameIdentifier, String nameOfTheScenario, String outputName, String newContent) {
        Option<Scenario> maybeScenario = this.projectKind().sampleDataManager().searchScenarioByName(nameIdentifier, nameOfTheScenario);
        Option maybeFile = maybeScenario.flatMap((Function1 & Serializable & scala.Serializable)scenario -> this.doSaveOutput(nameIdentifier, outputName, scenario.file(), newContent));
        return maybeFile;
    }

    public void deleteOutput(NameIdentifier nameIdentifier, String nameOfTheScenario, String outputUrl) {
        this.projectKind().sampleDataManager().searchScenarioByName(nameIdentifier, nameOfTheScenario).foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            WeaveScenarioManagerService.$anonfun$deleteOutput$1(outputUrl, x$4);
            return BoxedUnit.UNIT;
        });
        this.notifyAllScenarios(nameIdentifier);
    }

    public void deleteInput(NameIdentifier nameIdentifier, String nameOfTheScenario, String inputUrl) {
        this.projectKind().sampleDataManager().searchScenarioByName(nameIdentifier, nameOfTheScenario).foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
            WeaveScenarioManagerService.$anonfun$deleteInput$1(inputUrl, x$5);
            return BoxedUnit.UNIT;
        });
        this.notifyAllScenarios(nameIdentifier);
    }

    public Option<File> createScenario(NameIdentifier nameIdentifier, String nameOfTheScenario, String inputFileName, Option<String> maybeInputContent) {
        File sampleContainer = this.sampleDataFolder(nameIdentifier);
        File scenario = this.scenarioOf(sampleContainer, nameOfTheScenario);
        Option content = maybeInputContent.orElse((Function0 & Serializable & scala.Serializable)() -> InputScaffoldingFactory$.MODULE$.create(inputFileName).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.template()));
        return this.doCreateInput(nameIdentifier, inputFileName, (Option<String>)content, scenario);
    }

    public Option<String> createScenario$default$4() {
        return None$.MODULE$;
    }

    public File sampleDataFolder(NameIdentifier nameIdentifier) {
        SampleDataComponent sampleDataManager = this.projectKind().sampleDataManager();
        File sampleDataFolder = sampleDataManager.createSampleDataFolderFor(nameIdentifier);
        return sampleDataFolder;
    }

    public File scenarioOf(File sampleContainer, String nameOfTheScenario) {
        return new File(sampleContainer, nameOfTheScenario);
    }

    public Option<File> doCreateInput(NameIdentifier nameIdentifier, String inputFileName, Option<String> maybeInputContent, File scenario) {
        Object object;
        File inputFile = this.inputOf(scenario, inputFileName);
        ArrayList<Either<TextDocumentEdit, ResourceOperation>> edits = new ArrayList<Either<TextDocumentEdit, ResourceOperation>>();
        edits.add(this.createFileCmd(inputFile));
        if (maybeInputContent.isDefined()) {
            String content = (String)maybeInputContent.get();
            Position pos = new Position(0, 0);
            object = BoxesRunTime.boxToBoolean((boolean)edits.add(this.editFileCmd(inputFile, pos, pos, content)));
        } else {
            object = BoxedUnit.UNIT;
        }
        ApplyWorkspaceEditResponse response = this.applyEdits(edits);
        this.notifyAllScenarios(nameIdentifier);
        if (response.isApplied()) {
            return new Some((Object)inputFile);
        }
        return None$.MODULE$;
    }

    private Either<TextDocumentEdit, ResourceOperation> deleteFileCmd(File destinationFile) {
        String destinationFileUrl = URLUtils$.MODULE$.toLSPUrl(destinationFile);
        Either createFile = Either.forRight((Object)new DeleteFile(destinationFileUrl));
        return createFile;
    }

    private Either<TextDocumentEdit, ResourceOperation> createFileCmd(File destinationFile) {
        String destinationFileUrl = URLUtils$.MODULE$.toLSPUrl(destinationFile);
        Either createFile = Either.forRight((Object)new CreateFile(destinationFileUrl));
        return createFile;
    }

    private Either<TextDocumentEdit, ResourceOperation> editFileCmd(File destinationFile, Position startPos, Position endPos, String newText) {
        String outputFileUrl = URLUtils$.MODULE$.toLSPUrl(destinationFile);
        TextEdit textEdit = new TextEdit(new Range(startPos, endPos), newText);
        TextDocumentEdit textDocumentEdit = new TextDocumentEdit(new VersionedTextDocumentIdentifier(outputFileUrl, Predef$.MODULE$.int2Integer(0)), Arrays.asList((Object[])new TextEdit[]{textEdit}));
        Either editFile = Either.forLeft((Object)textDocumentEdit);
        return editFile;
    }

    private ApplyWorkspaceEditResponse applyEdits(Seq<Either<TextDocumentEdit, ResourceOperation>> edits) {
        List<Object> editsList = Arrays.asList((Object[])edits.toArray(ClassTag$.MODULE$.apply(Either.class)));
        return this.applyEdits(editsList);
    }

    private ApplyWorkspaceEditResponse applyEdits(List<Either<TextDocumentEdit, ResourceOperation>> editsList) {
        return this.workspaceEditsService.applyEdit(new ApplyWorkspaceEditParams(new WorkspaceEdit(editsList))).get();
    }

    private Option<File> doSaveOutput(NameIdentifier nameIdentifier, String outputName, File scenario, String newText) {
        ApplyWorkspaceEditResponse result;
        File outputFile = this.outputOf(scenario, outputName);
        Position docStart = new Position(0, 0);
        if (outputFile.exists() && !(result = this.applyEdits((Seq<Either<TextDocumentEdit, ResourceOperation>>)Predef$.MODULE$.wrapRefArray((Object[])new Either[]{this.deleteFileCmd(outputFile)}))).isApplied()) {
            return None$.MODULE$;
        }
        ApplyWorkspaceEditResponse response = this.applyEdits((Seq<Either<TextDocumentEdit, ResourceOperation>>)Predef$.MODULE$.wrapRefArray((Object[])new Either[]{this.createFileCmd(outputFile), this.editFileCmd(outputFile, docStart, docStart, newText)}));
        if (response.isApplied()) {
            this.notifyAllScenarios(nameIdentifier);
            return new Some((Object)outputFile);
        }
        return None$.MODULE$;
    }

    private File outputOf(File scenario, String outputName) {
        return new File(scenario, outputName);
    }

    public File inputOf(File scenario, String inputName) {
        File inputs = WeaveDirectoryUtils$.MODULE$.inputsFolder(scenario);
        return new File(inputs, this.getVariablePath(inputName));
    }

    private String getVariablePath(String fileName) {
        String theBaseName = FilenameUtils.getBaseName((String)fileName);
        String extension = FilenameUtils.getExtension((String)fileName);
        String variablePath = new StringBuilder(1).append(theBaseName.replace('.', File.separatorChar)).append(".").append(extension).toString();
        return variablePath;
    }

    public void org$mule$weave$lsp$services$WeaveScenarioManagerService$$notifyAllScenarios(VirtualFile vf) {
        this.notifyAllScenarios(vf.getNameIdentifier());
    }

    private void notifyAllScenarios(NameIdentifier nameIdentifier) {
        Option<Scenario> maybeActiveScenario = this.activeScenario(nameIdentifier);
        Scenario[] allScenarios = this.projectKind().sampleDataManager().listScenarios(nameIdentifier);
        this.org$mule$weave$lsp$services$WeaveScenarioManagerService$$weaveLanguageClient.showScenarios(new ShowScenariosParams(nameIdentifier.toString(), this.mapScenarios(maybeActiveScenario, allScenarios)));
    }

    public static final /* synthetic */ boolean $anonfun$activeScenario$2(Scenario s) {
        return s.name().equals(Scenario$.MODULE$.PLAYGROUND_SCENARIO());
    }

    public static final /* synthetic */ boolean $anonfun$setActiveScenario$1(String nameOfTheScenario$1, Scenario scenario) {
        return scenario.name().equals(nameOfTheScenario$1);
    }

    public static final /* synthetic */ void $anonfun$setActiveScenario$2(WeaveScenarioManagerService $this, NameIdentifier nameIdentifier$2, Scenario s) {
        $this.activeScenarios().put((Object)nameIdentifier$2, (Object)s);
        $this.notifyAllScenarios(nameIdentifier$2);
    }

    public static final /* synthetic */ boolean $anonfun$setActiveScenario$3(NameIdentifier nameIdentifier$2, VirtualFile vf) {
        return vf.getNameIdentifier().equals((Object)nameIdentifier$2);
    }

    public static final /* synthetic */ void $anonfun$setActiveScenario$4(WeaveScenarioManagerService $this, VirtualFile vf) {
        $this.eventBus().fire(new ActiveScenarioChangedEvent(vf));
    }

    public static final /* synthetic */ void $anonfun$deleteScenario$1(Scenario s) {
        FileUtils.deleteDirectory((File)s.file());
    }

    public static final /* synthetic */ boolean $anonfun$doSaveTest$4(AstNode x0$1) {
        AstNode astNode = x0$1;
        if (astNode instanceof FunctionCallNode) {
            String string;
            VariableReferenceNode variableReferenceNode;
            NameIdentifier nameIdentifier;
            FunctionCallNode functionCallNode = (FunctionCallNode)astNode;
            AstNode astNode2 = functionCallNode.function();
            FunctionCallParametersNode functionCallParametersNode = functionCallNode.args();
            if (astNode2 instanceof VariableReferenceNode && (nameIdentifier = (variableReferenceNode = (VariableReferenceNode)astNode2).variable()) != null && "describedBy".equals(string = nameIdentifier.name()) && functionCallParametersNode != null) {
                return true;
            }
        }
        return false;
    }

    private final Option appendScenarioToExistingTest$1(File testFile$1, String scenarioTemplate$1, NameIdentifier nameIdentifier$5) {
        WeaveDocumentToolingService documentToolingService = this.dataWeaveToolingService.openDocument(URLUtils$.MODULE$.toLSPUrl(testFile$1));
        Option maybePosition = documentToolingService.ast().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.astNode()).flatMap((Function1 & Serializable & scala.Serializable)x$3 -> AstNodeHelper$.MODULE$.find(x$3, (Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)WeaveScenarioManagerService.$anonfun$doSaveTest$4(x0$1))).flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
            AstNode astNode = x0$2;
            if (astNode instanceof FunctionCallNode) {
                ArrayNode arrayNode;
                AstNode array;
                Seq seq;
                Some some;
                String string;
                VariableReferenceNode variableReferenceNode;
                NameIdentifier nameIdentifier;
                FunctionCallNode functionCallNode = (FunctionCallNode)astNode;
                AstNode astNode2 = functionCallNode.function();
                FunctionCallParametersNode functionCallParametersNode = functionCallNode.args();
                if (astNode2 instanceof VariableReferenceNode && (nameIdentifier = (variableReferenceNode = (VariableReferenceNode)astNode2).variable()) != null && "describedBy".equals(string = nameIdentifier.name()) && functionCallParametersNode != null && !(some = Seq$.MODULE$.unapplySeq(seq = functionCallParametersNode.args())).isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0 && (array = (AstNode)((SeqLike)some.get()).apply(1)) instanceof ArrayNode && (arrayNode = (ArrayNode)array).children().nonEmpty()) {
                    return new Some((Object)LSPConverters$.MODULE$.toPosition(((WeaveLocationCapable)arrayNode.children().last()).location().endPosition()));
                }
            }
            return None$.MODULE$;
        }));
        return maybePosition.flatMap((Function1 & Serializable & scala.Serializable)p -> {
            if (this.applyEdits((Seq<Either<TextDocumentEdit, ResourceOperation>>)Predef$.MODULE$.wrapRefArray((Object[])new Either[]{this.editFileCmd(testFile$1, (Position)p, (Position)p, new StringBuilder(1).append(",").append(scenarioTemplate$1).toString())})).isApplied()) {
                this.notifyAllScenarios(nameIdentifier$5);
                return new Some((Object)testFile$1);
            }
            return None$.MODULE$;
        });
    }

    private final Option createTestWithFirstScenario$1(File testFile$1, String testTemplate$1, NameIdentifier nameIdentifier$5) {
        Position docStart = new Position(0, 0);
        ApplyWorkspaceEditResponse response = this.applyEdits((Seq<Either<TextDocumentEdit, ResourceOperation>>)Predef$.MODULE$.wrapRefArray((Object[])new Either[]{this.createFileCmd(testFile$1), this.editFileCmd(testFile$1, docStart, docStart, testTemplate$1)}));
        if (response.isApplied()) {
            this.notifyAllScenarios(nameIdentifier$5);
            return new Some((Object)testFile$1);
        }
        return None$.MODULE$;
    }

    public static final /* synthetic */ void $anonfun$deleteOutput$1(String outputUrl$1, Scenario x$4) {
        URLUtils$.MODULE$.toFile(outputUrl$1).foreach((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)f.delete()));
    }

    public static final /* synthetic */ void $anonfun$deleteInput$1(String inputUrl$1, Scenario x$5) {
        URLUtils$.MODULE$.toFile(inputUrl$1).foreach((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)f.delete()));
    }

    public WeaveScenarioManagerService(DataWeaveToolingService dataWeaveToolingService, WorkspaceEditService workspaceEditsService, DataWeaveProtocolClient weaveLanguageClient, VirtualFileSystem virtualFileSystem) {
        this.dataWeaveToolingService = dataWeaveToolingService;
        this.workspaceEditsService = workspaceEditsService;
        this.org$mule$weave$lsp$services$WeaveScenarioManagerService$$weaveLanguageClient = weaveLanguageClient;
        this.virtualFileSystem = virtualFileSystem;
        ToolingService.$init$(this);
        this.activeScenarios = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

