package org.mule.weave.lsp.commands

import org.mule.weave.extension.api.extension.command.WeaveCommand
import org.mule.weave.lsp.bat.BatConstants.BAT_PROJECT_NATURE
import org.mule.weave.lsp.bat.BatProjectHelper
import org.mule.weave.lsp.bat.BatUserMessages
import org.mule.weave.lsp.services.UIService
import org.mule.weave.lsp.services.WorkspaceServiceManager
import org.mule.weave.lsp.utils.Messages

/**
  * Trait that represent any weave command
  */
trait InternalWeaveCommand extends WeaveCommand {

  /**
    * Returns whether this command should run on the given context.
    *
    * @return
    */
  def enabled(uri: String): Boolean = true

}

abstract class BatCommand(workspaceServiceManager: WorkspaceServiceManager) extends InternalWeaveCommand {

  override def enabled(uri: String): Boolean = {
    workspaceServiceManager.projectKind(uri)
      .filter(projectKind => projectKind.project.hasNature(BAT_PROJECT_NATURE)).isDefined
  }

  protected def installCLIIfNeeded(batProjectManager: BatProjectHelper, uIService: UIService): Boolean = {
    if (!batProjectManager.isBatInstalled) {
      val value = uIService.showMessageRequest(BatUserMessages.installBatCLI())
      value.get() match {
        case msg if msg == Messages.no =>
          false
        case msg if msg == Messages.yes =>
          batProjectManager.downloadAndInstall()
        case _ => {
          false
        }
      }
    } else {
      true
    }
  }

}
