/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.lsp;

import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lsp4j.CodeLensOptions;
import org.eclipse.lsp4j.CompletionOptions;
import org.eclipse.lsp4j.DidChangeConfigurationParams;
import org.eclipse.lsp4j.DidChangeWorkspaceFoldersParams;
import org.eclipse.lsp4j.InitializeParams;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.InitializedParams;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.ServerInfo;
import org.eclipse.lsp4j.SignatureHelpOptions;
import org.eclipse.lsp4j.TextDocumentSyncKind;
import org.eclipse.lsp4j.WorkspaceFolder;
import org.eclipse.lsp4j.WorkspaceFoldersOptions;
import org.eclipse.lsp4j.WorkspaceServerCapabilities;
import org.eclipse.lsp4j.jsonrpc.services.JsonDelegate;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.lsp4j.services.WorkspaceService;
import org.mule.dx.platform.api.protocol.ClientAware;
import org.mule.weave.extension.api.WeaveLanguageServerBuilder;
import org.mule.weave.lsp.EmbeddedLanguageServerConfiguration;
import org.mule.weave.lsp.IDEExecutors$;
import org.mule.weave.lsp.WeaveLanguageServer;
import org.mule.weave.lsp.extension.client.LanguageClientDelegate;
import org.mule.weave.lsp.extension.protocol.DataWeaveProtocolService;
import org.mule.weave.lsp.extension.services.WeaveTextDocumentService;
import org.mule.weave.lsp.jobs.JobManagerService;
import org.mule.weave.lsp.project.DefaultProjectMetadata;
import org.mule.weave.lsp.project.ProjectKind;
import org.mule.weave.lsp.project.ProjectKindContext;
import org.mule.weave.lsp.project.ProjectKindFactory;
import org.mule.weave.lsp.project.ProjectSettings;
import org.mule.weave.lsp.project.ProjectSettings$;
import org.mule.weave.lsp.services.ClientLogger;
import org.mule.weave.lsp.services.ClientLoggerFactory;
import org.mule.weave.lsp.services.DataWeaveDocumentService;
import org.mule.weave.lsp.services.DataWeaveDocumentServiceDispatcher;
import org.mule.weave.lsp.services.DataWeaveDocumentServiceDispatcher$;
import org.mule.weave.lsp.services.DefaultBaseWorkspaceServiceContributor;
import org.mule.weave.lsp.services.DiagnosticsPublisher;
import org.mule.weave.lsp.services.WorkspaceEditApplier;
import org.mule.weave.lsp.services.WorkspaceEditService;
import org.mule.weave.lsp.services.WorkspaceServiceListener;
import org.mule.weave.lsp.services.WorkspaceServiceManager;
import org.mule.weave.lsp.services.delegate.TextDocumentServiceDelegate;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\t5c\u0001B\u0014)\u0001EB\u0001\u0002\u0017\u0001\u0003\u0002\u0003\u0006I!\u0017\u0005\t?\u0002\u0011\t\u0011)A\u0005A\"AA\r\u0001B\u0001B\u0003%Q\r\u0003\u0005m\u0001\t\u0005\t\u0015!\u0003n\u0011!\u0001\bA!A!\u0002\u0013\t\b\"B<\u0001\t\u0003A\b\u0002C@\u0001\u0005\u0004%I!!\u0001\t\u0011\u0005M\u0001\u0001)A\u0005\u0003\u0007A\u0011\"!\u0006\u0001\u0005\u0004%I!a\u0006\t\u0011\u0005\u0015\u0002\u0001)A\u0005\u00033A\u0011\"a\n\u0001\u0005\u0004%I!!\u000b\t\u0011\u0005E\u0002\u0001)A\u0005\u0003WA\u0011\"a\r\u0001\u0005\u0004%I!!\u000e\t\u0011\u0005\r\u0003\u0001)A\u0005\u0003oA1\"!\u0012\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002H!Y\u0011q\n\u0001A\u0002\u0003\u0007I\u0011BA)\u0011-\t\u0019\u0007\u0001a\u0001\u0002\u0003\u0006K!!\u0013\t\u0017\u0005\u0015\u0004\u00011AA\u0002\u0013%\u0011q\r\u0005\f\u0003_\u0002\u0001\u0019!a\u0001\n\u0013\t\t\bC\u0006\u0002v\u0001\u0001\r\u0011!Q!\n\u0005%\u0004\"CA<\u0001\t\u0007I\u0011BA=\u0011!\t\t\t\u0001Q\u0001\n\u0005m\u0004\"CAB\u0001\t\u0007I\u0011BAC\u0011!\ti\t\u0001Q\u0001\n\u0005\u001d\u0005\"CAH\u0001\t\u0007I\u0011BAI\u0011!\tI\n\u0001Q\u0001\n\u0005M\u0005bBAN\u0001\u0011\u0005\u0013Q\u0014\u0005\b\u0003{\u0003A\u0011IA`\u0011\u001d\tI\r\u0001C!\u0003\u0017Dq!!6\u0001\t\u0003\n9\u000eC\u0004\u0002Z\u0002!\t%a7\t\u000f\u0005]\b\u0001\"\u0011\u0002z\"9!\u0011\u0001\u0001\u0005B\t\r\u0001b\u0002B\u0004\u0001\u0011\u0005!\u0011\u0002\u0005\b\u0005#\u0001A\u0011\tB\n\u0011\u001d\u0011i\u0002\u0001C!\u0005?AqA!\u000b\u0001\t\u0013\u0011Y\u0003C\u0004\u0003>\u0001!IAa\u0010\u00037\u0015k'-\u001a3eK\u0012<V-\u0019<f\u0019\u0006tw-^1hKN+'O^3s\u0015\tI#&A\u0002mgBT!a\u000b\u0017\u0002\u000b],\u0017M^3\u000b\u00055r\u0013\u0001B7vY\u0016T\u0011aL\u0001\u0004_J<7\u0001A\n\u0006\u0001IRDi\u0015\t\u0003gaj\u0011\u0001\u000e\u0006\u0003kY\nA\u0001\\1oO*\tq'\u0001\u0003kCZ\f\u0017BA\u001d5\u0005\u0019y%M[3diB\u00111HQ\u0007\u0002y)\u0011QHP\u0001\tg\u0016\u0014h/[2fg*\u0011q\bQ\u0001\u0006YN\u0004HG\u001b\u0006\u0003\u0003:\nq!Z2mSB\u001cX-\u0003\u0002Dy\tqA*\u00198hk\u0006<WmU3sm\u0016\u0014\bcA#O!6\taI\u0003\u0002H\u0011\u0006A\u0001O]8u_\u000e|GN\u0003\u0002J\u0015\u0006\u0019\u0011\r]5\u000b\u0005-c\u0015\u0001\u00039mCR4wN]7\u000b\u00055c\u0013A\u00013y\u0013\tyeIA\u0006DY&,g\u000e^!xCJ,\u0007CA\u001eR\u0013\t\u0011FH\u0001\bMC:<W/Y4f\u00072LWM\u001c;\u0011\u0005Q3V\"A+\u000b\u0005uB\u0013BA,V\u0005a9vN]6ta\u0006\u001cWmU3sm&\u001cW\rT5ti\u0016tWM]\u0001\u0013aJ|'.Z2u\u0017&tGMR1di>\u0014\u0018\u0010\u0005\u0002[;6\t1L\u0003\u0002]Q\u00059\u0001O]8kK\u000e$\u0018B\u00010\\\u0005I\u0001&o\u001c6fGR\\\u0015N\u001c3GC\u000e$xN]=\u0002\u001b\r|gNZ5hkJ\fG/[8o!\t\t'-D\u0001)\u0013\t\u0019\u0007FA\u0012F[\n,G\rZ3e\u0019\u0006tw-^1hKN+'O^3s\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0002\u001fA\u0014x\u000e^8d_2\u001cVM\u001d<jG\u0016\u0004\"A\u001a6\u000e\u0003\u001dT!a\u00125\u000b\u0005%D\u0013!C3yi\u0016t7/[8o\u0013\tYwM\u0001\rECR\fw+Z1wKB\u0013x\u000e^8d_2\u001cVM\u001d<jG\u0016\fqc^8sWN\u0004\u0018mY3TKJ4\u0018nY3NC:\fw-\u001a:\u0011\u0005Qs\u0017BA8V\u0005]9vN]6ta\u0006\u001cWmU3sm&\u001cW-T1oC\u001e,'/A\tk_\nl\u0015M\\1hKJ\u001cVM\u001d<jG\u0016\u0004\"A];\u000e\u0003MT!\u0001\u001e\u0015\u0002\t)|'m]\u0005\u0003mN\u0014\u0011CS8c\u001b\u0006t\u0017mZ3s'\u0016\u0014h/[2f\u0003\u0019a\u0014N\\5u}Q1\u0011P_>}{z\u0004\"!\u0019\u0001\t\u000ba3\u0001\u0019A-\t\u000b}3\u0001\u0019\u00011\t\u000b\u00114\u0001\u0019A3\t\u000b14\u0001\u0019A7\t\u000bA4\u0001\u0019A9\u0002\r1|wmZ3s+\t\t\u0019\u0001\u0005\u0003\u0002\u0006\u0005=QBAA\u0004\u0015\u0011\tI!a\u0003\u0002\u000f1|wmZ5oO*\u0019\u0011Q\u0002\u001c\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003#\t9A\u0001\u0004M_\u001e<WM]\u0001\bY><w-\u001a:!\u0003M!X\r\u001f;E_\u000e,X.\u001a8u'\u0016\u0014h/[2f+\t\tI\u0002\u0005\u0003\u0002\u001c\u0005\u0005RBAA\u000f\u0015\r\ty\"V\u0001\tI\u0016dWmZ1uK&!\u00111EA\u000f\u0005m!V\r\u001f;E_\u000e,X.\u001a8u'\u0016\u0014h/[2f\t\u0016dWmZ1uK\u0006!B/\u001a=u\t>\u001cW/\\3oiN+'O^5dK\u0002\nq\u0003^3yi\u0012{7-^7f]R\u001cVM\u001d<jG\u0016LU\u000e\u001d7\u0016\u0005\u0005-\u0002c\u0001+\u0002.%\u0019\u0011qF+\u0003E\u0011\u000bG/Y,fCZ,Gi\\2v[\u0016tGoU3sm&\u001cW\rR5ta\u0006$8\r[3s\u0003a!X\r\u001f;E_\u000e,X.\u001a8u'\u0016\u0014h/[2f\u00136\u0004H\u000eI\u0001\u000fY\u0006tw-^1hK\u000ec\u0017.\u001a8u+\t\t9\u0004\u0005\u0003\u0002:\u0005}RBAA\u001e\u0015\r\ti\u0004[\u0001\u0007G2LWM\u001c;\n\t\u0005\u0005\u00131\b\u0002\u0017\u0019\u0006tw-^1hK\u000ec\u0017.\u001a8u\t\u0016dWmZ1uK\u0006yA.\u00198hk\u0006<Wm\u00117jK:$\b%A\ndY&,g\u000e\u001e'pO\u001e,'OR1di>\u0014\u00180\u0006\u0002\u0002JA\u0019A+a\u0013\n\u0007\u00055SKA\nDY&,g\u000e\u001e'pO\u001e,'OR1di>\u0014\u00180A\fdY&,g\u000e\u001e'pO\u001e,'OR1di>\u0014\u0018p\u0018\u0013fcR!\u00111KA0!\u0011\t)&a\u0017\u000e\u0005\u0005]#BAA-\u0003\u0015\u00198-\u00197b\u0013\u0011\ti&a\u0016\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003C\u0002\u0012\u0011!a\u0001\u0003\u0013\n1\u0001\u001f\u00132\u0003Q\u0019G.[3oi2{wmZ3s\r\u0006\u001cGo\u001c:zA\u0005a1\r\\5f]RdunZ4feV\u0011\u0011\u0011\u000e\t\u0004)\u0006-\u0014bAA7+\na1\t\\5f]RdunZ4fe\u0006\u00012\r\\5f]RdunZ4fe~#S-\u001d\u000b\u0005\u0003'\n\u0019\bC\u0005\u0002bM\t\t\u00111\u0001\u0002j\u0005i1\r\\5f]RdunZ4fe\u0002\n\u0001b]3ui&twm]\u000b\u0003\u0003w\u00022AWA?\u0013\r\tyh\u0017\u0002\u0010!J|'.Z2u'\u0016$H/\u001b8hg\u0006I1/\u001a;uS:<7\u000fI\u0001\u0015o>\u00148n\u001d9bG\u0016,E-\u001b;BaBd\u0017.\u001a:\u0016\u0005\u0005\u001d\u0005c\u0001+\u0002\n&\u0019\u00111R+\u0003)]{'o[:qC\u000e,W\tZ5u\u0003B\u0004H.[3s\u0003U9xN]6ta\u0006\u001cW-\u00123ji\u0006\u0003\b\u000f\\5fe\u0002\nA\u0003Z5bO:|7\u000f^5dgB+(\r\\5tQ\u0016\u0014XCAAJ!\r!\u0016QS\u0005\u0004\u0003/+&\u0001\u0006#jC\u001etwn\u001d;jGN\u0004VO\u00197jg\",'/A\u000beS\u0006<gn\\:uS\u000e\u001c\b+\u001e2mSNDWM\u001d\u0011\u0002\u0015%t\u0017\u000e^5bY&TX\r\u0006\u0003\u0002 \u0006M\u0006CBAQ\u0003O\u000bY+\u0004\u0002\u0002$*!\u0011QUA\u0006\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0005\u0003S\u000b\u0019KA\tD_6\u0004H.\u001a;bE2,g)\u001e;ve\u0016\u0004B!!,\u000206\ta(C\u0002\u00022z\u0012\u0001#\u00138ji&\fG.\u001b>f%\u0016\u001cX\u000f\u001c;\t\u000f\u0005U6\u00041\u0001\u00028\u00061\u0001/\u0019:b[N\u0004B!!,\u0002:&\u0019\u00111\u0018 \u0003!%s\u0017\u000e^5bY&TX\rU1sC6\u001c\u0018aC5oSRL\u0017\r\\5{K\u0012$B!a\u0015\u0002B\"9\u0011Q\u0017\u000fA\u0002\u0005\r\u0007\u0003BAW\u0003\u000bL1!a2?\u0005EIe.\u001b;jC2L'0\u001a3QCJ\fWn]\u0001\tg\",H\u000fZ8x]R\u0011\u0011Q\u001a\t\u0007\u0003C\u000b9+a4\u0011\t\u0005U\u0013\u0011[\u0005\u0005\u0003'\f9F\u0001\u0004B]f\u0014VMZ\u0001\u0005KbLG\u000f\u0006\u0002\u0002T\u00051r-\u001a;UKb$Hi\\2v[\u0016tGoU3sm&\u001cW\r\u0006\u0002\u0002^B!\u0011q\\Ar\u001b\t\t\tO\u0003\u0002>Q&!\u0011Q]Aq\u0005a9V-\u0019<f)\u0016DH\u000fR8dk6,g\u000e^*feZL7-\u001a\u0015\u0004?\u0005%\b\u0003BAv\u0003gl!!!<\u000b\u0007u\nyOC\u0002\u0002rz\nqA[:p]J\u00048-\u0003\u0003\u0002v\u00065(\u0001\u0004&t_:$U\r\\3hCR,\u0017aE4fi^{'o[:qC\u000e,7+\u001a:wS\u000e,GCAA~!\rY\u0014Q`\u0005\u0004\u0003\u007fd$\u0001E,pe.\u001c\b/Y2f'\u0016\u0014h/[2f\u0003\u001d\u0019wN\u001c8fGR$B!a\u0015\u0003\u0006!1\u0011QH\u0011A\u0002A\u000b\u0001\"\u001a=fGV$xN\u001d\u000b\u0003\u0005\u0017\u0001B!!)\u0003\u000e%!!qBAR\u0005=)\u00050Z2vi>\u00148+\u001a:wS\u000e,\u0017A\u00063jI\u000eC\u0017M\\4f\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0015\t\u0005M#Q\u0003\u0005\b\u0003k\u001b\u0003\u0019\u0001B\f!\u0011\tiK!\u0007\n\u0007\tmaH\u0001\u000fES\u0012\u001c\u0005.\u00198hK\u000e{gNZ5hkJ\fG/[8o!\u0006\u0014\u0018-\\:\u00023\u0011LGm\u00115b]\u001e,wk\u001c:lgB\f7-\u001a$pY\u0012,'o\u001d\u000b\u0005\u0003'\u0012\t\u0003C\u0004\u00026\u0012\u0002\rAa\t\u0011\t\u00055&QE\u0005\u0004\u0005Oq$a\b#jI\u000eC\u0017M\\4f/>\u00148n\u001d9bG\u00164u\u000e\u001c3feN\u0004\u0016M]1ng\u0006qB-[:d_Z,'/\u00118e%\u0016<\u0017n\u001d;feB\u0013xN[3di.Kg\u000e\u001a\u000b\u0005\u0005[\u0011\u0019\u0004E\u0002[\u0005_I1A!\r\\\u0005-\u0001&o\u001c6fGR\\\u0015N\u001c3\t\u000f\tUR\u00051\u0001\u00038\u0005!\u0012\r\u001a3fI^{'o[:qC\u000e,gi\u001c7eKJ\u0004B!!,\u0003:%\u0019!1\b \u0003\u001f]{'o[:qC\u000e,gi\u001c7eKJ\f\u0011c\u0019:fCR,\u0007K]8kK\u000e$8*\u001b8e)\u0019\u0011iC!\u0011\u0003L!9!1\t\u0014A\u0002\t\u0015\u0013a\u00049s_*,7\r^'fi\u0006$\u0017\r^1\u0011\u0007i\u00139%C\u0002\u0003Jm\u0013a\u0003R3gCVdG\u000f\u0015:pU\u0016\u001cG/T3uC\u0012\fG/\u0019\u0005\b\u0003\u000b2\u0003\u0019AA%\u0001")
public class EmbeddedWeaveLanguageServer
implements LanguageServer,
ClientAware<LanguageClient>,
WorkspaceServiceListener {
    private final ProjectKindFactory projectKindFactory;
    private final EmbeddedLanguageServerConfiguration configuration;
    private final DataWeaveProtocolService protocolService;
    private final WorkspaceServiceManager workspaceServiceManager;
    private final JobManagerService jobManagerService;
    private final Logger logger;
    private final TextDocumentServiceDelegate textDocumentService;
    private final DataWeaveDocumentServiceDispatcher textDocumentServiceImpl;
    private final LanguageClientDelegate languageClient;
    private ClientLoggerFactory clientLoggerFactory;
    private ClientLogger clientLogger;
    private final ProjectSettings settings;
    private final WorkspaceEditApplier workspaceEditApplier;
    private final DiagnosticsPublisher diagnosticsPublisher;

    private Logger logger() {
        return this.logger;
    }

    private TextDocumentServiceDelegate textDocumentService() {
        return this.textDocumentService;
    }

    private DataWeaveDocumentServiceDispatcher textDocumentServiceImpl() {
        return this.textDocumentServiceImpl;
    }

    private LanguageClientDelegate languageClient() {
        return this.languageClient;
    }

    private ClientLoggerFactory clientLoggerFactory() {
        return this.clientLoggerFactory;
    }

    private void clientLoggerFactory_$eq(ClientLoggerFactory x$1) {
        this.clientLoggerFactory = x$1;
    }

    private ClientLogger clientLogger() {
        return this.clientLogger;
    }

    private void clientLogger_$eq(ClientLogger x$1) {
        this.clientLogger = x$1;
    }

    private ProjectSettings settings() {
        return this.settings;
    }

    private WorkspaceEditApplier workspaceEditApplier() {
        return this.workspaceEditApplier;
    }

    private DiagnosticsPublisher diagnosticsPublisher() {
        return this.diagnosticsPublisher;
    }

    public CompletableFuture<InitializeResult> initialize(InitializeParams params) {
        this.logger().log(Level.INFO, new StringBuilder(11).append("Initialize ").append(this.configuration.lspID()).toString());
        return CompletableFuture.supplyAsync(() -> {
            this.logger().log(Level.INFO, new StringBuilder(13).append("Initializing ").append($this.configuration.lspID()).toString());
            Runtime.getRuntime().addShutdownHook(new Thread(() -> this.shutdown().get()));
            this.clientLoggerFactory_$eq(new ClientLoggerFactory(this.languageClient()));
            this.clientLogger_$eq(this.clientLoggerFactory().createLogger(WeaveLanguageServer.class, $this.configuration.lspID()));
            $this.workspaceServiceManager.addWorkspaceServiceListeners(this);
            this.settings().load(params.getInitializationOptions());
            if (params.getWorkspaceFolders() != null) {
                params.getWorkspaceFolders().forEach(workspaceFolder -> this.discoverAndRegisterProjectKind((WorkspaceFolder)workspaceFolder));
            }
            this.textDocumentService().delegate_$eq(this.textDocumentServiceImpl());
            if ($this.configuration.fileScheme().isDefined()) {
                $this.workspaceServiceManager.diagnosticsPublisherService().addPublisher(this.diagnosticsPublisher());
                $this.workspaceServiceManager.workspaceEditService().addApplier(this.workspaceEditApplier());
                $this.workspaceServiceManager.textDocumentTranslatorService().addTranslator((String)$this.configuration.fileScheme().get(), (WeaveLanguageServerBuilder.TextDocumentTranslator)$this.configuration.textDocumentLocator().get());
            }
            ServerCapabilities capabilities = new ServerCapabilities();
            capabilities.setTextDocumentSync(TextDocumentSyncKind.Full);
            capabilities.setCompletionProvider(new CompletionOptions(Predef$.MODULE$.boolean2Boolean(true), Arrays.asList((Object[])new String[]{"."})));
            capabilities.setHoverProvider(Predef$.MODULE$.boolean2Boolean(true));
            capabilities.setDocumentSymbolProvider(Predef$.MODULE$.boolean2Boolean(true));
            capabilities.setDefinitionProvider(Predef$.MODULE$.boolean2Boolean(true));
            capabilities.setDocumentFormattingProvider(Predef$.MODULE$.boolean2Boolean(true));
            capabilities.setFoldingRangeProvider(Predef$.MODULE$.boolean2Boolean(true));
            capabilities.setCodeActionProvider(Predef$.MODULE$.boolean2Boolean($this.configuration.codeActions()));
            capabilities.setWorkspaceSymbolProvider(Predef$.MODULE$.boolean2Boolean(true));
            capabilities.setCodeLensProvider(new CodeLensOptions(Predef$.MODULE$.boolean2Boolean($this.configuration.codeLens())));
            capabilities.setRenameProvider(Predef$.MODULE$.boolean2Boolean(true));
            capabilities.setDocumentRangeFormattingProvider(Predef$.MODULE$.boolean2Boolean(true));
            capabilities.setReferencesProvider(Predef$.MODULE$.boolean2Boolean(true));
            capabilities.setSignatureHelpProvider(new SignatureHelpOptions(Arrays.asList((Object[])new String[]{"("}), Arrays.asList((Object[])new String[]{","})));
            WorkspaceFoldersOptions workspaceFoldersOptions = new WorkspaceFoldersOptions();
            workspaceFoldersOptions.setSupported(Predef$.MODULE$.boolean2Boolean(true));
            workspaceFoldersOptions.setChangeNotifications(Predef$.MODULE$.boolean2Boolean(true));
            WorkspaceServerCapabilities workspaceServerCapabilities = new WorkspaceServerCapabilities(workspaceFoldersOptions);
            capabilities.setWorkspace(workspaceServerCapabilities);
            ServerInfo serverInfo = new ServerInfo(new StringBuilder(21).append("Embedded DataWeave (").append($this.configuration.lspID()).append(")").toString());
            this.clientLogger().logInfo(new StringBuilder(46).append("Initialize: Finished. Server: ").append(serverInfo).append(", Capabilities: ").append(capabilities).toString());
            return new InitializeResult(capabilities, serverInfo);
        });
    }

    public void initialized(InitializedParams params) {
        this.logger().log(Level.INFO, new StringBuilder(12).append("Initialized ").append(this.configuration.lspID()).toString());
    }

    public CompletableFuture<Object> shutdown() {
        return CompletableFuture.supplyAsync(() -> {
            Option<WeaveLanguageServerBuilder.TextDocumentTranslator> option;
            this.clientLogger().logInfo(new StringBuilder(9).append("Stopping ").append($this.configuration.lspID()).toString());
            if ($this.configuration.fileScheme().isDefined()) {
                $this.workspaceServiceManager.diagnosticsPublisherService().removePublisher(this.diagnosticsPublisher());
                $this.workspaceServiceManager.workspaceEditService().removeApplier(this.workspaceEditApplier());
                option = $this.workspaceServiceManager.textDocumentTranslatorService().removeTranslator((String)$this.configuration.fileScheme().get());
            } else {
                option = BoxedUnit.UNIT;
            }
            return null;
        });
    }

    public void exit() {
    }

    @JsonDelegate
    public WeaveTextDocumentService getTextDocumentService() {
        return this.textDocumentService();
    }

    public WorkspaceService getWorkspaceService() {
        return this.workspaceServiceManager.workspaceService();
    }

    public void connect(LanguageClient client) {
        this.languageClient().delegate_$eq(client);
    }

    public ExecutorService executor() {
        return IDEExecutors$.MODULE$.defaultExecutor();
    }

    @Override
    public void didChangeConfiguration(DidChangeConfigurationParams params) {
        this.settings().update(params.getSettings());
    }

    @Override
    public void didChangeWorkspaceFolders(DidChangeWorkspaceFoldersParams params) {
        params.getEvent().getRemoved().forEach(removedWorkspaceFolder -> {
            Option<ProjectKind> option = $this.workspaceServiceManager.onProjectKindRemoved(removedWorkspaceFolder.getUri());
            if (option instanceof Some) {
                Some some = (Some)option;
                ProjectKind projectKind = (ProjectKind)some.value();
                this.textDocumentServiceImpl().onProjectRemoved(projectKind);
                projectKind.shutdown();
                return;
            }
            if (None$.MODULE$.equals(option)) {
                this.logger().warning(new StringBuilder(44).append("There is no projectKind registered for URI: ").append(removedWorkspaceFolder.getUri()).toString());
                return;
            }
            throw new MatchError(option);
        });
        params.getEvent().getAdded().forEach(addedWorkspaceFolder -> {
            try {
                this.discoverAndRegisterProjectKind((WorkspaceFolder)addedWorkspaceFolder);
            }
            catch (Exception e) {
                this.clientLogger().logInfo(new StringBuilder(52).append("Unable to discover projectKind for workspaceFolder: ").append(addedWorkspaceFolder.getUri()).toString(), e);
            }
        });
    }

    private ProjectKind discoverAndRegisterProjectKind(WorkspaceFolder addedWorkspaceFolder) {
        DefaultProjectMetadata projectMetadata = new DefaultProjectMetadata((Option<String>)Option$.MODULE$.apply((Object)addedWorkspaceFolder.getUri()), this.settings());
        ProjectKind projectKind = this.createProjectKind(projectMetadata, this.clientLoggerFactory());
        this.textDocumentServiceImpl().onProjectKindCreated(projectKind, new DataWeaveDocumentService(projectKind, this.executor()));
        this.workspaceServiceManager.onProjectKindCreated(addedWorkspaceFolder.getUri(), projectKind, new DefaultBaseWorkspaceServiceContributor(projectKind, projectMetadata, this.protocolService.getClient(), this.workspaceServiceManager.commandManagerService(), this.configuration.textDocumentLocator()));
        return projectKind;
    }

    private ProjectKind createProjectKind(DefaultProjectMetadata projectMetadata, ClientLoggerFactory clientLoggerFactory) {
        WorkspaceEditService workspaceEditsService = this.workspaceServiceManager.workspaceEditService();
        ProjectKind projectKind = this.projectKindFactory.createKind(new ProjectKindContext(projectMetadata, clientLoggerFactory, this.protocolService.getClient(), this.jobManagerService, workspaceEditsService));
        projectKind.initialize();
        projectMetadata.setEventBus(projectKind.eventBus());
        return projectKind;
    }

    public EmbeddedWeaveLanguageServer(ProjectKindFactory projectKindFactory, EmbeddedLanguageServerConfiguration configuration, DataWeaveProtocolService protocolService, WorkspaceServiceManager workspaceServiceManager, JobManagerService jobManagerService) {
        this.projectKindFactory = projectKindFactory;
        this.configuration = configuration;
        this.protocolService = protocolService;
        this.workspaceServiceManager = workspaceServiceManager;
        this.jobManagerService = jobManagerService;
        WorkspaceServiceListener.$init$(this);
        this.logger = Logger.getLogger(this.getClass().getName());
        this.textDocumentService = new TextDocumentServiceDelegate();
        this.textDocumentServiceImpl = new DataWeaveDocumentServiceDispatcher(configuration.codeLens(), configuration.textDocumentLocator(), DataWeaveDocumentServiceDispatcher$.MODULE$.$lessinit$greater$default$3());
        this.languageClient = new LanguageClientDelegate();
        this.settings = new ProjectSettings(ProjectSettings$.MODULE$.apply$default$1(), ProjectSettings$.MODULE$.apply$default$2(), ProjectSettings$.MODULE$.apply$default$3(), ProjectSettings$.MODULE$.apply$default$4(), ProjectSettings$.MODULE$.apply$default$5(), ProjectSettings$.MODULE$.apply$default$6(), ProjectSettings$.MODULE$.apply$default$7(), ProjectSettings$.MODULE$.apply$default$8(), ProjectSettings$.MODULE$.apply$default$9(), ProjectSettings$.MODULE$.apply$default$10(), ProjectSettings$.MODULE$.apply$default$11());
        this.workspaceEditApplier = new WorkspaceEditApplier(this.languageClient(), configuration.fileScheme());
        this.diagnosticsPublisher = new DiagnosticsPublisher(this.languageClient(), configuration.fileScheme());
    }
}

