/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.lsp;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lsp4j.CodeLensOptions;
import org.eclipse.lsp4j.CompletionOptions;
import org.eclipse.lsp4j.DidChangeConfigurationParams;
import org.eclipse.lsp4j.DidChangeWorkspaceFoldersParams;
import org.eclipse.lsp4j.ExecuteCommandOptions;
import org.eclipse.lsp4j.InitializeParams;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.InitializedParams;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.ServerInfo;
import org.eclipse.lsp4j.SignatureHelpOptions;
import org.eclipse.lsp4j.TextDocumentSyncKind;
import org.eclipse.lsp4j.WorkspaceFolder;
import org.eclipse.lsp4j.WorkspaceFoldersOptions;
import org.eclipse.lsp4j.WorkspaceServerCapabilities;
import org.eclipse.lsp4j.jsonrpc.services.JsonDelegate;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.lsp4j.services.WorkspaceService;
import org.mule.dx.platform.api.protocol.ClientAware;
import org.mule.weave.extension.api.WeaveLanguageServerBuilder;
import org.mule.weave.lsp.IDEExecutors$;
import org.mule.weave.lsp.commands.CommandManagerService;
import org.mule.weave.lsp.extension.client.LanguageClientDelegate;
import org.mule.weave.lsp.extension.protocol.DataWeaveProtocolService;
import org.mule.weave.lsp.extension.services.WeaveTextDocumentService;
import org.mule.weave.lsp.jobs.JobManagerService;
import org.mule.weave.lsp.project.DefaultProjectMetadata;
import org.mule.weave.lsp.project.ProjectKind;
import org.mule.weave.lsp.project.ProjectKindContext;
import org.mule.weave.lsp.project.ProjectKindFactory;
import org.mule.weave.lsp.project.ProjectSettings;
import org.mule.weave.lsp.project.ProjectSettings$;
import org.mule.weave.lsp.services.ClientLogger;
import org.mule.weave.lsp.services.ClientLoggerFactory;
import org.mule.weave.lsp.services.DataWeaveDocumentService;
import org.mule.weave.lsp.services.DataWeaveDocumentServiceDispatcher;
import org.mule.weave.lsp.services.DataWeaveDocumentServiceDispatcher$;
import org.mule.weave.lsp.services.DefaultBaseWorkspaceServiceContributor;
import org.mule.weave.lsp.services.DefaultBaseWorkspaceServiceContributor$;
import org.mule.weave.lsp.services.DiagnosticsPublisher;
import org.mule.weave.lsp.services.WorkspaceEditApplier;
import org.mule.weave.lsp.services.WorkspaceEditService;
import org.mule.weave.lsp.services.WorkspaceServiceListener;
import org.mule.weave.lsp.services.WorkspaceServiceManager;
import org.mule.weave.lsp.services.delegate.TextDocumentServiceDelegate;
import org.mule.weave.lsp.utils.URLUtils$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.concurrent.TrieMap;
import scala.collection.concurrent.TrieMap$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\ted\u0001B\u0015+\u0001MB\u0001B\u0017\u0001\u0003\u0002\u0003\u0006Ia\u0017\u0005\tC\u0002\u0011\t\u0011)A\u0005E\"A\u0011\u000e\u0001B\u0001B\u0003%!\u000e\u0003\u0005n\u0001\t\u0005\t\u0015!\u0003o\u0011\u0015!\b\u0001\"\u0001v\u0011\u001da\bA1A\u0005\nuDq!!\u0004\u0001A\u0003%a\u0010C\u0005\u0002\u0010\u0001\u0011\r\u0011\"\u0003\u0002\u0012!A\u0011q\u0004\u0001!\u0002\u0013\t\u0019\u0002C\u0005\u0002\"\u0001\u0011\r\u0011\"\u0003\u0002$!A\u00111\u0006\u0001!\u0002\u0013\t)\u0003\u0003\u0006\u0002.\u0001A)\u0019!C\u0005\u0003_A\u0011\"a\u000e\u0001\u0005\u0004%I!!\u000f\t\u0011\u0005-\u0004\u0001)A\u0005\u0003wA\u0011\"!\u001c\u0001\u0005\u0004%I!a\u001c\t\u0011\u0005u\u0004\u0001)A\u0005\u0003cB1\"a \u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u0002\"Y\u0011\u0011\u0012\u0001A\u0002\u0003\u0007I\u0011BAF\u0011-\tI\n\u0001a\u0001\u0002\u0003\u0006K!a!\t\u0017\u0005m\u0005\u00011AA\u0002\u0013%\u0011Q\u0014\u0005\f\u0003K\u0003\u0001\u0019!a\u0001\n\u0013\t9\u000bC\u0006\u0002,\u0002\u0001\r\u0011!Q!\n\u0005}\u0005\"CAW\u0001\t\u0007I\u0011BAX\u0011!\t9\f\u0001Q\u0001\n\u0005E\u0006\"CA]\u0001\t\u0007I\u0011BA^\u0011!\t\t\r\u0001Q\u0001\n\u0005u\u0006bBAb\u0001\u0011\u0005\u0013Q\u0019\u0005\b\u0003G\u0004A\u0011BAs\u0011\u001d\t\u0019\u0010\u0001C!\u0003kDq!a@\u0001\t\u0013\u0011\t\u0001C\u0004\u0003\b\u0001!\tE!\u0003\t\u000f\tM\u0001\u0001\"\u0011\u0003\u0016!9!q\u0003\u0001\u0005B\te\u0001b\u0002B\u001b\u0001\u0011\u0005#q\u0007\u0005\b\u0005\u007f\u0001A\u0011\tB!\u0011\u001d\u0011)\u0005\u0001C\u0001\u0005\u000fBqAa\u0014\u0001\t\u0003\u0012\t\u0006C\u0004\u0003\\\u0001!\tE!\u0018\t\u000f\t\u001d\u0004\u0001\"\u0003\u0003j!9!1\u000e\u0001\u0005\n\t5$aE,fCZ,G*\u00198hk\u0006<WmU3sm\u0016\u0014(BA\u0016-\u0003\ra7\u000f\u001d\u0006\u0003[9\nQa^3bm\u0016T!a\f\u0019\u0002\t5,H.\u001a\u0006\u0002c\u0005\u0019qN]4\u0004\u0001M)\u0001\u0001\u000e\u001fG+B\u0011QGO\u0007\u0002m)\u0011q\u0007O\u0001\u0005Y\u0006twMC\u0001:\u0003\u0011Q\u0017M^1\n\u0005m2$AB(cU\u0016\u001cG\u000f\u0005\u0002>\t6\taH\u0003\u0002@\u0001\u0006A1/\u001a:wS\u000e,7O\u0003\u0002B\u0005\u0006)An\u001d95U*\u00111\tM\u0001\bK\u000ed\u0017\u000e]:f\u0013\t)eH\u0001\bMC:<W/Y4f'\u0016\u0014h/\u001a:\u0011\u0007\u001d\u0003&+D\u0001I\u0015\tI%*\u0001\u0005qe>$xnY8m\u0015\tYE*A\u0002ba&T!!\u0014(\u0002\u0011Ad\u0017\r\u001e4pe6T!a\u0014\u0018\u0002\u0005\u0011D\u0018BA)I\u0005-\u0019E.[3oi\u0006;\u0018M]3\u0011\u0005u\u001a\u0016B\u0001+?\u00059a\u0015M\\4vC\u001e,7\t\\5f]R\u0004\"A\u0016-\u000e\u0003]S!a\u0010\u0016\n\u0005e;&\u0001G,pe.\u001c\b/Y2f'\u0016\u0014h/[2f\u0019&\u001cH/\u001a8fe\u0006\u0011\u0002O]8kK\u000e$8*\u001b8e\r\u0006\u001cGo\u001c:z!\tav,D\u0001^\u0015\tq&&A\u0004qe>TWm\u0019;\n\u0005\u0001l&A\u0005)s_*,7\r^&j]\u00124\u0015m\u0019;pef\fq\u0002\u001d:pi>\u001cw\u000e\\*feZL7-\u001a\t\u0003G\u001el\u0011\u0001\u001a\u0006\u0003\u0013\u0016T!A\u001a\u0016\u0002\u0013\u0015DH/\u001a8tS>t\u0017B\u00015e\u0005a!\u0015\r^1XK\u00064X\r\u0015:pi>\u001cw\u000e\\*feZL7-Z\u0001\u0018o>\u00148n\u001d9bG\u0016\u001cVM\u001d<jG\u0016l\u0015M\\1hKJ\u0004\"AV6\n\u00051<&aF,pe.\u001c\b/Y2f'\u0016\u0014h/[2f\u001b\u0006t\u0017mZ3s\u0003EQwNY'b]\u0006<WM]*feZL7-\u001a\t\u0003_Jl\u0011\u0001\u001d\u0006\u0003c*\nAA[8cg&\u00111\u000f\u001d\u0002\u0012\u0015>\u0014W*\u00198bO\u0016\u00148+\u001a:wS\u000e,\u0017A\u0002\u001fj]&$h\bF\u0003wqfT8\u0010\u0005\u0002x\u00015\t!\u0006C\u0003[\u000b\u0001\u00071\fC\u0003b\u000b\u0001\u0007!\rC\u0003j\u000b\u0001\u0007!\u000eC\u0003n\u000b\u0001\u0007a.\u0001\u0004m_\u001e<WM]\u000b\u0002}B\u0019q0!\u0003\u000e\u0005\u0005\u0005!\u0002BA\u0002\u0003\u000b\tq\u0001\\8hO&twMC\u0002\u0002\ba\nA!\u001e;jY&!\u00111BA\u0001\u0005\u0019aunZ4fe\u00069An\\4hKJ\u0004\u0013a\u0005;fqR$unY;nK:$8+\u001a:wS\u000e,WCAA\n!\u0011\t)\"a\u0007\u000e\u0005\u0005]!bAA\r/\u0006AA-\u001a7fO\u0006$X-\u0003\u0003\u0002\u001e\u0005]!a\u0007+fqR$unY;nK:$8+\u001a:wS\u000e,G)\u001a7fO\u0006$X-\u0001\u000buKb$Hi\\2v[\u0016tGoU3sm&\u001cW\rI\u0001\u0018i\u0016DH\u000fR8dk6,g\u000e^*feZL7-Z%na2,\"!!\n\u0011\u0007Y\u000b9#C\u0002\u0002*]\u0013!\u0005R1uC^+\u0017M^3E_\u000e,X.\u001a8u'\u0016\u0014h/[2f\t&\u001c\b/\u0019;dQ\u0016\u0014\u0018\u0001\u0007;fqR$unY;nK:$8+\u001a:wS\u000e,\u0017*\u001c9mA\u0005iB.\u00198hk\u0006<WmU3sm\u0016\u0014Hi\\2v[\u0016tGoU3sm&\u001cW-\u0006\u0002\u00022A\u0019a+a\r\n\u0007\u0005UrK\u0001\rECR\fw+Z1wK\u0012{7-^7f]R\u001cVM\u001d<jG\u0016\f\u0001\u0005\u001d:pU\u0016\u001cGoS5oIN\u0014\u0015pV8sWN\u0004\u0018mY3G_2$WM]+sSV\u0011\u00111\b\t\t\u0003{\tY%a\u0014\u0002f5\u0011\u0011q\b\u0006\u0005\u0003\u0003\n\u0019%\u0001\u0006d_:\u001cWO\u001d:f]RTA!!\u0012\u0002H\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\u000b\u0005\u0005%\u0013!B:dC2\f\u0017\u0002BA'\u0003\u007f\u0011q\u0001\u0016:jK6\u000b\u0007\u000f\u0005\u0003\u0002R\u0005}c\u0002BA*\u00037\u0002B!!\u0016\u0002H5\u0011\u0011q\u000b\u0006\u0004\u00033\u0012\u0014A\u0002\u001fs_>$h(\u0003\u0003\u0002^\u0005\u001d\u0013A\u0002)sK\u0012,g-\u0003\u0003\u0002b\u0005\r$AB*ue&twM\u0003\u0003\u0002^\u0005\u001d\u0003c\u0001/\u0002h%\u0019\u0011\u0011N/\u0003\u0017A\u0013xN[3di.Kg\u000eZ\u0001\"aJ|'.Z2u\u0017&tGm\u001d\"z/>\u00148n\u001d9bG\u00164u\u000e\u001c3feV\u0013\u0018\u000eI\u0001\u000fY\u0006tw-^1hK\u000ec\u0017.\u001a8u+\t\t\t\b\u0005\u0003\u0002t\u0005eTBAA;\u0015\r\t9(Z\u0001\u0007G2LWM\u001c;\n\t\u0005m\u0014Q\u000f\u0002\u0017\u0019\u0006tw-^1hK\u000ec\u0017.\u001a8u\t\u0016dWmZ1uK\u0006yA.\u00198hk\u0006<Wm\u00117jK:$\b%A\ndY&,g\u000e\u001e'pO\u001e,'OR1di>\u0014\u00180\u0006\u0002\u0002\u0004B\u0019a+!\"\n\u0007\u0005\u001duKA\nDY&,g\u000e\u001e'pO\u001e,'OR1di>\u0014\u00180A\fdY&,g\u000e\u001e'pO\u001e,'OR1di>\u0014\u0018p\u0018\u0013fcR!\u0011QRAK!\u0011\ty)!%\u000e\u0005\u0005\u001d\u0013\u0002BAJ\u0003\u000f\u0012A!\u00168ji\"I\u0011q\u0013\n\u0002\u0002\u0003\u0007\u00111Q\u0001\u0004q\u0012\n\u0014\u0001F2mS\u0016tG\u000fT8hO\u0016\u0014h)Y2u_JL\b%\u0001\u0007dY&,g\u000e\u001e'pO\u001e,'/\u0006\u0002\u0002 B\u0019a+!)\n\u0007\u0005\rvK\u0001\u0007DY&,g\u000e\u001e'pO\u001e,'/\u0001\tdY&,g\u000e\u001e'pO\u001e,'o\u0018\u0013fcR!\u0011QRAU\u0011%\t9*FA\u0001\u0002\u0004\ty*A\u0007dY&,g\u000e\u001e'pO\u001e,'\u000fI\u0001\tg\u0016$H/\u001b8hgV\u0011\u0011\u0011\u0017\t\u00049\u0006M\u0016bAA[;\ny\u0001K]8kK\u000e$8+\u001a;uS:<7/A\u0005tKR$\u0018N\\4tA\u0005\u0011\u0011\nR\u000b\u0003\u0003{\u00032!NA`\u0013\r\t\tGN\u0001\u0004\u0013\u0012\u0003\u0013AC5oSRL\u0017\r\\5{KR!\u0011qYAm!\u0019\tI-!4\u0002R6\u0011\u00111\u001a\u0006\u0005\u0003\u0003\n)!\u0003\u0003\u0002P\u0006-'!E\"p[BdW\r^1cY\u00164U\u000f^;sKB!\u00111[Ak\u001b\u0005\u0001\u0015bAAl\u0001\n\u0001\u0012J\\5uS\u0006d\u0017N_3SKN,H\u000e\u001e\u0005\b\u00037\\\u0002\u0019AAo\u0003\u0019\u0001\u0018M]1ngB!\u00111[Ap\u0013\r\t\t\u000f\u0011\u0002\u0011\u0013:LG/[1mSj,\u0007+\u0019:b[N\f\u0011c\u0019:fCR,\u0007K]8kK\u000e$8*\u001b8e)\u0019\t)'a:\u0002r\"9\u0011\u0011\u001e\u000fA\u0002\u0005-\u0018a\u00049s_*,7\r^'fi\u0006$\u0017\r^1\u0011\u0007q\u000bi/C\u0002\u0002pv\u0013a\u0003R3gCVdG\u000f\u0015:pU\u0016\u001cG/T3uC\u0012\fG/\u0019\u0005\b\u0003\u007fb\u0002\u0019AAB\u0003-Ig.\u001b;jC2L'0\u001a3\u0015\t\u00055\u0015q\u001f\u0005\b\u00037l\u0002\u0019AA}!\u0011\t\u0019.a?\n\u0007\u0005u\bIA\tJ]&$\u0018.\u00197ju\u0016$\u0007+\u0019:b[N\fa#\u001b8ji&\fG.\u001b>fIB\u0013xN[3di.Kg\u000e\u001a\u000b\u0005\u0003\u001b\u0013\u0019\u0001C\u0004\u0003\u0006y\u0001\r!!\u001a\u0002\u0017A\u0014xN[3di.Kg\u000eZ\u0001\tg\",H\u000fZ8x]R\u0011!1\u0002\t\u0007\u0003\u0013\fiM!\u0004\u0011\t\u0005=%qB\u0005\u0005\u0005#\t9E\u0001\u0004B]f\u0014VMZ\u0001\u0005KbLG\u000f\u0006\u0002\u0002\u000e\u00061r-\u001a;UKb$Hi\\2v[\u0016tGoU3sm&\u001cW\r\u0006\u0002\u0003\u001cA!!Q\u0004B\u0011\u001b\t\u0011yB\u0003\u0002@K&!!1\u0005B\u0010\u0005a9V-\u0019<f)\u0016DH\u000fR8dk6,g\u000e^*feZL7-\u001a\u0015\u0004C\t\u001d\u0002\u0003\u0002B\u0015\u0005ci!Aa\u000b\u000b\u0007}\u0012iCC\u0002\u00030\u0001\u000bqA[:p]J\u00048-\u0003\u0003\u00034\t-\"\u0001\u0004&t_:$U\r\\3hCR,\u0017aE4fi^{'o[:qC\u000e,7+\u001a:wS\u000e,GC\u0001B\u001d!\ri$1H\u0005\u0004\u0005{q$\u0001E,pe.\u001c\b/Y2f'\u0016\u0014h/[2f\u0003\u001d\u0019wN\u001c8fGR$B!!$\u0003D!1\u0011qO\u0012A\u0002I\u000b\u0001\"\u001a=fGV$xN\u001d\u000b\u0003\u0005\u0013\u0002B!!3\u0003L%!!QJAf\u0005=)\u00050Z2vi>\u00148+\u001a:wS\u000e,\u0017A\u00063jI\u000eC\u0017M\\4f\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0015\t\u00055%1\u000b\u0005\b\u00037,\u0003\u0019\u0001B+!\u0011\t\u0019Na\u0016\n\u0007\te\u0003I\u0001\u000fES\u0012\u001c\u0005.\u00198hK\u000e{gNZ5hkJ\fG/[8o!\u0006\u0014\u0018-\\:\u00023\u0011LGm\u00115b]\u001e,wk\u001c:lgB\f7-\u001a$pY\u0012,'o\u001d\u000b\u0005\u0003\u001b\u0013y\u0006C\u0004\u0002\\\u001a\u0002\rA!\u0019\u0011\t\u0005M'1M\u0005\u0004\u0005K\u0002%a\b#jI\u000eC\u0017M\\4f/>\u00148n\u001d9bG\u00164u\u000e\u001c3feN\u0004\u0016M]1ng\u0006\u00193M]3bi\u0016d\u0015M\\4vC\u001e,7+\u001a:wKJ$unY;nK:$8+\u001a:wS\u000e,GCAA\u0019\u0003y!\u0017n]2pm\u0016\u0014\u0018I\u001c3SK\u001eL7\u000f^3s!J|'.Z2u\u0017&tG\r\u0006\u0003\u0002f\t=\u0004b\u0002B9Q\u0001\u0007!1O\u0001\u0015C\u0012$W\rZ,pe.\u001c\b/Y2f\r>dG-\u001a:\u0011\t\u0005M'QO\u0005\u0004\u0005o\u0002%aD,pe.\u001c\b/Y2f\r>dG-\u001a:")
public class WeaveLanguageServer
implements LanguageServer,
ClientAware<LanguageClient>,
WorkspaceServiceListener {
    private DataWeaveDocumentService languageServerDocumentService;
    private final ProjectKindFactory projectKindFactory;
    private final DataWeaveProtocolService protocolService;
    private final WorkspaceServiceManager workspaceServiceManager;
    private final JobManagerService jobManagerService;
    private final Logger logger;
    private final TextDocumentServiceDelegate textDocumentService;
    private final DataWeaveDocumentServiceDispatcher textDocumentServiceImpl;
    private final TrieMap<String, ProjectKind> projectKindsByWorkspaceFolderUri;
    private final LanguageClientDelegate languageClient;
    private ClientLoggerFactory clientLoggerFactory;
    private ClientLogger clientLogger;
    private final ProjectSettings settings;
    private final String ID;
    private volatile boolean bitmap$0;

    private Logger logger() {
        return this.logger;
    }

    private TextDocumentServiceDelegate textDocumentService() {
        return this.textDocumentService;
    }

    private DataWeaveDocumentServiceDispatcher textDocumentServiceImpl() {
        return this.textDocumentServiceImpl;
    }

    private DataWeaveDocumentService languageServerDocumentService$lzycompute() {
        WeaveLanguageServer weaveLanguageServer = this;
        synchronized (weaveLanguageServer) {
            if (!this.bitmap$0) {
                this.languageServerDocumentService = this.createLanguageServerDocumentService();
                this.bitmap$0 = true;
            }
        }
        return this.languageServerDocumentService;
    }

    private DataWeaveDocumentService languageServerDocumentService() {
        if (!this.bitmap$0) {
            return this.languageServerDocumentService$lzycompute();
        }
        return this.languageServerDocumentService;
    }

    private TrieMap<String, ProjectKind> projectKindsByWorkspaceFolderUri() {
        return this.projectKindsByWorkspaceFolderUri;
    }

    private LanguageClientDelegate languageClient() {
        return this.languageClient;
    }

    private ClientLoggerFactory clientLoggerFactory() {
        return this.clientLoggerFactory;
    }

    private void clientLoggerFactory_$eq(ClientLoggerFactory x$1) {
        this.clientLoggerFactory = x$1;
    }

    private ClientLogger clientLogger() {
        return this.clientLogger;
    }

    private void clientLogger_$eq(ClientLogger x$1) {
        this.clientLogger = x$1;
    }

    private ProjectSettings settings() {
        return this.settings;
    }

    private String ID() {
        return this.ID;
    }

    public CompletableFuture<InitializeResult> initialize(InitializeParams params) {
        this.logger().log(Level.INFO, new StringBuilder(11).append("Initialize ").append(this.ID()).toString());
        return CompletableFuture.supplyAsync(() -> {
            this.logger().log(Level.INFO, new StringBuilder(13).append("Initializing ").append(this.ID()).toString());
            Runtime.getRuntime().addShutdownHook(new Thread(() -> this.shutdown().get()));
            this.clientLoggerFactory_$eq(new ClientLoggerFactory(this.languageClient()));
            this.clientLogger_$eq(this.clientLoggerFactory().createLogger(WeaveLanguageServer.class, this.ID()));
            $this.workspaceServiceManager.addWorkspaceServiceListeners(this);
            this.settings().load(params.getInitializationOptions());
            if (params.getWorkspaceFolders() != null) {
                params.getWorkspaceFolders().forEach(workspaceFolder -> this.discoverAndRegisterProjectKind((WorkspaceFolder)workspaceFolder));
            }
            this.textDocumentService().delegate_$eq(this.textDocumentServiceImpl());
            $this.workspaceServiceManager.diagnosticsPublisherService().setDefaultPublisher(new DiagnosticsPublisher(this.languageClient(), (Option<String>)Option$.MODULE$.empty()));
            $this.workspaceServiceManager.workspaceEditService().setDefaultApplier(new WorkspaceEditApplier(this.languageClient(), (Option<String>)Option$.MODULE$.empty()));
            CommandManagerService commandManagerService = $this.workspaceServiceManager.commandManagerService();
            ServerCapabilities capabilities = new ServerCapabilities();
            capabilities.setTextDocumentSync(TextDocumentSyncKind.Full);
            capabilities.setCompletionProvider(new CompletionOptions(Predef$.MODULE$.boolean2Boolean(true), Arrays.asList((Object[])new String[]{"."})));
            capabilities.setHoverProvider(Predef$.MODULE$.boolean2Boolean(true));
            capabilities.setDocumentSymbolProvider(Predef$.MODULE$.boolean2Boolean(true));
            capabilities.setDefinitionProvider(Predef$.MODULE$.boolean2Boolean(true));
            capabilities.setDocumentFormattingProvider(Predef$.MODULE$.boolean2Boolean(true));
            capabilities.setFoldingRangeProvider(Predef$.MODULE$.boolean2Boolean(true));
            capabilities.setCodeActionProvider(Predef$.MODULE$.boolean2Boolean(true));
            capabilities.setWorkspaceSymbolProvider(Predef$.MODULE$.boolean2Boolean(true));
            capabilities.setCodeLensProvider(new CodeLensOptions(Predef$.MODULE$.boolean2Boolean(true)));
            capabilities.setRenameProvider(Predef$.MODULE$.boolean2Boolean(true));
            capabilities.setDocumentRangeFormattingProvider(Predef$.MODULE$.boolean2Boolean(true));
            capabilities.setReferencesProvider(Predef$.MODULE$.boolean2Boolean(true));
            capabilities.setSignatureHelpProvider(new SignatureHelpOptions(Arrays.asList((Object[])new String[]{"("}), Arrays.asList((Object[])new String[]{","})));
            capabilities.setExecuteCommandProvider(new ExecuteCommandOptions((List)JavaConverters$.MODULE$.seqAsJavaListConverter(commandManagerService.commandIds()).asJava()));
            WorkspaceFoldersOptions workspaceFoldersOptions = new WorkspaceFoldersOptions();
            workspaceFoldersOptions.setSupported(Predef$.MODULE$.boolean2Boolean(true));
            workspaceFoldersOptions.setChangeNotifications(Predef$.MODULE$.boolean2Boolean(true));
            WorkspaceServerCapabilities workspaceServerCapabilities = new WorkspaceServerCapabilities(workspaceFoldersOptions);
            capabilities.setWorkspace(workspaceServerCapabilities);
            ServerInfo serverInfo = new ServerInfo("DataWeave", this.settings().languageLevelVersion().value());
            this.clientLogger().logInfo(new StringBuilder(46).append("Initialize: Finished. Server: ").append(serverInfo).append(", Capabilities: ").append(capabilities).toString());
            return new InitializeResult(capabilities, serverInfo);
        });
    }

    private ProjectKind createProjectKind(DefaultProjectMetadata projectMetadata, ClientLoggerFactory clientLoggerFactory) {
        WorkspaceEditService workspaceEditsService = this.workspaceServiceManager.workspaceEditService();
        ProjectKind projectKind = this.projectKindFactory.createKind(new ProjectKindContext(projectMetadata, clientLoggerFactory, this.protocolService.getClient(), this.jobManagerService, workspaceEditsService));
        projectKind.initialize();
        projectMetadata.setEventBus(projectKind.eventBus());
        return projectKind;
    }

    public void initialized(InitializedParams params) {
        this.jobManagerService.schedule(x$2 -> this.projectKindsByWorkspaceFolderUri().foreach((Function1 & Serializable & scala.Serializable)entry -> {
            this.initializedProjectKind((ProjectKind)entry._2());
            return BoxedUnit.UNIT;
        }), "Starting DataWeave Language Server", "Starting DataWeave Language Server.");
    }

    private void initializedProjectKind(ProjectKind projectKind) {
        try {
            this.clientLogger().logInfo(new StringBuilder(19).append("Project: ").append(projectKind.project().getName()).append(" Starting.").toString());
            projectKind.initialized();
            this.clientLogger().logInfo("ProjectStartedEvent fired");
        }
        catch (Exception e) {
            this.clientLogger().logInfo("Unable to Start project.", e);
        }
    }

    public CompletableFuture<Object> shutdown() {
        return CompletableFuture.supplyAsync(() -> {
            this.clientLogger().logInfo("Stopping the services");
            this.projectKindsByWorkspaceFolderUri().foreach((Function1 & Serializable & scala.Serializable)entry -> {
                WeaveLanguageServer.$anonfun$shutdown$2(this, entry);
                return BoxedUnit.UNIT;
            });
            return null;
        });
    }

    public void exit() {
        System.exit(0);
    }

    @JsonDelegate
    public WeaveTextDocumentService getTextDocumentService() {
        return this.textDocumentService();
    }

    public WorkspaceService getWorkspaceService() {
        return this.workspaceServiceManager.workspaceService();
    }

    public void connect(LanguageClient client) {
        this.languageClient().delegate_$eq(client);
        this.workspaceServiceManager.onLanguageClientConnected(this.languageClient());
    }

    public ExecutorService executor() {
        return IDEExecutors$.MODULE$.defaultExecutor();
    }

    @Override
    public void didChangeConfiguration(DidChangeConfigurationParams params) {
        this.settings().update(params.getSettings());
    }

    @Override
    public void didChangeWorkspaceFolders(DidChangeWorkspaceFoldersParams params) {
        params.getEvent().getRemoved().forEach(removedWorkspaceFolder -> {
            Option<ProjectKind> option = $this.workspaceServiceManager.onProjectKindRemoved(removedWorkspaceFolder.getUri());
            if (option instanceof Some) {
                Some some = (Some)option;
                ProjectKind projectKind = (ProjectKind)some.value();
                this.textDocumentServiceImpl().onProjectRemoved(projectKind);
                projectKind.shutdown();
                return;
            }
            if (None$.MODULE$.equals(option)) {
                this.logger().warning(new StringBuilder(44).append("There is no projectKind registered for URI: ").append(removedWorkspaceFolder.getUri()).toString());
                return;
            }
            throw new MatchError(option);
        });
        params.getEvent().getAdded().forEach(addedWorkspaceFolder -> {
            try {
                ProjectKind projectKind = this.discoverAndRegisterProjectKind((WorkspaceFolder)addedWorkspaceFolder);
                this.initializedProjectKind(projectKind);
            }
            catch (Exception e) {
                this.clientLogger().logInfo(new StringBuilder(52).append("Unable to discover projectKind for workspaceFolder: ").append(addedWorkspaceFolder.getUri()).toString(), e);
            }
        });
    }

    private DataWeaveDocumentService createLanguageServerDocumentService() {
        DefaultProjectMetadata projectMetadata = new DefaultProjectMetadata((Option<String>)Option$.MODULE$.empty(), this.settings());
        ProjectKind projectKind = this.createProjectKind(projectMetadata, this.clientLoggerFactory());
        DataWeaveDocumentService languageServerDataWeaveDocumentService = new DataWeaveDocumentService(projectKind, this.executor());
        String uri = URLUtils$.MODULE$.toLSPUrl(projectMetadata.home());
        this.workspaceServiceManager.standaloneContribution(uri, projectKind, new DefaultBaseWorkspaceServiceContributor(projectKind, projectMetadata, this.protocolService.getClient(), this.workspaceServiceManager.commandManagerService(), DefaultBaseWorkspaceServiceContributor$.MODULE$.$lessinit$greater$default$5()));
        this.projectKindsByWorkspaceFolderUri().putIfAbsent((Object)uri, (Object)projectKind);
        projectKind.initialize();
        projectMetadata.setEventBus(projectKind.eventBus());
        ClassLoader currentContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(WeaveLanguageServer.class.getClassLoader());
            this.initializedProjectKind(projectKind);
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentContextClassLoader);
        }
        return languageServerDataWeaveDocumentService;
    }

    private ProjectKind discoverAndRegisterProjectKind(WorkspaceFolder addedWorkspaceFolder) {
        DefaultProjectMetadata projectMetadata = new DefaultProjectMetadata((Option<String>)Option$.MODULE$.apply((Object)addedWorkspaceFolder.getUri()), this.settings());
        ProjectKind projectKind = this.createProjectKind(projectMetadata, this.clientLoggerFactory());
        this.textDocumentServiceImpl().onProjectKindCreated(projectKind, new DataWeaveDocumentService(projectKind, this.executor()));
        this.workspaceServiceManager.onProjectKindCreated(addedWorkspaceFolder.getUri(), projectKind, new DefaultBaseWorkspaceServiceContributor(projectKind, projectMetadata, this.protocolService.getClient(), this.workspaceServiceManager.commandManagerService(), DefaultBaseWorkspaceServiceContributor$.MODULE$.$lessinit$greater$default$5()));
        this.projectKindsByWorkspaceFolderUri().putIfAbsent((Object)addedWorkspaceFolder.getUri(), (Object)projectKind);
        return projectKind;
    }

    public static final /* synthetic */ void $anonfun$shutdown$2(WeaveLanguageServer $this, Tuple2 entry) {
        $this.workspaceServiceManager.onProjectKindRemoved((String)entry._1());
        $this.textDocumentServiceImpl().onProjectRemoved((ProjectKind)entry._2());
        ((ProjectKind)entry._2()).shutdown();
    }

    public WeaveLanguageServer(ProjectKindFactory projectKindFactory, DataWeaveProtocolService protocolService, WorkspaceServiceManager workspaceServiceManager, JobManagerService jobManagerService) {
        this.projectKindFactory = projectKindFactory;
        this.protocolService = protocolService;
        this.workspaceServiceManager = workspaceServiceManager;
        this.jobManagerService = jobManagerService;
        WorkspaceServiceListener.$init$(this);
        this.logger = Logger.getLogger(this.getClass().getName());
        this.textDocumentService = new TextDocumentServiceDelegate();
        Function1 & Serializable & scala.Serializable x$12 = (Function1 & Serializable & scala.Serializable)x$1 -> this.languageServerDocumentService();
        boolean x$2 = DataWeaveDocumentServiceDispatcher$.MODULE$.$lessinit$greater$default$1();
        Option<WeaveLanguageServerBuilder.TextDocumentTranslator> x$3 = DataWeaveDocumentServiceDispatcher$.MODULE$.$lessinit$greater$default$2();
        this.textDocumentServiceImpl = new DataWeaveDocumentServiceDispatcher(x$2, x$3, (Function1<String, DataWeaveDocumentService>)x$12);
        this.projectKindsByWorkspaceFolderUri = (TrieMap)TrieMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.languageClient = new LanguageClientDelegate();
        this.settings = new ProjectSettings(ProjectSettings$.MODULE$.apply$default$1(), ProjectSettings$.MODULE$.apply$default$2(), ProjectSettings$.MODULE$.apply$default$3(), ProjectSettings$.MODULE$.apply$default$4(), ProjectSettings$.MODULE$.apply$default$5(), ProjectSettings$.MODULE$.apply$default$6(), ProjectSettings$.MODULE$.apply$default$7(), ProjectSettings$.MODULE$.apply$default$8(), ProjectSettings$.MODULE$.apply$default$9(), ProjectSettings$.MODULE$.apply$default$10(), ProjectSettings$.MODULE$.apply$default$11());
        this.ID = "DATA_WEAVE_LSP";
    }
}

