/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.lsp.services;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.CodeLensParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.DefinitionParams;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.lsp4j.DocumentFormattingParams;
import org.eclipse.lsp4j.DocumentRangeFormattingParams;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.DocumentSymbolParams;
import org.eclipse.lsp4j.FoldingRange;
import org.eclipse.lsp4j.FoldingRangeRequestParams;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.HoverParams;
import org.eclipse.lsp4j.InsertTextFormat;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.LocationLink;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.ParameterInformation;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ReferenceParams;
import org.eclipse.lsp4j.RenameParams;
import org.eclipse.lsp4j.SignatureHelp;
import org.eclipse.lsp4j.SignatureHelpParams;
import org.eclipse.lsp4j.SignatureInformation;
import org.eclipse.lsp4j.SymbolKind;
import org.eclipse.lsp4j.TextDocumentContentChangeEvent;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextDocumentItem;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.ResponseErrorException;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseError;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseErrorCode;
import org.mule.weave.extension.api.WeaveLanguageServerBuilder;
import org.mule.weave.extension.api.filesystem.VirtualFile;
import org.mule.weave.lsp.actions.CodeActionsManagerService;
import org.mule.weave.lsp.commands.Commands$;
import org.mule.weave.lsp.commands.CreateUnitTest$;
import org.mule.weave.lsp.commands.InsertDocumentationCommand$;
import org.mule.weave.lsp.commands.LSPWeaveTextDocument;
import org.mule.weave.lsp.extension.protocol.LaunchConfiguration$;
import org.mule.weave.lsp.extension.protocol.SampleInput;
import org.mule.weave.lsp.extension.services.DidFocusChangeParams;
import org.mule.weave.lsp.extension.services.WeaveTextDocumentService;
import org.mule.weave.lsp.i18n.UserMessages$;
import org.mule.weave.lsp.project.ProjectKind;
import org.mule.weave.lsp.project.components.ProjectStructureHelper$;
import org.mule.weave.lsp.project.components.Scenario;
import org.mule.weave.lsp.project.components.Scenario$;
import org.mule.weave.lsp.services.DataWeaveToolingService;
import org.mule.weave.lsp.services.TextDocumentTranslatorService;
import org.mule.weave.lsp.services.WeaveScenarioManagerService;
import org.mule.weave.lsp.services.events.DocumentChangedEvent;
import org.mule.weave.lsp.services.events.DocumentClosedEvent;
import org.mule.weave.lsp.services.events.DocumentFocusChangedEvent;
import org.mule.weave.lsp.services.events.DocumentOpenedEvent;
import org.mule.weave.lsp.services.events.DocumentSavedEvent;
import org.mule.weave.lsp.utils.LSPConverters$;
import org.mule.weave.lsp.utils.URLUtils$;
import org.mule.weave.lsp.utils.WeaveASTQueryUtils$;
import org.mule.weave.lsp.vfs.ProjectFileSystemService;
import org.mule.weave.lsp.vfs.VirtualFileAdapter$;
import org.mule.weave.v2.completion.Suggestion;
import org.mule.weave.v2.completion.SuggestionResult;
import org.mule.weave.v2.completion.SuggestionType$;
import org.mule.weave.v2.editor.AstNodeResult;
import org.mule.weave.v2.editor.Link;
import org.mule.weave.v2.editor.RegionKind$;
import org.mule.weave.v2.editor.SymbolInformation;
import org.mule.weave.v2.editor.SymbolKind$;
import org.mule.weave.v2.editor.VirtualFileSystem;
import org.mule.weave.v2.editor.WeaveDocumentToolingService;
import org.mule.weave.v2.editor.WeaveTextDocument;
import org.mule.weave.v2.formatting.FormattingOptions;
import org.mule.weave.v2.parser.ast.AstNode;
import org.mule.weave.v2.parser.ast.AstNodeHelper$;
import org.mule.weave.v2.parser.ast.functions.OverloadedFunctionNode;
import org.mule.weave.v2.parser.ast.header.directives.FunctionDirectiveNode;
import org.mule.weave.v2.parser.ast.header.directives.InputDirective;
import org.mule.weave.v2.parser.ast.module.ModuleNode;
import org.mule.weave.v2.parser.ast.structure.DocumentNode;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier$;
import org.mule.weave.v2.scope.Reference;
import org.mule.weave.v2.sdk.WeaveResourceResolver;
import org.mule.weave.v2.signature.FunctionSignatureResult;
import org.mule.weave.v2.utils.WeaveTypeEmitterConfig;
import org.mule.weave.v2.utils.WeaveTypeEmitterConfig$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

@ScalaSignature(bytes="\u0006\u0001\u0011}b\u0001B\u00193\u0001uB\u0001\"\u0014\u0001\u0003\u0002\u0003\u0006IA\u0014\u0005\t)\u0002\u0011\t\u0011)A\u0005+\")Q\f\u0001C\u0001=\"91\r\u0001b\u0001\n\u0013!\u0007BB6\u0001A\u0003%Q\rC\u0004m\u0001\t\u0007I\u0011B7\t\rE\u0004\u0001\u0015!\u0003o\u0011\u001d\u0011\bA1A\u0005\nMDaA\u001f\u0001!\u0002\u0013!\bbB>\u0001\u0005\u0004%I\u0001 \u0005\b\u0003\u0003\u0001\u0001\u0015!\u0003~\u0011!9\bA1A\u0005\n\u0005\r\u0001\u0002CA\u000b\u0001\u0001\u0006I!!\u0002\t\u0013\u0005]\u0001A1A\u0005\n\u0005e\u0001\u0002CA\u0014\u0001\u0001\u0006I!a\u0007\t\u0013\u0005%\u0002A1A\u0005\n\u0005-\u0002\u0002CA.\u0001\u0001\u0006I!!\f\t\u000f\u0005u\u0003\u0001\"\u0011\u0002`!9\u0011\u0011\u0011\u0001\u0005B\u0005\r\u0005bBAH\u0001\u0011\u0005\u0013\u0011\u0013\u0005\b\u00037\u0003A\u0011IAO\u0011\u001d\t9\u000b\u0001C!\u0003SCq!a-\u0001\t\u0003\n)\fC\u0004\u0002l\u0002!I!!<\t\u000f\u0005m\b\u0001\"\u0011\u0002~\"9!q\u0002\u0001\u0005\n\tE\u0001b\u0002B%\u0001\u0011%!1\n\u0005\b\u0005[\u0002A\u0011\tB8\u0011\u001d\u0011y\t\u0001C\u0005\u0005#CqA!4\u0001\t\u0013\u0011y\rC\u0004\u0003X\u0002!IA!7\t\u000f\tu\u0007\u0001\"\u0003\u0003`\"9!\u0011\u001e\u0001\u0005\n\t-\bb\u0002By\u0001\u0011%!1\u001f\u0005\b\u0005s\u0004A\u0011\tB~\u0011\u001d\u0019\u0019\u0001\u0001C!\u0007\u000bAqa!\u0007\u0001\t\u0003\u001aY\u0002C\u0004\u00048\u0001!\te!\u000f\t\u000f\r}\u0002\u0001\"\u0011\u0004B!911\u000b\u0001\u0005\u0002\rU\u0003bBB4\u0001\u0011\u00053\u0011\u000e\u0005\b\u0007\u000b\u0003A\u0011IBD\u0011\u001d\u0019I\f\u0001C\u0005\u0007wCqaa1\u0001\t\u0003\u001a)\rC\u0004\u0004d\u0002!\te!:\t\u000f\rm\b\u0001\"\u0011\u0004~\"9Aq\u0002\u0001\u0005B\u0011E\u0001b\u0002C\u0014\u0001\u0011%A\u0011\u0006\u0002\u0019\t\u0006$\u0018mV3bm\u0016$unY;nK:$8+\u001a:wS\u000e,'BA\u001a5\u0003!\u0019XM\u001d<jG\u0016\u001c(BA\u001b7\u0003\ra7\u000f\u001d\u0006\u0003oa\nQa^3bm\u0016T!!\u000f\u001e\u0002\t5,H.\u001a\u0006\u0002w\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\u0010$\u0011\u0005}\"U\"\u0001!\u000b\u0005\u0005\u0013\u0015\u0001\u00027b]\u001eT\u0011aQ\u0001\u0005U\u00064\u0018-\u0003\u0002F\u0001\n1qJ\u00196fGR\u0004\"aR&\u000e\u0003!S!aM%\u000b\u0005)#\u0014!C3yi\u0016t7/[8o\u0013\ta\u0005J\u0001\rXK\u00064X\rV3yi\u0012{7-^7f]R\u001cVM\u001d<jG\u0016\f1\u0002\u001d:pU\u0016\u001cGoS5oIB\u0011qJU\u0007\u0002!*\u0011\u0011\u000bN\u0001\baJ|'.Z2u\u0013\t\u0019\u0006KA\u0006Qe>TWm\u0019;LS:$\u0017\u0001C3yK\u000e,Ho\u001c:\u0011\u0005Y[V\"A,\u000b\u0005aK\u0016AC2p]\u000e,(O]3oi*\u0011!LQ\u0001\u0005kRLG.\u0003\u0002]/\nAQ\t_3dkR|'/\u0001\u0004=S:LGO\u0010\u000b\u0004?\u0006\u0014\u0007C\u00011\u0001\u001b\u0005\u0011\u0004\"B'\u0004\u0001\u0004q\u0005\"\u0002+\u0004\u0001\u0004)\u0016A\u00027pO\u001e,'/F\u0001f!\t1\u0017.D\u0001h\u0015\tA\u0017,A\u0004m_\u001e<\u0017N\\4\n\u0005)<'A\u0002'pO\u001e,'/A\u0004m_\u001e<WM\u001d\u0011\u0002\u001fQ|w\u000e\\5oON+'O^5dKN,\u0012A\u001c\t\u0003A>L!\u0001\u001d\u001a\u0003/\u0011\u000bG/Y,fCZ,Gk\\8mS:<7+\u001a:wS\u000e,\u0017\u0001\u0005;p_2LgnZ*feZL7-Z:!\u0003%\u0001(o\u001c6fGR45+F\u0001u!\t)\b0D\u0001w\u0015\t9H'A\u0002wMNL!!\u001f<\u00031A\u0013xN[3di\u001aKG.Z*zgR,WnU3sm&\u001cW-\u0001\u0006qe>TWm\u0019;G'\u0002\n\u0001c]2f]\u0006\u0014\u0018n\\:TKJ4\u0018nY3\u0016\u0003u\u0004\"\u0001\u0019@\n\u0005}\u0014$aG,fCZ,7kY3oCJLw.T1oC\u001e,'oU3sm&\u001cW-A\ttG\u0016t\u0017M]5pgN+'O^5dK\u0002*\"!!\u0002\u0011\t\u0005\u001d\u0011\u0011C\u0007\u0003\u0003\u0013QA!a\u0003\u0002\u000e\u00051Q\rZ5u_JT1!a\u00047\u0003\t1('\u0003\u0003\u0002\u0014\u0005%!!\u0005,jeR,\u0018\r\u001c$jY\u0016\u001c\u0016p\u001d;f[\u0006!aOZ:!\u0003e\u0019w\u000eZ3BGRLwN\\:NC:\fw-\u001a:TKJ4\u0018nY3\u0016\u0005\u0005m\u0001\u0003BA\u000f\u0003Gi!!a\b\u000b\u0007\u0005\u0005B'A\u0004bGRLwN\\:\n\t\u0005\u0015\u0012q\u0004\u0002\u001a\u0007>$W-Q2uS>t7/T1oC\u001e,'oU3sm&\u001cW-\u0001\u000ed_\u0012,\u0017i\u0019;j_:\u001cX*\u00198bO\u0016\u00148+\u001a:wS\u000e,\u0007%\u0001\fuKb$Hi\\2v[\u0016tG\u000f\u0016:b]Nd\u0017\r^8s+\t\ti\u0003\u0005\u0003\u00020\u0005Uc\u0002BA\u0019\u0003\u001frA!a\r\u0002J9!\u0011QGA$\u001d\u0011\t9$!\u0012\u000f\t\u0005e\u00121\t\b\u0005\u0003w\t\t%\u0004\u0002\u0002>)\u0019\u0011q\b\u001f\u0002\rq\u0012xn\u001c;?\u0013\u0005Y\u0014BA\u001d;\u0013\t9\u0004(\u0003\u0002Km%!\u00111JA'\u0003\r\t\u0007/\u001b\u0006\u0003\u0015ZJA!!\u0015\u0002T\u0005Qr+Z1wK2\u000bgnZ;bO\u0016\u001cVM\u001d<fe\n+\u0018\u000e\u001c3fe*!\u00111JA'\u0013\u0011\t9&!\u0017\u0003-Q+\u0007\u0010\u001e#pGVlWM\u001c;Ue\u0006t7\u000f\\1u_JTA!!\u0015\u0002T\u00059B/\u001a=u\t>\u001cW/\\3oiR\u0013\u0018M\\:mCR|'\u000fI\u0001\bI&$w\n]3o)\u0011\t\t'!\u001c\u0011\t\u0005\r\u0014\u0011N\u0007\u0003\u0003KR!!a\u001a\u0002\u000bM\u001c\u0017\r\\1\n\t\u0005-\u0014Q\r\u0002\u0005+:LG\u000fC\u0004\u0002pI\u0001\r!!\u001d\u0002\u0013=\u0004XM\u001c)be\u0006l\u0007\u0003BA:\u0003{j!!!\u001e\u000b\t\u0005]\u0014\u0011P\u0001\u0006YN\u0004HG\u001b\u0006\u0004\u0003wR\u0014aB3dY&\u00048/Z\u0005\u0005\u0003\u007f\n)HA\rES\u0012|\u0005/\u001a8UKb$Hi\\2v[\u0016tG\u000fU1sC6\u001c\u0018!\u00033jI\u000eC\u0017M\\4f)\u0011\t\t'!\"\t\u000f\u0005\u001d5\u00031\u0001\u0002\n\u00061\u0001/\u0019:b[N\u0004B!a\u001d\u0002\f&!\u0011QRA;\u0005m!\u0015\u000eZ\"iC:<W\rV3yi\u0012{7-^7f]R\u0004\u0016M]1ng\u0006AA-\u001b3DY>\u001cX\r\u0006\u0003\u0002b\u0005M\u0005bBAD)\u0001\u0007\u0011Q\u0013\t\u0005\u0003g\n9*\u0003\u0003\u0002\u001a\u0006U$A\u0007#jI\u000ecwn]3UKb$Hi\\2v[\u0016tG\u000fU1sC6\u001c\u0018a\u00023jIN\u000bg/\u001a\u000b\u0005\u0003C\ny\nC\u0004\u0002\bV\u0001\r!!)\u0011\t\u0005M\u00141U\u0005\u0005\u0003K\u000b)HA\rES\u0012\u001c\u0016M^3UKb$Hi\\2v[\u0016tG\u000fU1sC6\u001c\u0018A\u00043jI\u001a{7-^:DQ\u0006tw-\u001a\u000b\u0005\u0003C\nY\u000bC\u0004\u0002\bZ\u0001\r!!,\u0011\u0007\u001d\u000by+C\u0002\u00022\"\u0013A\u0003R5e\r>\u001cWo]\"iC:<W\rU1sC6\u001c\u0018AC2p[BdW\r^5p]R!\u0011qWAq!\u00151\u0016\u0011XA_\u0013\r\tYl\u0016\u0002\u0012\u0007>l\u0007\u000f\\3uC\ndWMR;ukJ,\u0007\u0003CA`\u0003\u0013\fi-a7\u000e\u0005\u0005\u0005'\u0002BAb\u0003\u000b\f\u0001\"\\3tg\u0006<Wm\u001d\u0006\u0005\u0003\u000f\f)(A\u0004kg>t'\u000f]2\n\t\u0005-\u0017\u0011\u0019\u0002\u0007\u000b&$\b.\u001a:\u0011\r\u0005=\u0017\u0011[Ak\u001b\u0005I\u0016bAAj3\n!A*[:u!\u0011\t\u0019(a6\n\t\u0005e\u0017Q\u000f\u0002\u000f\u0007>l\u0007\u000f\\3uS>t\u0017\n^3n!\u0011\t\u0019(!8\n\t\u0005}\u0017Q\u000f\u0002\u000f\u0007>l\u0007\u000f\\3uS>tG*[:u\u0011\u001d\t\u0019o\u0006a\u0001\u0003K\f\u0001\u0002]8tSRLwN\u001c\t\u0005\u0003g\n9/\u0003\u0003\u0002j\u0006U$\u0001E\"p[BdW\r^5p]B\u000b'/Y7t\u0003\u0015:W\r^*vO\u001e,7\u000f^5p]N\fe\u000eZ\"sK\u0006$XmQ8na2,G/[8o\u0019&\u001cH\u000f\u0006\u0004\u0002>\u0006=\u0018\u0011 \u0005\b\u0003cD\u0002\u0019AAz\u00039!xn\u001c7j]\u001e\u001cVM\u001d<jG\u0016\u0004B!a\u0002\u0002v&!\u0011q_A\u0005\u0005m9V-\u0019<f\t>\u001cW/\\3oiR{w\u000e\\5oON+'O^5dK\"9\u00111\u001d\rA\u0002\u0005\u0015\u0018!D:jO:\fG/\u001e:f\u0011\u0016d\u0007\u000f\u0006\u0003\u0002\u0000\n\u001d\u0001#\u0002,\u0002:\n\u0005\u0001\u0003BA:\u0005\u0007IAA!\u0002\u0002v\ti1+[4oCR,(/\u001a%fYBDq!a\"\u001a\u0001\u0004\u0011I\u0001\u0005\u0003\u0002t\t-\u0011\u0002\u0002B\u0007\u0003k\u00121cU5h]\u0006$XO]3IK2\u0004\b+\u0019:b[N\f!cZ3u\u0013:\u0004X\u000f\u001e#je\u0016\u001cG/\u001b<fgR!!1\u0003B\u001c!\u0019\u0011)Ba\u0007\u0003 5\u0011!q\u0003\u0006\u0005\u00053\t)'\u0001\u0006d_2dWm\u0019;j_:LAA!\b\u0003\u0018\t\u00191+Z9\u0011\t\t\u0005\"1G\u0007\u0003\u0005GQAA!\n\u0003(\u0005QA-\u001b:fGRLg/Z:\u000b\t\t%\"1F\u0001\u0007Q\u0016\fG-\u001a:\u000b\t\t5\"qF\u0001\u0004CN$(\u0002\u0002B\u0019\u0003\u001b\ta\u0001]1sg\u0016\u0014\u0018\u0002\u0002B\u001b\u0005G\u0011a\"\u00138qkR$\u0015N]3di&4X\rC\u0004\u0003:i\u0001\rAa\u000f\u0002\u00195\f\u0017PY3BgRtu\u000eZ3\u0011\r\u0005\r$Q\bB!\u0013\u0011\u0011y$!\u001a\u0003\r=\u0003H/[8o!\u0011\u0011\u0019E!\u0012\u000e\u0005\t-\u0012\u0002\u0002B$\u0005W\u0011q!Q:u\u001d>$W-A\u000bde\u0016\fG/Z'baBLgn\u001a+fgRdUM\\:\u0015\t\t5#\u0011\f\t\u0007\u0003\u001f\u0014yEa\u0015\n\u0007\tE\u0013LA\u0005BeJ\f\u0017\u0010T5tiB!\u00111\u000fB+\u0013\u0011\u00119&!\u001e\u0003\u0011\r{G-\u001a'f]NDqAa\u0017\u001c\u0001\u0004\u0011i&A\u0002ve2\u0004BAa\u0018\u0003h9!!\u0011\rB2!\u0011\tY$!\u001a\n\t\t\u0015\u0014QM\u0001\u0007!J,G-\u001a4\n\t\t%$1\u000e\u0002\u0007'R\u0014\u0018N\\4\u000b\t\t\u0015\u0014QM\u0001\tG>$W\rT3ogR!!\u0011\u000fBD!\u00151\u0016\u0011\u0018B:a\u0011\u0011)Ha\u001f\u0011\r\u0005=\u0017\u0011\u001bB<!\u0011\u0011IHa\u001f\r\u0001\u0011Y!Q\u0010\u000f\u0002\u0002\u0003\u0005)\u0011\u0001B@\u0005\ryF%M\t\u0005\u0005\u0003\u0013\u0019\u0006\u0005\u0003\u0002d\t\r\u0015\u0002\u0002BC\u0003K\u0012qAT8uQ&tw\rC\u0004\u0002\br\u0001\rA!#\u0011\t\u0005M$1R\u0005\u0005\u0005\u001b\u000b)H\u0001\bD_\u0012,G*\u001a8t!\u0006\u0014\u0018-\\:\u0002!M\fW\u000e\u001d7f\t\u0006$\u0018\rT3og\u0016\u001cHC\u0003B'\u0005'\u0013)K!.\u0003J\"9!QS\u000fA\u0002\t]\u0015!D7bs\n,7kY3oCJLw\u000e\u0005\u0004\u0002d\tu\"\u0011\u0014\t\u0005\u00057\u0013\t+\u0004\u0002\u0003\u001e*\u0019!q\u0014)\u0002\u0015\r|W\u000e]8oK:$8/\u0003\u0003\u0003$\nu%\u0001C*dK:\f'/[8\t\u000f\t\u001dV\u00041\u0001\u0003*\u0006qa.Y7f\u0013\u0012,g\u000e^5gS\u0016\u0014\b\u0003\u0002BV\u0005ck!A!,\u000b\t\t=&1F\u0001\nm\u0006\u0014\u0018.\u00192mKNLAAa-\u0003.\nqa*Y7f\u0013\u0012,g\u000e^5gS\u0016\u0014\bb\u0002B\\;\u0001\u0007!\u0011X\u0001\u0010S:\u0004X\u000f\u001e#je\u0016\u001cG/\u001b<fgB1!1\u0018Bc\u0005?qAA!0\u0003B:!\u00111\bB`\u0013\t\t9'\u0003\u0003\u0003D\u0006\u0015\u0014a\u00029bG.\fw-Z\u0005\u0005\u0005;\u00119M\u0003\u0003\u0003D\u0006\u0015\u0004b\u0002Bf;\u0001\u0007!QL\u0001\u0004kJL\u0017!\u00043pGN#\u0018M\u001d;SC:<W\r\u0006\u0002\u0003RB!\u00111\u000fBj\u0013\u0011\u0011).!\u001e\u0003\u000bI\u000bgnZ3\u0002\u001dI,h.T1qa&tw\rT3ogR!!1\u000bBn\u0011\u001d\u00119k\ba\u0001\u0005S\u000bQ\"\u001b8qkR4\u0015\u000e\\3OC6,G\u0003\u0002Bq\u0005K\u00042a\u0010Br\u0013\r\u0011I\u0007\u0011\u0005\b\u0005O\u0004\u0003\u0019\u0001B\u0010\u0003\tIG-\u0001\fbI\u0012$unY;nK:$\u0018\r^5p]2+gn]3t)\u0019\u0011iE!<\u0003p\"9!QF\u0011A\u0002\t\u0005\u0003b\u0002BfC\u0001\u0007!QL\u0001\u0012C\u0012$WK\\5u)\u0016\u001cH\u000fT3og\u0016\u001cHC\u0002B'\u0005k\u00149\u0010C\u0004\u0003.\t\u0002\rA!\u0011\t\u000f\t-'\u00051\u0001\u0003^\u0005y!/Z:pYZ,7i\u001c3f\u0019\u0016t7\u000f\u0006\u0003\u0003~\n}\b#\u0002,\u0002:\nM\u0003bBB\u0001G\u0001\u0007!1K\u0001\u000bk:\u0014Xm]8mm\u0016$\u0017\u0001\u00044pY\u0012Lgn\u001a*b]\u001e,G\u0003BB\u0004\u0007#\u0001RAVA]\u0007\u0013\u0001b!a4\u0002R\u000e-\u0001\u0003BA:\u0007\u001bIAaa\u0004\u0002v\taai\u001c7eS:<'+\u00198hK\"9\u0011q\u0011\u0013A\u0002\rM\u0001\u0003BA:\u0007+IAaa\u0006\u0002v\tIbi\u001c7eS:<'+\u00198hKJ+\u0017/^3tiB\u000b'/Y7t\u0003)\u0019w\u000eZ3BGRLwN\u001c\u000b\u0005\u0007;\u0019y\u0003E\u0003W\u0003s\u001by\u0002\u0005\u0004\u0002P\u0006E7\u0011\u0005\t\t\u0003\u007f\u000bIma\t\u0004*A!\u00111OB\u0013\u0013\u0011\u00199#!\u001e\u0003\u000f\r{W.\\1oIB!\u00111OB\u0016\u0013\u0011\u0019i#!\u001e\u0003\u0015\r{G-Z!di&|g\u000eC\u0004\u0002\b\u0016\u0002\ra!\r\u0011\t\u0005M41G\u0005\u0005\u0007k\t)H\u0001\tD_\u0012,\u0017i\u0019;j_:\u0004\u0016M]1ng\u0006)\"/Z:pYZ,7i\\7qY\u0016$\u0018n\u001c8Ji\u0016lG\u0003BB\u001e\u0007{\u0001RAVA]\u0003+Dqa!\u0001'\u0001\u0004\t).A\u0003i_Z,'\u000f\u0006\u0003\u0004D\r-\u0003#\u0002,\u0002:\u000e\u0015\u0003\u0003BA:\u0007\u000fJAa!\u0013\u0002v\t)\u0001j\u001c<fe\"9\u0011qQ\u0014A\u0002\r5\u0003\u0003BA:\u0007\u001fJAa!\u0015\u0002v\tY\u0001j\u001c<feB\u000b'/Y7t\u00031!xnU=nE>d7*\u001b8e)\u0011\u00199f!\u0018\u0011\t\u0005M4\u0011L\u0005\u0005\u00077\n)H\u0001\u0006Ts6\u0014w\u000e\\&j]\u0012Dqaa\u0018)\u0001\u0004\u0019\t'\u0001\u0003lS:$\u0007\u0003BA2\u0007GJAa!\u001a\u0002f\t\u0019\u0011J\u001c;\u0002\u001d\u0011|7-^7f]R\u001c\u00160\u001c2pYR!11NB?!\u00151\u0016\u0011XB7!\u0019\ty-!5\u0004pAA\u0011qXAe\u0007c\u001a9\b\u0005\u0003\u0002t\rM\u0014\u0002BB;\u0003k\u0012\u0011cU=nE>d\u0017J\u001c4pe6\fG/[8o!\u0011\t\u0019h!\u001f\n\t\rm\u0014Q\u000f\u0002\u000f\t>\u001cW/\\3oiNKXNY8m\u0011\u001d\t9)\u000ba\u0001\u0007\u007f\u0002B!a\u001d\u0004\u0002&!11QA;\u0005Q!unY;nK:$8+_7c_2\u0004\u0016M]1ng\u0006QA-\u001a4j]&$\u0018n\u001c8\u0015\t\r%5\u0011\u0017\t\u0006-\u0006e61\u0012\t\t\u0003\u007f\u000bIm!$\u0004 B\"1qRBJ!\u0019\ty-!5\u0004\u0012B!!\u0011PBJ\t-\u0019)JKA\u0001\u0002\u0003\u0015\taa&\u0003\u0007}##'\u0005\u0003\u0003\u0002\u000ee\u0005\u0003BA:\u00077KAa!(\u0002v\tAAj\\2bi&|g\u000e\r\u0003\u0004\"\u000e\u0015\u0006CBAh\u0003#\u001c\u0019\u000b\u0005\u0003\u0003z\r\u0015FaCBTU\u0005\u0005\t\u0011!B\u0001\u0007S\u00131a\u0018\u00134#\u0011\u0011\tia+\u0011\t\u0005M4QV\u0005\u0005\u0007_\u000b)H\u0001\u0007M_\u000e\fG/[8o\u0019&t7\u000eC\u0004\u0002\b*\u0002\raa-\u0011\t\u0005M4QW\u0005\u0005\u0007o\u000b)H\u0001\tEK\u001aLg.\u001b;j_:\u0004\u0016M]1ng\u0006Q!/Z:pYZ,WK\u001d7\u0015\t\ru6q\u0018\t\u0007\u0003G\u0012iD!\u0018\t\u000f\r\u00057\u00061\u0001\u0003*\u0006QQn\u001c3vY\u0016t\u0015-\\3\u0002\u0015\u0019|'/\\1ui&tw\r\u0006\u0003\u0004H\u000em\u0007#\u0002,\u0002:\u000e%\u0007\u0007BBf\u0007\u001f\u0004b!a4\u0002R\u000e5\u0007\u0003\u0002B=\u0007\u001f$1b!5-\u0003\u0003\u0005\tQ!\u0001\u0004T\n\u0019q\f\n\u001b\u0012\t\t\u00055Q\u001b\t\u0005\u0003g\u001a9.\u0003\u0003\u0004Z\u0006U$\u0001\u0003+fqR,E-\u001b;\t\u000f\u0005\u001dE\u00061\u0001\u0004^B!\u00111OBp\u0013\u0011\u0019\t/!\u001e\u00031\u0011{7-^7f]R4uN]7biRLgn\u001a)be\u0006l7/A\bsC:<WMR8s[\u0006$H/\u001b8h)\u0011\u00199oa=\u0011\u000bY\u000bIl!;1\t\r-8q\u001e\t\u0007\u0003\u001f\f\tn!<\u0011\t\te4q\u001e\u0003\f\u0007cl\u0013\u0011!A\u0001\u0006\u0003\u0019\u0019NA\u0002`IUBq!a\".\u0001\u0004\u0019)\u0010\u0005\u0003\u0002t\r]\u0018\u0002BB}\u0003k\u0012Q\u0004R8dk6,g\u000e\u001e*b]\u001e,gi\u001c:nCR$\u0018N\\4QCJ\fWn]\u0001\u0007e\u0016t\u0017-\\3\u0015\t\r}Hq\u0001\t\u0006-\u0006eF\u0011\u0001\t\u0005\u0003g\"\u0019!\u0003\u0003\u0005\u0006\u0005U$!D,pe.\u001c\b/Y2f\u000b\u0012LG\u000fC\u0004\u0002\b:\u0002\r\u0001\"\u0003\u0011\t\u0005MD1B\u0005\u0005\t\u001b\t)H\u0001\u0007SK:\fW.\u001a)be\u0006l7/\u0001\u0006sK\u001a,'/\u001a8dKN$B\u0001b\u0005\u0005 A)a+!/\u0005\u0016A\"Aq\u0003C\u000e!\u0019\ty-!5\u0005\u001aA!!\u0011\u0010C\u000e\t-!ibLA\u0001\u0002\u0003\u0015\taa&\u0003\u0007}#c\u0007C\u0004\u0002\b>\u0002\r\u0001\"\t\u0011\t\u0005MD1E\u0005\u0005\tK\t)HA\bSK\u001a,'/\u001a8dKB\u000b'/Y7t\u0003E9W\r^\"p[BdW\r^5p]RK\b/\u001a\u000b\u0005\tW!\t\u0004\u0005\u0003\u0002t\u00115\u0012\u0002\u0002C\u0018\u0003k\u0012!cQ8na2,G/[8o\u0013R,WnS5oI\"9A1\u0007\u0019A\u0002\u0011U\u0012aA:vOB!Aq\u0007C\u001e\u001b\t!ID\u0003\u0003\u00024\u00065\u0011\u0002\u0002C\u001f\ts\u0011!bU;hO\u0016\u001cH/[8o\u0001")
public class DataWeaveDocumentService
implements WeaveTextDocumentService {
    private final ProjectKind projectKind;
    private final Executor executor;
    private final Logger logger;
    private final DataWeaveToolingService toolingServices;
    private final ProjectFileSystemService projectFS;
    private final WeaveScenarioManagerService scenariosService;
    private final VirtualFileSystem vfs;
    private final CodeActionsManagerService codeActionsManagerService;
    private final WeaveLanguageServerBuilder.TextDocumentTranslator textDocumentTranslator;

    private Logger logger() {
        return this.logger;
    }

    private DataWeaveToolingService toolingServices() {
        return this.toolingServices;
    }

    private ProjectFileSystemService projectFS() {
        return this.projectFS;
    }

    private WeaveScenarioManagerService scenariosService() {
        return this.scenariosService;
    }

    private VirtualFileSystem vfs() {
        return this.vfs;
    }

    private CodeActionsManagerService codeActionsManagerService() {
        return this.codeActionsManagerService;
    }

    private WeaveLanguageServerBuilder.TextDocumentTranslator textDocumentTranslator() {
        return this.textDocumentTranslator;
    }

    public void didOpen(DidOpenTextDocumentParams openParam) {
        Option<org.mule.weave.v2.editor.VirtualFile> maybeVirtualFile;
        TextDocumentItem textDocument = openParam.getTextDocument();
        String uri = textDocument.getUri();
        this.logger().log(Level.INFO, new StringBuilder(9).append("DidOpen: ").append(uri).toString());
        Option<org.mule.weave.v2.editor.VirtualFile> option = maybeVirtualFile = this.projectFS().update(uri, openParam.getTextDocument().getText());
        if (option instanceof Some) {
            Some some = (Some)option;
            org.mule.weave.v2.editor.VirtualFile value = (org.mule.weave.v2.editor.VirtualFile)some.value();
            this.projectKind.eventBus().fire(new DocumentOpenedEvent(value));
            return;
        }
        if (None$.MODULE$.equals(option)) {
            org.mule.weave.v2.editor.VirtualFile virtualFile = this.vfs().file(uri);
            if (virtualFile != null) {
                this.projectKind.eventBus().fire(new DocumentOpenedEvent(virtualFile));
                return;
            }
            return;
        }
        throw new MatchError(option);
    }

    public void didChange(DidChangeTextDocumentParams params) {
        Option<org.mule.weave.v2.editor.VirtualFile> maybeVirtualFile;
        VersionedTextDocumentIdentifier textDocument = params.getTextDocument();
        String uri = textDocument.getUri();
        this.logger().log(Level.INFO, new StringBuilder(12).append(System.nanoTime()).append(" DidChange: ").append(uri).toString());
        Option<org.mule.weave.v2.editor.VirtualFile> option = maybeVirtualFile = this.projectFS().update(uri, ((TextDocumentContentChangeEvent)params.getContentChanges().get(0)).getText());
        if (option instanceof Some) {
            Some some = (Some)option;
            org.mule.weave.v2.editor.VirtualFile value = (org.mule.weave.v2.editor.VirtualFile)some.value();
            this.projectKind.eventBus().fire(new DocumentChangedEvent(value));
            return;
        }
        if (None$.MODULE$.equals(option)) {
            return;
        }
        throw new MatchError(option);
    }

    public void didClose(DidCloseTextDocumentParams params) {
        Option<org.mule.weave.v2.editor.VirtualFile> maybeVirtualFile;
        String uri = params.getTextDocument().getUri();
        this.logger().log(Level.INFO, new StringBuilder(10).append("DidClose: ").append(uri).toString());
        this.toolingServices().closeDocument(uri);
        Option<org.mule.weave.v2.editor.VirtualFile> option = maybeVirtualFile = this.projectFS().closed(uri);
        if (option instanceof Some) {
            Some some = (Some)option;
            org.mule.weave.v2.editor.VirtualFile value = (org.mule.weave.v2.editor.VirtualFile)some.value();
            this.projectKind.eventBus().fire(new DocumentClosedEvent(value));
            return;
        }
        if (None$.MODULE$.equals(option)) {
            org.mule.weave.v2.editor.VirtualFile virtualFile = this.vfs().file(uri);
            if (virtualFile != null) {
                this.projectKind.eventBus().fire(new DocumentClosedEvent(virtualFile));
                return;
            }
            return;
        }
        throw new MatchError(option);
    }

    public void didSave(DidSaveTextDocumentParams params) {
        Option<org.mule.weave.v2.editor.VirtualFile> maybeVirtualFile;
        String uri = params.getTextDocument().getUri();
        this.logger().log(Level.INFO, new StringBuilder(9).append("DidSave: ").append(uri).toString());
        Option<org.mule.weave.v2.editor.VirtualFile> option = maybeVirtualFile = this.projectFS().saved(params.getTextDocument().getUri());
        if (option instanceof Some) {
            Some some = (Some)option;
            org.mule.weave.v2.editor.VirtualFile value = (org.mule.weave.v2.editor.VirtualFile)some.value();
            this.projectKind.eventBus().fire(new DocumentSavedEvent(value));
            return;
        }
        if (None$.MODULE$.equals(option)) {
            org.mule.weave.v2.editor.VirtualFile virtualFile = this.vfs().file(uri);
            if (virtualFile != null) {
                this.projectKind.eventBus().fire(new DocumentSavedEvent(virtualFile));
                return;
            }
            return;
        }
        throw new MatchError(option);
    }

    @Override
    public void didFocusChange(DidFocusChangeParams params) {
        Option maybeVirtualFile;
        String uri = params.textDocumentIdentifier().getUri();
        this.logger().log(Level.INFO, new StringBuilder(16).append("DidFocusChange: ").append(uri).toString());
        Option option = maybeVirtualFile = Option$.MODULE$.apply((Object)this.projectFS().file(uri));
        if (option instanceof Some) {
            Some some = (Some)option;
            org.mule.weave.v2.editor.VirtualFile value = (org.mule.weave.v2.editor.VirtualFile)some.value();
            this.projectKind.eventBus().fire(new DocumentFocusChangedEvent(value));
            return;
        }
        if (None$.MODULE$.equals(option)) {
            org.mule.weave.v2.editor.VirtualFile virtualFile = this.vfs().file(uri);
            if (virtualFile != null) {
                this.projectKind.eventBus().fire(new DocumentFocusChangedEvent(virtualFile));
                return;
            }
            return;
        }
        throw new MatchError((Object)option);
    }

    public CompletableFuture<Either<java.util.List<CompletionItem>, CompletionList>> completion(CompletionParams position) {
        return CompletableFuture.supplyAsync(() -> {
            WeaveDocumentToolingService toolingService = this.toolingServices().openDocument(position.getTextDocument().getUri());
            return this.getSuggestionsAndCreateCompletionList(toolingService, position);
        }, this.executor);
    }

    private Either<java.util.List<CompletionItem>, CompletionList> getSuggestionsAndCreateCompletionList(WeaveDocumentToolingService toolingService, CompletionParams position) {
        int offset = toolingService.offsetOf(position.getPosition().getLine(), position.getPosition().getCharacter());
        SuggestionResult suggestionResult = toolingService.completion(offset);
        ArrayList result = new ArrayList();
        IntRef i = IntRef.create((int)0);
        Suggestion[] suggestions = suggestionResult.suggestions();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])suggestions)).foreach((Function1 & Serializable & scala.Serializable)sug -> {
            DataWeaveDocumentService.$anonfun$getSuggestionsAndCreateCompletionList$1(this, i, suggestionResult, toolingService, result, sug);
            return BoxedUnit.UNIT;
        });
        return Either.forRight((Object)new CompletionList(false, result));
    }

    public CompletableFuture<SignatureHelp> signatureHelp(SignatureHelpParams params) {
        return CompletableFuture.supplyAsync(() -> {
            Position position;
            int offset;
            WeaveDocumentToolingService toolingService = this.toolingServices().openDocument(params.getTextDocument().getUri());
            Option maybeResult = toolingService.signatureInfo(offset = toolingService.offsetOf((position = params.getPosition()).getLine(), position.getCharacter()));
            Option option = maybeResult;
            if (option instanceof Some) {
                Some some = (Some)option;
                FunctionSignatureResult signatureResult = (FunctionSignatureResult)some.value();
                SignatureInformation[] signatures = (SignatureInformation[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])signatureResult.signatures())).map((Function1 & Serializable & scala.Serializable)s -> {
                    ParameterInformation[] informations = (ParameterInformation[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])s.parameters())).map((Function1 & Serializable & scala.Serializable)p -> new ParameterInformation(new StringBuilder(2).append(p.name()).append(": ").append(p.wtype().toString()).toString(), ""), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ParameterInformation.class)));
                    MarkupContent documentation = (MarkupContent)s.docAsMarkdown().map((Function1 & Serializable & scala.Serializable)d -> new MarkupContent("markdown", d)).orNull(Predef$.MODULE$.$conforms());
                    String arguments = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])informations)).map((Function1 & Serializable & scala.Serializable)i -> (String)i.getLabel().getLeft(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(",");
                    return new SignatureInformation(new StringBuilder(2).append(signatureResult.name()).append("(").append(arguments).append(")").toString(), documentation, Arrays.asList((Object[])informations));
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(SignatureInformation.class)));
                int i = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])signatureResult.signatures())).indexWhere((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)s.active()));
                return new SignatureHelp(Arrays.asList((Object[])signatures), Predef$.MODULE$.int2Integer(i), Predef$.MODULE$.int2Integer(signatureResult.currentArgIndex()));
            }
            if (None$.MODULE$.equals(option)) {
                return new SignatureHelp();
            }
            throw new MatchError((Object)option);
        });
    }

    private Seq<InputDirective> getInputDirectives(Option<AstNode> maybeAstNode) {
        return (Seq)maybeAstNode.collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends AstNode, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof DocumentNode) {
                    DocumentNode documentNode = (DocumentNode)A1;
                    return (B1)documentNode;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(AstNode x1) {
                AstNode astNode = x1;
                return astNode instanceof DocumentNode;
            }
        }).map((Function1 & Serializable & scala.Serializable)documentNode -> (Seq)AstNodeHelper$.MODULE$.getInputs(documentNode).filter((Function1 & Serializable & scala.Serializable)inputDirective -> BoxesRunTime.boxToBoolean((boolean)DataWeaveDocumentService.$anonfun$getInputDirectives$3(inputDirective)))).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$);
    }

    private ArrayList<CodeLens> createMappingTestLens(String url) {
        Object object;
        ArrayList<CodeLens> lenses = new ArrayList<CodeLens>();
        Option<File> maybeFile = ProjectStructureHelper$.MODULE$.defaultTestSourceFolder(this.projectKind.structure());
        if (maybeFile.isDefined()) {
            Command command = new Command("Create Integration Mapping", Commands$.MODULE$.DW_CREATE_TEST_MAPPING(), Arrays.asList(URLUtils$.MODULE$.toLSPUrl((File)maybeFile.get()), url));
            object = BoxesRunTime.boxToBoolean((boolean)lenses.add(new CodeLens(this.docStartRange(), command, null)));
        } else {
            object = BoxedUnit.UNIT;
        }
        return lenses;
    }

    public CompletableFuture<java.util.List<? extends CodeLens>> codeLens(CodeLensParams params) {
        return CompletableFuture.supplyAsync(() -> DataWeaveDocumentService.$anonfun$codeLens$1(this, params));
    }

    private ArrayList<CodeLens> sampleDataLenses(Option<Scenario> maybeScenario, NameIdentifier nameIdentifier, Seq<InputDirective> inputDirectives, String uri) {
        Object object;
        ArrayList<CodeLens> lenses = new ArrayList<CodeLens>();
        if (maybeScenario.isEmpty()) {
            Object object2;
            if (inputDirectives.isEmpty()) {
                Command command = new Command(UserMessages$.MODULE$.defineSampleData(), Commands$.MODULE$.DW_CREATE_SCENARIO(), Arrays.asList(nameIdentifier.name(), uri, Scenario$.MODULE$.PLAYGROUND_SCENARIO()));
                object2 = BoxesRunTime.boxToBoolean((boolean)lenses.add(new CodeLens(this.docStartRange(), command, null)));
            } else {
                object2 = BoxedUnit.UNIT;
            }
            inputDirectives.foreach((Function1 & Serializable & scala.Serializable)id -> BoxesRunTime.boxToBoolean((boolean)DataWeaveDocumentService.$anonfun$sampleDataLenses$1(this, nameIdentifier, uri, lenses, id)));
            object = BoxedUnit.UNIT;
        } else {
            SampleInput[] scenarioInputs = ((Scenario)maybeScenario.get()).inputs();
            Map inputs = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])scenarioInputs)).groupBy((Function1 & Serializable & scala.Serializable)x$2 -> x$2.name());
            if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])scenarioInputs)).isEmpty() && inputDirectives.isEmpty()) {
                Command command = new Command(UserMessages$.MODULE$.defineSampleData(), Commands$.MODULE$.DW_CREATE_SCENARIO(), Arrays.asList(nameIdentifier.name(), uri, ((Scenario)maybeScenario.get()).name()));
                object = BoxesRunTime.boxToBoolean((boolean)lenses.add(new CodeLens(this.docStartRange(), command, null)));
            } else {
                inputDirectives.foreach((Function1 & Serializable & scala.Serializable)id -> {
                    if (!inputs.contains((Object)id.variable().name())) {
                        Command command = new Command(UserMessages$.MODULE$.defineSampleData(), Commands$.MODULE$.DW_CREATE_INPUT_SAMPLE(), Arrays.asList(nameIdentifier.name(), ((Scenario)maybeScenario.get()).name(), uri, id.variable().name(), this.inputFileName((InputDirective)id)));
                        return BoxesRunTime.boxToBoolean((boolean)lenses.add(new CodeLens(LSPConverters$.MODULE$.toRange(id.location()), command, null)));
                    }
                    return BoxedUnit.UNIT;
                });
                object = BoxedUnit.UNIT;
            }
        }
        return lenses;
    }

    private Range docStartRange() {
        Position docStart = new Position(0, 0);
        return new Range(docStart, docStart);
    }

    private CodeLens runMappingLens(NameIdentifier nameIdentifier) {
        Command runMappingCommand = new Command("Run Mapping", Commands$.MODULE$.DW_LAUNCH_MAPPING(), Arrays.asList(URLUtils$.MODULE$.toLSPUrl(Path.of(this.projectKind.project().getLocation()).toFile()), nameIdentifier.name(), LaunchConfiguration$.MODULE$.DATA_WEAVE_CONFIG_TYPE_NAME(), "false"));
        return new CodeLens(this.docStartRange(), runMappingCommand, null);
    }

    private String inputFileName(InputDirective id) {
        String extension = (String)id.mime().map((Function1 & Serializable & scala.Serializable)mime -> {
            String string = mime.mime();
            if ("application/json".equals(string)) {
                return ".json";
            }
            if ("application/java".equals(string)) {
                return ".dwl";
            }
            if ("application/xml".equals(string)) {
                return ".xml";
            }
            if ("application/yaml".equals(string)) {
                return ".yaml";
            }
            if ("application/x-ndjson".equals(string)) {
                return ".ndjson";
            }
            if ("application/octet-stream".equals(string)) {
                return ".bin";
            }
            if ("application/x-java-properties".equals(string)) {
                return ".properties";
            }
            if ("multipart/form-data".equals(string)) {
                return ".multipart";
            }
            if ("multipart/x-www-form-urlencoded".equals(string)) {
                return ".urlencoded";
            }
            if ("application/csv".equals(string) ? true : "text/csv".equals(string)) {
                return ".csv";
            }
            if ("text/plain".equals(string)) {
                return ".txt";
            }
            return new StringBuilder(1).append(".").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])string.split("/"))).last()).toString();
        }).orElse((Function0 & Serializable & scala.Serializable)() -> id.dataFormat().map((Function1 & Serializable & scala.Serializable)id -> {
            String string = id.id();
            if ("text".equals(string)) {
                return ".txt";
            }
            if ("java".equals(string)) {
                return ".dwl";
            }
            if ("excel".equals(string)) {
                return ".xlsx";
            }
            if ("binary".equals(string)) {
                return ".bin";
            }
            return new StringBuilder(1).append(".").append(string).toString();
        })).getOrElse((Function0 & Serializable & scala.Serializable)() -> ".json");
        return new StringBuilder(0).append(id.variable().name()).append(extension).toString();
    }

    private ArrayList<CodeLens> addDocumentationLenses(AstNode ast, String uri) {
        ArrayList<CodeLens> result = new ArrayList<CodeLens>();
        Seq functionNodes = AstNodeHelper$.MODULE$.collectChildrenWith(ast, FunctionDirectiveNode.class);
        ((IterableLike)functionNodes.filter((Function1 & Serializable & scala.Serializable)fd -> BoxesRunTime.boxToBoolean((boolean)DataWeaveDocumentService.$anonfun$addDocumentationLenses$1(fd)))).foreach((Function1 & Serializable & scala.Serializable)astNode -> BoxesRunTime.boxToBoolean((boolean)DataWeaveDocumentService.$anonfun$addDocumentationLenses$2(uri, result, astNode)));
        return result;
    }

    private ArrayList<CodeLens> addUnitTestLenses(AstNode ast, String uri) {
        ArrayList<CodeLens> result;
        block0: {
            result = new ArrayList<CodeLens>();
            AstNode astNode2 = ast;
            if (!(astNode2 instanceof ModuleNode)) break block0;
            ModuleNode moduleNode = (ModuleNode)astNode2;
            Seq topLevelFunctions = AstNodeHelper$.MODULE$.collectDirectChildrenWith((AstNode)moduleNode, FunctionDirectiveNode.class);
            topLevelFunctions.foreach((Function1 & Serializable & scala.Serializable)astNode -> BoxesRunTime.boxToBoolean((boolean)DataWeaveDocumentService.$anonfun$addUnitTestLenses$1(uri, result, astNode)));
        }
        return result;
    }

    public CompletableFuture<CodeLens> resolveCodeLens(CodeLens unresolved) {
        return CompletableFuture.completedFuture(unresolved);
    }

    public CompletableFuture<java.util.List<FoldingRange>> foldingRange(FoldingRangeRequestParams params) {
        return CompletableFuture.supplyAsync(() -> {
            WeaveDocumentToolingService service = this.toolingServices().openDocument(params.getTextDocument().getUri());
            FoldingRange[] regions = (FoldingRange[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])service.foldingRegions())).map((Function1 & Serializable & scala.Serializable)fr -> {
                FoldingRange range = new FoldingRange(fr.location().startPosition().line() - 1, fr.location().endPosition().line() - 1);
                int n = fr.kind();
                String kind = RegionKind$.MODULE$.COMMENTS() == n ? "comment" : "region";
                range.setKind(kind);
                return range;
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FoldingRange.class)));
            return Arrays.asList((Object[])regions);
        });
    }

    public CompletableFuture<java.util.List<Either<Command, CodeAction>>> codeAction(CodeActionParams params) {
        this.logger().log(Level.INFO, new StringBuilder(6).append("code: ").append(params).toString());
        String uri = params.getTextDocument().getUri();
        org.mule.weave.v2.editor.VirtualFile vf = this.vfs().file(uri);
        if (vf == null) {
            ResponseError error = new ResponseError(ResponseErrorCode.InvalidRequest, new StringBuilder(110).append("Invalid request codeAction(").append(params.getTextDocument().getUri()).append("), virtual file not registered as opened yet didOpen should have been called first.").toString(), null);
            return CompletableFuture.failedFuture((Throwable)new ResponseErrorException(error));
        }
        Optional contextMetadata = this.projectKind.metadataProvider().metadata((VirtualFile)VirtualFileAdapter$.MODULE$.apply(vf));
        return CompletableFuture.supplyAsync(() -> {
            Seq<CodeAction> actions = this.codeActionsManagerService().codeActionsFor(params, contextMetadata);
            ArrayList result = new ArrayList();
            actions.foreach((Function1 & Serializable & scala.Serializable)a -> BoxesRunTime.boxToBoolean((boolean)result.add(Either.forRight((Object)a))));
            return result;
        });
    }

    public CompletableFuture<CompletionItem> resolveCompletionItem(CompletionItem unresolved) {
        return CompletableFuture.completedFuture(unresolved);
    }

    public CompletableFuture<Hover> hover(HoverParams params) {
        return CompletableFuture.supplyAsync(() -> {
            WeaveDocumentToolingService toolingService = this.toolingServices().openDocument(params.getTextDocument().getUri());
            Position position = params.getPosition();
            int offset = toolingService.offsetOf(position.getLine(), position.getCharacter());
            return (Hover)toolingService.hoverResult(offset).map((Function1 & Serializable & scala.Serializable)hm -> {
                Hover hoverResult = new Hover();
                boolean x$1 = false;
                boolean x$2 = true;
                boolean x$3 = false;
                Seq x$4 = (Seq)new .colon.colon((Object)"Documentation", (List)Nil$.MODULE$);
                boolean x$5 = true;
                boolean x$6 = WeaveTypeEmitterConfig$.MODULE$.apply$default$3();
                boolean x$7 = WeaveTypeEmitterConfig$.MODULE$.apply$default$4();
                boolean x$8 = WeaveTypeEmitterConfig$.MODULE$.apply$default$5();
                boolean x$9 = WeaveTypeEmitterConfig$.MODULE$.apply$default$7();
                boolean x$10 = WeaveTypeEmitterConfig$.MODULE$.apply$default$9();
                boolean x$11 = WeaveTypeEmitterConfig$.MODULE$.apply$default$10();
                boolean x$12 = WeaveTypeEmitterConfig$.MODULE$.apply$default$11();
                boolean x$13 = WeaveTypeEmitterConfig$.MODULE$.apply$default$12();
                boolean x$14 = WeaveTypeEmitterConfig$.MODULE$.apply$default$14();
                boolean x$15 = WeaveTypeEmitterConfig$.MODULE$.apply$default$15();
                Option x$16 = WeaveTypeEmitterConfig$.MODULE$.apply$default$16();
                WeaveTypeEmitterConfig typeEmitterConfig = new WeaveTypeEmitterConfig(x$1, x$2, x$6, x$7, x$8, x$3, x$9, x$5, x$10, x$11, x$12, x$13, x$4, x$14, x$15, x$16);
                String expressionType = (String)Option$.MODULE$.apply((Object)hm.resultType()).map((Function1 & Serializable & scala.Serializable)wt -> new StringBuilder(9).append("Type: `").append(wt.toString(typeEmitterConfig)).append("`\n").toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
                String documentation = new StringBuilder(1).append(expressionType).append("\n").append(hm.markdownDocs().getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).toString();
                hoverResult.setContents(new MarkupContent("markdown", documentation));
                hoverResult.setRange(LSPConverters$.MODULE$.toRange(hm.weaveLocation()));
                return hoverResult;
            }).orElse((Function0 & Serializable & scala.Serializable)() -> Option$.MODULE$.apply((Object)toolingService.typeOf(offset)).map((Function1 & Serializable & scala.Serializable)wt -> {
                Hover hoverResult;
                block0: {
                    hoverResult = new Hover();
                    boolean x$17 = false;
                    boolean x$18 = true;
                    boolean x$19 = false;
                    boolean x$20 = true;
                    boolean x$21 = WeaveTypeEmitterConfig$.MODULE$.apply$default$3();
                    boolean x$22 = WeaveTypeEmitterConfig$.MODULE$.apply$default$4();
                    boolean x$23 = WeaveTypeEmitterConfig$.MODULE$.apply$default$5();
                    boolean x$24 = WeaveTypeEmitterConfig$.MODULE$.apply$default$7();
                    boolean x$25 = WeaveTypeEmitterConfig$.MODULE$.apply$default$9();
                    boolean x$26 = WeaveTypeEmitterConfig$.MODULE$.apply$default$10();
                    boolean x$27 = WeaveTypeEmitterConfig$.MODULE$.apply$default$11();
                    boolean x$28 = WeaveTypeEmitterConfig$.MODULE$.apply$default$12();
                    Seq x$29 = WeaveTypeEmitterConfig$.MODULE$.apply$default$13();
                    boolean x$30 = WeaveTypeEmitterConfig$.MODULE$.apply$default$14();
                    boolean x$31 = WeaveTypeEmitterConfig$.MODULE$.apply$default$15();
                    Option x$32 = WeaveTypeEmitterConfig$.MODULE$.apply$default$16();
                    WeaveTypeEmitterConfig typeEmitterConfig = new WeaveTypeEmitterConfig(x$17, x$18, x$21, x$22, x$23, x$19, x$24, x$20, x$25, x$26, x$27, x$28, x$29, x$30, x$31, x$32);
                    String expressionType = new StringBuilder(8).append("Type: `").append(wt.toString(typeEmitterConfig)).append("`").toString();
                    hoverResult.setContents(new MarkupContent("markdown", expressionType));
                    if (wt.location().startPosition().index() < 0) break block0;
                    hoverResult.setRange(LSPConverters$.MODULE$.toRange(wt.location()));
                }
                return hoverResult;
            })).orNull(Predef$.MODULE$.$conforms());
        }, this.executor);
    }

    public SymbolKind toSymbolKind(int kind) {
        int n = kind;
        if (SymbolKind$.MODULE$.Array() == n) {
            return SymbolKind.Array;
        }
        if (SymbolKind$.MODULE$.Boolean() == n) {
            return SymbolKind.Boolean;
        }
        if (SymbolKind$.MODULE$.Class() == n) {
            return SymbolKind.Class;
        }
        if (SymbolKind$.MODULE$.Constant() == n) {
            return SymbolKind.Constant;
        }
        if (SymbolKind$.MODULE$.Field() == n) {
            return SymbolKind.Field;
        }
        if (SymbolKind$.MODULE$.Module() == n) {
            return SymbolKind.Module;
        }
        if (SymbolKind$.MODULE$.Property() == n) {
            return SymbolKind.Property;
        }
        if (SymbolKind$.MODULE$.Namespace() == n) {
            return SymbolKind.Namespace;
        }
        if (SymbolKind$.MODULE$.String() == n) {
            return SymbolKind.String;
        }
        if (SymbolKind$.MODULE$.Variable() == n) {
            return SymbolKind.Variable;
        }
        if (SymbolKind$.MODULE$.Constructor() == n) {
            return SymbolKind.Constructor;
        }
        if (SymbolKind$.MODULE$.Enum() == n) {
            return SymbolKind.Enum;
        }
        if (SymbolKind$.MODULE$.Method() == n) {
            return SymbolKind.Method;
        }
        if (SymbolKind$.MODULE$.Function() == n) {
            return SymbolKind.Function;
        }
        if (SymbolKind$.MODULE$.File() == n) {
            return SymbolKind.File;
        }
        if (SymbolKind$.MODULE$.Package() == n) {
            return SymbolKind.Package;
        }
        if (SymbolKind$.MODULE$.Interface() == n) {
            return SymbolKind.Interface;
        }
        return SymbolKind.Property;
    }

    public CompletableFuture<java.util.List<Either<org.eclipse.lsp4j.SymbolInformation, DocumentSymbol>>> documentSymbol(DocumentSymbolParams params) {
        return CompletableFuture.supplyAsync(() -> {
            TextDocumentIdentifier document = params.getTextDocument();
            WeaveDocumentToolingService toolingService = this.toolingServices().openDocument(document.getUri());
            ArrayList result = new ArrayList();
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])toolingService.documentSymbol())).foreach((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)DataWeaveDocumentService.$anonfun$documentSymbol$2(this, result, e)));
            return result;
        }, this.executor);
    }

    public CompletableFuture<Either<java.util.List<? extends Location>, java.util.List<? extends LocationLink>>> definition(DefinitionParams params) {
        return CompletableFuture.supplyAsync(() -> {
            WeaveDocumentToolingService toolingService = this.toolingServices().openDocument(params.getTextDocument().getUri());
            int offset = toolingService.offsetOf(params.getPosition().getLine(), params.getPosition().getCharacter());
            ArrayList result = new ArrayList();
            Link[] definitions = toolingService.definitions(offset);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])definitions)).foreach((Function1 & Serializable & scala.Serializable)ll -> BoxesRunTime.boxToBoolean((boolean)DataWeaveDocumentService.$anonfun$definition$2(this, params, result, ll)));
            return Either.forRight(result);
        }, this.executor);
    }

    private Option<String> resolveUrl(NameIdentifier moduleName) {
        WeaveResourceResolver resourceResolver = this.vfs().asResourceResolver();
        Option maybeUrl = resourceResolver.resolve(moduleName).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.url());
        return maybeUrl;
    }

    public CompletableFuture<java.util.List<? extends TextEdit>> formatting(DocumentFormattingParams params) {
        return CompletableFuture.supplyAsync(() -> {
            WeaveDocumentToolingService toolingService = this.toolingServices().openDocument(params.getTextDocument().getUri());
            LSPWeaveTextDocument textDocument = new LSPWeaveTextDocument(toolingService);
            toolingService.formatDocument((WeaveTextDocument)textDocument, new FormattingOptions(params.getOptions().getTabSize(), params.getOptions().isInsertSpaces()));
            return textDocument.edits();
        }, this.executor);
    }

    public CompletableFuture<java.util.List<? extends TextEdit>> rangeFormatting(DocumentRangeFormattingParams params) {
        return CompletableFuture.supplyAsync(() -> {
            WeaveDocumentToolingService toolingService = this.toolingServices().openDocument(params.getTextDocument().getUri());
            LSPWeaveTextDocument textDocument = new LSPWeaveTextDocument(toolingService);
            Range range = params.getRange();
            int startOffset = toolingService.offsetOf(range.getStart().getLine(), range.getStart().getCharacter());
            int endOffset = toolingService.offsetOf(range.getEnd().getLine(), range.getEnd().getCharacter());
            toolingService.format(startOffset, endOffset, (WeaveTextDocument)textDocument, new FormattingOptions(params.getOptions().getTabSize(), params.getOptions().isInsertSpaces()));
            return textDocument.edits();
        }, this.executor);
    }

    public CompletableFuture<WorkspaceEdit> rename(RenameParams params) {
        return CompletableFuture.supplyAsync(() -> {
            WeaveDocumentToolingService toolingService = this.toolingServices().openDocument(params.getTextDocument().getUri());
            int offset = toolingService.offsetOf(params.getPosition().getLine(), params.getPosition().getCharacter());
            Reference[] ref2 = toolingService.rename(offset, params.getNewName());
            WorkspaceEdit edit = new WorkspaceEdit();
            NameIdentifier localNameIdentifier = toolingService.file().getNameIdentifier();
            Map renamesByDocument = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ref2)).groupBy((Function1 & Serializable & scala.Serializable)ref -> (NameIdentifier)ref.moduleSource().getOrElse((Function0 & Serializable & scala.Serializable)() -> localNameIdentifier));
            renamesByDocument.foreach((Function1 & Serializable & scala.Serializable)references -> {
                Option<String> option = this.resolveUrl((NameIdentifier)references._1());
                if (option instanceof Some) {
                    Some some = (Some)option;
                    String url = (String)some.value();
                    return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])references._2())).map((Function1 & Serializable & scala.Serializable)reference -> {
                        Location location = this.textDocumentTranslator().translate(url, LSPConverters$.MODULE$.toRange(reference.referencedNode().location()));
                        ArrayList<TextEdit> changes = (ArrayList<TextEdit>)edit.getChanges().get(location.getUri());
                        if (changes == null) {
                            changes = new ArrayList<TextEdit>();
                        }
                        changes.add(new TextEdit(location.getRange(), params.getNewName()));
                        return edit.getChanges().put(location.getUri(), changes);
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(java.util.List.class)));
                }
                if (None$.MODULE$.equals(option)) {
                    return BoxedUnit.UNIT;
                }
                throw new MatchError(option);
            });
            return edit;
        }, this.executor);
    }

    public CompletableFuture<java.util.List<? extends Location>> references(ReferenceParams params) {
        return CompletableFuture.supplyAsync(() -> {
            WeaveDocumentToolingService toolingService = this.toolingServices().openDocument(params.getTextDocument().getUri());
            int offset = toolingService.offsetOf(params.getPosition().getLine(), params.getPosition().getCharacter());
            Reference[] referencesResult = toolingService.references(offset);
            return JavaConverters$.MODULE$.seqAsJavaList((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])referencesResult)).map((Function1 & Serializable & scala.Serializable)r -> {
                String url = r.isLocalReference() ? params.getTextDocument().getUri() : (String)this.resolveUrl((NameIdentifier)r.moduleSource().get()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
                Range range = LSPConverters$.MODULE$.toRange(r.referencedNode().location());
                return this.textDocumentTranslator().translate(url, range);
            }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit())));
        }, this.executor);
    }

    private CompletionItemKind getCompletionType(Suggestion sug) {
        int n = sug.itemType();
        if (SuggestionType$.MODULE$.Class() == n) {
            return CompletionItemKind.Class;
        }
        if (SuggestionType$.MODULE$.Constructor() == n) {
            return CompletionItemKind.Constructor;
        }
        if (SuggestionType$.MODULE$.Field() == n) {
            return CompletionItemKind.Field;
        }
        if (SuggestionType$.MODULE$.Enum() == n) {
            return CompletionItemKind.Enum;
        }
        if (SuggestionType$.MODULE$.Function() == n) {
            return CompletionItemKind.Function;
        }
        if (SuggestionType$.MODULE$.Keyword() == n) {
            return CompletionItemKind.Keyword;
        }
        if (SuggestionType$.MODULE$.Module() == n) {
            return CompletionItemKind.Module;
        }
        if (SuggestionType$.MODULE$.Method() == n) {
            return CompletionItemKind.Method;
        }
        if (SuggestionType$.MODULE$.Property() == n) {
            return CompletionItemKind.Property;
        }
        if (SuggestionType$.MODULE$.Variable() == n) {
            return CompletionItemKind.Variable;
        }
        return CompletionItemKind.Property;
    }

    public static final /* synthetic */ void $anonfun$getSuggestionsAndCreateCompletionList$1(DataWeaveDocumentService $this, IntRef i$1, SuggestionResult suggestionResult$1, WeaveDocumentToolingService toolingService$1, ArrayList result$1, Suggestion sug) {
        String index = Integer.toString(i$1.elem);
        String prefix = new StringOps(Predef$.MODULE$.augmentString("0")).$times(suggestionResult$1.suggestions().length - index.length());
        CompletionItem item = new CompletionItem(sug.name());
        item.setDetail((String)sug.wtype().map((Function1 & Serializable & scala.Serializable)wt -> {
            boolean x$1 = false;
            boolean x$2 = true;
            boolean x$3 = true;
            boolean x$4 = false;
            boolean x$5 = false;
            boolean x$6 = WeaveTypeEmitterConfig$.MODULE$.apply$default$5();
            boolean x$7 = WeaveTypeEmitterConfig$.MODULE$.apply$default$7();
            boolean x$8 = WeaveTypeEmitterConfig$.MODULE$.apply$default$8();
            boolean x$9 = WeaveTypeEmitterConfig$.MODULE$.apply$default$9();
            boolean x$10 = WeaveTypeEmitterConfig$.MODULE$.apply$default$10();
            boolean x$11 = WeaveTypeEmitterConfig$.MODULE$.apply$default$11();
            boolean x$12 = WeaveTypeEmitterConfig$.MODULE$.apply$default$12();
            Seq x$13 = WeaveTypeEmitterConfig$.MODULE$.apply$default$13();
            boolean x$14 = WeaveTypeEmitterConfig$.MODULE$.apply$default$14();
            boolean x$15 = WeaveTypeEmitterConfig$.MODULE$.apply$default$15();
            Option x$16 = WeaveTypeEmitterConfig$.MODULE$.apply$default$16();
            WeaveTypeEmitterConfig emitterConfig = new WeaveTypeEmitterConfig(x$1, x$3, x$4, x$2, x$6, x$5, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16);
            return wt.toString(emitterConfig);
        }).orNull(Predef$.MODULE$.$conforms()));
        item.setSortText(new StringBuilder(0).append(prefix).append(index).toString());
        item.setDocumentation(new MarkupContent("markdown", (String)sug.markdownDocumentation().getOrElse((Function0 & Serializable & scala.Serializable)() -> "")));
        int startIndex = suggestionResult$1.replacementStart();
        int endIndex = suggestionResult$1.replacementEnd();
        org.mule.weave.v2.parser.location.Position startPosition = toolingService$1.file().asResource().positionOf(startIndex);
        org.mule.weave.v2.parser.location.Position endPosition = toolingService$1.file().asResource().positionOf(endIndex);
        TextEdit edit = new TextEdit(new Range(LSPConverters$.MODULE$.toPosition(startPosition), LSPConverters$.MODULE$.toPosition(endPosition)), sug.template().toVSCodeString());
        item.setTextEdit(Either.forLeft((Object)edit));
        item.setFilterText(sug.template().toVSCodeString());
        item.setInsertTextFormat(InsertTextFormat.Snippet);
        item.setKind($this.getCompletionType(sug));
        result$1.add(item);
        ++i$1.elem;
    }

    public static final /* synthetic */ boolean $anonfun$getInputDirectives$3(InputDirective inputDirective) {
        return !NameIdentifier$.MODULE$.INSERTED_FAKE_VARIABLE().equals((Object)inputDirective.variable()) && AstNodeHelper$.MODULE$.notInjectedNode((AstNode)inputDirective);
    }

    public static final /* synthetic */ AstNode $anonfun$codeLens$2(AstNodeResult x$1) {
        return x$1.astNode();
    }

    public static final /* synthetic */ boolean $anonfun$codeLens$3(DataWeaveDocumentService $this, ArrayList result$2, String uri$1, AstNode ast) {
        result$2.addAll($this.addDocumentationLenses(ast, uri$1));
        return result$2.addAll($this.addUnitTestLenses(ast, uri$1));
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ java.util.List $anonfun$codeLens$1(DataWeaveDocumentService $this, CodeLensParams params$2) {
        block4: {
            block6: {
                block5: {
                    uri = params$2.getTextDocument().getUri();
                    result = new ArrayList<CodeLens>();
                    documentToolingService = $this.toolingServices().openDocument(params$2.getTextDocument().getUri());
                    nameIdentifier = documentToolingService.file().getNameIdentifier();
                    maybeAstNode = documentToolingService.ast().map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$codeLens$2(org.mule.weave.v2.editor.AstNodeResult ), (Lorg/mule/weave/v2/editor/AstNodeResult;)Lorg/mule/weave/v2/parser/ast/AstNode;)());
                    maybeString = WeaveASTQueryUtils$.MODULE$.fileKind((Option<AstNode>)maybeAstNode);
                    if (documentToolingService.file().readOnly()) break block4;
                    var9_8 = false;
                    var10_9 = null;
                    var11_10 = maybeString;
                    if (!(var11_10 instanceof Some)) break block5;
                    var9_8 = true;
                    var10_9 = (Some)var11_10;
                    var12_11 = (String)var10_9.value();
                    v0 = WeaveASTQueryUtils$.MODULE$.MODULE();
                    var13_12 = var12_11;
                    if (v0 != null ? v0.equals(var13_12) == false : var13_12 != null) break block5;
                    BoxesRunTime.boxToBoolean((boolean)result.addAll($this.createMappingTestLens(documentToolingService.file().url())));
                    break block6;
                }
                if (!var9_8) ** GOTO lbl-1000
                var14_13 = (String)var10_9.value();
                v1 = WeaveASTQueryUtils$.MODULE$.MAPPING();
                var15_14 = var14_13;
                if (!(v1 != null ? v1.equals(var15_14) == false : var15_14 != null)) {
                    maybeScenario = $this.scenariosService().activeScenario(nameIdentifier);
                    inputDirectives = $this.getInputDirectives((Option<AstNode>)maybeAstNode);
                    result.addAll($this.sampleDataLenses(maybeScenario, nameIdentifier, inputDirectives, uri));
                    BoxesRunTime.boxToBoolean((boolean)result.add($this.runMappingLens(nameIdentifier)));
                } else if (var9_8) {
                    var18_17 = (String)var10_9.value();
                    v2 = WeaveASTQueryUtils$.MODULE$.BAT();
                    var19_18 = var18_17;
                    if (!(v2 != null ? v2.equals(var19_18) == false : var19_18 != null)) {
                        command = new Command("Run BAT Test", Commands$.MODULE$.DW_LAUNCH_MAPPING(), Arrays.asList(new Object[]{URLUtils$.MODULE$.toLSPUrl(Path.of($this.projectKind.project().getLocation()).toFile()), nameIdentifier.name(), LaunchConfiguration$.MODULE$.BAT_CONFIG_TYPE_NAME(), "false"}));
                        BoxesRunTime.boxToBoolean((boolean)result.add(new CodeLens($this.docStartRange(), command, null)));
                    }
                }
            }
            maybeAstNode.foreach((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$codeLens$3$adapted(org.mule.weave.lsp.services.DataWeaveDocumentService java.util.ArrayList java.lang.String org.mule.weave.v2.parser.ast.AstNode ), (Lorg/mule/weave/v2/parser/ast/AstNode;)Ljava/lang/Object;)((DataWeaveDocumentService)$this, result, (String)uri));
        }
        return result;
    }

    public static final /* synthetic */ boolean $anonfun$sampleDataLenses$1(DataWeaveDocumentService $this, NameIdentifier nameIdentifier$1, String uri$2, ArrayList lenses$1, InputDirective id) {
        Command command = new Command(UserMessages$.MODULE$.defineSampleData(), Commands$.MODULE$.DW_CREATE_INPUT_SAMPLE(), Arrays.asList(nameIdentifier$1.name(), Scenario$.MODULE$.PLAYGROUND_SCENARIO(), uri$2, id.variable().name(), $this.inputFileName(id)));
        return lenses$1.add(new CodeLens(LSPConverters$.MODULE$.toRange(id.location()), command, null));
    }

    public static final /* synthetic */ boolean $anonfun$addDocumentationLenses$1(FunctionDirectiveNode fd) {
        return fd.weaveDoc().isEmpty() && !(fd.literal() instanceof OverloadedFunctionNode);
    }

    public static final /* synthetic */ boolean $anonfun$addDocumentationLenses$2(String uri$3, ArrayList result$3, FunctionDirectiveNode astNode) {
        Command command = InsertDocumentationCommand$.MODULE$.createCommand(uri$3, (AstNode)astNode);
        Range range = new Range(LSPConverters$.MODULE$.toPosition(astNode.location().startPosition()), LSPConverters$.MODULE$.toPosition(astNode.location().startPosition()));
        return result$3.add(new CodeLens(range, command, null));
    }

    public static final /* synthetic */ boolean $anonfun$addUnitTestLenses$1(String uri$4, ArrayList result$4, FunctionDirectiveNode astNode) {
        Command command = CreateUnitTest$.MODULE$.createCommand(uri$4, (AstNode)astNode);
        Range range = new Range(LSPConverters$.MODULE$.toPosition(astNode.location().startPosition()), LSPConverters$.MODULE$.toPosition(astNode.location().startPosition()));
        return result$4.add(new CodeLens(range, command, null));
    }

    public static final /* synthetic */ boolean $anonfun$documentSymbol$2(DataWeaveDocumentService $this, ArrayList result$6, SymbolInformation e) {
        DocumentSymbol symbol = new DocumentSymbol();
        symbol.setName(e.name());
        symbol.setSelectionRange(LSPConverters$.MODULE$.toRange(e.location()));
        symbol.setRange(LSPConverters$.MODULE$.toRange(e.location()));
        symbol.setKind($this.toSymbolKind(e.kind()));
        return result$6.add(Either.forRight((Object)symbol));
    }

    public static final /* synthetic */ boolean $anonfun$definition$4(Link ll$1, SampleInput sampleInput) {
        return sampleInput.name().equals(ll$1.linkLocation().name());
    }

    public static final /* synthetic */ void $anonfun$definition$5(LocationLink link$1, SampleInput sampleInput) {
        Position position = new Position(0, 0);
        link$1.setTargetRange(new Range(position, position));
        link$1.setTargetSelectionRange(new Range(position, position));
        link$1.setTargetUri(sampleInput.uri());
    }

    public static final /* synthetic */ void $anonfun$definition$3(Link ll$1, LocationLink link$1, Scenario activeScenario) {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])activeScenario.inputs())).find((Function1 & Serializable & scala.Serializable)sampleInput -> BoxesRunTime.boxToBoolean((boolean)DataWeaveDocumentService.$anonfun$definition$4(ll$1, sampleInput))).foreach((Function1 & Serializable & scala.Serializable)sampleInput -> {
            DataWeaveDocumentService.$anonfun$definition$5(link$1, sampleInput);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$definition$2(DataWeaveDocumentService $this, DefinitionParams params$7, ArrayList result$7, Link ll) {
        LocationLink link = new LocationLink();
        link.setOriginSelectionRange(LSPConverters$.MODULE$.toRange(ll.linkLocation().location()));
        Reference reference = ll.reference();
        link.setTargetRange(LSPConverters$.MODULE$.toRange(reference.referencedNode().location()));
        link.setTargetSelectionRange(LSPConverters$.MODULE$.toRange(reference.referencedNode().location()));
        if (reference.isLocalReference()) {
            link.setTargetUri(params$7.getTextDocument().getUri());
            $this.scenariosService().activeScenario($this.vfs().file(params$7.getTextDocument().getUri()).getNameIdentifier()).foreach((Function1 & Serializable & scala.Serializable)activeScenario -> {
                DataWeaveDocumentService.$anonfun$definition$3(ll, link, activeScenario);
                return BoxedUnit.UNIT;
            });
        } else {
            NameIdentifier moduleName = (NameIdentifier)reference.moduleSource().get();
            Option<String> maybeUrl = $this.resolveUrl(moduleName);
            Option<String> option = maybeUrl;
            if (option instanceof Some) {
                Some some = (Some)option;
                String url = (String)some.value();
                link.setTargetUri(url);
            } else if (None$.MODULE$.equals(option)) {
                $this.logger().log(Level.INFO, new StringBuilder(23).append("Resource not found for ").append(moduleName).toString());
            } else {
                throw new MatchError(option);
            }
        }
        return result$7.add(link);
    }

    public DataWeaveDocumentService(ProjectKind projectKind, Executor executor) {
        this.projectKind = projectKind;
        this.executor = executor;
        this.logger = Logger.getLogger(this.getClass().getName());
        this.toolingServices = projectKind.toolingService(DataWeaveToolingService.class);
        this.projectFS = projectKind.toolingService(ProjectFileSystemService.class);
        this.scenariosService = projectKind.toolingService(WeaveScenarioManagerService.class);
        this.vfs = projectKind.vfs();
        this.codeActionsManagerService = projectKind.toolingService(CodeActionsManagerService.class);
        this.textDocumentTranslator = projectKind.toolingService(TextDocumentTranslatorService.class);
    }

    public static final /* synthetic */ Object $anonfun$codeLens$3$adapted(DataWeaveDocumentService $this, ArrayList result$2, String uri$1, AstNode ast) {
        return BoxesRunTime.boxToBoolean((boolean)DataWeaveDocumentService.$anonfun$codeLens$3($this, result$2, uri$1, ast));
    }
}

