/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.lsp.services;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lsp4j.DidChangeConfigurationParams;
import org.eclipse.lsp4j.DidChangeWatchedFilesParams;
import org.eclipse.lsp4j.DidChangeWorkspaceFoldersParams;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.WorkspaceSymbolParams;
import org.eclipse.lsp4j.services.WorkspaceService;
import org.mule.weave.extension.api.extension.command.WeaveCommand;
import org.mule.weave.lsp.commands.CommandManagerService;
import org.mule.weave.lsp.commands.Commands$;
import org.mule.weave.lsp.commands.InternalWeaveCommand;
import org.mule.weave.lsp.extension.protocol.DataWeaveProtocolClient;
import org.mule.weave.lsp.extension.protocol.SetContextParams;
import org.mule.weave.lsp.extension.protocol.SetContextValue;
import org.mule.weave.lsp.jobs.JobManagerService;
import org.mule.weave.lsp.jobs.Status;
import org.mule.weave.lsp.jobs.Task;
import org.mule.weave.lsp.project.ProjectKind;
import org.mule.weave.lsp.services.WorkspaceServiceContributor;
import org.mule.weave.lsp.services.WorkspaceServiceContributorRegistry;
import org.mule.weave.lsp.services.WorkspaceServiceListener;
import org.mule.weave.lsp.services.events.DocumentChangedEvent$;
import org.mule.weave.lsp.services.events.DocumentFocusChangedEvent$;
import org.mule.weave.lsp.services.events.DocumentOpenedEvent$;
import org.mule.weave.lsp.services.events.OnDocumentChanged;
import org.mule.weave.lsp.services.events.OnDocumentFocused;
import org.mule.weave.lsp.services.events.OnDocumentOpened;
import org.mule.weave.v2.editor.VirtualFile;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.concurrent.TrieMap;
import scala.collection.concurrent.TrieMap$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005Mh\u0001\u0002\u000f\u001e\u0001!B\u0001B\u0010\u0001\u0003\u0002\u0003\u0006Ia\u0010\u0005\t\u000f\u0002\u0011\t\u0011)A\u0005\u0011\"Aa\n\u0001B\u0001B\u0003%q\nC\u0003V\u0001\u0011\u0005a\u000bC\u0004\\\u0001\t\u0007I\u0011\u0002/\t\r\u0015\u0004\u0001\u0015!\u0003^\u0011\u001d1\u0007A1A\u0005\n\u001dDaa\u001f\u0001!\u0002\u0013A\u0007b\u0002?\u0001\u0005\u0004%I! \u0005\b\u0003\u001f\u0001\u0001\u0015!\u0003\u007f\u0011%\t\t\u0002\u0001b\u0001\n\u0013\t\u0019\u0002\u0003\u0005\u0002\"\u0001\u0001\u000b\u0011BA\u000b\u0011%\t\u0019\u0003\u0001b\u0001\n\u0013\t)\u0003\u0003\u0005\u0002.\u0001\u0001\u000b\u0011BA\u0014\u0011%\ty\u0003\u0001b\u0001\n\u0013\t\t\u0004\u0003\u0005\u0002:\u0001\u0001\u000b\u0011BA\u001a\u0011\u001d\tY\u0004\u0001C!\u0003{Aq!a\u0013\u0001\t\u0003\ti\u0005C\u0004\u0002X\u0001!\t!!\u0017\t\u000f\u0005u\u0003\u0001\"\u0003\u0002`!9\u00111\r\u0001\u0005\n\u0005\u0015\u0004bBA5\u0001\u0011%\u00111\u000e\u0005\b\u0003\u0003\u0003A\u0011IAB\u0011\u001d\tY\f\u0001C!\u0003{Cq!a2\u0001\t\u0003\nI\rC\u0004\u0002\\\u0002!\t%!8\t\u000f\u0005\u001d\b\u0001\"\u0011\u0002j\nIB)\u0019;b/\u0016\fg/Z,pe.\u001c\b/Y2f'\u0016\u0014h/[2f\u0015\tqr$\u0001\u0005tKJ4\u0018nY3t\u0015\t\u0001\u0013%A\u0002mgBT!AI\u0012\u0002\u000b],\u0017M^3\u000b\u0005\u0011*\u0013\u0001B7vY\u0016T\u0011AJ\u0001\u0004_J<7\u0001A\n\u0005\u0001%\n$\b\u0005\u0002+_5\t1F\u0003\u0002-[\u0005!A.\u00198h\u0015\u0005q\u0013\u0001\u00026bm\u0006L!\u0001M\u0016\u0003\r=\u0013'.Z2u!\t\u0011\u0004(D\u00014\u0015\tqBG\u0003\u00026m\u0005)An\u001d95U*\u0011q'J\u0001\bK\u000ed\u0017\u000e]:f\u0013\tI4G\u0001\tX_J\\7\u000f]1dKN+'O^5dKB\u00111\bP\u0007\u0002;%\u0011Q(\b\u0002$/>\u00148n\u001d9bG\u0016\u001cVM\u001d<jG\u0016\u001cuN\u001c;sS\n,Ho\u001c:SK\u001eL7\u000f\u001e:z\u0003M9X-\u0019<f!J|Go\\2pY\u000ec\u0017.\u001a8u!\t\u0001U)D\u0001B\u0015\t\u00115)\u0001\u0005qe>$xnY8m\u0015\t!u$A\u0005fqR,gn]5p]&\u0011a)\u0011\u0002\u0018\t\u0006$\u0018mV3bm\u0016\u0004&o\u001c;pG>d7\t\\5f]R\f\u0011C[8c\u001b\u0006t\u0017mZ3s'\u0016\u0014h/[2f!\tIE*D\u0001K\u0015\tYu$\u0001\u0003k_\n\u001c\u0018BA'K\u0005EQuNY'b]\u0006<WM]*feZL7-Z\u0001\u000fG>lW.\u00198e\u001b\u0006t\u0017mZ3s!\t\u00016+D\u0001R\u0015\t\u0011v$\u0001\u0005d_6l\u0017M\u001c3t\u0013\t!\u0016KA\u000bD_6l\u0017M\u001c3NC:\fw-\u001a:TKJ4\u0018nY3\u0002\rqJg.\u001b;?)\u00119\u0006,\u0017.\u0011\u0005m\u0002\u0001\"\u0002 \u0005\u0001\u0004y\u0004\"B$\u0005\u0001\u0004A\u0005\"\u0002(\u0005\u0001\u0004y\u0015A\u00027pO\u001e,'/F\u0001^!\tq6-D\u0001`\u0015\t\u0001\u0017-A\u0004m_\u001e<\u0017N\\4\u000b\u0005\tl\u0013\u0001B;uS2L!\u0001Z0\u0003\r1{wmZ3s\u0003\u001dawnZ4fe\u0002\nA\u0004\u001d:pU\u0016\u001cGoV8sWN\u0004\u0018mY3D_:$(/\u001b2vi>\u00148/F\u0001i!\u0011I\u0007O\u001d=\u000e\u0003)T!a\u001b7\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002n]\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\u000b\u0003=\fQa]2bY\u0006L!!\u001d6\u0003\u000fQ\u0013\u0018.Z'baB\u00111O^\u0007\u0002i*\u0011QoH\u0001\baJ|'.Z2u\u0013\t9HOA\u0006Qe>TWm\u0019;LS:$\u0007CA\u001ez\u0013\tQXDA\u000eX_J\\7\u000f]1dKN+'O^5dK\u000e{g\u000e\u001e:jEV$xN]\u0001\u001eaJ|'.Z2u/>\u00148n\u001d9bG\u0016\u001cuN\u001c;sS\n,Ho\u001c:tA\u0005Iro\u001c:lgB\f7-Z*feZL7-\u001a'jgR,g.\u001a:t+\u0005q\b#B@\u0002\u0006\u0005%QBAA\u0001\u0015\r\t\u0019\u0001\\\u0001\b[V$\u0018M\u00197f\u0013\u0011\t9!!\u0001\u0003\r\t+hMZ3s!\rY\u00141B\u0005\u0004\u0003\u001bi\"\u0001G,pe.\u001c\b/Y2f'\u0016\u0014h/[2f\u0019&\u001cH/\u001a8fe\u0006Qro\u001c:lgB\f7-Z*feZL7-\u001a'jgR,g.\u001a:tA\u0005\trN\u001c#pGVlWM\u001c;DQ\u0006tw-\u001a3\u0016\u0005\u0005U\u0001\u0003BA\f\u0003;i!!!\u0007\u000b\u0007\u0005mQ$\u0001\u0004fm\u0016tGo]\u0005\u0005\u0003?\tIBA\tP]\u0012{7-^7f]R\u001c\u0005.\u00198hK\u0012\f!c\u001c8E_\u000e,X.\u001a8u\u0007\"\fgnZ3eA\u0005\u0001rN\u001c#pGVlWM\u001c;Pa\u0016tW\rZ\u000b\u0003\u0003O\u0001B!a\u0006\u0002*%!\u00111FA\r\u0005Aye\u000eR8dk6,g\u000e^(qK:,G-A\tp]\u0012{7-^7f]R|\u0005/\u001a8fI\u0002\n\u0011c\u001c8E_\u000e,X.\u001a8u\r>\u001cWo]3e+\t\t\u0019\u0004\u0005\u0003\u0002\u0018\u0005U\u0012\u0002BA\u001c\u00033\u0011\u0011c\u00148E_\u000e,X.\u001a8u\r>\u001cWo]3e\u0003Iyg\u000eR8dk6,g\u000e\u001e$pGV\u001cX\r\u001a\u0011\u00027\u0005$GmV8sWN\u0004\u0018mY3TKJ4\u0018nY3MSN$XM\\3s)\u0011\ty$a\u0012\u0011\t\u0005\u0005\u00131I\u0007\u0002]&\u0019\u0011Q\t8\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003\u0013\n\u0002\u0019AA\u0005\u0003a9xN]6ta\u0006\u001cWmU3sm&\u001cW\rT5ti\u0016tWM]\u0001\u0015_:\u0004&o\u001c6fGR\\\u0015N\u001c3De\u0016\fG/\u001a3\u0015\r\u0005}\u0012qJA*\u0011\u0019\t\tF\u0005a\u0001e\u0006Y\u0001O]8kK\u000e$8*\u001b8e\u0011\u0019\t)F\u0005a\u0001q\u0006Yro\u001c:lgB\f7-Z*feZL7-Z\"p]R\u0014\u0018NY;u_J\fAc\u001c8Qe>TWm\u0019;LS:$'+Z7pm\u0016$G\u0003BA \u00037Ba!!\u0015\u0014\u0001\u0004\u0011\u0018!\u0007:fO&\u001cH/\u001a:E_\u000e,X.\u001a8u\u0019&\u001cH/\u001a8feN$B!a\u0010\u0002b!1\u0011\u0011\u000b\u000bA\u0002I\f1$\u001e8sK\u001eL7\u000f^3s\t>\u001cW/\\3oi2K7\u000f^3oKJ\u001cH\u0003BA \u0003OBa!!\u0015\u0016\u0001\u0004\u0011\u0018\u0001\u00068pi&4\u0017pQ8oi\u0016DHo\u00115b]\u001e,G\r\u0006\u0003\u0002@\u00055\u0004bBA8-\u0001\u0007\u0011\u0011O\u0001\u0003m\u001a\u0004B!a\u001d\u0002~5\u0011\u0011Q\u000f\u0006\u0005\u0003o\nI(\u0001\u0004fI&$xN\u001d\u0006\u0004\u0003w\n\u0013A\u0001<3\u0013\u0011\ty(!\u001e\u0003\u0017YK'\u000f^;bY\u001aKG.Z\u0001\u0007gfl'm\u001c7\u0015\t\u0005\u0015\u0015\u0011\u0017\t\u0007\u0003\u000f\u000bY)a$\u000e\u0005\u0005%%BA6b\u0013\u0011\ti)!#\u0003#\r{W\u000e\u001d7fi\u0006\u0014G.\u001a$viV\u0014X\r\r\u0003\u0002\u0012\u0006u\u0005CBAJ\u0003+\u000bI*D\u0001b\u0013\r\t9*\u0019\u0002\u0005\u0019&\u001cH\u000f\u0005\u0003\u0002\u001c\u0006uE\u0002\u0001\u0003\f\u0003?;\u0012\u0011!A\u0001\u0006\u0003\t\tKA\u0002`IE\nB!a)\u0002*B!\u0011\u0011IAS\u0013\r\t9K\u001c\u0002\b\u001d>$\b.\u001b8h!\u0011\tY+!,\u000e\u0003QJ1!a,5\u0005E\u0019\u00160\u001c2pY&sgm\u001c:nCRLwN\u001c\u0005\b\u0003g;\u0002\u0019AA[\u0003\u0019\u0001\u0018M]1ngB!\u00111VA\\\u0013\r\tI\f\u000e\u0002\u0016/>\u00148n\u001d9bG\u0016\u001c\u00160\u001c2pYB\u000b'/Y7t\u0003Y!\u0017\u000eZ\"iC:<WmQ8oM&<WO]1uS>tG\u0003BA \u0003\u007fCq!a-\u0019\u0001\u0004\t\t\r\u0005\u0003\u0002,\u0006\r\u0017bAAci\taB)\u001b3DQ\u0006tw-Z\"p]\u001aLw-\u001e:bi&|g\u000eU1sC6\u001c\u0018AD3yK\u000e,H/Z\"p[6\fg\u000e\u001a\u000b\u0005\u0003\u0017\f\u0019\u000e\u0005\u0004\u0002\b\u0006-\u0015Q\u001a\t\u0005\u0003\u0003\ny-C\u0002\u0002R:\u0014a!\u00118z%\u00164\u0007bBAZ3\u0001\u0007\u0011Q\u001b\t\u0005\u0003W\u000b9.C\u0002\u0002ZR\u0012A#\u0012=fGV$XmQ8n[\u0006tG\rU1sC6\u001c\u0018!\u00073jI\u000eC\u0017M\\4f/>\u00148n\u001d9bG\u00164u\u000e\u001c3feN$B!a\u0010\u0002`\"9\u00111\u0017\u000eA\u0002\u0005\u0005\b\u0003BAV\u0003GL1!!:5\u0005}!\u0015\u000eZ\"iC:<WmV8sWN\u0004\u0018mY3G_2$WM]:QCJ\fWn]\u0001\u0016I&$7\t[1oO\u0016<\u0016\r^2iK\u00124\u0015\u000e\\3t)\u0011\ty$a;\t\u000f\u0005M6\u00041\u0001\u0002nB!\u00111VAx\u0013\r\t\t\u0010\u000e\u0002\u001c\t&$7\t[1oO\u0016<\u0016\r^2iK\u00124\u0015\u000e\\3t!\u0006\u0014\u0018-\\:")
public class DataWeaveWorkspaceService
implements WorkspaceService,
WorkspaceServiceContributorRegistry {
    private final DataWeaveProtocolClient weaveProtocolClient;
    private final JobManagerService jobManagerService;
    private final CommandManagerService commandManager;
    private final Logger logger;
    private final TrieMap<ProjectKind, WorkspaceServiceContributor> projectWorkspaceContributors;
    private final Buffer<WorkspaceServiceListener> workspaceServiceListeners;
    private final OnDocumentChanged onDocumentChanged;
    private final OnDocumentOpened onDocumentOpened;
    private final OnDocumentFocused onDocumentFocused;

    private Logger logger() {
        return this.logger;
    }

    private TrieMap<ProjectKind, WorkspaceServiceContributor> projectWorkspaceContributors() {
        return this.projectWorkspaceContributors;
    }

    private Buffer<WorkspaceServiceListener> workspaceServiceListeners() {
        return this.workspaceServiceListeners;
    }

    private OnDocumentChanged onDocumentChanged() {
        return this.onDocumentChanged;
    }

    private OnDocumentOpened onDocumentOpened() {
        return this.onDocumentOpened;
    }

    private OnDocumentFocused onDocumentFocused() {
        return this.onDocumentFocused;
    }

    @Override
    public void addWorkspaceServiceListener(WorkspaceServiceListener workspaceServiceListener) {
        this.workspaceServiceListeners().$plus$eq((Object)workspaceServiceListener);
    }

    @Override
    public void onProjectKindCreated(ProjectKind projectKind, WorkspaceServiceContributor workspaceServiceContributor) {
        Option option = this.projectWorkspaceContributors().putIfAbsent((Object)projectKind, (Object)workspaceServiceContributor);
        if (option instanceof Some) {
            return;
        }
        if (None$.MODULE$.equals(option)) {
            this.registerDocumentListeners(projectKind);
            return;
        }
        throw new MatchError((Object)option);
    }

    @Override
    public void onProjectKindRemoved(ProjectKind projectKind) {
        Option option = this.projectWorkspaceContributors().remove((Object)projectKind);
        if (option instanceof Some) {
            this.unregisterDocumentListeners(projectKind);
            return;
        }
        if (None$.MODULE$.equals(option)) {
            return;
        }
        throw new MatchError((Object)option);
    }

    private void registerDocumentListeners(ProjectKind projectKind) {
        projectKind.eventBus().register(DocumentChangedEvent$.MODULE$.DOCUMENT_CHANGED(), this.onDocumentChanged());
        projectKind.eventBus().register(DocumentOpenedEvent$.MODULE$.DOCUMENT_OPENED(), this.onDocumentOpened());
        projectKind.eventBus().register(DocumentFocusChangedEvent$.MODULE$.DOCUMENT_FOCUS_CHANGED(), this.onDocumentFocused());
    }

    private void unregisterDocumentListeners(ProjectKind projectKind) {
        projectKind.eventBus().unRegister(DocumentChangedEvent$.MODULE$.DOCUMENT_CHANGED(), this.onDocumentChanged());
        projectKind.eventBus().unRegister(DocumentOpenedEvent$.MODULE$.DOCUMENT_OPENED(), this.onDocumentOpened());
        projectKind.eventBus().unRegister(DocumentFocusChangedEvent$.MODULE$.DOCUMENT_FOCUS_CHANGED(), this.onDocumentFocused());
    }

    private void notifyContextChanged(VirtualFile vf) {
        SetContextParams params = new SetContextParams((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)this.commandManager.commands().map((Function1 & Serializable & scala.Serializable)command -> {
            boolean bl;
            WeaveCommand weaveCommand = command;
            if (weaveCommand instanceof InternalWeaveCommand) {
                InternalWeaveCommand internalWeaveCommand = (InternalWeaveCommand)weaveCommand;
                bl = internalWeaveCommand.enabled(vf.url());
            } else {
                bl = true;
            }
            boolean isEnabled = bl;
            return new SetContextValue(new StringBuilder(0).append(command.commandId()).append(Commands$.MODULE$.COMMAND_ENABLED_SUFFIX()).toString(), isEnabled, vf.url());
        }, Seq$.MODULE$.canBuildFrom())).asJava());
        this.weaveProtocolClient.setContext(params);
    }

    public CompletableFuture<List<? extends SymbolInformation>> symbol(WorkspaceSymbolParams params) {
        this.logger().log(Level.INFO, new StringBuilder(8).append("symbol: ").append(params.getQuery()).toString());
        CompletableFuture[] futures = (CompletableFuture[])((TraversableOnce)this.projectWorkspaceContributors().values().map((Function1 & Serializable & scala.Serializable)projectWorkspaceContributor -> projectWorkspaceContributor.symbol(params), Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(CompletableFuture.class));
        CompletableFuture<Void> allFutures = CompletableFuture.allOf(futures);
        return allFutures.thenApply(x$1 -> {
            ArrayList symbolsInformation = new ArrayList();
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])futures)).foreach((Function1 & Serializable & scala.Serializable)future -> BoxesRunTime.boxToBoolean((boolean)symbolsInformation.addAll((Collection)future.join())));
            return symbolsInformation;
        });
    }

    public void didChangeConfiguration(DidChangeConfigurationParams params) {
        this.logger().log(Level.INFO, new StringBuilder(24).append("didChangeConfiguration: ").append(params.getSettings()).toString());
        this.workspaceServiceListeners().foreach((Function1 & Serializable & scala.Serializable)listener -> {
            listener.didChangeConfiguration(params);
            return BoxedUnit.UNIT;
        });
        this.projectWorkspaceContributors().values().foreach((Function1 & Serializable & scala.Serializable)projectWorkspaceContributor -> {
            projectWorkspaceContributor.didChangeConfiguration(params);
            return BoxedUnit.UNIT;
        });
    }

    public CompletableFuture<Object> executeCommand(ExecuteCommandParams params) {
        this.logger().log(Level.INFO, new StringBuilder(16).append("executeCommand: ").append(params).toString());
        return CompletableFuture.supplyAsync(() -> $this.commandManager.commandBy(params.getCommand()).map((Function1 & Serializable & scala.Serializable)c -> {
            ObjectRef result = ObjectRef.create(null);
            $this.jobManagerService.execute(new Task(null, result, (WeaveCommand)c, params){
                private final ObjectRef result$1;
                private final WeaveCommand c$1;
                private final ExecuteCommandParams params$3;

                public void run(Status cancelable) {
                    this.result$1.elem = this.c$1.execute(this.params$3);
                }
                {
                    this.result$1 = result$1;
                    this.c$1 = c$1;
                    this.params$3 = params$3;
                }
            }, new StringBuilder(17).append("Running command: ").append(c.name()).toString(), String.valueOf(c.description(params)));
            return result.elem;
        }).orNull(Predef$.MODULE$.$conforms()));
    }

    public void didChangeWorkspaceFolders(DidChangeWorkspaceFoldersParams params) {
        this.logger().log(Level.INFO, new StringBuilder(27).append("didChangeWorkspaceFolders: ").append(params.getEvent()).toString());
        this.workspaceServiceListeners().foreach((Function1 & Serializable & scala.Serializable)listener -> {
            listener.didChangeWorkspaceFolders(params);
            return BoxedUnit.UNIT;
        });
    }

    public void didChangeWatchedFiles(DidChangeWatchedFilesParams params) {
        this.logger().log(Level.INFO, new StringBuilder(23).append("didChangeWatchedFiles: ").append(params.getChanges()).toString());
        this.projectWorkspaceContributors().values().foreach((Function1 & Serializable & scala.Serializable)projectWorkspaceContributor -> {
            projectWorkspaceContributor.didChangeWatchedFiles(params);
            return BoxedUnit.UNIT;
        });
    }

    public DataWeaveWorkspaceService(DataWeaveProtocolClient weaveProtocolClient, JobManagerService jobManagerService, CommandManagerService commandManager) {
        this.weaveProtocolClient = weaveProtocolClient;
        this.jobManagerService = jobManagerService;
        this.commandManager = commandManager;
        this.logger = Logger.getLogger(this.getClass().getName());
        this.projectWorkspaceContributors = (TrieMap)TrieMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.workspaceServiceListeners = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.onDocumentChanged = vf -> this.notifyContextChanged(vf);
        this.onDocumentOpened = vf -> this.notifyContextChanged(vf);
        this.onDocumentFocused = vf -> this.notifyContextChanged(vf);
    }
}

