/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.lsp.services;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lsp4j.DidChangeConfigurationParams;
import org.eclipse.lsp4j.DidChangeWatchedFilesParams;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.SymbolKind;
import org.eclipse.lsp4j.WorkspaceSymbolParams;
import org.mule.weave.extension.api.WeaveLanguageServerBuilder;
import org.mule.weave.extension.api.extension.command.WeaveCommand;
import org.mule.weave.lsp.commands.CommandManagerService;
import org.mule.weave.lsp.commands.Commands$;
import org.mule.weave.lsp.commands.InternalWeaveCommand;
import org.mule.weave.lsp.extension.protocol.DataWeaveProtocolClient;
import org.mule.weave.lsp.extension.protocol.SetContextParams;
import org.mule.weave.lsp.extension.protocol.SetContextValue;
import org.mule.weave.lsp.indexer.LSPWeaveIndexService;
import org.mule.weave.lsp.project.DefaultProjectMetadata;
import org.mule.weave.lsp.project.ProjectKind;
import org.mule.weave.lsp.services.DefaultBaseWorkspaceServiceContributor$;
import org.mule.weave.lsp.services.WorkspaceServiceContributor;
import org.mule.weave.lsp.services.events.DocumentChangedEvent$;
import org.mule.weave.lsp.services.events.DocumentFocusChangedEvent$;
import org.mule.weave.lsp.services.events.DocumentOpenedEvent$;
import org.mule.weave.lsp.services.events.FileChangedEvent;
import org.mule.weave.lsp.services.events.OnDocumentChanged;
import org.mule.weave.lsp.services.events.OnDocumentFocused;
import org.mule.weave.lsp.services.events.OnDocumentOpened;
import org.mule.weave.lsp.utils.LSPConverters$;
import org.mule.weave.v2.editor.VirtualFile;
import org.mule.weave.v2.editor.indexing.IdentifierType$;
import org.mule.weave.v2.editor.indexing.LocatedResult;
import org.mule.weave.v2.editor.indexing.WeaveIdentifier;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.parser.location.Position;
import org.mule.weave.v2.sdk.WeaveResource;
import org.mule.weave.v2.sdk.WeaveResourceResolver;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005e\u0001B\t\u0013\u0001uA\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\t_\u0001\u0011\t\u0011)A\u0005a!A1\u0007\u0001B\u0001B\u0003%A\u0007\u0003\u0005=\u0001\t\u0005\t\u0015!\u0003>\u0011!\u0019\u0005A!A!\u0002\u0013!\u0005\"\u00020\u0001\t\u0003y\u0006b\u00024\u0001\u0005\u0004%Ia\u001a\u0005\u0007e\u0002\u0001\u000b\u0011\u00025\t\u000bM\u0004A\u0011\u0002;\t\u000f\u0005\u0015\u0001\u0001\"\u0011\u0002\b!9\u0011\u0011\n\u0001\u0005B\u0005-\u0003bBA+\u0001\u0011\u0005\u0013qK\u0004\n\u0003C\u0012\u0012\u0011!E\u0001\u0003G2\u0001\"\u0005\n\u0002\u0002#\u0005\u0011Q\r\u0005\u0007=:!\t!a\u001a\t\u0013\u0005%d\"%A\u0005\u0002\u0005-$A\n#fM\u0006,H\u000e\u001e\"bg\u0016<vN]6ta\u0006\u001cWmU3sm&\u001cWmQ8oiJL'-\u001e;pe*\u00111\u0003F\u0001\tg\u0016\u0014h/[2fg*\u0011QCF\u0001\u0004YN\u0004(BA\f\u0019\u0003\u00159X-\u0019<f\u0015\tI\"$\u0001\u0003nk2,'\"A\u000e\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001qB\u0005\u0005\u0002 E5\t\u0001EC\u0001\"\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0003E\u0001\u0004B]f\u0014VM\u001a\t\u0003K\u0019j\u0011AE\u0005\u0003OI\u00111dV8sWN\u0004\u0018mY3TKJ4\u0018nY3D_:$(/\u001b2vi>\u0014\u0018a\u00039s_*,7\r^&j]\u0012\u0004\"AK\u0017\u000e\u0003-R!\u0001\f\u000b\u0002\u000fA\u0014xN[3di&\u0011af\u000b\u0002\f!J|'.Z2u\u0017&tG-A\bqe>TWm\u0019;NKR\fG-\u0019;b!\tQ\u0013'\u0003\u00023W\t1B)\u001a4bk2$\bK]8kK\u000e$X*\u001a;bI\u0006$\u0018-A\nxK\u00064X\r\u0015:pi>\u001cw\u000e\\\"mS\u0016tG\u000f\u0005\u00026u5\taG\u0003\u00028q\u0005A\u0001O]8u_\u000e|GN\u0003\u0002:)\u0005IQ\r\u001f;f]NLwN\\\u0005\u0003wY\u0012q\u0003R1uC^+\u0017M^3Qe>$xnY8m\u00072LWM\u001c;\u0002\u001d\r|W.\\1oI6\u000bg.Y4feB\u0011a(Q\u0007\u0002\u007f)\u0011\u0001\tF\u0001\tG>lW.\u00198eg&\u0011!i\u0010\u0002\u0016\u0007>lW.\u00198e\u001b\u0006t\u0017mZ3s'\u0016\u0014h/[2f\u0003mi\u0017-\u001f2f)\u0016DH\u000fR8dk6,g\u000e\u001e+sC:\u001cH.\u0019;peB\u0019q$R$\n\u0005\u0019\u0003#AB(qi&|g\u000e\u0005\u0002I7:\u0011\u0011\n\u0017\b\u0003\u0015Vs!a\u0013+\u000f\u00051\u001bfBA'S\u001d\tq\u0015+D\u0001P\u0015\t\u0001F$\u0001\u0004=e>|GOP\u0005\u00027%\u0011\u0011DG\u0005\u0003/aI!!\u000f\f\n\u0005Y;\u0016aA1qS*\u0011\u0011HF\u0005\u00033j\u000b!dV3bm\u0016d\u0015M\\4vC\u001e,7+\u001a:wKJ\u0014U/\u001b7eKJT!AV,\n\u0005qk&A\u0006+fqR$unY;nK:$HK]1og2\fGo\u001c:\u000b\u0005eS\u0016A\u0002\u001fj]&$h\b\u0006\u0004aC\n\u001cG-\u001a\t\u0003K\u0001AQ\u0001\u000b\u0004A\u0002%BQa\f\u0004A\u0002ABQa\r\u0004A\u0002QBQ\u0001\u0010\u0004A\u0002uBqa\u0011\u0004\u0011\u0002\u0003\u0007A)\u0001\u0004m_\u001e<WM]\u000b\u0002QB\u0011\u0011\u000e]\u0007\u0002U*\u00111\u000e\\\u0001\bY><w-\u001b8h\u0015\tig.\u0001\u0003vi&d'\"A8\u0002\t)\fg/Y\u0005\u0003c*\u0014a\u0001T8hO\u0016\u0014\u0018a\u00027pO\u001e,'\u000fI\u0001\u0015]>$\u0018NZ=D_:$X\r\u001f;DQ\u0006tw-\u001a3\u0015\u0005UD\bCA\u0010w\u0013\t9\bE\u0001\u0003V]&$\b\"B=\n\u0001\u0004Q\u0018A\u0001<g!\rY\u0018\u0011A\u0007\u0002y*\u0011QP`\u0001\u0007K\u0012LGo\u001c:\u000b\u0005}4\u0012A\u0001<3\u0013\r\t\u0019\u0001 \u0002\f-&\u0014H/^1m\r&dW-\u0001\u0004ts6\u0014w\u000e\u001c\u000b\u0005\u0003\u0013\ty\u0004\u0005\u0004\u0002\f\u0005E\u0011QC\u0007\u0003\u0003\u001bQ1!a\u0004m\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0005\u0003'\tiAA\tD_6\u0004H.\u001a;bE2,g)\u001e;ve\u0016\u0004D!a\u0006\u0002$A1\u0011\u0011DA\u000e\u0003?i\u0011\u0001\\\u0005\u0004\u0003;a'\u0001\u0002'jgR\u0004B!!\t\u0002$1\u0001AaCA\u0013\u0015\u0005\u0005\t\u0011!B\u0001\u0003O\u00111a\u0018\u00133#\u0011\tI#a\f\u0011\u0007}\tY#C\u0002\u0002.\u0001\u0012qAT8uQ&tw\r\u0005\u0003\u00022\u0005mRBAA\u001a\u0015\u0011\t)$a\u000e\u0002\u000b1\u001c\b\u000f\u000e6\u000b\u0007\u0005e\"$A\u0004fG2L\u0007o]3\n\t\u0005u\u00121\u0007\u0002\u0012'fl'm\u001c7J]\u001a|'/\\1uS>t\u0007bBA!\u0015\u0001\u0007\u00111I\u0001\u0007a\u0006\u0014\u0018-\\:\u0011\t\u0005E\u0012QI\u0005\u0005\u0003\u000f\n\u0019DA\u000bX_J\\7\u000f]1dKNKXNY8m!\u0006\u0014\u0018-\\:\u0002-\u0011LGm\u00115b]\u001e,7i\u001c8gS\u001e,(/\u0019;j_:$2!^A'\u0011\u001d\t\te\u0003a\u0001\u0003\u001f\u0002B!!\r\u0002R%!\u00111KA\u001a\u0005q!\u0015\u000eZ\"iC:<WmQ8oM&<WO]1uS>t\u0007+\u0019:b[N\fQ\u0003Z5e\u0007\"\fgnZ3XCR\u001c\u0007.\u001a3GS2,7\u000fF\u0002v\u00033Bq!!\u0011\r\u0001\u0004\tY\u0006\u0005\u0003\u00022\u0005u\u0013\u0002BA0\u0003g\u00111\u0004R5e\u0007\"\fgnZ3XCR\u001c\u0007.\u001a3GS2,7\u000fU1sC6\u001c\u0018A\n#fM\u0006,H\u000e\u001e\"bg\u0016<vN]6ta\u0006\u001cWmU3sm&\u001cWmQ8oiJL'-\u001e;peB\u0011QED\n\u0003\u001dy!\"!a\u0019\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00136+\t\tiGK\u0002E\u0003_Z#!!\u001d\u0011\t\u0005M\u0014QP\u0007\u0003\u0003kRA!a\u001e\u0002z\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003w\u0002\u0013AC1o]>$\u0018\r^5p]&!\u0011qPA;\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class DefaultBaseWorkspaceServiceContributor
implements WorkspaceServiceContributor {
    private final ProjectKind projectKind;
    private final DefaultProjectMetadata projectMetadata;
    private final DataWeaveProtocolClient weaveProtocolClient;
    private final CommandManagerService commandManager;
    private final Option<WeaveLanguageServerBuilder.TextDocumentTranslator> maybeTextDocumentTranslator;
    private final Logger logger;

    public static Option<WeaveLanguageServerBuilder.TextDocumentTranslator> $lessinit$greater$default$5() {
        return DefaultBaseWorkspaceServiceContributor$.MODULE$.$lessinit$greater$default$5();
    }

    private Logger logger() {
        return this.logger;
    }

    public void org$mule$weave$lsp$services$DefaultBaseWorkspaceServiceContributor$$notifyContextChanged(VirtualFile vf) {
        String uri = (String)this.maybeTextDocumentTranslator.map((Function1 & Serializable & scala.Serializable)translator -> translator.translate(vf.url())).getOrElse((Function0 & Serializable & scala.Serializable)() -> vf.url());
        SetContextParams params = new SetContextParams((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)this.commandManager.commands().map((Function1 & Serializable & scala.Serializable)command -> {
            boolean bl;
            WeaveCommand weaveCommand = command;
            if (weaveCommand instanceof InternalWeaveCommand) {
                InternalWeaveCommand internalWeaveCommand = (InternalWeaveCommand)weaveCommand;
                bl = internalWeaveCommand.enabled(uri);
            } else {
                bl = true;
            }
            boolean isEnabled = bl;
            return new SetContextValue(new StringBuilder(0).append(command.commandId()).append(Commands$.MODULE$.COMMAND_ENABLED_SUFFIX()).toString(), isEnabled, vf.url());
        }, Seq$.MODULE$.canBuildFrom())).asJava());
        this.weaveProtocolClient.setContext(params);
    }

    @Override
    public CompletableFuture<List<? extends SymbolInformation>> symbol(WorkspaceSymbolParams params) {
        return CompletableFuture.supplyAsync(() -> {
            WeaveResourceResolver resourceResolver = $this.projectKind.vfs().asResourceResolver();
            Iterable<LocatedResult<WeaveIdentifier>> iterable = $this.projectKind.toolingService(LSPWeaveIndexService.class).searchSymbol(params.getQuery());
            ArrayList result = new ArrayList();
            iterable.foreach((Function1 & Serializable & scala.Serializable)lr -> {
                Option moduleResource;
                SymbolInformation information = new SymbolInformation();
                information.setName(((WeaveIdentifier)lr.value()).value());
                int n = ((WeaveIdentifier)lr.value()).idType();
                SymbolKind kind = IdentifierType$.MODULE$.FUNCTION() == n ? SymbolKind.Function : (IdentifierType$.MODULE$.VARIABLE() == n ? SymbolKind.Variable : (IdentifierType$.MODULE$.NAMESPACE() == n ? SymbolKind.Namespace : (IdentifierType$.MODULE$.ANNOTATION() == n ? SymbolKind.Interface : SymbolKind.Field)));
                information.setKind(kind);
                NameIdentifier name = lr.moduleName();
                Option option = moduleResource = resourceResolver.resolve(name);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    WeaveResource weaveResource = (WeaveResource)some.value();
                    Range range = new Range();
                    Position startPosition = weaveResource.positionOf(((WeaveIdentifier)lr.value()).startLocation());
                    Position endPosition = weaveResource.positionOf(((WeaveIdentifier)lr.value()).endLocation());
                    range.setStart(LSPConverters$.MODULE$.toPosition(startPosition));
                    range.setEnd(LSPConverters$.MODULE$.toPosition(endPosition));
                    Location location = new Location(weaveResource.url(), range);
                    information.setLocation(location);
                    return BoxesRunTime.boxToBoolean((boolean)result.add(information));
                }
                return BoxedUnit.UNIT;
            });
            return result;
        });
    }

    @Override
    public void didChangeConfiguration(DidChangeConfigurationParams params) {
        this.logger().log(Level.INFO, new StringBuilder(24).append("didChangeConfiguration: ").append(params.getSettings()).toString());
        this.projectMetadata.settings().update(params.getSettings());
    }

    @Override
    public void didChangeWatchedFiles(DidChangeWatchedFilesParams params) {
        params.getChanges().forEach(fe -> {
            if ($this.projectKind.isProjectFile(fe.getUri())) {
                this.logger().log(Level.FINE, new StringBuilder(26).append("Changed Watched File : ").append(fe.getUri()).append(" - ").append(fe.getType()).toString());
                $this.projectKind.eventBus().fire(new FileChangedEvent(fe.getUri(), fe.getType()));
                return;
            }
            this.logger().log(Level.FINE, new StringBuilder(26).append("Ignored Watched File : ").append(fe.getUri()).append(" - ").append(fe.getType()).toString());
        });
    }

    public DefaultBaseWorkspaceServiceContributor(ProjectKind projectKind, DefaultProjectMetadata projectMetadata, DataWeaveProtocolClient weaveProtocolClient, CommandManagerService commandManager, Option<WeaveLanguageServerBuilder.TextDocumentTranslator> maybeTextDocumentTranslator) {
        this.projectKind = projectKind;
        this.projectMetadata = projectMetadata;
        this.weaveProtocolClient = weaveProtocolClient;
        this.commandManager = commandManager;
        this.maybeTextDocumentTranslator = maybeTextDocumentTranslator;
        this.logger = Logger.getLogger(this.getClass().getName());
        projectKind.eventBus().register(DocumentChangedEvent$.MODULE$.DOCUMENT_CHANGED(), new OnDocumentChanged(this){
            private final /* synthetic */ DefaultBaseWorkspaceServiceContributor $outer;

            public void onDocumentChanged(VirtualFile vf) {
                this.$outer.org$mule$weave$lsp$services$DefaultBaseWorkspaceServiceContributor$$notifyContextChanged(vf);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        projectKind.eventBus().register(DocumentOpenedEvent$.MODULE$.DOCUMENT_OPENED(), new OnDocumentOpened(this){
            private final /* synthetic */ DefaultBaseWorkspaceServiceContributor $outer;

            public void onDocumentOpened(VirtualFile vf) {
                this.$outer.org$mule$weave$lsp$services$DefaultBaseWorkspaceServiceContributor$$notifyContextChanged(vf);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        projectKind.eventBus().register(DocumentFocusChangedEvent$.MODULE$.DOCUMENT_FOCUS_CHANGED(), new OnDocumentFocused(this){
            private final /* synthetic */ DefaultBaseWorkspaceServiceContributor $outer;

            public void onDocumentFocused(VirtualFile vf) {
                this.$outer.org$mule$weave$lsp$services$DefaultBaseWorkspaceServiceContributor$$notifyContextChanged(vf);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

