/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.lsp.services;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.eclipse.lsp4j.FileChangeType;
import org.mule.weave.extension.api.project.ProjectMetadata;
import org.mule.weave.lsp.agent.WeaveAgentService;
import org.mule.weave.lsp.extension.protocol.DataWeaveProtocolClient;
import org.mule.weave.lsp.extension.protocol.PreviewResult;
import org.mule.weave.lsp.extension.protocol.PreviewResult$;
import org.mule.weave.lsp.jobs.JobManagerService;
import org.mule.weave.lsp.project.ProjectKind;
import org.mule.weave.lsp.project.events.OnProjectStarted;
import org.mule.weave.lsp.project.events.ProjectStartedEvent$;
import org.mule.weave.lsp.services.DataWeaveToolingService;
import org.mule.weave.lsp.services.Debouncer;
import org.mule.weave.lsp.services.ToolingService;
import org.mule.weave.lsp.services.events.ActiveScenarioChangedEvent$;
import org.mule.weave.lsp.services.events.DocumentChangedEvent$;
import org.mule.weave.lsp.services.events.DocumentFocusChangedEvent$;
import org.mule.weave.lsp.services.events.FileChangedEvent$;
import org.mule.weave.lsp.services.events.OnActiveScenarioChanged;
import org.mule.weave.lsp.services.events.OnDocumentChanged;
import org.mule.weave.lsp.services.events.OnDocumentFocused;
import org.mule.weave.lsp.services.events.OnFileChanged;
import org.mule.weave.lsp.services.exception.RunPreviewException;
import org.mule.weave.lsp.utils.InternalEventBus;
import org.mule.weave.lsp.utils.URLUtils$;
import org.mule.weave.lsp.utils.WeaveASTQueryUtils$;
import org.mule.weave.v2.editor.VirtualFile;
import org.mule.weave.v2.editor.WeaveDocumentToolingService;
import org.mule.weave.v2.parser.ast.AstNode;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0001\u0005Uh\u0001\u0002\u0013&\u0001AB\u0001b\u000f\u0001\u0003\u0002\u0003\u0006I\u0001\u0010\u0005\t\u0005\u0002\u0011\t\u0011)A\u0005\u0007\"A1\n\u0001B\u0001B\u0003%A\n\u0003\u0005P\u0001\t\u0005\t\u0015!\u0003Q\u0011\u00151\u0006\u0001\"\u0001X\u0011\u001di\u0006A1A\u0005\nyCa!\u001b\u0001!\u0002\u0013y\u0006\"\u00036\u0001\u0001\u0004\u0005\r\u0011\"\u0003l\u0011%\u0011\b\u00011AA\u0002\u0013%1\u000fC\u0005z\u0001\u0001\u0007\t\u0011)Q\u0005Y\"I!\u0010\u0001a\u0001\u0002\u0004%Ia\u001f\u0005\f\u0003\u000b\u0001\u0001\u0019!a\u0001\n\u0013\t9\u0001\u0003\u0006\u0002\f\u0001\u0001\r\u0011!Q!\nqD\u0011\"!\u0004\u0001\u0001\u0004%I!a\u0004\t\u0013\u0005]\u0001\u00011A\u0005\n\u0005e\u0001\u0002CA\u000f\u0001\u0001\u0006K!!\u0005\t\u0013\u0005\u001d\u0002\u00011A\u0005\n\u0005%\u0002\"CA!\u0001\u0001\u0007I\u0011BA\"\u0011!\t9\u0005\u0001Q!\n\u0005-\u0002\"CA%\u0001\u0001\u0007I\u0011BA\u0015\u0011%\tY\u0005\u0001a\u0001\n\u0013\ti\u0005\u0003\u0005\u0002R\u0001\u0001\u000b\u0015BA\u0016\u0011%\t\u0019\u0006\u0001b\u0001\n\u0013\t)\u0006\u0003\u0005\u0002r\u0001\u0001\u000b\u0011BA,\u0011\u001d\t\u0019\b\u0001C!\u0003kBq!a\u001f\u0001\t\u0003\ti\bC\u0004\u0002\n\u0002!\t!a#\t\u000f\u0005%\u0005\u0001\"\u0001\u0002\u0018\"9\u0011\u0011\u0012\u0001\u0005\n\u0005m\u0005bBAa\u0001\u0011%\u00111\u0019\u0005\b\u0003\u0003\u0004A\u0011BAe\u0011\u001d\ti\r\u0001C\u0001\u0003\u001fD\u0011\"a6\u0001#\u0003%\t!!7\t\u000f\u0005=\b\u0001\"\u0001\u0002r\"9\u00111\u001f\u0001\u0005\u0002\u0005E(A\u0004)sKZLWm^*feZL7-\u001a\u0006\u0003M\u001d\n\u0001b]3sm&\u001cWm\u001d\u0006\u0003Q%\n1\u0001\\:q\u0015\tQ3&A\u0003xK\u00064XM\u0003\u0002-[\u0005!Q.\u001e7f\u0015\u0005q\u0013aA8sO\u000e\u00011c\u0001\u00012oA\u0011!'N\u0007\u0002g)\tA'A\u0003tG\u0006d\u0017-\u0003\u00027g\t1\u0011I\\=SK\u001a\u0004\"\u0001O\u001d\u000e\u0003\u0015J!AO\u0013\u0003\u001dQ{w\u000e\\5oON+'O^5dK\u0006a\u0011mZ3oiN+'O^5dKB\u0011Q\bQ\u0007\u0002})\u0011qhJ\u0001\u0006C\u001e,g\u000e^\u0005\u0003\u0003z\u0012\u0011cV3bm\u0016\fu-\u001a8u'\u0016\u0014h/[2f\u0003M9X-\u0019<f\u0019\u0006tw-^1hK\u000ec\u0017.\u001a8u!\t!\u0015*D\u0001F\u0015\t1u)\u0001\u0005qe>$xnY8m\u0015\tAu%A\u0005fqR,gn]5p]&\u0011!*\u0012\u0002\u0018\t\u0006$\u0018mV3bm\u0016\u0004&o\u001c;pG>d7\t\\5f]R\fq\u0002^8pY&twmU3sm&\u001cWm\u001d\t\u0003q5K!AT\u0013\u0003/\u0011\u000bG/Y,fCZ,Gk\\8mS:<7+\u001a:wS\u000e,\u0017A\u00036pE6\u000bg.Y4feB\u0011\u0011\u000bV\u0007\u0002%*\u00111kJ\u0001\u0005U>\u00147/\u0003\u0002V%\n\t\"j\u001c2NC:\fw-\u001a:TKJ4\u0018nY3\u0002\rqJg.\u001b;?)\u0015A\u0016LW.]!\tA\u0004\u0001C\u0003<\u000b\u0001\u0007A\bC\u0003C\u000b\u0001\u00071\tC\u0003L\u000b\u0001\u0007A\nC\u0003P\u000b\u0001\u0007\u0001+\u0001\u0004m_\u001e<WM]\u000b\u0002?B\u0011\u0001mZ\u0007\u0002C*\u0011!mY\u0001\bY><w-\u001b8h\u0015\t!W-\u0001\u0003vi&d'\"\u00014\u0002\t)\fg/Y\u0005\u0003Q\u0006\u0014a\u0001T8hO\u0016\u0014\u0018a\u00027pO\u001e,'\u000fI\u0001\tKZ,g\u000e\u001e\"vgV\tA\u000e\u0005\u0002na6\taN\u0003\u0002pO\u0005)Q\u000f^5mg&\u0011\u0011O\u001c\u0002\u0011\u0013:$XM\u001d8bY\u00163XM\u001c;CkN\fA\"\u001a<f]R\u0014Uo]0%KF$\"\u0001^<\u0011\u0005I*\u0018B\u0001<4\u0005\u0011)f.\u001b;\t\u000faL\u0011\u0011!a\u0001Y\u0006\u0019\u0001\u0010J\u0019\u0002\u0013\u00154XM\u001c;CkN\u0004\u0013a\u00039s_*,7\r^&j]\u0012,\u0012\u0001 \t\u0004{\u0006\u0005Q\"\u0001@\u000b\u0005}<\u0013a\u00029s_*,7\r^\u0005\u0004\u0003\u0007q(a\u0003)s_*,7\r^&j]\u0012\fq\u0002\u001d:pU\u0016\u001cGoS5oI~#S-\u001d\u000b\u0004i\u0006%\u0001b\u0002=\r\u0003\u0003\u0005\r\u0001`\u0001\raJ|'.Z2u\u0017&tG\rI\u0001\fK:\f'\r\\3WC2,X-\u0006\u0002\u0002\u0012A\u0019!'a\u0005\n\u0007\u0005U1GA\u0004C_>dW-\u00198\u0002\u001f\u0015t\u0017M\u00197f-\u0006dW/Z0%KF$2\u0001^A\u000e\u0011!Ax\"!AA\u0002\u0005E\u0011\u0001D3oC\ndWMV1mk\u0016\u0004\u0003f\u0001\t\u0002\"A\u0019!'a\t\n\u0007\u0005\u00152G\u0001\u0005w_2\fG/\u001b7f\u0003M\u0001XM\u001c3j]\u001e\u0004&o\u001c6fGR\u001cF/\u0019:u+\t\tY\u0003E\u00033\u0003[\t\t$C\u0002\u00020M\u0012aa\u00149uS>t\u0007\u0003BA\u001a\u0003{i!!!\u000e\u000b\t\u0005]\u0012\u0011H\u0001\u0007K\u0012LGo\u001c:\u000b\u0007\u0005m\u0012&\u0001\u0002we%!\u0011qHA\u001b\u0005-1\u0016N\u001d;vC24\u0015\u000e\\3\u0002/A,g\u000eZ5oOB\u0013xN[3diN#\u0018M\u001d;`I\u0015\fHc\u0001;\u0002F!A\u0001PEA\u0001\u0002\u0004\tY#\u0001\u000bqK:$\u0017N\\4Qe>TWm\u0019;Ti\u0006\u0014H\u000fI\u0001\u0011GV\u0014(/\u001a8u-\u001a\u0004&/\u001a<jK^\fAcY;se\u0016tGO\u00164Qe\u00164\u0018.Z<`I\u0015\fHc\u0001;\u0002P!A\u00010FA\u0001\u0002\u0004\tY#A\tdkJ\u0014XM\u001c;WMB\u0013XM^5fo\u0002\n\u0001\u0003\u001d:fm&,w\u000fR3c_Vt7-\u001a:\u0016\u0005\u0005]\u0003#\u0002\u001d\u0002Z\u0005u\u0013bAA.K\tIA)\u001a2pk:\u001cWM\u001d\t\u0005\u0003?\ni'\u0004\u0002\u0002b)!\u00111MA3\u0003%1\u0018M]5bE2,7O\u0003\u0003\u0002h\u0005%\u0014aA1ti*!\u00111NA\u001d\u0003\u0019\u0001\u0018M]:fe&!\u0011qNA1\u00059q\u0015-\\3JI\u0016tG/\u001b4jKJ\f\u0011\u0003\u001d:fm&,w\u000fR3c_Vt7-\u001a:!\u0003)Ig.\u001b;jC2L'0\u001a\u000b\u0006i\u0006]\u0014\u0011\u0010\u0005\u0006uf\u0001\r\u0001 \u0005\u0006Uf\u0001\r\u0001\\\u0001\u000beVt\u0007K]3wS\u0016<H\u0003BA@\u0003\u000b\u00032\u0001RAA\u0013\r\t\u0019)\u0012\u0002\u000e!J,g/[3x%\u0016\u001cX\u000f\u001c;\t\u000f\u0005\u001d%\u00041\u0001\u00022\u0005\u0011aOZ\u0001\u000eG\u0006t'+\u001e8Qe\u00164\u0018.Z<\u0015\t\u0005E\u0011Q\u0012\u0005\b\u0003\u001f[\u0002\u0019AAI\u0003Y!wnY;nK:$Hk\\8mS:<7+\u001a:wS\u000e,\u0007\u0003BA\u001a\u0003'KA!!&\u00026\tYr+Z1wK\u0012{7-^7f]R$vn\u001c7j]\u001e\u001cVM\u001d<jG\u0016$B!!\u0005\u0002\u001a\"9\u0011q\u0011\u000fA\u0002\u0005EBCBA\t\u0003;\u000by\nC\u0004\u0002\bv\u0001\r!!\r\t\u000f\u0005\u0005V\u00041\u0001\u0002$\u0006\u0001b-\u001b7f\u0017&tGMU3t_24XM\u001d\t\u0006e\u0005\u0015\u0016\u0011V\u0005\u0004\u0003O\u001b$!\u0003$v]\u000e$\u0018n\u001c81!\u0015\u0011\u0014QFAV!\u0011\ti+a/\u000f\t\u0005=\u0016q\u0017\t\u0004\u0003c\u001bTBAAZ\u0015\r\t)lL\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005e6'\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003{\u000byL\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003s\u001b\u0014\u0001\u00034jY\u0016\\\u0015N\u001c3\u0015\t\u0005%\u0016Q\u0019\u0005\b\u0003\u000ft\u0002\u0019AAV\u0003\u001d1\u0017\u000e\\3Ve2$B!!+\u0002L\"9\u0011qR\u0010A\u0002\u0005E\u0015AE:dQ\u0016$W\u000f\\3Sk:\u0004&/\u001a<jK^$b!a \u0002R\u0006M\u0007bBADA\u0001\u0007\u0011\u0011\u0007\u0005\n\u0003+\u0004\u0003\u0013!a\u0001\u0003#\tAa]=oG\u0006a2o\u00195fIVdWMU;o!J,g/[3xI\u0011,g-Y;mi\u0012\u0012TCAAnU\u0011\t\t\"!8,\u0005\u0005}\u0007\u0003BAq\u0003Wl!!a9\u000b\t\u0005\u0015\u0018q]\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!;4\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003[\f\u0019OA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fa!\u001a8bE2,G#\u0001;\u0002\u000f\u0011L7/\u00192mK\u0002")
public class PreviewService
implements ToolingService {
    private final WeaveAgentService agentService;
    private final DataWeaveProtocolClient weaveLanguageClient;
    private final DataWeaveToolingService toolingServices;
    private final JobManagerService jobManager;
    private final Logger logger;
    private InternalEventBus eventBus;
    private ProjectKind projectKind;
    private volatile boolean org$mule$weave$lsp$services$PreviewService$$enableValue;
    private Option<VirtualFile> org$mule$weave$lsp$services$PreviewService$$pendingProjectStart;
    private Option<VirtualFile> org$mule$weave$lsp$services$PreviewService$$currentVfPreview;
    private final Debouncer<NameIdentifier> previewDebouncer;

    private Logger logger() {
        return this.logger;
    }

    private InternalEventBus eventBus() {
        return this.eventBus;
    }

    private void eventBus_$eq(InternalEventBus x$1) {
        this.eventBus = x$1;
    }

    private ProjectKind projectKind() {
        return this.projectKind;
    }

    private void projectKind_$eq(ProjectKind x$1) {
        this.projectKind = x$1;
    }

    public boolean org$mule$weave$lsp$services$PreviewService$$enableValue() {
        return this.org$mule$weave$lsp$services$PreviewService$$enableValue;
    }

    private void org$mule$weave$lsp$services$PreviewService$$enableValue_$eq(boolean x$1) {
        this.org$mule$weave$lsp$services$PreviewService$$enableValue = x$1;
    }

    public Option<VirtualFile> org$mule$weave$lsp$services$PreviewService$$pendingProjectStart() {
        return this.org$mule$weave$lsp$services$PreviewService$$pendingProjectStart;
    }

    public void org$mule$weave$lsp$services$PreviewService$$pendingProjectStart_$eq(Option<VirtualFile> x$1) {
        this.org$mule$weave$lsp$services$PreviewService$$pendingProjectStart = x$1;
    }

    public Option<VirtualFile> org$mule$weave$lsp$services$PreviewService$$currentVfPreview() {
        return this.org$mule$weave$lsp$services$PreviewService$$currentVfPreview;
    }

    private void org$mule$weave$lsp$services$PreviewService$$currentVfPreview_$eq(Option<VirtualFile> x$1) {
        this.org$mule$weave$lsp$services$PreviewService$$currentVfPreview = x$1;
    }

    private Debouncer<NameIdentifier> previewDebouncer() {
        return this.previewDebouncer;
    }

    @Override
    public void initialize(ProjectKind projectKind, InternalEventBus eventBus) {
        this.eventBus_$eq(eventBus);
        this.projectKind_$eq(projectKind);
        eventBus.register(DocumentChangedEvent$.MODULE$.DOCUMENT_CHANGED(), new OnDocumentChanged(this){
            private final /* synthetic */ PreviewService $outer;

            public void onDocumentChanged(VirtualFile vf) {
                if (this.$outer.org$mule$weave$lsp$services$PreviewService$$enableValue() && this.$outer.canRunPreview(vf)) {
                    this.$outer.scheduleRunPreview(vf, this.$outer.scheduleRunPreview$default$2());
                    return;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        eventBus.register(DocumentFocusChangedEvent$.MODULE$.DOCUMENT_FOCUS_CHANGED(), new OnDocumentFocused(this){
            private final /* synthetic */ PreviewService $outer;

            public void onDocumentFocused(VirtualFile vf) {
                if (this.$outer.org$mule$weave$lsp$services$PreviewService$$enableValue() && this.$outer.canRunPreview(vf)) {
                    this.$outer.scheduleRunPreview(vf, this.$outer.scheduleRunPreview$default$2());
                    return;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        eventBus.register(FileChangedEvent$.MODULE$.FILE_CHANGED_EVENT(), new OnFileChanged(this, projectKind){
            private final /* synthetic */ PreviewService $outer;
            private final ProjectKind projectKind$1;

            public void onFileChanged(String uri, FileChangeType changeType) {
                if (this.$outer.org$mule$weave$lsp$services$PreviewService$$enableValue()) {
                    this.$outer.org$mule$weave$lsp$services$PreviewService$$currentVfPreview().map((Function1 & Serializable & scala.Serializable)currentVFPreview -> $this.projectKind$1.sampleDataManager().searchSampleDataFolderFor(currentVFPreview.getNameIdentifier()).map((Function1 & Serializable & scala.Serializable)scenarioFolder -> {
                        if (URLUtils$.MODULE$.isChildOf(uri, (File)scenarioFolder) || URLUtils$.MODULE$.isChildOf(URLUtils$.MODULE$.toLSPUrl(scenarioFolder.getPath()), uri)) {
                            return $this.$outer.scheduleRunPreview((VirtualFile)currentVFPreview, $this.$outer.scheduleRunPreview$default$2());
                        }
                        return BoxedUnit.UNIT;
                    }));
                    return;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.projectKind$1 = projectKind$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onFileChanged$1(org.mule.weave.lsp.services.PreviewService$$anon$3 java.lang.String org.mule.weave.v2.editor.VirtualFile ), $anonfun$onFileChanged$2(org.mule.weave.lsp.services.PreviewService$$anon$3 java.lang.String org.mule.weave.v2.editor.VirtualFile java.io.File )}, serializedLambda);
            }
        });
        eventBus.register(ProjectStartedEvent$.MODULE$.PROJECT_STARTED(), new OnProjectStarted(this){
            private final /* synthetic */ PreviewService $outer;

            public void onProjectStarted(ProjectMetadata metadata) {
                if (this.$outer.org$mule$weave$lsp$services$PreviewService$$pendingProjectStart().isDefined()) {
                    this.$outer.scheduleRunPreview((VirtualFile)this.$outer.org$mule$weave$lsp$services$PreviewService$$pendingProjectStart().get(), this.$outer.scheduleRunPreview$default$2());
                    this.$outer.org$mule$weave$lsp$services$PreviewService$$pendingProjectStart_$eq((Option<VirtualFile>)None$.MODULE$);
                    return;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        eventBus.register(ActiveScenarioChangedEvent$.MODULE$.ACTIVE_SCENARIO_CHANGED(), new OnActiveScenarioChanged(this){
            private final /* synthetic */ PreviewService $outer;

            public void onActiveScenarioChanged(VirtualFile vf) {
                if (this.$outer.org$mule$weave$lsp$services$PreviewService$$enableValue() && this.$outer.org$mule$weave$lsp$services$PreviewService$$currentVfPreview().isDefined() && ((VirtualFile)this.$outer.org$mule$weave$lsp$services$PreviewService$$currentVfPreview().get()).url().equals(vf.url()) && this.$outer.canRunPreview(vf)) {
                    this.$outer.scheduleRunPreview(vf, this.$outer.scheduleRunPreview$default$2());
                    return;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public PreviewResult runPreview(VirtualFile vf) {
        String fileUrl = vf.url();
        if (!this.projectKind().isStarted()) {
            String x$1 = fileUrl;
            boolean x$2 = false;
            List<String> x$3 = Collections.emptyList();
            String x$4 = "Project is not yet initialized.\nPreview is going to be executed once project initializes.";
            String x$5 = PreviewResult$.MODULE$.apply$default$4();
            String x$6 = PreviewResult$.MODULE$.apply$default$5();
            String x$7 = PreviewResult$.MODULE$.apply$default$7();
            String x$8 = PreviewResult$.MODULE$.apply$default$8();
            long x$9 = PreviewResult$.MODULE$.apply$default$9();
            return new PreviewResult(x$1, x$2, x$3, x$5, x$6, x$4, x$7, x$8, x$9);
        }
        NameIdentifier identifier = vf.getNameIdentifier();
        String content = vf.read();
        this.logger().info(new StringBuilder(27).append("Trigger run preview for `").append(identifier).append("`.").toString());
        return this.agentService.run(identifier, content, fileUrl);
    }

    public boolean canRunPreview(WeaveDocumentToolingService documentToolingService) {
        if (documentToolingService == null) {
            return false;
        }
        return this.canRunPreview(documentToolingService.file(), (Function0<Option<String>>)(Function0 & Serializable & scala.Serializable)() -> this.fileKind(documentToolingService));
    }

    public boolean canRunPreview(VirtualFile vf) {
        return this.canRunPreview(vf, (Function0<Option<String>>)(Function0 & Serializable & scala.Serializable)() -> this.fileKind(vf.url()));
    }

    private boolean canRunPreview(VirtualFile vf, Function0<Option<String>> fileKindResolver) {
        if (vf == null) {
            return false;
        }
        Option<URI> fileUrl = URLUtils$.MODULE$.toURI(vf.url());
        if (fileUrl.exists((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)PreviewService.$anonfun$canRunPreview$3(p)))) {
            return false;
        }
        Option mayBeKind = (Option)fileKindResolver.apply();
        boolean isMapping = mayBeKind.forall((Function1 & Serializable & scala.Serializable)kind -> BoxesRunTime.boxToBoolean((boolean)kind.equals(WeaveASTQueryUtils$.MODULE$.MAPPING())));
        return !vf.readOnly() && isMapping;
    }

    private Option<String> fileKind(String fileUrl) {
        return this.fileKind(this.toolingServices.openDocument(fileUrl));
    }

    private Option<String> fileKind(WeaveDocumentToolingService documentToolingService) {
        Option maybeAstNode = documentToolingService.ast().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.astNode());
        Option<String> mayBeKind = WeaveASTQueryUtils$.MODULE$.fileKind((Option<AstNode>)maybeAstNode);
        return mayBeKind;
    }

    public PreviewResult scheduleRunPreview(VirtualFile vf, boolean sync) {
        String fileUrl = vf.url();
        if (!this.canRunPreview(vf)) {
            String x$1 = fileUrl;
            boolean x$2 = false;
            List<String> x$3 = Collections.emptyList();
            String x$4 = new StringBuilder(42).append("File `").append(vf.getNameIdentifier().name()).append("` is not an executable mapping file.").toString();
            String x$5 = PreviewResult$.MODULE$.apply$default$4();
            String x$6 = PreviewResult$.MODULE$.apply$default$5();
            String x$7 = PreviewResult$.MODULE$.apply$default$7();
            String x$8 = PreviewResult$.MODULE$.apply$default$8();
            long x$9 = PreviewResult$.MODULE$.apply$default$9();
            PreviewResult previewResult = new PreviewResult(x$1, x$2, x$3, x$5, x$6, x$4, x$7, x$8, x$9);
            if (sync) {
                return previewResult;
            }
            this.weaveLanguageClient.showPreviewResult(previewResult);
        } else if (!this.projectKind().isStarted()) {
            if (sync) {
                throw new RunPreviewException("Project is not yet initialized, preview cannot be executed at this time.");
            }
            this.org$mule$weave$lsp$services$PreviewService$$pendingProjectStart_$eq((Option<VirtualFile>)new Some((Object)vf));
            PreviewResult previewResult = this.runPreview(vf);
            this.weaveLanguageClient.showPreviewResult(previewResult);
        } else {
            if (sync) {
                return this.runPreview(vf);
            }
            NameIdentifier identifier = vf.getNameIdentifier();
            this.previewDebouncer().debounce(identifier, () -> $this.jobManager.execute(x$2 -> $this.weaveLanguageClient.showPreviewResult(this.runPreview(vf)), "Running preview", new StringBuilder(19).append("Running preview of ").append(identifier).toString()), 300L, TimeUnit.MILLISECONDS);
        }
        this.org$mule$weave$lsp$services$PreviewService$$currentVfPreview_$eq((Option<VirtualFile>)new Some((Object)vf));
        return null;
    }

    public boolean scheduleRunPreview$default$2() {
        return false;
    }

    public void enable() {
        this.org$mule$weave$lsp$services$PreviewService$$enableValue_$eq(true);
    }

    public void disable() {
        this.org$mule$weave$lsp$services$PreviewService$$enableValue_$eq(false);
        this.org$mule$weave$lsp$services$PreviewService$$currentVfPreview_$eq((Option<VirtualFile>)None$.MODULE$);
    }

    public static final /* synthetic */ boolean $anonfun$canRunPreview$3(URI p) {
        String string = p.getScheme();
        String string2 = "preview";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public PreviewService(WeaveAgentService agentService, DataWeaveProtocolClient weaveLanguageClient, DataWeaveToolingService toolingServices, JobManagerService jobManager) {
        this.agentService = agentService;
        this.weaveLanguageClient = weaveLanguageClient;
        this.toolingServices = toolingServices;
        this.jobManager = jobManager;
        ToolingService.$init$(this);
        this.logger = Logger.getLogger(this.getClass().getName());
        this.org$mule$weave$lsp$services$PreviewService$$enableValue = false;
        this.org$mule$weave$lsp$services$PreviewService$$pendingProjectStart = None$.MODULE$;
        this.org$mule$weave$lsp$services$PreviewService$$currentVfPreview = None$.MODULE$;
        this.previewDebouncer = new Debouncer();
    }
}

