/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.lsp.vfs;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.file.Path;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lsp4j.FileChangeType;
import org.mule.weave.extension.api.component.structure.WeaveProjectStructure;
import org.mule.weave.lsp.project.ProjectKind;
import org.mule.weave.lsp.project.components.ProjectStructureHelper$;
import org.mule.weave.lsp.services.ToolingService;
import org.mule.weave.lsp.services.events.FileChangedEvent$;
import org.mule.weave.lsp.services.events.OnFileChanged;
import org.mule.weave.lsp.utils.InternalEventBus;
import org.mule.weave.lsp.utils.URLUtils$;
import org.mule.weave.lsp.utils.VFUtils$;
import org.mule.weave.lsp.vfs.CompositeNameIdentifierResolver;
import org.mule.weave.lsp.vfs.InMemoryVirtualFileResourceResolver;
import org.mule.weave.lsp.vfs.JarFileNameIdentifierResolver;
import org.mule.weave.lsp.vfs.NameIdentifierResolver;
import org.mule.weave.lsp.vfs.ProjectFileNameIdentifierResolver;
import org.mule.weave.lsp.vfs.ProjectFileSystemService$;
import org.mule.weave.lsp.vfs.ProjectVirtualFile;
import org.mule.weave.lsp.vfs.ProjectVirtualFile$;
import org.mule.weave.lsp.vfs.SimpleNameIdentifierResolver$;
import org.mule.weave.lsp.vfs.events.ProjectVirtualFileChangedEvent;
import org.mule.weave.lsp.vfs.events.ProjectVirtualFileCreatedEvent;
import org.mule.weave.lsp.vfs.events.ProjectVirtualFileDeletedEvent;
import org.mule.weave.lsp.vfs.resource.FolderWeaveResourceResolver;
import org.mule.weave.v2.editor.ChangeListener;
import org.mule.weave.v2.editor.VirtualFile;
import org.mule.weave.v2.editor.VirtualFileSystem;
import org.mule.weave.v2.sdk.ChainedWeaveResourceResolver;
import org.mule.weave.v2.sdk.WeaveResourceResolver;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0001\t\u001dc\u0001\u0002\u0017.\u0001aB\u0001\"\u0014\u0001\u0003\u0002\u0003\u0006IA\u0014\u0005\u0006%\u0002!\ta\u0015\u0005\b-\u0002\u0011\r\u0011\"\u0003X\u0011\u0019q\u0007\u0001)A\u00051\"9q\u000e\u0001b\u0001\n\u0013\u0001\bB\u0002;\u0001A\u0003%\u0011\u000fC\u0004v\u0001\t\u0007I\u0011\u0002<\t\ru\u0004\u0001\u0015!\u0003x\u0011\u001dq\bA1A\u0005\n}D\u0001\"!\u0006\u0001A\u0003%\u0011\u0011\u0001\u0005\f\u0003/\u0001\u0001\u0019!a\u0001\n\u0013\tI\u0002C\u0006\u0002(\u0001\u0001\r\u00111A\u0005\n\u0005%\u0002bCA\u001b\u0001\u0001\u0007\t\u0011)Q\u0005\u00037A1\"a\u000e\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002:!Y\u00111\u000b\u0001A\u0002\u0003\u0007I\u0011BA+\u0011-\tI\u0006\u0001a\u0001\u0002\u0003\u0006K!a\u000f\t\u0017\u0005m\u0003\u00011AA\u0002\u0013%\u0011Q\f\u0005\f\u0003W\u0002\u0001\u0019!a\u0001\n\u0013\ti\u0007C\u0006\u0002r\u0001\u0001\r\u0011!Q!\n\u0005}\u0003bCA:\u0001\u0001\u0007\t\u0019!C\u0005\u0003kB1\"! \u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u0000!Y\u00111\u0011\u0001A\u0002\u0003\u0005\u000b\u0015BA<\u0011\u001d\t)\t\u0001C!\u0003\u000fCq!!$\u0001\t\u0003\ty\tC\u0004\u0002&\u0002!\t!a*\t\u000f\u0005-\u0006\u0001\"\u0001\u0002.\"9\u0011\u0011\u0017\u0001\u0005\n\u0005M\u0006bBA\\\u0001\u0011\u0005\u0011\u0011\u0018\u0005\b\u0003\u0007\u0004A\u0011BAc\u0011\u001d\tI\r\u0001C\u0005\u0003\u0017Dq!a4\u0001\t\u0003\n\t\u000eC\u0004\u0002X\u0002!\t%!7\t\u000f\u0005}\u0007\u0001\"\u0003\u0002b\"9\u0011Q\u001d\u0001\u0005\n\u0005\u001d\bbBAv\u0001\u0011%\u0011Q\u001e\u0005\b\u0003c\u0004A\u0011IAz\u0011\u001d\tI\u0010\u0001C!\u0003wDq!a@\u0001\t\u0013\u0011\t\u0001C\u0004\u0003\u0006\u0001!IAa\u0002\t\u000f\t-\u0001\u0001\"\u0003\u0003\u000e!9!q\u0003\u0001\u0005\u0002\te\u0001b\u0002B\u0016\u0001\u0011\u0005#Q\u0006\u0005\b\u0005w\u0001A\u0011\tB\u001f\u0005a\u0001&o\u001c6fGR4\u0015\u000e\\3TsN$X-\\*feZL7-\u001a\u0006\u0003]=\n1A\u001e4t\u0015\t\u0001\u0014'A\u0002mgBT!AM\u001a\u0002\u000b],\u0017M^3\u000b\u0005Q*\u0014\u0001B7vY\u0016T\u0011AN\u0001\u0004_J<7\u0001A\n\u0005\u0001ezt\t\u0005\u0002;{5\t1HC\u0001=\u0003\u0015\u00198-\u00197b\u0013\tq4H\u0001\u0004B]f\u0014VM\u001a\t\u0003\u0001\u0016k\u0011!\u0011\u0006\u0003\u0005\u000e\u000ba!\u001a3ji>\u0014(B\u0001#2\u0003\t1('\u0003\u0002G\u0003\n\tb+\u001b:uk\u0006dg)\u001b7f'f\u001cH/Z7\u0011\u0005![U\"A%\u000b\u0005){\u0013\u0001C:feZL7-Z:\n\u00051K%A\u0004+p_2LgnZ*feZL7-Z\u0001\u001eU\u0006\u0014h)\u001b7f\u001d\u0006lW-\u00133f]RLg-[3s%\u0016\u001cx\u000e\u001c<feB\u0011q\nU\u0007\u0002[%\u0011\u0011+\f\u0002\u001e\u0015\u0006\u0014h)\u001b7f\u001d\u0006lW-\u00133f]RLg-[3s%\u0016\u001cx\u000e\u001c<fe\u00061A(\u001b8jiz\"\"\u0001V+\u0011\u0005=\u0003\u0001\"B'\u0003\u0001\u0004q\u0015!D5o\u001b\u0016lwN]=GS2,7/F\u0001Y!\u0011If\fY6\u000e\u0003iS!a\u0017/\u0002\u000f5,H/\u00192mK*\u0011QlO\u0001\u000bG>dG.Z2uS>t\u0017BA0[\u0005\ri\u0015\r\u001d\t\u0003C\"t!A\u00194\u0011\u0005\r\\T\"\u00013\u000b\u0005\u0015<\u0014A\u0002\u001fs_>$h(\u0003\u0002hw\u00051\u0001K]3eK\u001aL!!\u001b6\u0003\rM#(/\u001b8h\u0015\t97\b\u0005\u0002PY&\u0011Q.\f\u0002\u0013!J|'.Z2u-&\u0014H/^1m\r&dW-\u0001\bj]6+Wn\u001c:z\r&dWm\u001d\u0011\u0002\u0017=\u0004XM\\3e\r&dWm]\u000b\u0002cB\u0019\u0011L\u001d1\n\u0005MT&aA*fi\u0006aq\u000e]3oK\u00124\u0015\u000e\\3tA\u0005\u0011bOZ:DQ\u0006tw-\u001a'jgR,g.\u001a:t+\u00059\bcA-yu&\u0011\u0011P\u0017\u0002\f\u0003J\u0014\u0018-\u001f\"vM\u001a,'\u000f\u0005\u0002Aw&\u0011A0\u0011\u0002\u000f\u0007\"\fgnZ3MSN$XM\\3s\u0003M1hm]\"iC:<W\rT5ti\u0016tWM]:!\u0003\u0019awnZ4feV\u0011\u0011\u0011\u0001\t\u0005\u0003\u0007\t\t\"\u0004\u0002\u0002\u0006)!\u0011qAA\u0005\u0003\u001dawnZ4j]\u001eTA!a\u0003\u0002\u000e\u0005!Q\u000f^5m\u0015\t\ty!\u0001\u0003kCZ\f\u0017\u0002BA\n\u0003\u000b\u0011a\u0001T8hO\u0016\u0014\u0018a\u00027pO\u001e,'\u000fI\u0001\faJ|'.Z2u\u0017&tG-\u0006\u0002\u0002\u001cA!\u0011QDA\u0012\u001b\t\tyBC\u0002\u0002\"=\nq\u0001\u001d:pU\u0016\u001cG/\u0003\u0003\u0002&\u0005}!a\u0003)s_*,7\r^&j]\u0012\fq\u0002\u001d:pU\u0016\u001cGoS5oI~#S-\u001d\u000b\u0005\u0003W\t\t\u0004E\u0002;\u0003[I1!a\f<\u0005\u0011)f.\u001b;\t\u0013\u0005MB\"!AA\u0002\u0005m\u0011a\u0001=%c\u0005a\u0001O]8kK\u000e$8*\u001b8eA\u0005\u0001\u0002O]8kK\u000e$8\u000b\u001e:vGR,(/Z\u000b\u0003\u0003w\u0001B!!\u0010\u0002P5\u0011\u0011q\b\u0006\u0005\u0003\u0003\n\u0019%A\u0005tiJ,8\r^;sK*!\u0011QIA$\u0003%\u0019w.\u001c9p]\u0016tGO\u0003\u0003\u0002J\u0005-\u0013aA1qS*\u0019\u0011QJ\u0019\u0002\u0013\u0015DH/\u001a8tS>t\u0017\u0002BA)\u0003\u007f\u0011QcV3bm\u0016\u0004&o\u001c6fGR\u001cFO];diV\u0014X-\u0001\u000bqe>TWm\u0019;TiJ,8\r^;sK~#S-\u001d\u000b\u0005\u0003W\t9\u0006C\u0005\u00024=\t\t\u00111\u0001\u0002<\u0005\t\u0002O]8kK\u000e$8\u000b\u001e:vGR,(/\u001a\u0011\u0002\u0011\u00154XM\u001c;CkN,\"!a\u0018\u0011\t\u0005\u0005\u0014qM\u0007\u0003\u0003GR1!!\u001a0\u0003\u0015)H/\u001b7t\u0013\u0011\tI'a\u0019\u0003!%sG/\u001a:oC2,e/\u001a8u\u0005V\u001c\u0018\u0001D3wK:$()^:`I\u0015\fH\u0003BA\u0016\u0003_B\u0011\"a\r\u0013\u0003\u0003\u0005\r!a\u0018\u0002\u0013\u00154XM\u001c;CkN\u0004\u0013A\u00068b[\u0016LE-\u001a8uS\u001aLWM\u001d*fg>dg/\u001a:\u0016\u0005\u0005]\u0004cA(\u0002z%\u0019\u00111P\u0017\u0003-9\u000bW.Z%eK:$\u0018NZ5feJ+7o\u001c7wKJ\f!D\\1nK&#WM\u001c;jM&,'OU3t_24XM]0%KF$B!a\u000b\u0002\u0002\"I\u00111G\u000b\u0002\u0002\u0003\u0007\u0011qO\u0001\u0018]\u0006lW-\u00133f]RLg-[3s%\u0016\u001cx\u000e\u001c<fe\u0002\n!\"\u001b8ji&\fG.\u001b>f)\u0019\tY#!#\u0002\f\"9\u0011qC\fA\u0002\u0005m\u0001bBA./\u0001\u0007\u0011qL\u0001\u0007kB$\u0017\r^3\u0015\r\u0005E\u0015QTAQ!\u0015Q\u00141SAL\u0013\r\t)j\u000f\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007\u0001\u000bI*C\u0002\u0002\u001c\u0006\u00131BV5siV\fGNR5mK\"1\u0011q\u0014\rA\u0002\u0001\f1!\u001e:j\u0011\u0019\t\u0019\u000b\u0007a\u0001A\u000691m\u001c8uK:$\u0018AB2m_N,G\r\u0006\u0003\u0002\u0012\u0006%\u0006BBAP3\u0001\u0007\u0001-A\u0003tCZ,G\r\u0006\u0003\u0002\u0012\u0006=\u0006BBAP5\u0001\u0007\u0001-A\u0004dQ\u0006tw-\u001a3\u0015\t\u0005-\u0012Q\u0017\u0005\u0007\u0003?[\u0002\u0019\u00011\u0002\u001d%\u001c\u0018J\\'f[>\u0014\u0018PR5mKR!\u00111XAa!\rQ\u0014QX\u0005\u0004\u0003\u007f[$a\u0002\"p_2,\u0017M\u001c\u0005\u0007\u0003?c\u0002\u0019\u00011\u0002\u000f\u0011,G.\u001a;fIR!\u00111FAd\u0011\u0019\ty*\ba\u0001A\u000691M]3bi\u0016$G\u0003BA\u0016\u0003\u001bDa!a(\u001f\u0001\u0004\u0001\u0017AD2iC:<W\rT5ti\u0016tWM\u001d\u000b\u0005\u0003W\t\u0019\u000e\u0003\u0004\u0002V~\u0001\rA_\u0001\u0003G2\f\u0011b\u001c8DQ\u0006tw-\u001a3\u0015\t\u0005-\u00121\u001c\u0005\b\u0003;\u0004\u0003\u0019AAL\u0003\t1h-\u0001\bue&<w-\u001a:DQ\u0006tw-Z:\u0015\t\u0005-\u00121\u001d\u0005\b\u0003;\f\u0003\u0019AAL\u00039!(/[4hKJ\u001c%/Z1uK\u0012$B!a\u000b\u0002j\"9\u0011Q\u001c\u0012A\u0002\u0005]\u0015A\u0004;sS\u001e<WM\u001d#fY\u0016$X\r\u001a\u000b\u0005\u0003W\ty\u000fC\u0004\u0002^\u000e\u0002\r!a&\u0002)I,Wn\u001c<f\u0007\"\fgnZ3MSN$XM\\3s)\u0011\tY#!>\t\r\u0005]H\u00051\u0001{\u0003\u001d\u0019XM\u001d<jG\u0016\fAAZ5mKR!\u0011qSA\u007f\u0011\u0019\ty*\na\u0001A\u0006a1m\u001c8uC&t7OR5mKR!\u00111\u0018B\u0002\u0011\u0019\tyJ\na\u0001A\u0006IAm\\$fi\u001aKG.\u001a\u000b\u0004W\n%\u0001BBAPO\u0001\u0007\u0001-\u0001\u0007e_V\u0003H-\u0019;f\r&dW\r\u0006\u0004\u0003\u0010\tE!1\u0003\t\u0005u\u0005M5\u000e\u0003\u0004\u0002 \"\u0002\r\u0001\u0019\u0005\u0007\u0005+A\u0003\u0019A6\u0002\u0017YL'\u000f^;bY\u001aKG.Z\u0001\rg>,(oY3S_>$xJ\u001a\u000b\u0005\u00057\u0011I\u0003E\u0003;\u0003'\u0013i\u0002\u0005\u0003\u0003 \t\u0015RB\u0001B\u0011\u0015\u0011\u0011\u0019#!\u0004\u0002\u0005%|\u0017\u0002\u0002B\u0014\u0005C\u0011AAR5mK\"1\u0011qT\u0015A\u0002\u0001\f!#Y:SKN|WO]2f%\u0016\u001cx\u000e\u001c<feV\u0011!q\u0006\t\u0005\u0005c\u00119$\u0004\u0002\u00034)\u0019!QG\"\u0002\u0007M$7.\u0003\u0003\u0003:\tM\"!F,fCZ,'+Z:pkJ\u001cWMU3t_24XM]\u0001\nY&\u001cHOR5mKN$\"Aa\u0010\u0011\r\t\u0005#1IAL\u001b\t\tI!\u0003\u0003\u0003F\u0005%!\u0001C%uKJ\fGo\u001c:")
public class ProjectFileSystemService
implements VirtualFileSystem,
ToolingService {
    private final JarFileNameIdentifierResolver jarFileNameIdentifierResolver;
    private final Map<String, ProjectVirtualFile> inMemoryFiles;
    private final Set<String> org$mule$weave$lsp$vfs$ProjectFileSystemService$$openedFiles;
    private final ArrayBuffer<ChangeListener> vfsChangeListeners;
    private final Logger logger;
    private ProjectKind projectKind;
    private WeaveProjectStructure org$mule$weave$lsp$vfs$ProjectFileSystemService$$projectStructure;
    private InternalEventBus eventBus;
    private NameIdentifierResolver nameIdentifierResolver;

    private Map<String, ProjectVirtualFile> inMemoryFiles() {
        return this.inMemoryFiles;
    }

    public Set<String> org$mule$weave$lsp$vfs$ProjectFileSystemService$$openedFiles() {
        return this.org$mule$weave$lsp$vfs$ProjectFileSystemService$$openedFiles;
    }

    private ArrayBuffer<ChangeListener> vfsChangeListeners() {
        return this.vfsChangeListeners;
    }

    private Logger logger() {
        return this.logger;
    }

    private ProjectKind projectKind() {
        return this.projectKind;
    }

    private void projectKind_$eq(ProjectKind x$1) {
        this.projectKind = x$1;
    }

    public WeaveProjectStructure org$mule$weave$lsp$vfs$ProjectFileSystemService$$projectStructure() {
        return this.org$mule$weave$lsp$vfs$ProjectFileSystemService$$projectStructure;
    }

    private void org$mule$weave$lsp$vfs$ProjectFileSystemService$$projectStructure_$eq(WeaveProjectStructure x$1) {
        this.org$mule$weave$lsp$vfs$ProjectFileSystemService$$projectStructure = x$1;
    }

    private InternalEventBus eventBus() {
        return this.eventBus;
    }

    private void eventBus_$eq(InternalEventBus x$1) {
        this.eventBus = x$1;
    }

    private NameIdentifierResolver nameIdentifierResolver() {
        return this.nameIdentifierResolver;
    }

    private void nameIdentifierResolver_$eq(NameIdentifierResolver x$1) {
        this.nameIdentifierResolver = x$1;
    }

    @Override
    public void initialize(ProjectKind projectKind, InternalEventBus eventBus) {
        this.projectKind_$eq(projectKind);
        this.org$mule$weave$lsp$vfs$ProjectFileSystemService$$projectStructure_$eq(projectKind.structure());
        this.nameIdentifierResolver_$eq(new CompositeNameIdentifierResolver((NameIdentifierResolver[])((Object[])new NameIdentifierResolver[]{new ProjectFileNameIdentifierResolver(this.org$mule$weave$lsp$vfs$ProjectFileSystemService$$projectStructure()), this.jarFileNameIdentifierResolver, SimpleNameIdentifierResolver$.MODULE$})));
        this.eventBus_$eq(eventBus);
        eventBus.register(FileChangedEvent$.MODULE$.FILE_CHANGED_EVENT(), new OnFileChanged(this){
            private final /* synthetic */ ProjectFileSystemService $outer;

            public void onFileChanged(String uri2, FileChangeType changeType) {
                FileChangeType fileChangeType = changeType;
                if (FileChangeType.Created.equals(fileChangeType)) {
                    if (ProjectStructureHelper$.MODULE$.isAProjectFile(uri2, this.$outer.org$mule$weave$lsp$vfs$ProjectFileSystemService$$projectStructure()) && URLUtils$.MODULE$.toFile(uri2).exists((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)$anon$1.$anonfun$onFileChanged$1(f)))) {
                        this.$outer.org$mule$weave$lsp$vfs$ProjectFileSystemService$$created(uri2);
                        return;
                    }
                    return;
                }
                if (FileChangeType.Changed.equals(fileChangeType)) {
                    if (ProjectStructureHelper$.MODULE$.isAProjectFile(uri2, this.$outer.org$mule$weave$lsp$vfs$ProjectFileSystemService$$projectStructure())) {
                        this.$outer.org$mule$weave$lsp$vfs$ProjectFileSystemService$$openedFiles().iterator().filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)$anon$1.$anonfun$onFileChanged$2(uri2, p))).foreach((Function1 & Serializable & scala.Serializable)uri -> {
                            $anon$1.$anonfun$onFileChanged$3(this, uri);
                            return BoxedUnit.UNIT;
                        });
                        return;
                    }
                    return;
                }
                if (FileChangeType.Deleted.equals(fileChangeType)) {
                    if (ProjectStructureHelper$.MODULE$.isAProjectFile(uri2, this.$outer.org$mule$weave$lsp$vfs$ProjectFileSystemService$$projectStructure())) {
                        this.$outer.org$mule$weave$lsp$vfs$ProjectFileSystemService$$openedFiles().iterator().filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)$anon$1.$anonfun$onFileChanged$4(uri2, p))).foreach((Function1 & Serializable & scala.Serializable)uri -> {
                            $anon$1.$anonfun$onFileChanged$5(this, uri);
                            return BoxedUnit.UNIT;
                        });
                        return;
                    }
                    return;
                }
                throw new MatchError((Object)fileChangeType);
            }

            public static final /* synthetic */ boolean $anonfun$onFileChanged$1(File f) {
                return f.exists() && f.isFile();
            }

            public static final /* synthetic */ boolean $anonfun$onFileChanged$2(String uri$1, String p) {
                return URLUtils$.MODULE$.isChildOf(p, uri$1);
            }

            public static final /* synthetic */ void $anonfun$onFileChanged$3($anon$1 $this, String uri) {
                $this.$outer.org$mule$weave$lsp$vfs$ProjectFileSystemService$$changed(uri);
            }

            public static final /* synthetic */ boolean $anonfun$onFileChanged$4(String uri$1, String p) {
                return URLUtils$.MODULE$.isChildOf(p, uri$1);
            }

            public static final /* synthetic */ void $anonfun$onFileChanged$5($anon$1 $this, String uri) {
                $this.$outer.org$mule$weave$lsp$vfs$ProjectFileSystemService$$deleted(uri);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onFileChanged$1$adapted(java.io.File ), $anonfun$onFileChanged$2$adapted(java.lang.String java.lang.String ), $anonfun$onFileChanged$3$adapted(org.mule.weave.lsp.vfs.ProjectFileSystemService$$anon$1 java.lang.String ), $anonfun$onFileChanged$4$adapted(java.lang.String java.lang.String ), $anonfun$onFileChanged$5$adapted(org.mule.weave.lsp.vfs.ProjectFileSystemService$$anon$1 java.lang.String )}, serializedLambda);
            }
        });
    }

    public Option<VirtualFile> update(String uri, String content) {
        this.logger().log(Level.INFO, new StringBuilder(13).append("Update `").append(uri).append("` -> ").append(content).toString());
        Option option = Option$.MODULE$.apply((Object)this.file(uri));
        if (option instanceof Some) {
            Some some = (Some)option;
            VirtualFile vf = (VirtualFile)some.value();
            boolean written = vf.write(content);
            if (written) {
                this.triggerChanges(vf);
            }
            return new Some((Object)vf);
        }
        if (None$.MODULE$.equals(option)) {
            ProjectVirtualFile virtualFile = new ProjectVirtualFile(this, this.nameIdentifierResolver(), URLUtils$.MODULE$.toCanonicalString(uri), (Option<File>)None$.MODULE$, (Option<String>)new Some((Object)content), !VFUtils$.MODULE$.isSupportedEditableScheme(uri));
            this.doUpdateFile(uri, virtualFile);
            this.triggerChanges(virtualFile);
            return new Some((Object)virtualFile);
        }
        throw new MatchError((Object)option);
    }

    public Option<VirtualFile> closed(String uri) {
        this.logger().log(Level.INFO, new StringBuilder(7).append("closed ").append(uri).toString());
        return this.inMemoryFiles().remove((Object)uri);
    }

    public Option<VirtualFile> saved(String uri) {
        this.logger().log(Level.INFO, new StringBuilder(7).append("saved: ").append(uri).toString());
        return this.inMemoryFiles().get((Object)uri).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.save());
    }

    public void org$mule$weave$lsp$vfs$ProjectFileSystemService$$changed(String uri) {
        this.logger().log(Level.INFO, new StringBuilder(9).append("changed: ").append(uri).toString());
        VirtualFile virtualFile = this.file(uri);
        this.triggerChanges(virtualFile);
    }

    public boolean isInMemoryFile(String uri) {
        return this.inMemoryFiles().contains((Object)uri);
    }

    public void org$mule$weave$lsp$vfs$ProjectFileSystemService$$deleted(String uri) {
        this.logger().log(Level.INFO, new StringBuilder(8).append("deleted ").append(uri).toString());
        this.inMemoryFiles().remove((Object)uri);
        this.org$mule$weave$lsp$vfs$ProjectFileSystemService$$openedFiles().remove((Object)uri);
        ProjectVirtualFile virtualFile = new ProjectVirtualFile(this, this.nameIdentifierResolver(), uri, URLUtils$.MODULE$.toFile(uri), ProjectVirtualFile$.MODULE$.$lessinit$greater$default$5(), ProjectVirtualFile$.MODULE$.$lessinit$greater$default$6());
        this.triggerDeleted(virtualFile);
    }

    public void org$mule$weave$lsp$vfs$ProjectFileSystemService$$created(String uri) {
        this.logger().log(Level.INFO, new StringBuilder(9).append("created: ").append(uri).toString());
        this.org$mule$weave$lsp$vfs$ProjectFileSystemService$$openedFiles().add((Object)uri);
        ProjectVirtualFile virtualFile = new ProjectVirtualFile(this, this.nameIdentifierResolver(), uri, URLUtils$.MODULE$.toFile(uri), ProjectVirtualFile$.MODULE$.$lessinit$greater$default$5(), ProjectVirtualFile$.MODULE$.$lessinit$greater$default$6());
        this.triggerCreated(virtualFile);
    }

    public void changeListener(ChangeListener cl) {
        this.vfsChangeListeners().$plus$eq((Object)cl);
    }

    public void onChanged(VirtualFile vf) {
        this.triggerChanges(vf);
    }

    private void triggerChanges(VirtualFile vf) {
        this.vfsChangeListeners().foreach((Function1 & Serializable & scala.Serializable)listener -> {
            listener.onChanged(vf);
            return BoxedUnit.UNIT;
        });
        if (this.eventBus() != null) {
            this.eventBus().fire(new ProjectVirtualFileChangedEvent(vf));
            return;
        }
    }

    private void triggerCreated(VirtualFile vf) {
        this.vfsChangeListeners().foreach((Function1 & Serializable & scala.Serializable)listener -> {
            listener.onCreated(vf);
            return BoxedUnit.UNIT;
        });
        if (this.eventBus() != null) {
            this.eventBus().fire(new ProjectVirtualFileCreatedEvent(vf));
            return;
        }
    }

    private void triggerDeleted(VirtualFile vf) {
        this.vfsChangeListeners().foreach((Function1 & Serializable & scala.Serializable)listener -> {
            listener.onDeleted(vf);
            return BoxedUnit.UNIT;
        });
        if (this.eventBus() != null) {
            this.eventBus().fire(new ProjectVirtualFileDeletedEvent(vf));
            return;
        }
    }

    public void removeChangeListener(ChangeListener service) {
        this.vfsChangeListeners().remove(this.vfsChangeListeners().indexOf((Object)service));
    }

    public VirtualFile file(String uri) {
        this.logger().log(Level.FINE, new StringBuilder(5).append("file ").append(uri).toString());
        this.org$mule$weave$lsp$vfs$ProjectFileSystemService$$openedFiles().add((Object)uri);
        if (this.containsFile(uri)) {
            return this.doGetFile(uri);
        }
        Option<File> maybeFile = URLUtils$.MODULE$.toFile(uri);
        if (maybeFile.isEmpty()) {
            return null;
        }
        if (((File)maybeFile.get()).exists()) {
            ProjectFileSystemService x$1 = this;
            NameIdentifierResolver x$2 = this.nameIdentifierResolver();
            String x$3 = URLUtils$.MODULE$.toCanonicalString(uri);
            Option<File> x$4 = maybeFile;
            boolean x$5 = !VFUtils$.MODULE$.isSupportedEditableScheme(uri);
            Option<String> x$6 = ProjectVirtualFile$.MODULE$.$lessinit$greater$default$5();
            ProjectVirtualFile virtualFile = new ProjectVirtualFile(x$1, x$2, x$3, x$4, x$6, x$5);
            this.doUpdateFile(uri, virtualFile);
            return virtualFile;
        }
        return null;
    }

    private boolean containsFile(String uri) {
        return this.inMemoryFiles().contains((Object)URLUtils$.MODULE$.toCanonicalString(uri));
    }

    private ProjectVirtualFile doGetFile(String uri) {
        return (ProjectVirtualFile)this.inMemoryFiles().apply((Object)URLUtils$.MODULE$.toCanonicalString(uri));
    }

    private Option<ProjectVirtualFile> doUpdateFile(String uri, ProjectVirtualFile virtualFile) {
        return this.inMemoryFiles().put((Object)URLUtils$.MODULE$.toCanonicalString(uri), (Object)virtualFile);
    }

    public Option<File> sourceRootOf(String uri) {
        File[] rootFolders = (File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.org$mule$weave$lsp$vfs$ProjectFileSystemService$$projectStructure().modules())).flatMap((Function1 & Serializable & scala.Serializable)module -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])module.roots())).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$2.sources())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class))))).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])module.roots())).flatMap((Function1 & Serializable & scala.Serializable)x$3 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$3.resources())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class))))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class))))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class)));
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rootFolders)).find((Function1 & Serializable & scala.Serializable)root -> BoxesRunTime.boxToBoolean((boolean)ProjectFileSystemService.$anonfun$sourceRootOf$4(uri, root)));
    }

    public WeaveResourceResolver asResourceResolver() {
        InMemoryVirtualFileResourceResolver inMemoryVirtualFileResourceResolver;
        FolderWeaveResourceResolver[] resolvers = (FolderWeaveResourceResolver[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.org$mule$weave$lsp$vfs$ProjectFileSystemService$$projectStructure().modules())).flatMap((Function1 & Serializable & scala.Serializable)module -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])module.roots())).flatMap((Function1 & Serializable & scala.Serializable)root -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])root.sources())).map((Function1 & Serializable & scala.Serializable)root -> new FolderWeaveResourceResolver((File)root, $this), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FolderWeaveResourceResolver.class))))).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])root.resources())).map((Function1 & Serializable & scala.Serializable)root -> new FolderWeaveResourceResolver((File)root, $this), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FolderWeaveResourceResolver.class))))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FolderWeaveResourceResolver.class))))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FolderWeaveResourceResolver.class))))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FolderWeaveResourceResolver.class)));
        InMemoryVirtualFileResourceResolver inMemoryVirtualFileResourceResolver2 = inMemoryVirtualFileResourceResolver = new InMemoryVirtualFileResourceResolver(this.inMemoryFiles());
        return new ChainedWeaveResourceResolver((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])resolvers)).$plus$colon((Object)inMemoryVirtualFileResourceResolver2, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit())));
    }

    public java.util.Iterator<VirtualFile> listFiles() {
        Iterator result = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.org$mule$weave$lsp$vfs$ProjectFileSystemService$$projectStructure().modules())).toIterator().flatMap((Function1 & Serializable & scala.Serializable)module -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])module.roots())).toIterator().flatMap((Function1 & Serializable & scala.Serializable)root2 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])root2.sources())).toIterator().flatMap((Function1 & Serializable & scala.Serializable)root -> VFUtils$.MODULE$.listFiles((File)root, this)).$plus$plus((Function0 & Serializable & scala.Serializable)() -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])root2.resources())).toIterator().flatMap((Function1 & Serializable & scala.Serializable)root -> VFUtils$.MODULE$.listFiles((File)root, this)))));
        Iterator<VirtualFile> wrapper = new Iterator<VirtualFile>(this, result){
            private final /* synthetic */ ProjectFileSystemService $outer;
            private final Iterator result$1;

            public String toString() {
                return Iterator.toString$((Iterator)this);
            }

            public boolean hasNext() {
                return this.result$1.hasNext();
            }

            public VirtualFile next() {
                VirtualFile next = (VirtualFile)this.result$1.next();
                this.$outer.org$mule$weave$lsp$vfs$ProjectFileSystemService$$openedFiles().add((Object)next.url());
                return next;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.result$1 = result$1;
                GenTraversableOnce.$init$((GenTraversableOnce)this);
                TraversableOnce.$init$((TraversableOnce)this);
                Iterator.$init$((Iterator)this);
            }
        };
        return (java.util.Iterator)JavaConverters$.MODULE$.asJavaIteratorConverter((Iterator)wrapper).asJava();
    }

    public static final /* synthetic */ boolean $anonfun$sourceRootOf$4(String uri$2, File root) {
        Option<Path> maybePath = URLUtils$.MODULE$.toPath(uri$2);
        return maybePath.exists((Function1 & Serializable & scala.Serializable)path -> BoxesRunTime.boxToBoolean((boolean)path.startsWith(root.toPath())));
    }

    public ProjectFileSystemService(JarFileNameIdentifierResolver jarFileNameIdentifierResolver) {
        this.jarFileNameIdentifierResolver = jarFileNameIdentifierResolver;
        VirtualFileSystem.$init$((VirtualFileSystem)this);
        ToolingService.$init$(this);
        this.inMemoryFiles = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.org$mule$weave$lsp$vfs$ProjectFileSystemService$$openedFiles = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.vfsChangeListeners = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.logger = Logger.getLogger(this.getClass().getName());
    }
}

