/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.lsp.agent;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.mule.weave.extension.api.component.dependency.DependencyArtifact;
import org.mule.weave.extension.api.project.ProjectMetadata;
import org.mule.weave.lsp.agent.AgentClasspathResolver;
import org.mule.weave.lsp.agent.FutureValue;
import org.mule.weave.lsp.agent.FutureValue$;
import org.mule.weave.lsp.agent.WeaveTypeBind;
import org.mule.weave.lsp.extension.protocol.PreviewResult;
import org.mule.weave.lsp.extension.protocol.PreviewResult$;
import org.mule.weave.lsp.project.ProjectKind;
import org.mule.weave.lsp.project.components.ClassPathConfig;
import org.mule.weave.lsp.project.components.ClassPathConfig$;
import org.mule.weave.lsp.project.components.JavaWeaveLauncher$;
import org.mule.weave.lsp.project.components.ProjectStructureHelper$;
import org.mule.weave.lsp.project.components.Scenario;
import org.mule.weave.lsp.project.events.DependencyArtifactResolvedEvent$;
import org.mule.weave.lsp.project.events.OnDependencyArtifactResolved;
import org.mule.weave.lsp.project.events.OnProjectStarted;
import org.mule.weave.lsp.project.events.ProjectStartedEvent$;
import org.mule.weave.lsp.services.ClientLogger;
import org.mule.weave.lsp.services.ClientLoggerFactory;
import org.mule.weave.lsp.services.DataWeaveToolingService;
import org.mule.weave.lsp.services.ToolingService;
import org.mule.weave.lsp.services.WeaveScenarioManagerService;
import org.mule.weave.lsp.services.events.AgentStartedEvent;
import org.mule.weave.lsp.services.events.AgentStoppedEvent;
import org.mule.weave.lsp.utils.IOUtils$;
import org.mule.weave.lsp.utils.InternalEventBus;
import org.mule.weave.lsp.utils.NetUtils$;
import org.mule.weave.lsp.utils.ProcessStreamLineConsumer;
import org.mule.weave.v2.agent.api.event.DataFormatsDefinitionsEvent;
import org.mule.weave.v2.agent.api.event.ImplicitInputTypesEvent;
import org.mule.weave.v2.agent.api.event.InferWeaveTypeEvent;
import org.mule.weave.v2.agent.api.event.ModuleResolvedEvent;
import org.mule.weave.v2.agent.api.event.PreviewExecutedEvent;
import org.mule.weave.v2.agent.api.event.PreviewExecutedFailedEvent;
import org.mule.weave.v2.agent.api.event.PreviewExecutedSuccessfulEvent;
import org.mule.weave.v2.agent.api.event.UnexpectedServerErrorEvent;
import org.mule.weave.v2.agent.api.event.WeaveDataFormatDescriptor;
import org.mule.weave.v2.agent.api.event.WeaveDataFormatProperty;
import org.mule.weave.v2.agent.client.ClientProtocol;
import org.mule.weave.v2.agent.client.ConnectionRetriesListener;
import org.mule.weave.v2.agent.client.DataFormatDefinitionListener;
import org.mule.weave.v2.agent.client.ImplicitWeaveTypesListener;
import org.mule.weave.v2.agent.client.ModuleLoadedListener;
import org.mule.weave.v2.agent.client.PreviewExecutedListener;
import org.mule.weave.v2.agent.client.WeaveAgentClient;
import org.mule.weave.v2.agent.client.WeaveTypeInferListener;
import org.mule.weave.v2.agent.client.tcp.TcpClientProtocol;
import org.mule.weave.v2.completion.DataFormatDescriptor;
import org.mule.weave.v2.completion.DataFormatDescriptor$;
import org.mule.weave.v2.completion.DataFormatProperty;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.sdk.WeaveResource;
import org.mule.weave.v2.sdk.WeaveResource$;
import org.mule.weave.v2.ts.WeaveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\r-a\u0001\u0002\u001b6\u0001\u0001C\u0001\"\u0014\u0001\u0003\u0002\u0003\u0006IA\u0014\u0005\t#\u0002\u0011\t\u0011)A\u0005%\"AA\f\u0001B\u0001B\u0003%Q\f\u0003\u0005a\u0001\t\u0005\t\u0015!\u0003b\u0011!Q\u0007A!A!\u0002\u0013Y\u0007\u0002\u00038\u0001\u0005\u0003\u0005\u000b\u0011B8\t\u000bM\u0004A\u0011\u0001;\t\u000fq\u0004!\u0019!C\u0005{\"9\u0011\u0011\u0002\u0001!\u0002\u0013q\b\"CA\u0006\u0001\t\u0007I\u0011BA\u0007\u0011!\t)\u0002\u0001Q\u0001\n\u0005=\u0001\"CA\f\u0001\t\u0007I\u0011AA\r\u0011!\t9\u0003\u0001Q\u0001\n\u0005m\u0001\"CA\u0015\u0001\t\u0007I\u0011AA\r\u0011!\tY\u0003\u0001Q\u0001\n\u0005m\u0001\"CA\u0017\u0001\t\u0007I\u0011AA\r\u0011!\ty\u0003\u0001Q\u0001\n\u0005m\u0001bCA\u0019\u0001\u0001\u0007\t\u0019!C\u0005\u0003gA1\"a\u000f\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002>!Y\u0011\u0011\n\u0001A\u0002\u0003\u0005\u000b\u0015BA\u001b\u0011-\tY\u0005\u0001a\u0001\u0002\u0004%I!!\u0014\t\u0017\u0005\u0005\u0004\u00011AA\u0002\u0013%\u00111\r\u0005\f\u0003O\u0002\u0001\u0019!A!B\u0013\ty\u0005C\u0006\u0002j\u0001\u0001\r\u00111A\u0005\n\u0005-\u0004bCA<\u0001\u0001\u0007\t\u0019!C\u0005\u0003sB1\"! \u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002n!I\u0011q\u0010\u0001C\u0002\u0013%\u0011\u0011\u0011\u0005\t\u0003\u001f\u0003\u0001\u0015!\u0003\u0002\u0004\"Y\u0011\u0011\u0013\u0001A\u0002\u0003\u0007I\u0011BAJ\u0011-\t\t\u000b\u0001a\u0001\u0002\u0004%I!a)\t\u0017\u0005\u001d\u0006\u00011A\u0001B\u0003&\u0011Q\u0013\u0005\b\u0003S\u0003A\u0011IAV\u0011\u001d\t\t\f\u0001C\u0001\u0003gCq!!.\u0001\t\u0003\t\u0019\fC\u0004\u00028\u0002!I!!/\t\u000f\u0005\u0005\u0007\u0001\"\u0003\u0002D\"9\u00111\u001a\u0001\u0005B\u0005M\u0006bBAg\u0001\u0011\u0005\u0011q\u001a\u0005\b\u0003s\u0004A\u0011AA~\u0011\u001d\u0011I\u0003\u0001C\u0001\u0005WAqA!\f\u0001\t\u0013\t\u0019\rC\u0004\u00030\u0001!\tA!\r\t\u000f\t\u0015\u0003\u0001\"\u0001\u0003H!9!\u0011\f\u0001\u0005\u0002\tm\u0003b\u0002B-\u0001\u0011\u0005!1\u0012\u0005\b\u0005s\u0003A\u0011\u0002B^\u0011%\u0011\u0019\rAI\u0001\n\u0013\u0011)\rC\u0004\u0003\\\u0002!\tA!8\t\u000f\t=\b\u0001\"\u0003\u0003r\"91q\u0001\u0001\u0005B\u0005M\u0006bBB\u0005\u0001\u0011%\u00111\u0017\u0002\u0012/\u0016\fg/Z!hK:$8+\u001a:wS\u000e,'B\u0001\u001c8\u0003\u0015\tw-\u001a8u\u0015\tA\u0014(A\u0002mgBT!AO\u001e\u0002\u000b],\u0017M^3\u000b\u0005qj\u0014\u0001B7vY\u0016T\u0011AP\u0001\u0004_J<7\u0001A\n\u0004\u0001\u0005;\u0005C\u0001\"F\u001b\u0005\u0019%\"\u0001#\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001b%AB!osJ+g\r\u0005\u0002I\u00176\t\u0011J\u0003\u0002Ko\u0005A1/\u001a:wS\u000e,7/\u0003\u0002M\u0013\nqAk\\8mS:<7+\u001a:wS\u000e,\u0017!\u0005<bY&$\u0017\r^5p]N+'O^5dKB\u0011\u0001jT\u0005\u0003!&\u0013q\u0003R1uC^+\u0017M^3U_>d\u0017N\\4TKJ4\u0018nY3\u0002\u0011\u0015DXmY;u_J\u0004\"a\u0015.\u000e\u0003QS!!\u0016,\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002X1\u0006!Q\u000f^5m\u0015\u0005I\u0016\u0001\u00026bm\u0006L!a\u0017+\u0003\u0011\u0015CXmY;u_J\fQ\u0002\\8hO\u0016\u0014h)Y2u_JL\bC\u0001%_\u0013\ty\u0016JA\nDY&,g\u000e\u001e'pO\u001e,'OR1di>\u0014\u00180A\u0004qe>TWm\u0019;\u0011\u0005\tDW\"A2\u000b\u0005\u0001$'BA3g\u0003\r\t\u0007/\u001b\u0006\u0003Of\n\u0011\"\u001a=uK:\u001c\u0018n\u001c8\n\u0005%\u001c'a\u0004)s_*,7\r^'fi\u0006$\u0017\r^1\u0002-M\u001cWM\\1sS>l\u0015M\\1hKJ\u001cVM\u001d<jG\u0016\u0004\"\u0001\u00137\n\u00055L%aG,fCZ,7kY3oCJLw.T1oC\u001e,'oU3sm&\u001cW-A\tdY\u0006\u001c8\u000f]1uQJ+7o\u001c7wKJ\u0004\"\u0001]9\u000e\u0003UJ!A]\u001b\u0003-\u0005;WM\u001c;DY\u0006\u001c8\u000f]1uQJ+7o\u001c7wKJ\fa\u0001P5oSRtDcB;wobL(p\u001f\t\u0003a\u0002AQ!T\u0004A\u00029CQ!U\u0004A\u0002ICQ\u0001X\u0004A\u0002uCQ\u0001Y\u0004A\u0002\u0005DQA[\u0004A\u0002-DQA\\\u0004A\u0002=\fa\u0001\\8hO\u0016\u0014X#\u0001@\u0011\u0007}\f)!\u0004\u0002\u0002\u0002)\u0019\u00111A\u001f\u0002\u000bMdg\r\u000e6\n\t\u0005\u001d\u0011\u0011\u0001\u0002\u0007\u0019><w-\u001a:\u0002\u000f1|wmZ3sA\u0005a1\r\\5f]RdunZ4feV\u0011\u0011q\u0002\t\u0004\u0011\u0006E\u0011bAA\n\u0013\na1\t\\5f]RdunZ4fe\u0006i1\r\\5f]RdunZ4fe\u0002\n\u0001%Q$F\u001dR{6+\u0012*W\u000bJ{F*Q+O\u0007\"+%kX'B\u0013:{6\tT!T'V\u0011\u00111\u0004\t\u0005\u0003;\t\u0019#\u0004\u0002\u0002 )\u0019\u0011\u0011\u0005-\u0002\t1\fgnZ\u0005\u0005\u0003K\tyB\u0001\u0004TiJLgnZ\u0001\"\u0003\u001e+e\nV0T\u000bJ3VIU0M\u0003Vs5\tS#S?6\u000b\u0015JT0D\u0019\u0006\u001b6\u000bI\u0001\u000b\u0019&;\u0005\nV0H%\u0016K\u0016a\u0003'J\u000f\"#vl\u0012*F3\u0002\n1AU#E\u0003\u0011\u0011V\t\u0012\u0011\u0002\u0019\u0005<WM\u001c;Qe>\u001cWm]:\u0016\u0005\u0005U\u0002\u0003BA\u000f\u0003oIA!!\u000f\u0002 \t9\u0001K]8dKN\u001c\u0018\u0001E1hK:$\bK]8dKN\u001cx\fJ3r)\u0011\ty$!\u0012\u0011\u0007\t\u000b\t%C\u0002\u0002D\r\u0013A!\u00168ji\"I\u0011qI\n\u0002\u0002\u0003\u0007\u0011QG\u0001\u0004q\u0012\n\u0014!D1hK:$\bK]8dKN\u001c\b%\u0001\txK\u00064X-Q4f]R\u001cE.[3oiV\u0011\u0011q\n\t\u0005\u0003#\ni&\u0004\u0002\u0002T)!\u0011QKA,\u0003\u0019\u0019G.[3oi*\u0019a'!\u0017\u000b\u0007\u0005m\u0013(\u0001\u0002we%!\u0011qLA*\u0005A9V-\u0019<f\u0003\u001e,g\u000e^\"mS\u0016tG/\u0001\u000bxK\u00064X-Q4f]R\u001cE.[3oi~#S-\u001d\u000b\u0005\u0003\u007f\t)\u0007C\u0005\u0002HY\t\t\u00111\u0001\u0002P\u0005\tr/Z1wK\u0006;WM\u001c;DY&,g\u000e\u001e\u0011\u0002\u0017A\u0014xN[3di.Kg\u000eZ\u000b\u0003\u0003[\u0002B!a\u001c\u0002t5\u0011\u0011\u0011\u000f\u0006\u0003A^JA!!\u001e\u0002r\tY\u0001K]8kK\u000e$8*\u001b8e\u0003=\u0001(o\u001c6fGR\\\u0015N\u001c3`I\u0015\fH\u0003BA \u0003wB\u0011\"a\u0012\u001a\u0003\u0003\u0005\r!!\u001c\u0002\u0019A\u0014xN[3di.Kg\u000e\u001a\u0011\u0002\u001dM$\u0018M\u001d;BO\u0016tG\u000fT8dWV\u0011\u00111\u0011\t\u0005\u0003\u000b\u000bY)\u0004\u0002\u0002\b*\u0019\u0011\u0011\u0012+\u0002\u000b1|7m[:\n\t\u00055\u0015q\u0011\u0002\u0005\u0019>\u001c7.A\bti\u0006\u0014H/Q4f]RdunY6!\u0003!)g/\u001a8u\u0005V\u001cXCAAK!\u0011\t9*!(\u000e\u0005\u0005e%bAANo\u0005)Q\u000f^5mg&!\u0011qTAM\u0005AIe\u000e^3s]\u0006dWI^3oi\n+8/\u0001\u0007fm\u0016tGOQ;t?\u0012*\u0017\u000f\u0006\u0003\u0002@\u0005\u0015\u0006\"CA$=\u0005\u0005\t\u0019AAK\u0003%)g/\u001a8u\u0005V\u001c\b%\u0001\u0006j]&$\u0018.\u00197ju\u0016$b!a\u0010\u0002.\u0006=\u0006bBA5A\u0001\u0007\u0011Q\u000e\u0005\b\u0003#\u0003\u0003\u0019AAK\u0003\u001d\u0011Xm\u001d;beR$\"!a\u0010\u0002\u0015M$\u0018M\u001d;BO\u0016tG/A\u0007bO\u0016tG/\u0012=ji\u000e{G-Z\u000b\u0003\u0003w\u00032AQA_\u0013\r\tyl\u0011\u0002\u0004\u0013:$\u0018AD5t!J|7-Z:t\u00032Lg/Z\u000b\u0003\u0003\u000b\u00042AQAd\u0013\r\tIm\u0011\u0002\b\u0005>|G.Z1o\u0003-Ig.\u001b;jC2L'0\u001a3\u0002;%tg-\u001a:J]B,H/T3uC\u0012\fG/\u0019$peN\u001bWM\\1sS>$B!!5\u0002jB)1+a5\u0002X&\u0019\u0011Q\u001b+\u0003#\r{W\u000e\u001d7fi\u0006\u0014G.\u001a$viV\u0014X\rE\u0003C\u00033\fi.C\u0002\u0002\\\u000e\u0013aa\u00149uS>t\u0007#\u0002\"\u0002`\u0006\r\u0018bAAq\u0007\n)\u0011I\u001d:bsB\u0019\u0001/!:\n\u0007\u0005\u001dXGA\u0007XK\u00064X\rV=qK\nKg\u000e\u001a\u0005\b\u0003W4\u0003\u0019AAw\u0003!\u00198-\u001a8be&|\u0007\u0003BAx\u0003kl!!!=\u000b\t\u0005M\u0018\u0011O\u0001\u000bG>l\u0007o\u001c8f]R\u001c\u0018\u0002BA|\u0003c\u0014\u0001bU2f]\u0006\u0014\u0018n\\\u0001\u000ee\u0016\u001cx\u000e\u001c<f\u001b>$W\u000f\\3\u0015\r\u0005u(Q\u0002B\u0013!\u0015\u0019\u00161[A\u0000!\u0015\u0011\u0015\u0011\u001cB\u0001!\u0011\u0011\u0019A!\u0003\u000e\u0005\t\u0015!\u0002\u0002B\u0004\u00033\n1a\u001d3l\u0013\u0011\u0011YA!\u0002\u0003\u001b]+\u0017M^3SKN|WO]2f\u0011\u001d\u0011ya\na\u0001\u0005#\t!\"\u001b3f]RLg-[3s!\u0011\u0011\u0019B!\t\u000f\t\tU!Q\u0004\t\u0004\u0005/\u0019UB\u0001B\r\u0015\r\u0011YbP\u0001\u0007yI|w\u000e\u001e \n\u0007\t}1)\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003K\u0011\u0019CC\u0002\u0003 \rCqAa\n(\u0001\u0004\u0011\t\"\u0001\u0004m_\u0006$WM]\u0001\u000fG\",7m[\"p]:,7\r^3e)\t\t)-\u0001\bjg\u0012K7oY8o]\u0016\u001cG/\u001a3\u0002=%tg-\u001a:PkR\u0004X\u000f^'fi\u0006$\u0017\r^1G_J\u001c6-\u001a8be&|G\u0003\u0002B\u001a\u0005\u0007\u0002RaUAj\u0005k\u0001RAQAm\u0005o\u0001BA!\u000f\u0003@5\u0011!1\b\u0006\u0005\u0005{\tI&\u0001\u0002ug&!!\u0011\tB\u001e\u0005%9V-\u0019<f)f\u0004X\rC\u0004\u0002l*\u0002\r!!<\u0002\u0017\u0011\fG/\u0019$pe6\fGo\u001d\u000b\u0003\u0005\u0013\u0002RAQAp\u0005\u0017\u0002BA!\u0014\u0003V5\u0011!q\n\u0006\u0005\u0005#\u0012\u0019&A\u0003fm\u0016tGOC\u0002f\u0003/JAAa\u0016\u0003P\tIr+Z1wK\u0012\u000bG/\u0019$pe6\fG\u000fR3tGJL\u0007\u000f^8s\u0003\r\u0011XO\u001c\u000b\t\u0005;\u0012YGa!\u0003\bB!!q\fB4\u001b\t\u0011\tG\u0003\u0003\u0003d\t\u0015\u0014\u0001\u00039s_R|7m\u001c7\u000b\u0005\u001d<\u0014\u0002\u0002B5\u0005C\u0012Q\u0002\u0015:fm&,wOU3tk2$\bb\u0002B7Y\u0001\u0007!qN\u0001\u000f]\u0006lW-\u00133f]RLg-[3s!\u0011\u0011\tHa \u000e\u0005\tM$\u0002\u0002B;\u0005o\n\u0011B^1sS\u0006\u0014G.Z:\u000b\t\te$1P\u0001\u0004CN$(\u0002\u0002B?\u00033\na\u0001]1sg\u0016\u0014\u0018\u0002\u0002BA\u0005g\u0012aBT1nK&#WM\u001c;jM&,'\u000fC\u0004\u0003\u00062\u0002\rA!\u0005\u0002\u000f\r|g\u000e^3oi\"9!\u0011\u0012\u0017A\u0002\tE\u0011aA;sYR\u0011\"Q\fBG\u0005\u001f\u0013\tJa%\u0003\u001a\n\r&\u0011\u0016B[\u0011\u001d\u0011i'\fa\u0001\u0005_BqA!\".\u0001\u0004\u0011\t\u0002C\u0004\u0003\n6\u0002\rA!\u0005\t\u000f\tUU\u00061\u0001\u0003\u0018\u0006y\u0001O]3wS\u0016<8kY3oCJLw\u000eE\u0003C\u00033\fi\u000fC\u0004\u0003\u001c6\u0002\rA!(\u0002#I,h\u000e^5nKB\u0013x\u000e]3si&,7\u000f\u0005\u0005\u0003\u0014\t}%\u0011\u0003B\t\u0013\u0011\u0011\tKa\t\u0003\u00075\u000b\u0007\u000fC\u0004\u0003&6\u0002\rAa*\u0002\u001d=,H\u000f];u\u001b&lW\rV=qKB)!)!7\u0003\u0012!9!1V\u0017A\u0002\t5\u0016\u0001D7bs\n,G+[7f_V$\b#\u0002\"\u0002Z\n=\u0006c\u0001\"\u00032&\u0019!1W\"\u0003\t1{gn\u001a\u0005\b\u0005ok\u0003\u0019AAc\u0003I9\u0018\u000e\u001e5UKN$8o\u00117bgN\u0004\u0018\r\u001e5\u0002/\r\fGnY;mCR,Gj\\2bY\u000ec\u0017m]:qCRDG\u0003\u0002B_\u0005\u007f\u0003RAQAp\u0005#A\u0011B!1/!\u0003\u0005\r!!2\u0002\u0013]LG\u000f\u001b+fgR\u001c\u0018!I2bY\u000e,H.\u0019;f\u0019>\u001c\u0017\r\\\"mCN\u001c\b/\u0019;iI\u0011,g-Y;mi\u0012\nTC\u0001BdU\u0011\t)M!3,\u0005\t-\u0007\u0003\u0002Bg\u0005/l!Aa4\u000b\t\tE'1[\u0001\nk:\u001c\u0007.Z2lK\u0012T1A!6D\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u00053\u0014yMA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f!\u0003Z3gS:,G\rR1uC\u001a{'/\\1ugR\u0011!q\u001c\t\u0006'\u0006M'\u0011\u001d\t\u0006\u0005\u0006}'1\u001d\t\u0005\u0005K\u0014Y/\u0004\u0002\u0003h*!!\u0011^A-\u0003)\u0019w.\u001c9mKRLwN\\\u0005\u0005\u0005[\u00149O\u0001\u000bECR\fgi\u001c:nCR$Um]2sSB$xN]\u0001\u0011i>$\u0015\r^1G_Jl\u0017\r\u001e)s_B$BAa=\u0003|B)!)a8\u0003vB!!Q\u001dB|\u0013\u0011\u0011IPa:\u0003%\u0011\u000bG/\u0019$pe6\fG\u000f\u0015:pa\u0016\u0014H/\u001f\u0005\b\u0005{\f\u0004\u0019\u0001B\u0000\u0003i9X-\u0019<f\t\u0006$\u0018MR8s[\u0006$\bK]8qKJ$\u0018pU3r!\u0015\u0011\u0015q\\B\u0001!\u0011\u0011iea\u0001\n\t\r\u0015!q\n\u0002\u0018/\u0016\fg/\u001a#bi\u00064uN]7biB\u0013x\u000e]3sif\fAa\u001d;pa\u0006I1\u000f^8q\u0003\u001e,g\u000e\u001e")
public class WeaveAgentService
implements ToolingService {
    public final DataWeaveToolingService org$mule$weave$lsp$agent$WeaveAgentService$$validationService;
    private final Executor executor;
    private final ProjectMetadata project;
    private final WeaveScenarioManagerService scenarioManagerService;
    private final AgentClasspathResolver classpathResolver;
    private final Logger logger;
    private final ClientLogger org$mule$weave$lsp$agent$WeaveAgentService$$clientLogger;
    private final String AGENT_SERVER_LAUNCHER_MAIN_CLASS;
    private final String LIGHT_GREY;
    private final String RED;
    private Process agentProcess;
    private WeaveAgentClient weaveAgentClient;
    private ProjectKind projectKind;
    private final Lock startAgentLock;
    private InternalEventBus eventBus;

    private Logger logger() {
        return this.logger;
    }

    public ClientLogger org$mule$weave$lsp$agent$WeaveAgentService$$clientLogger() {
        return this.org$mule$weave$lsp$agent$WeaveAgentService$$clientLogger;
    }

    public String AGENT_SERVER_LAUNCHER_MAIN_CLASS() {
        return this.AGENT_SERVER_LAUNCHER_MAIN_CLASS;
    }

    public String LIGHT_GREY() {
        return this.LIGHT_GREY;
    }

    public String RED() {
        return this.RED;
    }

    private Process agentProcess() {
        return this.agentProcess;
    }

    private void agentProcess_$eq(Process x$1) {
        this.agentProcess = x$1;
    }

    private WeaveAgentClient weaveAgentClient() {
        return this.weaveAgentClient;
    }

    private void weaveAgentClient_$eq(WeaveAgentClient x$1) {
        this.weaveAgentClient = x$1;
    }

    private ProjectKind projectKind() {
        return this.projectKind;
    }

    private void projectKind_$eq(ProjectKind x$1) {
        this.projectKind = x$1;
    }

    private Lock startAgentLock() {
        return this.startAgentLock;
    }

    private InternalEventBus eventBus() {
        return this.eventBus;
    }

    private void eventBus_$eq(InternalEventBus x$1) {
        this.eventBus = x$1;
    }

    @Override
    public void initialize(ProjectKind projectKind, InternalEventBus eventBus) {
        this.eventBus_$eq(eventBus);
        this.projectKind_$eq(projectKind);
        eventBus.register(DependencyArtifactResolvedEvent$.MODULE$.ARTIFACT_RESOLVED(), new OnDependencyArtifactResolved(this){
            private final /* synthetic */ WeaveAgentService $outer;

            public void onArtifactsResolved(DependencyArtifact[] artifacts) {
                this.$outer.restart();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        eventBus.register(ProjectStartedEvent$.MODULE$.PROJECT_STARTED(), new OnProjectStarted(this){
            private final /* synthetic */ WeaveAgentService $outer;

            public void onProjectStarted(ProjectMetadata projectMetadata) {
                this.$outer.startAgent();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void restart() {
        this.stopAgent();
        this.startAgent();
    }

    public void startAgent() {
        if (this.startAgentLock().tryLock()) {
            this.logger().debug("Locked startAgent");
            try {
                if (!this.org$mule$weave$lsp$agent$WeaveAgentService$$isProcessAlive()) {
                    int port = NetUtils$.MODULE$.freePort();
                    Seq<String> jars = this.classpathResolver.resolveClasspathJars();
                    if (jars.isEmpty()) {
                        this.logger().error("Could not resolve agent jars");
                    }
                    boolean x$1 = false;
                    Seq<String> x$2 = jars;
                    boolean x$3 = ClassPathConfig$.MODULE$.apply$default$2();
                    ClassPathConfig classpathCfg = new ClassPathConfig(x$1, x$3, x$2);
                    ArrayList<String> commandArgs = JavaWeaveLauncher$.MODULE$.buildJavaProcessBaseArgs(this.projectKind(), classpathCfg, this.AGENT_SERVER_LAUNCHER_MAIN_CLASS(), JavaWeaveLauncher$.MODULE$.buildJavaProcessBaseArgs$default$4());
                    ProcessBuilder builder = new ProcessBuilder(new String[0]);
                    ArrayList<String> args = new ArrayList<String>();
                    args.addAll(commandArgs);
                    args.add("-p");
                    args.add(Integer.toString(port));
                    builder.command(args);
                    this.agentProcess_$eq(builder.start());
                    this.logger().debug(new StringBuilder(16).append("Starting Agent: ").append(((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(args).asScala()).mkString(" ")).toString());
                    this.org$mule$weave$lsp$agent$WeaveAgentService$$clientLogger().logInfo("Starting DataWeave Agent");
                    ProcessStreamLineConsumer processStreamLineConsumer = new ProcessStreamLineConsumer(this){
                        private final /* synthetic */ WeaveAgentService $outer;

                        public void onStdErrorLineRead(String line) {
                            this.$outer.org$mule$weave$lsp$agent$WeaveAgentService$$clientLogger().logError(String.valueOf(line));
                        }

                        public void onStdOutLineRead(String line) {
                            this.$outer.org$mule$weave$lsp$agent$WeaveAgentService$$clientLogger().logInfo(String.valueOf(line));
                        }

                        public void onIOException(IOException ioException) {
                            this.$outer.org$mule$weave$lsp$agent$WeaveAgentService$$clientLogger().logError("Error on Agent", ioException);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    };
                    IOUtils$.MODULE$.forwardProcessStream(this.agentProcess(), this.executor, processStreamLineConsumer);
                    TcpClientProtocol clientProtocol = new TcpClientProtocol("localhost", port);
                    this.weaveAgentClient_$eq(new WeaveAgentClient((ClientProtocol)clientProtocol));
                    this.org$mule$weave$lsp$agent$WeaveAgentService$$clientLogger().logInfo(new StringBuilder(45).append("DataWeave Agent Client trying to connect at: ").append(port).toString());
                    this.weaveAgentClient().connect(50, 500L, new ConnectionRetriesListener(this, port){
                        private final /* synthetic */ WeaveAgentService $outer;
                        private final int port$1;

                        public void startConnecting() {
                            this.$outer.org$mule$weave$lsp$agent$WeaveAgentService$$clientLogger().logInfo(new StringBuilder(37).append("DataWeave Agent start connecting at: ").append(this.port$1).toString());
                        }

                        public void connectedSuccessfully() {
                            this.$outer.org$mule$weave$lsp$agent$WeaveAgentService$$clientLogger().logInfo(new StringBuilder(30).append("DataWeave Agent connected at: ").append(this.port$1).toString());
                        }

                        public void failToConnect(String reason) {
                            this.$outer.org$mule$weave$lsp$agent$WeaveAgentService$$clientLogger().logError(new StringBuilder(36).append("Fail to connect to DataWeave Agent: ").append(reason).toString());
                        }

                        public boolean onRetry(int count, int total) {
                            if (!this.$outer.org$mule$weave$lsp$agent$WeaveAgentService$$isProcessAlive()) {
                                this.$outer.org$mule$weave$lsp$agent$WeaveAgentService$$clientLogger().logError(new StringBuilder(67).append("Will not retry as process is no longer alive and exit code was: `").append(this.$outer.org$mule$weave$lsp$agent$WeaveAgentService$$agentExitCode()).append("`.").toString());
                                return false;
                            }
                            this.$outer.org$mule$weave$lsp$agent$WeaveAgentService$$clientLogger().logError(new StringBuilder(23).append("Retrying to connect: ").append(count).append("/").append(total).append(".").toString());
                            return true;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.port$1 = port$1;
                        }
                    });
                    if (!this.weaveAgentClient().isConnected()) {
                        this.org$mule$weave$lsp$agent$WeaveAgentService$$clientLogger().logError("Unable to connect to Weave Agent");
                    } else {
                        this.org$mule$weave$lsp$agent$WeaveAgentService$$clientLogger().logInfo(new StringBuilder(32).append("Weave Agent Started at port: `").append(port).append("`.").toString());
                        this.eventBus().fire(new AgentStartedEvent());
                    }
                }
            }
            finally {
                this.startAgentLock().unlock();
            }
            return;
        }
    }

    public int org$mule$weave$lsp$agent$WeaveAgentService$$agentExitCode() {
        if (this.agentProcess() == null) {
            return -1;
        }
        return this.agentProcess().exitValue();
    }

    public boolean org$mule$weave$lsp$agent$WeaveAgentService$$isProcessAlive() {
        return this.agentProcess() != null && this.agentProcess().isAlive();
    }

    @Override
    public void initialized() {
    }

    public CompletableFuture<Option<WeaveTypeBind[]>> inferInputMetadataForScenario(Scenario scenario) {
        return CompletableFuture.supplyAsync(() -> {
            if (this.checkConnected()) {
                FutureValue result = new FutureValue(FutureValue$.MODULE$.$lessinit$greater$default$1());
                this.weaveAgentClient().inferInputsWeaveType(scenario.inputsDirectory().getAbsolutePath(), new ImplicitWeaveTypesListener(this, result){
                    private final /* synthetic */ WeaveAgentService $outer;
                    private final FutureValue result$1;

                    public void onImplicitWeaveTypesCalculated(ImplicitInputTypesEvent event) {
                        WeaveTypeBind[] binds = (WeaveTypeBind[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])event.types())).flatMap((Function1 & Serializable & scala.Serializable)m -> Option$.MODULE$.option2Iterable($this.$outer.org$mule$weave$lsp$agent$WeaveAgentService$$validationService.loadType(m.wtypeString()).map((Function1 & Serializable & scala.Serializable)wt -> new WeaveTypeBind(m.name(), (WeaveType)wt))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(WeaveTypeBind.class)));
                        this.result$1.set(new Some((Object)binds));
                    }

                    public void onUnexpectedError(UnexpectedServerErrorEvent unexpectedServerErrorEvent) {
                        this.$outer.org$mule$weave$lsp$agent$WeaveAgentService$$clientLogger().logError(new StringBuilder(54).append("Unexpected error at 'inferInputsWeaveType' caused by: ").append(unexpectedServerErrorEvent.stacktrace()).toString());
                        this.result$1.set(None$.MODULE$);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.result$1 = result$1;
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onImplicitWeaveTypesCalculated$1(org.mule.weave.lsp.agent.WeaveAgentService$$anon$5 org.mule.weave.v2.agent.api.event.WeaveTypeEntry ), $anonfun$onImplicitWeaveTypesCalculated$2(org.mule.weave.v2.agent.api.event.WeaveTypeEntry org.mule.weave.v2.ts.WeaveType )}, serializedLambda);
                    }
                });
                return result.get().flatten(Predef$.MODULE$.$conforms());
            }
            return None$.MODULE$;
        }, this.executor);
    }

    public CompletableFuture<Option<WeaveResource>> resolveModule(String identifier, String loader) {
        return CompletableFuture.supplyAsync(() -> {
            if (this.checkConnected()) {
                FutureValue result = new FutureValue(FutureValue$.MODULE$.$lessinit$greater$default$1());
                this.weaveAgentClient().resolveModule(identifier, loader, this.calculateLocalClasspath(this.calculateLocalClasspath$default$1()), new ModuleLoadedListener(this, result){
                    private final /* synthetic */ WeaveAgentService $outer;
                    private final FutureValue result$2;

                    public void onModuleLoaded(ModuleResolvedEvent resultEvent) {
                        None$ maybeUrl;
                        Object object = maybeUrl = resultEvent.url() == null ? None$.MODULE$ : resultEvent.url();
                        if (resultEvent.content().isDefined()) {
                            String content = (String)resultEvent.content().getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
                            String url = (String)maybeUrl.getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
                            this.result$2.set(new Some((Object)WeaveResource$.MODULE$.apply(url, content)));
                            return;
                        }
                        this.result$2.set(None$.MODULE$);
                    }

                    public void onUnexpectedError(UnexpectedServerErrorEvent unexpectedServerErrorEvent) {
                        this.$outer.org$mule$weave$lsp$agent$WeaveAgentService$$clientLogger().logError(new StringBuilder(47).append("Unexpected error at 'resolveModule' caused by: ").append(unexpectedServerErrorEvent.stacktrace()).toString());
                        this.result$2.set(None$.MODULE$);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.result$2 = result$2;
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onModuleLoaded$1(), $anonfun$onModuleLoaded$2()}, serializedLambda);
                    }
                });
                return result.get().flatten(Predef$.MODULE$.$conforms());
            }
            return None$.MODULE$;
        }, this.executor);
    }

    public boolean checkConnected() {
        if (this.isDisconnected()) {
            this.org$mule$weave$lsp$agent$WeaveAgentService$$clientLogger().logInfo("Restarting Agent as is not initialized.");
            this.restart();
        }
        return this.weaveAgentClient() != null && this.weaveAgentClient().isConnected();
    }

    private boolean isDisconnected() {
        return this.weaveAgentClient() == null || !this.weaveAgentClient().isConnected() || !this.org$mule$weave$lsp$agent$WeaveAgentService$$isProcessAlive();
    }

    public CompletableFuture<Option<WeaveType>> inferOutputMetadataForScenario(Scenario scenario) {
        return CompletableFuture.supplyAsync(() -> {
            if (this.checkConnected()) {
                FutureValue result = new FutureValue(FutureValue$.MODULE$.$lessinit$greater$default$1());
                Option<File> maybeExpected = scenario.expected();
                if (maybeExpected.isDefined()) {
                    this.weaveAgentClient().inferWeaveType(((File)maybeExpected.get()).getAbsolutePath(), new WeaveTypeInferListener(this, result){
                        private final /* synthetic */ WeaveAgentService $outer;
                        private final FutureValue result$3;

                        public void onWeaveTypeInfer(InferWeaveTypeEvent event) {
                            this.result$3.set(this.$outer.org$mule$weave$lsp$agent$WeaveAgentService$$validationService.loadType(event.typeString()));
                        }

                        public void onUnexpectedError(UnexpectedServerErrorEvent unexpectedServerErrorEvent) {
                            this.$outer.org$mule$weave$lsp$agent$WeaveAgentService$$clientLogger().logError(new StringBuilder(64).append("Unexpected error at 'inferOutputMetadataForScenario' caused by: ").append(unexpectedServerErrorEvent.stacktrace()).toString());
                            this.result$3.set(None$.MODULE$);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.result$3 = result$3;
                        }
                    });
                    return result.get().flatten(Predef$.MODULE$.$conforms());
                }
                return None$.MODULE$;
            }
            return None$.MODULE$;
        }, this.executor);
    }

    public WeaveDataFormatDescriptor[] dataFormats() {
        if (this.checkConnected()) {
            FutureValue runResult = new FutureValue(FutureValue$.MODULE$.$lessinit$greater$default$1());
            this.weaveAgentClient().definedDataFormats(new DataFormatDefinitionListener(this, runResult){
                private final /* synthetic */ WeaveAgentService $outer;
                private final FutureValue runResult$1;

                public void onDataFormatDefinitionCalculated(DataFormatsDefinitionsEvent dfde) {
                    this.runResult$1.set(dfde.formats());
                }

                public void onUnexpectedError(UnexpectedServerErrorEvent unexpectedServerErrorEvent) {
                    this.$outer.org$mule$weave$lsp$agent$WeaveAgentService$$clientLogger().logError(new StringBuilder(52).append("Unexpected error at 'definedDataFormats' caused by: ").append(unexpectedServerErrorEvent.stacktrace()).toString());
                    this.runResult$1.set(Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(WeaveDataFormatDescriptor.class)));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.runResult$1 = runResult$1;
                }
            });
            return (WeaveDataFormatDescriptor[])runResult.get().getOrElse((Function0 & Serializable & scala.Serializable)() -> (WeaveDataFormatDescriptor[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(WeaveDataFormatDescriptor.class)));
        }
        return (WeaveDataFormatDescriptor[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(WeaveDataFormatDescriptor.class));
    }

    public PreviewResult run(NameIdentifier nameIdentifier, String content, String url) {
        Option<Scenario> maybeScenario = this.scenarioManagerService.activeScenario(nameIdentifier);
        return this.run(nameIdentifier, content, url, maybeScenario, (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)), (Option<String>)None$.MODULE$, (Option<Object>)None$.MODULE$, false);
    }

    public PreviewResult run(NameIdentifier nameIdentifier, String content, String url, Option<Scenario> previewScenario, Map<String, String> runtimeProperties, Option<String> outputMimeType, Option<Object> maybeTimeout, boolean withTestsClasspath) {
        if (this.checkConnected()) {
            long timeout = BoxesRunTime.unboxToLong((Object)maybeTimeout.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString($this.project.settings().previewTimeout().value())).toLong()));
            FutureValue runResult = new FutureValue(timeout * 2L);
            String[] classpath = this.calculateLocalClasspath(withTestsClasspath);
            String inputsPath = (String)previewScenario.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.inputsDirectory().getAbsolutePath()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
            long startTime = System.currentTimeMillis();
            PreviewExecutedListener weaveAgentClientListener = new PreviewExecutedListener(this, runResult, url, startTime){
                private final /* synthetic */ WeaveAgentService $outer;
                private final FutureValue runResult$2;
                private final String url$1;
                private final long startTime$1;

                public void onPreviewExecuted(PreviewExecutedEvent result) {
                    long endTime = System.currentTimeMillis();
                    PreviewExecutedEvent previewExecutedEvent = result;
                    if (previewExecutedEvent instanceof PreviewExecutedFailedEvent) {
                        PreviewExecutedFailedEvent previewExecutedFailedEvent = (PreviewExecutedFailedEvent)previewExecutedEvent;
                        String message = previewExecutedFailedEvent.message();
                        Seq messages = previewExecutedFailedEvent.messages();
                        String[] logsArray = (String[])((TraversableOnce)messages.map((Function1 & Serializable & scala.Serializable)m -> new StringBuilder(3).append(m.timestamp()).append(" : ").append(m.message()).toString(), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
                        String x$1 = message;
                        boolean x$2 = false;
                        List<Object> x$3 = Arrays.asList((Object[])logsArray);
                        String x$4 = this.url$1;
                        long x$5 = endTime - this.startTime$1;
                        String x$6 = PreviewResult$.MODULE$.apply$default$4();
                        String x$7 = PreviewResult$.MODULE$.apply$default$5();
                        String x$8 = PreviewResult$.MODULE$.apply$default$7();
                        String x$9 = PreviewResult$.MODULE$.apply$default$8();
                        this.runResult$2.set(new PreviewResult(x$4, x$2, x$3, x$6, x$7, x$1, x$8, x$9, x$5));
                        return;
                    }
                    if (previewExecutedEvent instanceof PreviewExecutedSuccessfulEvent) {
                        PreviewExecutedSuccessfulEvent previewExecutedSuccessfulEvent = (PreviewExecutedSuccessfulEvent)previewExecutedEvent;
                        byte[] result2 = previewExecutedSuccessfulEvent.result();
                        String mimeType = previewExecutedSuccessfulEvent.mimeType();
                        String extension = previewExecutedSuccessfulEvent.extension();
                        String encoding = previewExecutedSuccessfulEvent.encoding();
                        Seq messages = previewExecutedSuccessfulEvent.messages();
                        String[] logsArray = (String[])((TraversableOnce)messages.map((Function1 & Serializable & scala.Serializable)m -> new StringBuilder(3).append(m.timestamp()).append(" : ").append(m.message()).toString(), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
                        String x$10 = new String(result2, encoding);
                        String x$11 = mimeType;
                        boolean x$12 = true;
                        List<Object> x$13 = Arrays.asList((Object[])logsArray);
                        String x$14 = this.url$1;
                        long x$15 = endTime - this.startTime$1;
                        String x$16 = extension;
                        String x$17 = PreviewResult$.MODULE$.apply$default$6();
                        String x$18 = PreviewResult$.MODULE$.apply$default$7();
                        this.runResult$2.set(new PreviewResult(x$14, x$12, x$13, x$10, x$11, x$17, x$18, x$16, x$15));
                        return;
                    }
                    throw new MatchError((Object)previewExecutedEvent);
                }

                public void onUnexpectedError(UnexpectedServerErrorEvent unexpectedServerErrorEvent) {
                    long endTime = System.currentTimeMillis();
                    this.$outer.org$mule$weave$lsp$agent$WeaveAgentService$$clientLogger().logError(new StringBuilder(44).append("Unexpected error at 'runPreview' caused by: ").append(unexpectedServerErrorEvent.stacktrace()).toString());
                    String x$1 = "Unexpected error at 'runPreview'";
                    boolean x$2 = false;
                    List<Object> x$3 = Arrays.asList((Object[])new String[]{unexpectedServerErrorEvent.stacktrace()});
                    String x$4 = this.url$1;
                    long x$5 = endTime - this.startTime$1;
                    String x$6 = PreviewResult$.MODULE$.apply$default$4();
                    String x$7 = PreviewResult$.MODULE$.apply$default$5();
                    String x$8 = PreviewResult$.MODULE$.apply$default$7();
                    String x$9 = PreviewResult$.MODULE$.apply$default$8();
                    PreviewResult result = new PreviewResult(x$4, x$2, x$3, x$6, x$7, x$1, x$8, x$9, x$5);
                    this.runResult$2.set(result);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.runResult$2 = runResult$2;
                    this.url$1 = url$1;
                    this.startTime$1 = startTime$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onPreviewExecuted$1(org.mule.weave.v2.agent.api.event.WeaveLogMessage ), $anonfun$onPreviewExecuted$2(org.mule.weave.v2.agent.api.event.WeaveLogMessage )}, serializedLambda);
                }
            };
            this.weaveAgentClient().runPreview(inputsPath, content, nameIdentifier.toString(), url, timeout, classpath, runtimeProperties, outputMimeType, weaveAgentClientListener);
            return (PreviewResult)runResult.get().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                String x$1 = "Unable to Start DataWeave Agent to Run Preview.";
                boolean x$2 = false;
                List<String> x$3 = Collections.emptyList();
                String x$4 = url;
                String x$5 = PreviewResult$.MODULE$.apply$default$4();
                String x$6 = PreviewResult$.MODULE$.apply$default$5();
                String x$7 = PreviewResult$.MODULE$.apply$default$7();
                String x$8 = PreviewResult$.MODULE$.apply$default$8();
                long x$9 = PreviewResult$.MODULE$.apply$default$9();
                return new PreviewResult(x$4, x$2, x$3, x$5, x$6, x$1, x$7, x$8, x$9);
            });
        }
        String x$10 = "Unable to Start DataWeave Agent to Run Preview.";
        boolean x$11 = false;
        List<String> x$12 = Collections.emptyList();
        String x$13 = url;
        String x$14 = PreviewResult$.MODULE$.apply$default$4();
        String x$15 = PreviewResult$.MODULE$.apply$default$5();
        String x$16 = PreviewResult$.MODULE$.apply$default$7();
        String x$17 = PreviewResult$.MODULE$.apply$default$8();
        long x$18 = PreviewResult$.MODULE$.apply$default$9();
        return new PreviewResult(x$13, x$11, x$12, x$14, x$15, x$10, x$16, x$17, x$18);
    }

    private String[] calculateLocalClasspath(boolean withTests) {
        String[] sources = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ProjectStructureHelper$.MODULE$.mainSourceFolders(this.projectKind().structure()))).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getAbsolutePath(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        String[] resources = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ProjectStructureHelper$.MODULE$.mainResourcesFolders(this.projectKind().structure()))).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getAbsolutePath(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        String[] targets = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ProjectStructureHelper$.MODULE$.mainTargetFolders(this.projectKind().structure()))).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getAbsolutePath(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        String[] tests = withTests ? (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ProjectStructureHelper$.MODULE$.testsSourceFolders(this.projectKind().structure()))).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.getAbsolutePath(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))) : (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class));
        return (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sources)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])resources)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])targets)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tests)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
    }

    private boolean calculateLocalClasspath$default$1() {
        return false;
    }

    public CompletableFuture<DataFormatDescriptor[]> definedDataFormats() {
        return CompletableFuture.supplyAsync(() -> {
            if (this.checkConnected()) {
                FutureValue result = new FutureValue(FutureValue$.MODULE$.$lessinit$greater$default$1());
                this.weaveAgentClient().definedDataFormats(new DataFormatDefinitionListener(this, result){
                    private final /* synthetic */ WeaveAgentService $outer;
                    private final FutureValue result$4;

                    public void onDataFormatDefinitionCalculated(DataFormatsDefinitionsEvent event) {
                        WeaveDataFormatDescriptor[] formats = event.formats();
                        DataFormatDescriptor[] descriptor = (DataFormatDescriptor[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])formats)).map((Function1 & Serializable & scala.Serializable)weaveDataFormatDescriptor -> {
                            String mimeType = weaveDataFormatDescriptor.mimeType();
                            return DataFormatDescriptor$.MODULE$.apply(mimeType, weaveDataFormatDescriptor.id(), $this.$outer.org$mule$weave$lsp$agent$WeaveAgentService$$toDataFormatProp(weaveDataFormatDescriptor.writerProperties()), $this.$outer.org$mule$weave$lsp$agent$WeaveAgentService$$toDataFormatProp(weaveDataFormatDescriptor.readerProperties()));
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DataFormatDescriptor.class)));
                        this.result$4.set(descriptor);
                    }

                    public void onUnexpectedError(UnexpectedServerErrorEvent unexpectedServerErrorEvent) {
                        this.$outer.org$mule$weave$lsp$agent$WeaveAgentService$$clientLogger().logError(new StringBuilder(52).append("Unexpected error at 'definedDataFormats' caused by: ").append(unexpectedServerErrorEvent.stacktrace()).toString());
                        this.result$4.set(Array$.MODULE$.empty(ClassTag$.MODULE$.apply(DataFormatDescriptor.class)));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.result$4 = result$4;
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onDataFormatDefinitionCalculated$1(org.mule.weave.lsp.agent.WeaveAgentService$$anon$10 org.mule.weave.v2.agent.api.event.WeaveDataFormatDescriptor )}, serializedLambda);
                    }
                });
                return (DataFormatDescriptor[])result.get().getOrElse((Function0 & Serializable & scala.Serializable)() -> (DataFormatDescriptor[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(DataFormatDescriptor.class)));
            }
            return (DataFormatDescriptor[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(DataFormatDescriptor.class));
        }, this.executor);
    }

    public DataFormatProperty[] org$mule$weave$lsp$agent$WeaveAgentService$$toDataFormatProp(WeaveDataFormatProperty[] weaveDataFormatPropertySeq) {
        return (DataFormatProperty[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])weaveDataFormatPropertySeq)).map((Function1 & Serializable & scala.Serializable)property -> new DataFormatProperty(property.name(), property.description(), property.wtype(), property.values()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DataFormatProperty.class)));
    }

    @Override
    public void stop() {
        this.logger().debug("stop() hit");
        this.stopAgent();
    }

    private void stopAgent() {
        this.logger().debug("stopAgent() hit");
        if (this.weaveAgentClient() != null) {
            this.weaveAgentClient().disconnect();
        }
        if (this.agentProcess() != null) {
            this.agentProcess().destroyForcibly();
            this.agentProcess_$eq(null);
        }
        this.eventBus().fire(new AgentStoppedEvent());
    }

    public WeaveAgentService(DataWeaveToolingService validationService, Executor executor, ClientLoggerFactory loggerFactory, ProjectMetadata project, WeaveScenarioManagerService scenarioManagerService, AgentClasspathResolver classpathResolver) {
        this.org$mule$weave$lsp$agent$WeaveAgentService$$validationService = validationService;
        this.executor = executor;
        this.project = project;
        this.scenarioManagerService = scenarioManagerService;
        this.classpathResolver = classpathResolver;
        ToolingService.$init$(this);
        this.logger = LoggerFactory.getLogger(WeaveAgentService.class);
        this.org$mule$weave$lsp$agent$WeaveAgentService$$clientLogger = loggerFactory.createLogger(WeaveAgentService.class);
        this.AGENT_SERVER_LAUNCHER_MAIN_CLASS = "org.mule.weave.v2.agent.server.AgentServerLauncher";
        this.LIGHT_GREY = "rgb(113, 113, 113)";
        this.RED = "rgb(139, 0, 0)";
        this.startAgentLock = new ReentrantLock();
    }
}

