package org.mule.weave.lsp.commands

import org.eclipse.lsp4j.ExecuteCommandParams
import org.eclipse.lsp4j.MessageParams
import org.eclipse.lsp4j.MessageType
import org.mule.weave.extension.api.extension.command.WeaveCommand
import org.mule.weave.lsp.services.UIService
import org.mule.weave.lsp.services.WeaveScenarioManagerService
import org.mule.weave.lsp.services.WorkspaceServiceManager
import org.mule.weave.v2.parser.ast.variables.NameIdentifier

class DeleteScenarioCommand(workspaceServiceManager: WorkspaceServiceManager, uIService: UIService) extends WeaveCommand {

  override def commandId(): String = Commands.DW_DELETE_SCENARIO

  override def execute(params: ExecuteCommandParams): AnyRef = {
    val nameIdentifier: String = Commands.argAsString(params.getArguments, 0)
    val uri: String = Commands.argAsString(params.getArguments, 1)
    val nameOfScenario: String = Commands.argAsString(params.getArguments, 2)

    val maybeProjectKind = workspaceServiceManager.projectKind(uri)
    if (maybeProjectKind.isDefined) {
      val scenariosManager: WeaveScenarioManagerService = maybeProjectKind.get.toolingService(classOf[WeaveScenarioManagerService])
      scenariosManager.deleteScenario(NameIdentifier(nameIdentifier), nameOfScenario)
    } else {
      uIService.showMessage(new MessageParams(MessageType.Error, s"No project is associated to: ${uri}. ${commandId} cannot be executed"))
    }

    null
  }

  override def name(): String = "Deletes Scenario"

  override def description(params: ExecuteCommandParams): String = s"Deleting Scenario `${Commands.argAsString(params.getArguments, 0)}`."
}
