package org.mule.weave.lsp.services

import org.eclipse.lsp4j.MessageActionItem
import org.eclipse.lsp4j.MessageParams
import org.eclipse.lsp4j.ShowMessageRequestParams
import org.eclipse.lsp4j.services.LanguageClient
import org.mule.dx.platform.api.protocol.ClientAware
import org.mule.weave.lsp.extension.protocol.DataWeaveProtocolClient
import org.mule.weave.lsp.extension.protocol.OpenTextDocumentParams
import org.mule.weave.lsp.extension.protocol.OpenWindowsParams
import org.mule.weave.lsp.extension.protocol.WeaveInputBoxParams
import org.mule.weave.lsp.extension.protocol.WeaveInputBoxResult
import org.mule.weave.lsp.extension.protocol.WeaveOpenDialogParams
import org.mule.weave.lsp.extension.protocol.WeaveQuickPickParams
import org.mule.weave.lsp.extension.protocol.WeaveQuickPickResult

import java.util.concurrent.CompletableFuture

/**
 * Service that captures al the UI releated capabilitites and abstracts from what protocol to use to render
 *
 * @param languageClient
 * @param weaveProtocolClient
 */
class UIService(weaveProtocolClient: DataWeaveProtocolClient) extends ClientAware[LanguageClient] {
  private var languageClient: LanguageClient = _

  def showMessageRequest(requestParams: ShowMessageRequestParams): CompletableFuture[MessageActionItem] = {
    if (languageClient == null) {
      return CompletableFuture.completedFuture(new MessageActionItem())
    }
    languageClient.showMessageRequest(requestParams);
  }

  def showMessage(messageParams: MessageParams): Unit = {
    if (languageClient != null) {
      languageClient.showMessage(messageParams)
    }
  }

  override def connect(client: LanguageClient): Unit = {
    languageClient = client
  }

  def weaveInputBox(params: WeaveInputBoxParams): CompletableFuture[WeaveInputBoxResult] = {
    weaveProtocolClient.weaveInputBox(params)
  }

  def weaveQuickPick(params: WeaveQuickPickParams): CompletableFuture[WeaveQuickPickResult] = {
    weaveProtocolClient.weaveQuickPick(params)
  }

  def weaveFileBrowser(params: WeaveOpenDialogParams): CompletableFuture[String] = {
    weaveProtocolClient.weaveFileBrowser(params)
  }

  def openTextDocument(params: OpenTextDocumentParams): Unit = {
    weaveProtocolClient.openTextDocument(params)
  }

  def openWindow(params: OpenWindowsParams): Unit = {
    weaveProtocolClient.openWindow(params)
  }

}
