/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.lsp.vfs;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.file.Path;
import org.eclipse.lsp4j.FileChangeType;
import org.mule.weave.extension.api.component.structure.WeaveProjectStructure;
import org.mule.weave.lsp.project.ProjectKind;
import org.mule.weave.lsp.project.components.ProjectStructureHelper$;
import org.mule.weave.lsp.services.ToolingService;
import org.mule.weave.lsp.services.events.FileChangedEvent$;
import org.mule.weave.lsp.services.events.OnFileChanged;
import org.mule.weave.lsp.utils.InternalEventBus;
import org.mule.weave.lsp.utils.URLUtils$;
import org.mule.weave.lsp.utils.VFUtils$;
import org.mule.weave.lsp.vfs.CompositeNameIdentifierResolver;
import org.mule.weave.lsp.vfs.InMemoryVirtualFileResourceResolver;
import org.mule.weave.lsp.vfs.JarFileNameIdentifierResolver;
import org.mule.weave.lsp.vfs.NameIdentifierResolver;
import org.mule.weave.lsp.vfs.ProjectFileNameIdentifierResolver;
import org.mule.weave.lsp.vfs.ProjectFileSystemService$;
import org.mule.weave.lsp.vfs.ProjectVirtualFile;
import org.mule.weave.lsp.vfs.ProjectVirtualFile$;
import org.mule.weave.lsp.vfs.SimpleNameIdentifierResolver$;
import org.mule.weave.lsp.vfs.events.ProjectVirtualFileChangedEvent;
import org.mule.weave.lsp.vfs.events.ProjectVirtualFileCreatedEvent;
import org.mule.weave.lsp.vfs.events.ProjectVirtualFileDeletedEvent;
import org.mule.weave.lsp.vfs.resource.FolderWeaveResourceResolver;
import org.mule.weave.v2.editor.ChangeListener;
import org.mule.weave.v2.editor.VirtualFile;
import org.mule.weave.v2.editor.VirtualFileSystem;
import org.mule.weave.v2.sdk.ChainedWeaveResourceResolver;
import org.mule.weave.v2.sdk.WeaveResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0001\t\u001dc\u0001\u0002\u0017.\u0001aB\u0001\"\u0014\u0001\u0003\u0002\u0003\u0006IA\u0014\u0005\u0006%\u0002!\ta\u0015\u0005\b-\u0002\u0011\r\u0011\"\u0003X\u0011\u0019q\u0006\u0001)A\u00051\"9q\f\u0001b\u0001\n\u0013\u0001\u0007BB<\u0001A\u0003%\u0011\rC\u0004y\u0001\t\u0007I\u0011B=\t\ru\u0004\u0001\u0015!\u0003{\u0011\u001dq\bA1A\u0005\n}D\u0001\"!\u0004\u0001A\u0003%\u0011\u0011\u0001\u0005\f\u0003\u001f\u0001\u0001\u0019!a\u0001\n\u0013\t\t\u0002C\u0006\u0002 \u0001\u0001\r\u00111A\u0005\n\u0005\u0005\u0002bCA\u0017\u0001\u0001\u0007\t\u0011)Q\u0005\u0003'A1\"a\f\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u00022!Y\u00111\n\u0001A\u0002\u0003\u0007I\u0011BA'\u0011-\t\t\u0006\u0001a\u0001\u0002\u0003\u0006K!a\r\t\u0017\u0005M\u0003\u00011AA\u0002\u0013%\u0011Q\u000b\u0005\f\u0003G\u0002\u0001\u0019!a\u0001\n\u0013\t)\u0007C\u0006\u0002j\u0001\u0001\r\u0011!Q!\n\u0005]\u0003bCA6\u0001\u0001\u0007\t\u0019!C\u0005\u0003[B1\"!\u001e\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002x!Y\u00111\u0010\u0001A\u0002\u0003\u0005\u000b\u0015BA8\u0011\u001d\ti\b\u0001C!\u0003\u007fBq!!\"\u0001\t\u0003\t9\tC\u0004\u0002\u001e\u0002!\t!a(\t\u000f\u0005\r\u0006\u0001\"\u0001\u0002&\"9\u0011\u0011\u0016\u0001\u0005\n\u0005-\u0006bBAX\u0001\u0011\u0005\u0011\u0011\u0017\u0005\b\u0003w\u0003A\u0011BA_\u0011\u001d\t\t\r\u0001C\u0005\u0003\u0007Dq!a2\u0001\t\u0003\nI\rC\u0004\u0002P\u0002!\t%!5\t\u000f\u0005]\u0007\u0001\"\u0003\u0002Z\"9\u0011Q\u001c\u0001\u0005\n\u0005}\u0007bBAr\u0001\u0011%\u0011Q\u001d\u0005\b\u0003S\u0004A\u0011IAv\u0011\u001d\t\t\u0010\u0001C!\u0003gDq!a>\u0001\t\u0013\tI\u0010C\u0004\u0002~\u0002!I!a@\t\u000f\t\r\u0001\u0001\"\u0003\u0003\u0006!9!q\u0002\u0001\u0005\u0002\tE\u0001b\u0002B\u0014\u0001\u0011\u0005#\u0011\u0006\u0005\b\u0005o\u0001A\u0011\tB\u001d\u0005a\u0001&o\u001c6fGR4\u0015\u000e\\3TsN$X-\\*feZL7-\u001a\u0006\u0003]=\n1A\u001e4t\u0015\t\u0001\u0014'A\u0002mgBT!AM\u001a\u0002\u000b],\u0017M^3\u000b\u0005Q*\u0014\u0001B7vY\u0016T\u0011AN\u0001\u0004_J<7\u0001A\n\u0005\u0001ezt\t\u0005\u0002;{5\t1HC\u0001=\u0003\u0015\u00198-\u00197b\u0013\tq4H\u0001\u0004B]f\u0014VM\u001a\t\u0003\u0001\u0016k\u0011!\u0011\u0006\u0003\u0005\u000e\u000ba!\u001a3ji>\u0014(B\u0001#2\u0003\t1('\u0003\u0002G\u0003\n\tb+\u001b:uk\u0006dg)\u001b7f'f\u001cH/Z7\u0011\u0005![U\"A%\u000b\u0005){\u0013\u0001C:feZL7-Z:\n\u00051K%A\u0004+p_2LgnZ*feZL7-Z\u0001\u001eU\u0006\u0014h)\u001b7f\u001d\u0006lW-\u00133f]RLg-[3s%\u0016\u001cx\u000e\u001c<feB\u0011q\nU\u0007\u0002[%\u0011\u0011+\f\u0002\u001e\u0015\u0006\u0014h)\u001b7f\u001d\u0006lW-\u00133f]RLg-[3s%\u0016\u001cx\u000e\u001c<fe\u00061A(\u001b8jiz\"\"\u0001V+\u0011\u0005=\u0003\u0001\"B'\u0003\u0001\u0004q\u0015A\u00027pO\u001e,'/F\u0001Y!\tIF,D\u0001[\u0015\tYV'A\u0003tY\u001a$$.\u0003\u0002^5\n1Aj\\4hKJ\fq\u0001\\8hO\u0016\u0014\b%A\u0007j]6+Wn\u001c:z\r&dWm]\u000b\u0002CB!!mZ5u\u001b\u0005\u0019'B\u00013f\u0003\u001diW\u000f^1cY\u0016T!AZ\u001e\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002iG\n\u0019Q*\u00199\u0011\u0005)\fhBA6p!\ta7(D\u0001n\u0015\tqw'\u0001\u0004=e>|GOP\u0005\u0003an\na\u0001\u0015:fI\u00164\u0017B\u0001:t\u0005\u0019\u0019FO]5oO*\u0011\u0001o\u000f\t\u0003\u001fVL!A^\u0017\u0003%A\u0013xN[3diZK'\u000f^;bY\u001aKG.Z\u0001\u000fS:lU-\\8ss\u001aKG.Z:!\u0003-y\u0007/\u001a8fI\u001aKG.Z:\u0016\u0003i\u00042AY>j\u0013\ta8MA\u0002TKR\fAb\u001c9f]\u0016$g)\u001b7fg\u0002\n!C\u001e4t\u0007\"\fgnZ3MSN$XM\\3sgV\u0011\u0011\u0011\u0001\t\u0006E\u0006\r\u0011qA\u0005\u0004\u0003\u000b\u0019'aC!se\u0006L()\u001e4gKJ\u00042\u0001QA\u0005\u0013\r\tY!\u0011\u0002\u000f\u0007\"\fgnZ3MSN$XM\\3s\u0003M1hm]\"iC:<W\rT5ti\u0016tWM]:!\u0003-\u0001(o\u001c6fGR\\\u0015N\u001c3\u0016\u0005\u0005M\u0001\u0003BA\u000b\u00037i!!a\u0006\u000b\u0007\u0005eq&A\u0004qe>TWm\u0019;\n\t\u0005u\u0011q\u0003\u0002\f!J|'.Z2u\u0017&tG-A\bqe>TWm\u0019;LS:$w\fJ3r)\u0011\t\u0019#!\u000b\u0011\u0007i\n)#C\u0002\u0002(m\u0012A!\u00168ji\"I\u00111\u0006\u0007\u0002\u0002\u0003\u0007\u00111C\u0001\u0004q\u0012\n\u0014\u0001\u00049s_*,7\r^&j]\u0012\u0004\u0013\u0001\u00059s_*,7\r^*ueV\u001cG/\u001e:f+\t\t\u0019\u0004\u0005\u0003\u00026\u0005\u001dSBAA\u001c\u0015\u0011\tI$a\u000f\u0002\u0013M$(/^2ukJ,'\u0002BA\u001f\u0003\u007f\t\u0011bY8na>tWM\u001c;\u000b\t\u0005\u0005\u00131I\u0001\u0004CBL'bAA#c\u0005IQ\r\u001f;f]NLwN\\\u0005\u0005\u0003\u0013\n9DA\u000bXK\u00064X\r\u0015:pU\u0016\u001cGo\u0015;sk\u000e$XO]3\u0002)A\u0014xN[3diN#(/^2ukJ,w\fJ3r)\u0011\t\u0019#a\u0014\t\u0013\u0005-r\"!AA\u0002\u0005M\u0012!\u00059s_*,7\r^*ueV\u001cG/\u001e:fA\u0005AQM^3oi\n+8/\u0006\u0002\u0002XA!\u0011\u0011LA0\u001b\t\tYFC\u0002\u0002^=\nQ!\u001e;jYNLA!!\u0019\u0002\\\t\u0001\u0012J\u001c;fe:\fG.\u0012<f]R\u0014Uo]\u0001\rKZ,g\u000e\u001e\"vg~#S-\u001d\u000b\u0005\u0003G\t9\u0007C\u0005\u0002,I\t\t\u00111\u0001\u0002X\u0005IQM^3oi\n+8\u000fI\u0001\u0017]\u0006lW-\u00133f]RLg-[3s%\u0016\u001cx\u000e\u001c<feV\u0011\u0011q\u000e\t\u0004\u001f\u0006E\u0014bAA:[\t1b*Y7f\u0013\u0012,g\u000e^5gS\u0016\u0014(+Z:pYZ,'/\u0001\u000eoC6,\u0017\nZ3oi&4\u0017.\u001a:SKN|GN^3s?\u0012*\u0017\u000f\u0006\u0003\u0002$\u0005e\u0004\"CA\u0016+\u0005\u0005\t\u0019AA8\u0003]q\u0017-\\3JI\u0016tG/\u001b4jKJ\u0014Vm]8mm\u0016\u0014\b%\u0001\u0006j]&$\u0018.\u00197ju\u0016$b!a\t\u0002\u0002\u0006\r\u0005bBA\b/\u0001\u0007\u00111\u0003\u0005\b\u0003':\u0002\u0019AA,\u0003\u0019)\b\u000fZ1uKR1\u0011\u0011RAK\u00033\u0003RAOAF\u0003\u001fK1!!$<\u0005\u0019y\u0005\u000f^5p]B\u0019\u0001)!%\n\u0007\u0005M\u0015IA\u0006WSJ$X/\u00197GS2,\u0007BBAL1\u0001\u0007\u0011.A\u0002ve&Da!a'\u0019\u0001\u0004I\u0017aB2p]R,g\u000e^\u0001\u0007G2|7/\u001a3\u0015\t\u0005%\u0015\u0011\u0015\u0005\u0007\u0003/K\u0002\u0019A5\u0002\u000bM\fg/\u001a3\u0015\t\u0005%\u0015q\u0015\u0005\u0007\u0003/S\u0002\u0019A5\u0002\u000f\rD\u0017M\\4fIR!\u00111EAW\u0011\u0019\t9j\u0007a\u0001S\u0006q\u0011n]%o\u001b\u0016lwN]=GS2,G\u0003BAZ\u0003s\u00032AOA[\u0013\r\t9l\u000f\u0002\b\u0005>|G.Z1o\u0011\u0019\t9\n\ba\u0001S\u00069A-\u001a7fi\u0016$G\u0003BA\u0012\u0003\u007fCa!a&\u001e\u0001\u0004I\u0017aB2sK\u0006$X\r\u001a\u000b\u0005\u0003G\t)\r\u0003\u0004\u0002\u0018z\u0001\r![\u0001\u000fG\"\fgnZ3MSN$XM\\3s)\u0011\t\u0019#a3\t\u000f\u00055w\u00041\u0001\u0002\b\u0005\u00111\r\\\u0001\n_:\u001c\u0005.\u00198hK\u0012$B!a\t\u0002T\"9\u0011Q\u001b\u0011A\u0002\u0005=\u0015A\u0001<g\u00039!(/[4hKJ\u001c\u0005.\u00198hKN$B!a\t\u0002\\\"9\u0011Q[\u0011A\u0002\u0005=\u0015A\u0004;sS\u001e<WM]\"sK\u0006$X\r\u001a\u000b\u0005\u0003G\t\t\u000fC\u0004\u0002V\n\u0002\r!a$\u0002\u001dQ\u0014\u0018nZ4fe\u0012+G.\u001a;fIR!\u00111EAt\u0011\u001d\t)n\ta\u0001\u0003\u001f\u000bAC]3n_Z,7\t[1oO\u0016d\u0015n\u001d;f]\u0016\u0014H\u0003BA\u0012\u0003[Dq!a<%\u0001\u0004\t9!A\u0004tKJ4\u0018nY3\u0002\t\u0019LG.\u001a\u000b\u0005\u0003\u001f\u000b)\u0010\u0003\u0004\u0002\u0018\u0016\u0002\r![\u0001\rG>tG/Y5og\u001aKG.\u001a\u000b\u0005\u0003g\u000bY\u0010\u0003\u0004\u0002\u0018\u001a\u0002\r![\u0001\nI><U\r\u001e$jY\u0016$2\u0001\u001eB\u0001\u0011\u0019\t9j\na\u0001S\u0006aAm\\+qI\u0006$XMR5mKR1!q\u0001B\u0005\u0005\u0017\u0001BAOAFi\"1\u0011q\u0013\u0015A\u0002%DaA!\u0004)\u0001\u0004!\u0018a\u0003<jeR,\u0018\r\u001c$jY\u0016\fAb]8ve\u000e,'k\\8u\u001f\u001a$BAa\u0005\u0003&A)!(a#\u0003\u0016A!!q\u0003B\u0011\u001b\t\u0011IB\u0003\u0003\u0003\u001c\tu\u0011AA5p\u0015\t\u0011y\"\u0001\u0003kCZ\f\u0017\u0002\u0002B\u0012\u00053\u0011AAR5mK\"1\u0011qS\u0015A\u0002%\f!#Y:SKN|WO]2f%\u0016\u001cx\u000e\u001c<feV\u0011!1\u0006\t\u0005\u0005[\u0011\u0019$\u0004\u0002\u00030)\u0019!\u0011G\"\u0002\u0007M$7.\u0003\u0003\u00036\t=\"!F,fCZ,'+Z:pkJ\u001cWMU3t_24XM]\u0001\nY&\u001cHOR5mKN$\"Aa\u000f\u0011\r\tu\"1IAH\u001b\t\u0011yD\u0003\u0003\u0003B\tu\u0011\u0001B;uS2LAA!\u0012\u0003@\tA\u0011\n^3sCR|'\u000f")
public class ProjectFileSystemService
implements VirtualFileSystem,
ToolingService {
    private final JarFileNameIdentifierResolver jarFileNameIdentifierResolver;
    private final Logger logger;
    private final Map<String, ProjectVirtualFile> inMemoryFiles;
    private final Set<String> org$mule$weave$lsp$vfs$ProjectFileSystemService$$openedFiles;
    private final ArrayBuffer<ChangeListener> vfsChangeListeners;
    private ProjectKind projectKind;
    private WeaveProjectStructure org$mule$weave$lsp$vfs$ProjectFileSystemService$$projectStructure;
    private InternalEventBus eventBus;
    private NameIdentifierResolver nameIdentifierResolver;

    private Logger logger() {
        return this.logger;
    }

    private Map<String, ProjectVirtualFile> inMemoryFiles() {
        return this.inMemoryFiles;
    }

    public Set<String> org$mule$weave$lsp$vfs$ProjectFileSystemService$$openedFiles() {
        return this.org$mule$weave$lsp$vfs$ProjectFileSystemService$$openedFiles;
    }

    private ArrayBuffer<ChangeListener> vfsChangeListeners() {
        return this.vfsChangeListeners;
    }

    private ProjectKind projectKind() {
        return this.projectKind;
    }

    private void projectKind_$eq(ProjectKind x$1) {
        this.projectKind = x$1;
    }

    public WeaveProjectStructure org$mule$weave$lsp$vfs$ProjectFileSystemService$$projectStructure() {
        return this.org$mule$weave$lsp$vfs$ProjectFileSystemService$$projectStructure;
    }

    private void org$mule$weave$lsp$vfs$ProjectFileSystemService$$projectStructure_$eq(WeaveProjectStructure x$1) {
        this.org$mule$weave$lsp$vfs$ProjectFileSystemService$$projectStructure = x$1;
    }

    private InternalEventBus eventBus() {
        return this.eventBus;
    }

    private void eventBus_$eq(InternalEventBus x$1) {
        this.eventBus = x$1;
    }

    private NameIdentifierResolver nameIdentifierResolver() {
        return this.nameIdentifierResolver;
    }

    private void nameIdentifierResolver_$eq(NameIdentifierResolver x$1) {
        this.nameIdentifierResolver = x$1;
    }

    @Override
    public void initialize(ProjectKind projectKind, InternalEventBus eventBus) {
        this.projectKind_$eq(projectKind);
        this.org$mule$weave$lsp$vfs$ProjectFileSystemService$$projectStructure_$eq(projectKind.structure());
        this.nameIdentifierResolver_$eq(new CompositeNameIdentifierResolver((NameIdentifierResolver[])((Object[])new NameIdentifierResolver[]{new ProjectFileNameIdentifierResolver(this.org$mule$weave$lsp$vfs$ProjectFileSystemService$$projectStructure()), this.jarFileNameIdentifierResolver, SimpleNameIdentifierResolver$.MODULE$})));
        this.eventBus_$eq(eventBus);
        eventBus.register(FileChangedEvent$.MODULE$.FILE_CHANGED_EVENT(), new OnFileChanged(this){
            private final /* synthetic */ ProjectFileSystemService $outer;

            public void onFileChanged(String uri2, FileChangeType changeType) {
                FileChangeType fileChangeType = changeType;
                if (FileChangeType.Created.equals(fileChangeType)) {
                    if (ProjectStructureHelper$.MODULE$.isAProjectFile(uri2, this.$outer.org$mule$weave$lsp$vfs$ProjectFileSystemService$$projectStructure()) && URLUtils$.MODULE$.toFile(uri2).exists((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)$anon$1.$anonfun$onFileChanged$1(f)))) {
                        this.$outer.org$mule$weave$lsp$vfs$ProjectFileSystemService$$created(uri2);
                        return;
                    }
                    return;
                }
                if (FileChangeType.Changed.equals(fileChangeType)) {
                    if (ProjectStructureHelper$.MODULE$.isAProjectFile(uri2, this.$outer.org$mule$weave$lsp$vfs$ProjectFileSystemService$$projectStructure())) {
                        this.$outer.org$mule$weave$lsp$vfs$ProjectFileSystemService$$openedFiles().iterator().filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)$anon$1.$anonfun$onFileChanged$2(uri2, p))).foreach((Function1 & Serializable & scala.Serializable)uri -> {
                            $anon$1.$anonfun$onFileChanged$3(this, uri);
                            return BoxedUnit.UNIT;
                        });
                        return;
                    }
                    return;
                }
                if (FileChangeType.Deleted.equals(fileChangeType)) {
                    if (ProjectStructureHelper$.MODULE$.isAProjectFile(uri2, this.$outer.org$mule$weave$lsp$vfs$ProjectFileSystemService$$projectStructure())) {
                        this.$outer.org$mule$weave$lsp$vfs$ProjectFileSystemService$$openedFiles().iterator().filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)$anon$1.$anonfun$onFileChanged$4(uri2, p))).foreach((Function1 & Serializable & scala.Serializable)uri -> {
                            $anon$1.$anonfun$onFileChanged$5(this, uri);
                            return BoxedUnit.UNIT;
                        });
                        return;
                    }
                    return;
                }
                throw new MatchError((Object)fileChangeType);
            }

            public static final /* synthetic */ boolean $anonfun$onFileChanged$1(File f) {
                return f.exists() && f.isFile();
            }

            public static final /* synthetic */ boolean $anonfun$onFileChanged$2(String uri$1, String p) {
                return URLUtils$.MODULE$.isChildOf(p, uri$1);
            }

            public static final /* synthetic */ void $anonfun$onFileChanged$3($anon$1 $this, String uri) {
                $this.$outer.org$mule$weave$lsp$vfs$ProjectFileSystemService$$changed(uri);
            }

            public static final /* synthetic */ boolean $anonfun$onFileChanged$4(String uri$1, String p) {
                return URLUtils$.MODULE$.isChildOf(p, uri$1);
            }

            public static final /* synthetic */ void $anonfun$onFileChanged$5($anon$1 $this, String uri) {
                $this.$outer.org$mule$weave$lsp$vfs$ProjectFileSystemService$$deleted(uri);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onFileChanged$1$adapted(java.io.File ), $anonfun$onFileChanged$2$adapted(java.lang.String java.lang.String ), $anonfun$onFileChanged$3$adapted(org.mule.weave.lsp.vfs.ProjectFileSystemService$$anon$1 java.lang.String ), $anonfun$onFileChanged$4$adapted(java.lang.String java.lang.String ), $anonfun$onFileChanged$5$adapted(org.mule.weave.lsp.vfs.ProjectFileSystemService$$anon$1 java.lang.String )}, serializedLambda);
            }
        });
    }

    public Option<VirtualFile> update(String uri, String content) {
        this.logger().debug(new StringBuilder(13).append("Update `").append(uri).append("` -> ").append(content).toString());
        Option option = Option$.MODULE$.apply((Object)this.file(uri));
        if (option instanceof Some) {
            Some some = (Some)option;
            VirtualFile vf = (VirtualFile)some.value();
            boolean written = vf.write(content);
            if (written) {
                this.triggerChanges(vf);
            }
            return new Some((Object)vf);
        }
        if (None$.MODULE$.equals(option)) {
            ProjectVirtualFile virtualFile = new ProjectVirtualFile(this, this.nameIdentifierResolver(), URLUtils$.MODULE$.toCanonicalString(uri), (Option<File>)None$.MODULE$, (Option<String>)new Some((Object)content), !VFUtils$.MODULE$.isSupportedEditableScheme(uri));
            this.doUpdateFile(uri, virtualFile);
            this.triggerChanges(virtualFile);
            return new Some((Object)virtualFile);
        }
        throw new MatchError((Object)option);
    }

    public Option<VirtualFile> closed(String uri) {
        this.logger().debug(new StringBuilder(7).append("closed ").append(uri).toString());
        return this.inMemoryFiles().remove((Object)uri);
    }

    public Option<VirtualFile> saved(String uri) {
        this.logger().debug(new StringBuilder(7).append("saved: ").append(uri).toString());
        return this.inMemoryFiles().get((Object)uri).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.save());
    }

    public void org$mule$weave$lsp$vfs$ProjectFileSystemService$$changed(String uri) {
        this.logger().debug(new StringBuilder(9).append("changed: ").append(uri).toString());
        VirtualFile virtualFile = this.file(uri);
        this.triggerChanges(virtualFile);
    }

    public boolean isInMemoryFile(String uri) {
        return this.inMemoryFiles().contains((Object)uri);
    }

    public void org$mule$weave$lsp$vfs$ProjectFileSystemService$$deleted(String uri) {
        this.logger().debug(new StringBuilder(8).append("deleted ").append(uri).toString());
        this.inMemoryFiles().remove((Object)uri);
        this.org$mule$weave$lsp$vfs$ProjectFileSystemService$$openedFiles().remove((Object)uri);
        ProjectVirtualFile virtualFile = new ProjectVirtualFile(this, this.nameIdentifierResolver(), uri, URLUtils$.MODULE$.toFile(uri), ProjectVirtualFile$.MODULE$.$lessinit$greater$default$5(), ProjectVirtualFile$.MODULE$.$lessinit$greater$default$6());
        this.triggerDeleted(virtualFile);
    }

    public void org$mule$weave$lsp$vfs$ProjectFileSystemService$$created(String uri) {
        this.logger().debug(new StringBuilder(9).append("created: ").append(uri).toString());
        this.org$mule$weave$lsp$vfs$ProjectFileSystemService$$openedFiles().add((Object)uri);
        ProjectVirtualFile virtualFile = new ProjectVirtualFile(this, this.nameIdentifierResolver(), uri, URLUtils$.MODULE$.toFile(uri), ProjectVirtualFile$.MODULE$.$lessinit$greater$default$5(), ProjectVirtualFile$.MODULE$.$lessinit$greater$default$6());
        this.triggerCreated(virtualFile);
    }

    public void changeListener(ChangeListener cl) {
        this.vfsChangeListeners().$plus$eq((Object)cl);
    }

    public void onChanged(VirtualFile vf) {
        this.triggerChanges(vf);
    }

    private void triggerChanges(VirtualFile vf) {
        this.vfsChangeListeners().foreach((Function1 & Serializable & scala.Serializable)listener -> {
            listener.onChanged(vf);
            return BoxedUnit.UNIT;
        });
        if (this.eventBus() != null) {
            this.eventBus().fire(new ProjectVirtualFileChangedEvent(vf));
            return;
        }
    }

    private void triggerCreated(VirtualFile vf) {
        this.vfsChangeListeners().foreach((Function1 & Serializable & scala.Serializable)listener -> {
            listener.onCreated(vf);
            return BoxedUnit.UNIT;
        });
        if (this.eventBus() != null) {
            this.eventBus().fire(new ProjectVirtualFileCreatedEvent(vf));
            return;
        }
    }

    private void triggerDeleted(VirtualFile vf) {
        this.vfsChangeListeners().foreach((Function1 & Serializable & scala.Serializable)listener -> {
            listener.onDeleted(vf);
            return BoxedUnit.UNIT;
        });
        if (this.eventBus() != null) {
            this.eventBus().fire(new ProjectVirtualFileDeletedEvent(vf));
            return;
        }
    }

    public void removeChangeListener(ChangeListener service) {
        this.vfsChangeListeners().remove(this.vfsChangeListeners().indexOf((Object)service));
    }

    public VirtualFile file(String uri) {
        this.logger().debug(new StringBuilder(5).append("file ").append(uri).toString());
        this.org$mule$weave$lsp$vfs$ProjectFileSystemService$$openedFiles().add((Object)uri);
        if (this.containsFile(uri)) {
            return this.doGetFile(uri);
        }
        Option<File> maybeFile = URLUtils$.MODULE$.toFile(uri);
        if (maybeFile.isEmpty()) {
            return null;
        }
        if (((File)maybeFile.get()).exists()) {
            ProjectFileSystemService x$1 = this;
            NameIdentifierResolver x$2 = this.nameIdentifierResolver();
            String x$3 = URLUtils$.MODULE$.toCanonicalString(uri);
            Option<File> x$4 = maybeFile;
            boolean x$5 = !VFUtils$.MODULE$.isSupportedEditableScheme(uri);
            Option<String> x$6 = ProjectVirtualFile$.MODULE$.$lessinit$greater$default$5();
            ProjectVirtualFile virtualFile = new ProjectVirtualFile(x$1, x$2, x$3, x$4, x$6, x$5);
            this.doUpdateFile(uri, virtualFile);
            return virtualFile;
        }
        return null;
    }

    private boolean containsFile(String uri) {
        return this.inMemoryFiles().contains((Object)URLUtils$.MODULE$.toCanonicalString(uri));
    }

    private ProjectVirtualFile doGetFile(String uri) {
        return (ProjectVirtualFile)this.inMemoryFiles().apply((Object)URLUtils$.MODULE$.toCanonicalString(uri));
    }

    private Option<ProjectVirtualFile> doUpdateFile(String uri, ProjectVirtualFile virtualFile) {
        return this.inMemoryFiles().put((Object)URLUtils$.MODULE$.toCanonicalString(uri), (Object)virtualFile);
    }

    public Option<File> sourceRootOf(String uri) {
        File[] rootFolders = (File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.org$mule$weave$lsp$vfs$ProjectFileSystemService$$projectStructure().modules())).flatMap((Function1 & Serializable & scala.Serializable)module -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])module.roots())).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$2.sources())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class))))).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])module.roots())).flatMap((Function1 & Serializable & scala.Serializable)x$3 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$3.resources())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class))))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class))))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class)));
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rootFolders)).find((Function1 & Serializable & scala.Serializable)root -> BoxesRunTime.boxToBoolean((boolean)ProjectFileSystemService.$anonfun$sourceRootOf$4(uri, root)));
    }

    public WeaveResourceResolver asResourceResolver() {
        InMemoryVirtualFileResourceResolver inMemoryVirtualFileResourceResolver;
        FolderWeaveResourceResolver[] resolvers = (FolderWeaveResourceResolver[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.org$mule$weave$lsp$vfs$ProjectFileSystemService$$projectStructure().modules())).flatMap((Function1 & Serializable & scala.Serializable)module -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])module.roots())).flatMap((Function1 & Serializable & scala.Serializable)root -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])root.sources())).map((Function1 & Serializable & scala.Serializable)root -> new FolderWeaveResourceResolver((File)root, $this), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FolderWeaveResourceResolver.class))))).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])root.resources())).map((Function1 & Serializable & scala.Serializable)root -> new FolderWeaveResourceResolver((File)root, $this), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FolderWeaveResourceResolver.class))))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FolderWeaveResourceResolver.class))))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FolderWeaveResourceResolver.class))))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FolderWeaveResourceResolver.class)));
        InMemoryVirtualFileResourceResolver inMemoryVirtualFileResourceResolver2 = inMemoryVirtualFileResourceResolver = new InMemoryVirtualFileResourceResolver(this.inMemoryFiles());
        return new ChainedWeaveResourceResolver((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])resolvers)).$plus$colon((Object)inMemoryVirtualFileResourceResolver2, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit())));
    }

    public java.util.Iterator<VirtualFile> listFiles() {
        Iterator result = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.org$mule$weave$lsp$vfs$ProjectFileSystemService$$projectStructure().modules())).toIterator().flatMap((Function1 & Serializable & scala.Serializable)module -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])module.roots())).toIterator().flatMap((Function1 & Serializable & scala.Serializable)root2 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])root2.sources())).toIterator().flatMap((Function1 & Serializable & scala.Serializable)root -> VFUtils$.MODULE$.listFiles((File)root, this)).$plus$plus((Function0 & Serializable & scala.Serializable)() -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])root2.resources())).toIterator().flatMap((Function1 & Serializable & scala.Serializable)root -> VFUtils$.MODULE$.listFiles((File)root, this)))));
        Iterator<VirtualFile> wrapper = new Iterator<VirtualFile>(this, result){
            private final /* synthetic */ ProjectFileSystemService $outer;
            private final Iterator result$1;

            public String toString() {
                return Iterator.toString$((Iterator)this);
            }

            public boolean hasNext() {
                return this.result$1.hasNext();
            }

            public VirtualFile next() {
                VirtualFile next = (VirtualFile)this.result$1.next();
                this.$outer.org$mule$weave$lsp$vfs$ProjectFileSystemService$$openedFiles().add((Object)next.url());
                return next;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.result$1 = result$1;
                GenTraversableOnce.$init$((GenTraversableOnce)this);
                TraversableOnce.$init$((TraversableOnce)this);
                Iterator.$init$((Iterator)this);
            }
        };
        return (java.util.Iterator)JavaConverters$.MODULE$.asJavaIteratorConverter((Iterator)wrapper).asJava();
    }

    public static final /* synthetic */ boolean $anonfun$sourceRootOf$4(String uri$2, File root) {
        Option<Path> maybePath = URLUtils$.MODULE$.toPath(uri$2);
        return maybePath.exists((Function1 & Serializable & scala.Serializable)path -> BoxesRunTime.boxToBoolean((boolean)path.startsWith(root.toPath())));
    }

    public ProjectFileSystemService(JarFileNameIdentifierResolver jarFileNameIdentifierResolver) {
        this.jarFileNameIdentifierResolver = jarFileNameIdentifierResolver;
        VirtualFileSystem.$init$((VirtualFileSystem)this);
        ToolingService.$init$(this);
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.inMemoryFiles = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.org$mule$weave$lsp$vfs$ProjectFileSystemService$$openedFiles = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.vfsChangeListeners = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

