package org.mule.weave.lsp.commands

import org.eclipse.lsp4j.services.LanguageClient
import org.mule.dx.platform.api.protocol.ClientAware
import org.mule.weave.extension.api.extension.command.WeaveCommand
import org.mule.weave.lsp.jobs.JobManagerService
import org.mule.weave.lsp.services.ClientLoggerFactory
import org.mule.weave.lsp.services.WorkspaceServiceManager

class CommandManagerService(jobManagerService: JobManagerService,
                            workspaceServiceManager: WorkspaceServiceManager,
                            customCommands: Array[WeaveCommand]
                           ) extends ClientAware[LanguageClient] {
  private var clientLoggerFactory: ClientLoggerFactory = new ClientLoggerFactory(null)

  override def connect(client: LanguageClient): Unit = {
    clientLoggerFactory = new ClientLoggerFactory(client)
  }

  private lazy val _commands: Seq[WeaveCommand] = {
    val uIService = workspaceServiceManager.uIService()
    val configurationService = workspaceServiceManager.configurationService()

    Seq(
      new CreateProjectCommand(uIService),
      new ReloadDependenciesCommand(workspaceServiceManager),

      new RunBatTestCommand(clientLoggerFactory, uIService, workspaceServiceManager),
      new RunBatFolderTestCommand(clientLoggerFactory, workspaceServiceManager, uIService),
      new InstallBatCommand(clientLoggerFactory, workspaceServiceManager),

      new CreateTestCommand(workspaceServiceManager, uIService),
      new CreateUnitTest(workspaceServiceManager, uIService),

      new CreateMappingFileCommand(workspaceServiceManager, uIService),
      new CreateModuleFileCommand(workspaceServiceManager, uIService),
      new CreateIntegrationMappingFileCommand(workspaceServiceManager, uIService),

      new RunWeaveCommand(workspaceServiceManager, clientLoggerFactory, jobManagerService, uIService),

      new RunPreviewCommand(workspaceServiceManager, uIService),
      new LaunchWeaveCommand(uIService, configurationService),
      new LaunchWeaveTestCommand(uIService, configurationService, workspaceServiceManager),

      new QuickFixCommand(workspaceServiceManager, uIService),

      new InsertDocumentationCommand(workspaceServiceManager, uIService),
      new InsertWeaveTypeCommand(workspaceServiceManager, uIService),
      new ExtractVariableCommand(workspaceServiceManager, uIService),
      new ExtractConstantCommand(workspaceServiceManager, uIService),
      new ExtractFunctionCommand(workspaceServiceManager, uIService),

      new CreateInputSampleCommand(workspaceServiceManager, uIService),
      new CreateMappingTestCommand(workspaceServiceManager, uIService),

      new CreateScenarioCommand(workspaceServiceManager, uIService),
      new DeleteScenarioCommand(workspaceServiceManager, uIService),
      new SetActiveScenarioCommand(workspaceServiceManager, uIService),

      new DeleteInputSampleCommand(workspaceServiceManager, uIService),
      new DeleteOutputSampleCommand(workspaceServiceManager, uIService),

      new EnablePreviewModeCommand(workspaceServiceManager, uIService)
    ) ++ customCommands
  }

  def commands: Seq[WeaveCommand] = {
    _commands
  }

  def commandBy(commandId: String): Option[WeaveCommand] = {
    commands.find(_.commandId() == commandId)
  }

  def commandIds(): Seq[String] = {
    commands.map(_.commandId())
  }

}
