package org.mule.weave.lsp.commands

import org.eclipse.lsp4j.ExecuteCommandParams
import org.mule.weave.extension.api.extension.command.WeaveCommand
import org.mule.weave.lsp.services.WorkspaceServiceManager

class ReloadDependenciesCommand(workspaceServiceManager: WorkspaceServiceManager) extends WeaveCommand {
  override def commandId(): String = Commands.DW_RELOAD_DEPENDENCIES

  override def execute(params: ExecuteCommandParams): AnyRef = {
    workspaceServiceManager.projectKinds().foreach(projectKind =>  projectKind.dependencyManager().reload())
    null
  }

  override def name(): String = "Reloads dependencies."

  override def description(params: ExecuteCommandParams): String = "Reloading dependencies."
}
