package org.mule.weave.lsp.indexer.events

import org.mule.weave.lsp.indexer.events.IndexingFinishedEvent.INDEXING_FINISHED
import org.mule.weave.lsp.indexer.events.IndexingType.IndexingType
import org.mule.weave.lsp.utils.InternalEvent
import org.mule.weave.lsp.utils.InternalEventHandler
import org.mule.weave.lsp.utils.InternalEventType

class IndexingFinishedEvent(indexingType: IndexingType) extends InternalEvent {
  override type T = OnIndexingFinished

  override def getType: InternalEventType[OnIndexingFinished] = {
    INDEXING_FINISHED
  }

  override def dispatch(handler: OnIndexingFinished): Unit = {
    handler.onIndexingFinished(indexingType);
  }
}

object IndexingFinishedEvent {
  val INDEXING_FINISHED: InternalEventType[OnIndexingFinished] = InternalEventType[OnIndexingFinished]("INDEXING_FINISHED")
}

trait OnIndexingFinished extends InternalEventHandler {
  def onIndexingFinished(indexingType: IndexingType)
}
