package org.mule.weave.lsp.vfs.events

import org.mule.weave.lsp.utils.InternalEvent
import org.mule.weave.lsp.utils.InternalEventHandler
import org.mule.weave.lsp.utils.InternalEventType
import org.mule.weave.lsp.vfs.events.LibrariesModifiedEvent.LIBRARIES_MODIFIED

class LibrariesModifiedEvent extends InternalEvent {
  override type T = OnLibrariesModified

  override def getType: InternalEventType[OnLibrariesModified] = {
    LIBRARIES_MODIFIED
  }

  override def dispatch(handler: OnLibrariesModified): Unit = {
    handler.onLibrariesModified()
  }

}

object LibrariesModifiedEvent {
  val LIBRARIES_MODIFIED: InternalEventType[OnLibrariesModified] = InternalEventType[OnLibrariesModified]("LIBRARIES_MODIFIED")
}

trait OnLibrariesModified extends InternalEventHandler {
  def onLibrariesModified()
}
