/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.lsp.commands;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.lsp4j.ConfigurationItem;
import org.eclipse.lsp4j.ConfigurationParams;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.mule.weave.extension.api.extension.command.WeaveCommand;
import org.mule.weave.lsp.commands.Commands$;
import org.mule.weave.lsp.extension.protocol.LaunchConfiguration;
import org.mule.weave.lsp.extension.protocol.LaunchConfiguration$;
import org.mule.weave.lsp.extension.protocol.LaunchConfigurationProperty;
import org.mule.weave.lsp.extension.protocol.WeaveQuickPickItem;
import org.mule.weave.lsp.extension.protocol.WeaveQuickPickItem$;
import org.mule.weave.lsp.extension.protocol.WeaveQuickPickParams;
import org.mule.weave.lsp.extension.protocol.WeaveQuickPickParams$;
import org.mule.weave.lsp.extension.protocol.WeaveQuickPickResult;
import org.mule.weave.lsp.services.ConfigurationService;
import org.mule.weave.lsp.services.UIService;
import org.mule.weave.lsp.utils.Icons;
import org.mule.weave.lsp.utils.Icons$vscode$;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001q4Aa\u0003\u0007\u0001/!A1\u0006\u0001B\u0001B\u0003%A\u0006\u0003\u00053\u0001\t\u0005\t\u0015!\u00034\u0011\u00151\u0004\u0001\"\u00018\u0011\u001da\u0004A1A\u0005\u0002uBa\u0001\u0012\u0001!\u0002\u0013q\u0004\"B#\u0001\t\u00032\u0005\"\u0002+\u0001\t\u0003*\u0006\"\u00023\u0001\t\u0013)\u0007\"\u0002=\u0001\t\u00032\u0005\"B=\u0001\t\u0003R(A\u0005'bk:\u001c\u0007nV3bm\u0016\u001cu.\\7b]\u0012T!!\u0004\b\u0002\u0011\r|W.\\1oINT!a\u0004\t\u0002\u00071\u001c\bO\u0003\u0002\u0012%\u0005)q/Z1wK*\u00111\u0003F\u0001\u0005[VdWMC\u0001\u0016\u0003\ry'oZ\u0002\u0001'\r\u0001\u0001\u0004\t\t\u00033yi\u0011A\u0007\u0006\u00037q\tA\u0001\\1oO*\tQ$\u0001\u0003kCZ\f\u0017BA\u0010\u001b\u0005\u0019y%M[3diB\u0011\u0011%K\u0007\u0002E)\u00111\u0005J\u0001\bG>lW.\u00198e\u0015\t)c%A\u0005fqR,gn]5p]*\u0011q\u0005K\u0001\u0004CBL'BA\u0013\u0011\u0013\tQ#E\u0001\u0007XK\u00064XmQ8n[\u0006tG-A\u0005v\u0013N+'O^5dKB\u0011Q\u0006M\u0007\u0002])\u0011qFD\u0001\tg\u0016\u0014h/[2fg&\u0011\u0011G\f\u0002\n+&\u001bVM\u001d<jG\u0016\fAcY8oM&<WO]1uS>t7+\u001a:wS\u000e,\u0007CA\u00175\u0013\t)dF\u0001\u000bD_:4\u0017nZ;sCRLwN\\*feZL7-Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007aR4\b\u0005\u0002:\u00015\tA\u0002C\u0003,\u0007\u0001\u0007A\u0006C\u00033\u0007\u0001\u00071'\u0001\u0003jG>tW#\u0001 \u0011\u0005}\u0012U\"\u0001!\u000b\u0005\u0005s\u0011!B;uS2\u001c\u0018BA\"A\u0005\u0015I5m\u001c8t\u0003\u0015I7m\u001c8!\u0003%\u0019w.\\7b]\u0012LE\rF\u0001H!\tA\u0015K\u0004\u0002J\u001fB\u0011!*T\u0007\u0002\u0017*\u0011AJF\u0001\u0007yI|w\u000e\u001e \u000b\u00039\u000bQa]2bY\u0006L!\u0001U'\u0002\rA\u0013X\rZ3g\u0013\t\u00116K\u0001\u0004TiJLgn\u001a\u0006\u0003!6\u000bq!\u001a=fGV$X\r\u0006\u0002W5B\u0011q\u000bW\u0007\u0002\u001b&\u0011\u0011,\u0014\u0002\u0007\u0003:L(+\u001a4\t\u000bm;\u0001\u0019\u0001/\u0002\rA\f'/Y7t!\ti&-D\u0001_\u0015\ty\u0006-A\u0003mgB$$N\u0003\u0002b)\u00059Qm\u00197jaN,\u0017BA2_\u0005Q)\u00050Z2vi\u0016\u001cu.\\7b]\u0012\u0004\u0016M]1ng\u0006Q2M]3bi\u0016$UMZ1vYR\u001cuN\u001c4jOV\u0014\u0018\r^5p]R)a-\\8rgB\u0011qm[\u0007\u0002Q*\u0011\u0011N[\u0001\taJ|Go\\2pY*\u0011QED\u0005\u0003Y\"\u00141\u0003T1v]\u000eD7i\u001c8gS\u001e,(/\u0019;j_:DQA\u001c\u0005A\u0002\u001d\u000b!\u0002\u001d:pU\u0016\u001cG/\u0016:j\u0011\u0015\u0001\b\u00021\u0001H\u0003-i\u0017\r\u001d9j]\u001et\u0015-\\3\t\u000bID\u0001\u0019A$\u0002\u0015\r|gNZ5h)f\u0004X\rC\u0003u\u0011\u0001\u0007Q/A\u0004o_\u0012+'-^4\u0011\u0005]3\u0018BA<N\u0005\u001d\u0011un\u001c7fC:\fAA\\1nK\u0006YA-Z:de&\u0004H/[8o)\t95\u0010C\u0003\\\u0015\u0001\u0007A\f")
public class LaunchWeaveCommand
implements WeaveCommand {
    private final UIService uIService;
    private final ConfigurationService configurationService;
    private final Icons icon;

    public Icons icon() {
        return this.icon;
    }

    public String commandId() {
        return Commands$.MODULE$.DW_LAUNCH_MAPPING();
    }

    public Object execute(ExecuteCommandParams params) {
        block9: {
            ArrayList<LaunchConfiguration> results;
            block10: {
                block8: {
                    String projectUri = Commands$.MODULE$.argAsString(params.getArguments(), 0);
                    String mappingName = Commands$.MODULE$.argAsString(params.getArguments(), 1);
                    String configType = Commands$.MODULE$.argAsString(params.getArguments(), 2);
                    boolean noDebug = Commands$.MODULE$.argAsBoolean(params.getArguments(), 3);
                    ConfigurationItem item = new ConfigurationItem();
                    item.setScopeUri(projectUri);
                    item.setSection(LaunchConfiguration$.MODULE$.LAUNCH_REQUEST_TYPE());
                    List<Object> configurations = this.configurationService.configuration(new ConfigurationParams(Arrays.asList((Object[])new ConfigurationItem[]{item}))).get();
                    results = new ArrayList<LaunchConfiguration>();
                    if (!configurations.isEmpty()) {
                        for (int e = 0; e < configurations.size(); ++e) {
                            Object config = configurations.get(0);
                            Object object = config;
                            if (!(object instanceof JsonObject)) continue;
                            JsonObject jsonObject = (JsonObject)object;
                            JsonArray array = jsonObject.getAsJsonArray("configurations");
                            if (array == null) continue;
                            Iterator configs = array.iterator();
                            while (configs.hasNext()) {
                                Object object2;
                                JsonObject launchConfig = ((JsonElement)configs.next()).getAsJsonObject();
                                String string = launchConfig.get(LaunchConfiguration$.MODULE$.TYPE_PROP_NAME()).getAsString();
                                String string2 = configType;
                                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                                    String string3 = launchConfig.get(LaunchConfiguration$.MODULE$.MAIN_FILE_NAME()).getAsString();
                                    String string4 = mappingName;
                                    if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                                        String string5 = launchConfig.get(LaunchConfiguration$.MODULE$.REQUEST_PROP_NAME()).getAsString();
                                        String string6 = LaunchConfiguration$.MODULE$.LAUNCH_REQUEST_TYPE();
                                        if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
                                            Iterator entries = launchConfig.entrySet().iterator();
                                            String theName = launchConfig.get(LaunchConfiguration$.MODULE$.NAME_PROP_NAME()).getAsString();
                                            String theRequest = launchConfig.get(LaunchConfiguration$.MODULE$.REQUEST_PROP_NAME()).getAsString();
                                            ArrayList<LaunchConfigurationProperty> configurationProperties = new ArrayList<LaunchConfigurationProperty>();
                                            while (entries.hasNext()) {
                                                Map.Entry entry = (Map.Entry)entries.next();
                                                Object object3 = !LaunchConfiguration$.MODULE$.DEFAULT_CONFIG_NAMES().contains(entry.getKey()) ? BoxesRunTime.boxToBoolean((boolean)configurationProperties.add(new LaunchConfigurationProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsJsonPrimitive().getAsString()))) : BoxedUnit.UNIT;
                                            }
                                            object2 = BoxesRunTime.boxToBoolean((boolean)results.add(new LaunchConfiguration(LaunchConfiguration$.MODULE$.DATA_WEAVE_CONFIG_TYPE_NAME(), projectUri, theName, theRequest, noDebug, configurationProperties)));
                                            continue;
                                        }
                                    }
                                }
                                object2 = BoxedUnit.UNIT;
                            }
                        }
                    }
                    if (!results.isEmpty()) break block8;
                    LaunchConfiguration launchConfiguration = this.createDefaultConfiguration(projectUri, mappingName, configType, noDebug);
                    this.configurationService.runConfiguration(launchConfiguration);
                    break block9;
                }
                if (results.size() != 1) break block10;
                this.configurationService.runConfiguration((LaunchConfiguration)results.get(0));
                break block9;
            }
            ArrayList<WeaveQuickPickItem> items = new ArrayList<WeaveQuickPickItem>();
            Iterator configIterators = results.iterator();
            int i = 0;
            while (configIterators.hasNext()) {
                LaunchConfiguration configuration = (LaunchConfiguration)configIterators.next();
                items.add(new WeaveQuickPickItem(Integer.toString(i), new StringBuilder(0).append(this.icon().file()).append(configuration.name()).toString(), WeaveQuickPickItem$.MODULE$.apply$default$3(), WeaveQuickPickItem$.MODULE$.apply$default$4(), WeaveQuickPickItem$.MODULE$.apply$default$5(), WeaveQuickPickItem$.MODULE$.apply$default$6()));
                ++i;
            }
            WeaveQuickPickResult result = this.uIService.weaveQuickPick(new WeaveQuickPickParams(items, "Select The Configuration To Run", WeaveQuickPickParams$.MODULE$.apply$default$3(), WeaveQuickPickParams$.MODULE$.apply$default$4(), WeaveQuickPickParams$.MODULE$.apply$default$5(), WeaveQuickPickParams$.MODULE$.apply$default$6(), WeaveQuickPickParams$.MODULE$.apply$default$7(), WeaveQuickPickParams$.MODULE$.apply$default$8(), WeaveQuickPickParams$.MODULE$.apply$default$9(), WeaveQuickPickParams$.MODULE$.apply$default$10())).get();
            if (Predef$.MODULE$.Boolean2boolean(result.cancelled())) break block9;
            this.configurationService.runConfiguration((LaunchConfiguration)results.get(new StringOps(Predef$.MODULE$.augmentString(result.itemsId().get(0))).toInt()));
        }
        return null;
    }

    private LaunchConfiguration createDefaultConfiguration(String projectUri, String mappingName, String configType, boolean noDebug) {
        LaunchConfigurationProperty mapping = new LaunchConfigurationProperty(LaunchConfiguration$.MODULE$.MAIN_FILE_NAME(), mappingName);
        return new LaunchConfiguration(configType, projectUri, new StringBuilder(10).append("Debugging ").append(mappingName).toString(), LaunchConfiguration$.MODULE$.LAUNCH_REQUEST_TYPE(), noDebug, Arrays.asList((Object[])new LaunchConfigurationProperty[]{mapping}));
    }

    public String name() {
        return "Launch DataWeave.";
    }

    public String description(ExecuteCommandParams params) {
        return "Launching DataWeave File.";
    }

    public LaunchWeaveCommand(UIService uIService, ConfigurationService configurationService) {
        this.uIService = uIService;
        this.configurationService = configurationService;
        this.icon = Icons$vscode$.MODULE$;
    }
}

